/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.StringValueFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AbstractSingleChildFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.NotFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.schema.CheckSchemaPredicateVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.schema.ConvertSchemaPredicateToFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.tsfile.utils.Pair;

public class SchemaPredicateUtil {
    private SchemaPredicateUtil() {
    }

    static Pair<List<Expression>, List<Expression>> separateIdDeterminedPredicate(List<Expression> expressionList, TsTable table, MPPQueryContext queryContext, boolean isDirectDeviceQuery) {
        ArrayList<Expression> idDeterminedList = new ArrayList<Expression>();
        ArrayList<Expression> idFuzzyList = new ArrayList<Expression>();
        CheckSchemaPredicateVisitor visitor = new CheckSchemaPredicateVisitor();
        CheckSchemaPredicateVisitor.Context context = new CheckSchemaPredicateVisitor.Context(table, queryContext, isDirectDeviceQuery);
        for (Expression expression : expressionList) {
            if (Objects.isNull(expression)) continue;
            if (expression instanceof BetweenPredicate) {
                BetweenPredicate predicate = (BetweenPredicate)expression;
                SchemaPredicateUtil.separateExpression(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, predicate.getMin(), predicate.getValue()), idDeterminedList, idFuzzyList, visitor, context);
                SchemaPredicateUtil.separateExpression(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, predicate.getValue(), predicate.getMax()), idDeterminedList, idFuzzyList, visitor, context);
                continue;
            }
            SchemaPredicateUtil.separateExpression(expression, idDeterminedList, idFuzzyList, visitor, context);
        }
        return new Pair(idDeterminedList, idFuzzyList);
    }

    private static void separateExpression(Expression expression, List<Expression> idDeterminedList, List<Expression> idFuzzyList, CheckSchemaPredicateVisitor visitor, CheckSchemaPredicateVisitor.Context context) {
        if (Boolean.TRUE.equals(expression.accept(visitor, context))) {
            idFuzzyList.add(expression);
        } else {
            idDeterminedList.add(expression);
        }
    }

    static List<Map<Integer, List<SchemaFilter>>> convertDeviceIdPredicateToOrConcatList(List<Expression> schemaFilterList, TsTable table) {
        ConvertSchemaPredicateToFilterVisitor visitor = new ConvertSchemaPredicateToFilterVisitor();
        ConvertSchemaPredicateToFilterVisitor.Context context = new ConvertSchemaPredicateToFilterVisitor.Context(table);
        List orConcatList = schemaFilterList.stream().map(IrUtils::extractOrPredicatesWithInExpanded).collect(Collectors.toList());
        int orSize = orConcatList.size();
        ArrayList<Map<Integer, List<SchemaFilter>>> result = new ArrayList<Map<Integer, List<SchemaFilter>>>();
        int[] indexes = new int[orSize];
        block0: for (int remainingCaseNum = orConcatList.stream().map(List::size).reduce(1, (a, b) -> a * b).intValue(); remainingCaseNum > 0; --remainingCaseNum) {
            boolean hasConflictFilter = false;
            HashMap<Integer, List<SchemaFilter>> oneCase = new HashMap<Integer, List<SchemaFilter>>();
            for (int j = 0; j < orSize; ++j) {
                Expression currentExpression = (Expression)((List)orConcatList.get(j)).get(indexes[j]);
                if (SchemaPredicateUtil.handleFilter((AbstractSingleChildFilter)currentExpression.accept(visitor, context), oneCase)) continue;
                hasConflictFilter = true;
                break;
            }
            if (!hasConflictFilter) {
                result.add(oneCase);
            }
            for (int k = orSize - 1; k >= 0; --k) {
                int n = k;
                indexes[n] = indexes[n] + 1;
                if (indexes[k] < ((List)orConcatList.get(k)).size()) continue block0;
                indexes[k] = 0;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean handleFilter(AbstractSingleChildFilter filter, Map<Integer, List<SchemaFilter>> index2FilterMap) {
        AbstractSingleChildFilter currentFilter = filter;
        boolean isNotFilter = false;
        while (currentFilter.getSchemaFilterType().equals((Object)SchemaFilterType.NOT)) {
            currentFilter = (AbstractSingleChildFilter)currentFilter.getChild();
            isNotFilter = !isNotFilter;
        }
        int index = ((IdFilter)currentFilter).getIndex();
        SchemaFilter childFilter = currentFilter.getChild();
        if (isNotFilter) {
            currentFilter.setChild((SchemaFilter)new NotFilter(childFilter));
        }
        if (!index2FilterMap.containsKey(index)) {
            index2FilterMap.computeIfAbsent(index, k -> new ArrayList()).add(currentFilter);
            return true;
        } else if (!isNotFilter && childFilter.getSchemaFilterType().equals((Object)SchemaFilterType.PRECISE)) {
            if (!index2FilterMap.get(index).stream().allMatch(existingFilter -> Boolean.TRUE.equals(existingFilter.accept((SchemaFilterVisitor)StringValueFilterVisitor.getInstance(), (Object)((PreciseFilter)childFilter).getValue())))) return false;
            index2FilterMap.put(index, Collections.singletonList(currentFilter));
            return true;
        } else {
            SchemaFilter firstFilter = index2FilterMap.get(index).get(0);
            if (firstFilter.getSchemaFilterType().equals((Object)SchemaFilterType.ID) && ((IdFilter)firstFilter).getChild().getSchemaFilterType().equals((Object)SchemaFilterType.PRECISE)) {
                return Boolean.TRUE.equals(currentFilter.accept((SchemaFilterVisitor)StringValueFilterVisitor.getInstance(), (Object)((PreciseFilter)((IdFilter)firstFilter).getChild()).getValue()));
            }
            index2FilterMap.get(index).add((SchemaFilter)currentFilter);
        }
        return true;
    }

    static List<Integer> extractIdSingleMatchExpressionCases(List<Map<Integer, List<SchemaFilter>>> index2FilterMapList, TsTable tableInstance) {
        ArrayList<Integer> selectedExpressionCases = new ArrayList<Integer>();
        int idCount = tableInstance.getIdNums();
        for (int i = 0; i < index2FilterMapList.size(); ++i) {
            Map<Integer, List<SchemaFilter>> filterMap = index2FilterMapList.get(i);
            if (filterMap.size() != idCount || !filterMap.values().stream().allMatch(filterList -> ((SchemaFilter)filterList.get(0)).getSchemaFilterType().equals((Object)SchemaFilterType.ID) && ((IdFilter)filterList.get(0)).getChild().getSchemaFilterType().equals((Object)SchemaFilterType.PRECISE))) continue;
            selectedExpressionCases.add(i);
        }
        return selectedExpressionCases;
    }

    static Expression compactDeviceIdFuzzyPredicate(List<Expression> expressionList) {
        if (expressionList.isEmpty()) {
            return null;
        }
        return expressionList.size() > 1 ? new LogicalExpression(LogicalExpression.Operator.AND, expressionList) : expressionList.get(0);
    }
}

