/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySource;
import org.apache.iotdb.db.queryengine.plan.execution.memory.TableModelStatementMemorySourceContext;
import org.apache.iotdb.db.queryengine.plan.execution.memory.TableModelStatementMemorySourceVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TimePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.security.Identity;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllColumns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Join;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuerySpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.TimeDuration;

public class Analysis
implements IAnalysis {
    private String databaseName;
    private List<TEndPoint> redirectNodeList;
    @Nullable
    private Statement root;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private String updateType;
    private final Map<NodeRef<Table>, Query> namedQueries = new LinkedHashMap<NodeRef<Table>, Query>();
    private final Map<NodeRef<Query>, Node> expandableNamedQueries = new LinkedHashMap<NodeRef<Query>, Node>();
    private final Map<NodeRef<Node>, Scope> expandableBaseScopes = new LinkedHashMap<NodeRef<Node>, Scope>();
    private final Map<NodeRef<QuerySpecification>, Scope> implicitFromScopes = new LinkedHashMap<NodeRef<QuerySpecification>, Scope>();
    private final Map<NodeRef<Node>, Scope> scopes = new LinkedHashMap<NodeRef<Node>, Scope>();
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences = new LinkedHashMap<NodeRef<Expression>, ResolvedField>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> tableColumnReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<String>>>();
    private final Map<NodeRef<Fill>, FillAnalysis> fill = new LinkedHashMap<NodeRef<Fill>, FillAnalysis>();
    private final Map<NodeRef<Offset>, Long> offset = new LinkedHashMap<NodeRef<Offset>, Long>();
    private final Map<NodeRef<Node>, OptionalLong> limit = new LinkedHashMap<NodeRef<Node>, OptionalLong>();
    private final Map<NodeRef<AllColumns>, List<Field>> selectAllResultFields = new LinkedHashMap<NodeRef<AllColumns>, List<Field>>();
    private boolean containsSelectDistinct;
    private final Map<NodeRef<Join>, Expression> joins = new LinkedHashMap<NodeRef<Join>, Expression>();
    private final Map<NodeRef<Join>, JoinUsingAnalysis> joinUsing = new LinkedHashMap<NodeRef<Join>, JoinUsingAnalysis>();
    private final Map<NodeRef<Node>, SubqueryAnalysis> subQueries = new LinkedHashMap<NodeRef<Node>, SubqueryAnalysis>();
    private final Map<NodeRef<Expression>, PredicateCoercions> predicateCoercions = new LinkedHashMap<NodeRef<Expression>, PredicateCoercions>();
    private final Map<NodeRef<Table>, TableEntry> tables = new LinkedHashMap<NodeRef<Table>, TableEntry>();
    private final Map<NodeRef<Expression>, Type> types = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> coercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Map<NodeRef<Relation>, List<Type>> relationCoercions = new LinkedHashMap<NodeRef<Relation>, List<Type>>();
    private final Map<NodeRef<Node>, RoutineEntry> resolvedFunctions = new LinkedHashMap<NodeRef<Node>, RoutineEntry>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> aggregates = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<Expression>> orderByAggregates = new LinkedHashMap<NodeRef<OrderBy>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, GroupingSetAnalysis> groupingSets = new LinkedHashMap<NodeRef<QuerySpecification>, GroupingSetAnalysis>();
    private final Map<NodeRef<Node>, Expression> where = new LinkedHashMap<NodeRef<Node>, Expression>();
    private final Map<NodeRef<QuerySpecification>, Expression> having = new LinkedHashMap<NodeRef<QuerySpecification>, Expression>();
    private final Map<NodeRef<QuerySpecification>, FunctionCall> gapFill = new LinkedHashMap<NodeRef<QuerySpecification>, FunctionCall>();
    private final Map<NodeRef<QuerySpecification>, List<Expression>> gapFillGroupingKeys = new LinkedHashMap<NodeRef<QuerySpecification>, List<Expression>>();
    private final Map<NodeRef<Node>, List<Expression>> orderByExpressions = new LinkedHashMap<NodeRef<Node>, List<Expression>>();
    private final Set<NodeRef<OrderBy>> redundantOrderBy = new HashSet<NodeRef<OrderBy>>();
    private final Map<NodeRef<Node>, List<SelectExpression>> selectExpressions = new LinkedHashMap<NodeRef<Node>, List<SelectExpression>>();
    private final Multimap<Field, SourceColumn> originColumnDetails = ArrayListMultimap.create();
    private final Multimap<NodeRef<Expression>, Field> fieldLineage = ArrayListMultimap.create();
    private final Map<NodeRef<Relation>, QualifiedName> relationNames = new LinkedHashMap<NodeRef<Relation>, QualifiedName>();
    private final Set<NodeRef<Relation>> aliasedRelations = new LinkedHashSet<NodeRef<Relation>>();
    private final Map<QualifiedObjectName, Map<Symbol, ColumnSchema>> tableColumnSchemas = new HashMap<QualifiedObjectName, Map<Symbol, ColumnSchema>>();
    private DataPartition dataPartition;
    private SchemaPartition schemaPartition;
    private DatasetHeader respDatasetHeader;
    private boolean finishQueryAfterAnalyze;
    private boolean hasValueFilter = false;
    private TSStatus failStatus;
    private boolean hasSortNode = false;
    private boolean emptyDataSource = false;
    private boolean isQuery = false;

    public DataPartition getDataPartition() {
        return this.dataPartition;
    }

    public Analysis(@Nullable Statement root, Map<NodeRef<Parameter>, Expression> parameters) {
        this.root = root;
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    public Map<NodeRef<Parameter>, Expression> getParameters() {
        return this.parameters;
    }

    public Statement getStatement() {
        Objects.requireNonNull(this.root);
        return this.root;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(NodeRef.of(table));
    }

    public boolean isAnalyzed(Expression expression) {
        return expression instanceof DataType || this.types.containsKey(NodeRef.of(expression));
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put(NodeRef.of(tableReference), query);
    }

    public void registerExpandableQuery(Query query, Node recursiveReference) {
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(recursiveReference, "recursiveReference is null");
        this.expandableNamedQueries.put(NodeRef.of(query), recursiveReference);
    }

    public boolean isExpandableQuery(Query query) {
        return this.expandableNamedQueries.containsKey(NodeRef.of(query));
    }

    public Node getRecursiveReference(Query query) {
        Preconditions.checkArgument((boolean)this.isExpandableQuery(query), (Object)"query is not registered as expandable");
        return this.expandableNamedQueries.get(NodeRef.of(query));
    }

    public void setExpandableBaseScope(Node node, Scope scope) {
        this.expandableBaseScopes.put(NodeRef.of(node), scope);
    }

    public Optional<Scope> getExpandableBaseScope(Node node) {
        return Optional.ofNullable(this.expandableBaseScopes.get(NodeRef.of(node)));
    }

    public Scope getScope(Node node) {
        return this.tryGetScope(node).orElseThrow(() -> new IllegalArgumentException(String.format("Analysis does not contain information for node: %s", node)));
    }

    public void setImplicitFromScope(QuerySpecification node, Scope scope) {
        this.implicitFromScopes.put(NodeRef.of(node), scope);
    }

    public Scope getImplicitFromScope(QuerySpecification node) {
        return this.implicitFromScopes.get(NodeRef.of(node));
    }

    public Optional<Scope> tryGetScope(Node node) {
        NodeRef<Node> key = NodeRef.of(node);
        if (this.scopes.containsKey(key)) {
            return Optional.of(this.scopes.get(key));
        }
        return Optional.empty();
    }

    public Scope getRootScope() {
        return this.getScope(this.root);
    }

    public void setStatement(Statement statement) {
        this.root = statement;
    }

    public void setScope(Node node, Scope scope) {
        this.scopes.put(NodeRef.of(node), scope);
    }

    public Set<ResolvedFunction> getResolvedFunctions() {
        return (Set)this.resolvedFunctions.values().stream().map(RoutineEntry::getFunction).collect(ImmutableSet.toImmutableSet());
    }

    public ResolvedFunction getResolvedFunction(Node node) {
        return this.resolvedFunctions.get(NodeRef.of(node)).getFunction();
    }

    public void addResolvedFunction(Node node, ResolvedFunction function, String authorization) {
        this.resolvedFunctions.put(NodeRef.of(node), new RoutineEntry(function, authorization));
    }

    public void addColumnReferences(Map<NodeRef<Expression>, ResolvedField> columnReferences) {
        this.columnReferences.putAll(columnReferences);
    }

    public Set<NodeRef<Expression>> getColumnReferences() {
        return Collections.unmodifiableSet(this.columnReferences.keySet());
    }

    public Map<NodeRef<Expression>, ResolvedField> getColumnReferenceFields() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put(NodeRef.of(node), (List<FunctionCall>)ImmutableList.copyOf(aggregates));
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(NodeRef.of(query));
    }

    public boolean noAggregates() {
        return this.aggregates.isEmpty() || this.aggregates.size() == 1 && this.aggregates.entrySet().iterator().next().getValue().isEmpty();
    }

    public void setOrderByAggregates(OrderBy node, List<Expression> aggregates) {
        this.orderByAggregates.put(NodeRef.of(node), (List<Expression>)ImmutableList.copyOf(aggregates));
    }

    public List<Expression> getOrderByAggregates(OrderBy node) {
        return this.orderByAggregates.get(NodeRef.of(node));
    }

    public Map<NodeRef<Expression>, Type> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    public Type getType(Expression expression) {
        Type type = this.types.get(NodeRef.of(expression));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Expression not analyzed: %s", (Object)expression);
        return type;
    }

    public void addType(Expression expression, Type type) {
        this.types.put(NodeRef.of(expression), type);
    }

    public void addTypes(Map<NodeRef<Expression>, Type> types) {
        this.types.putAll(types);
    }

    public List<Type> getRelationCoercion(Relation relation) {
        return this.relationCoercions.get(NodeRef.of(relation));
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put(NodeRef.of(relation), (List<Type>)ImmutableList.copyOf((Object[])types));
    }

    public Map<NodeRef<Expression>, Type> getCoercions() {
        return Collections.unmodifiableMap(this.coercions);
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(NodeRef.of(expression));
    }

    public void addCoercion(Expression expression, Type type, boolean isTypeOnlyCoercion) {
        this.coercions.put(NodeRef.of(expression), type);
        if (isTypeOnlyCoercion) {
            this.typeOnlyCoercions.add(NodeRef.of(expression));
        }
    }

    public void addCoercions(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
        this.coercions.putAll(coercions);
        this.typeOnlyCoercions.addAll(typeOnlyCoercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(NodeRef.of(expression));
    }

    public void setGroupingSets(QuerySpecification node, GroupingSetAnalysis groupingSets) {
        this.groupingSets.put(NodeRef.of(node), groupingSets);
    }

    public boolean isAggregation(QuerySpecification node) {
        return this.groupingSets.containsKey(NodeRef.of(node));
    }

    public boolean containsAggregationQuery() {
        return !this.groupingSets.isEmpty() || this.containsSelectDistinct;
    }

    public GroupingSetAnalysis getGroupingSets(QuerySpecification node) {
        return this.groupingSets.get(NodeRef.of(node));
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put(NodeRef.of(node), expression);
    }

    public Expression getWhere(Node node) {
        return this.where.get(NodeRef.of(node));
    }

    public Map<NodeRef<Node>, Expression> getWhereMap() {
        return this.where;
    }

    public void setOrderByExpressions(Node node, List<Expression> items) {
        this.orderByExpressions.put(NodeRef.of(node), (List<Expression>)ImmutableList.copyOf(items));
    }

    public List<Expression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(NodeRef.of(node));
    }

    public void markRedundantOrderBy(OrderBy orderBy) {
        this.redundantOrderBy.add(NodeRef.of(orderBy));
    }

    public boolean isOrderByRedundant(OrderBy orderBy) {
        return this.redundantOrderBy.contains(NodeRef.of(orderBy));
    }

    public void setFill(Fill node, FillAnalysis fillAnalysis) {
        this.fill.put(NodeRef.of(node), fillAnalysis);
    }

    public FillAnalysis getFill(Fill node) {
        Preconditions.checkState((boolean)this.fill.containsKey(NodeRef.of(node)), (String)"missing FillAnalysis for node %s", (Object)node);
        return this.fill.get(NodeRef.of(node));
    }

    public void setOffset(Offset node, long rowCount) {
        this.offset.put(NodeRef.of(node), rowCount);
    }

    public long getOffset(Offset node) {
        Preconditions.checkState((boolean)this.offset.containsKey(NodeRef.of(node)), (String)"missing OFFSET value for node %s", (Object)node);
        return this.offset.get(NodeRef.of(node));
    }

    public void setLimit(Node node, OptionalLong rowCount) {
        this.limit.put(NodeRef.of(node), rowCount);
    }

    public void setLimit(Node node, long rowCount) {
        this.limit.put(NodeRef.of(node), OptionalLong.of(rowCount));
    }

    public OptionalLong getLimit(Node node) {
        Preconditions.checkState((boolean)this.limit.containsKey(NodeRef.of(node)), (String)"missing LIMIT value for node %s", (Object)node);
        return this.limit.get(NodeRef.of(node));
    }

    public void setSelectAllResultFields(AllColumns node, List<Field> expressions) {
        this.selectAllResultFields.put(NodeRef.of(node), (List<Field>)ImmutableList.copyOf(expressions));
    }

    public List<Field> getSelectAllResultFields(AllColumns node) {
        return this.selectAllResultFields.get(NodeRef.of(node));
    }

    public void setSelectExpressions(Node node, List<SelectExpression> expressions) {
        this.selectExpressions.put(NodeRef.of(node), (List<SelectExpression>)ImmutableList.copyOf(expressions));
    }

    public List<SelectExpression> getSelectExpressions(Node node) {
        return this.selectExpressions.get(NodeRef.of(node));
    }

    public void setContainsSelectDistinct() {
        this.containsSelectDistinct = true;
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put(NodeRef.of(node), expression);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(NodeRef.of(query));
    }

    public void setGapFill(QuerySpecification node, FunctionCall dateBinGapFill) {
        this.gapFill.put(NodeRef.of(node), dateBinGapFill);
    }

    public FunctionCall getGapFill(QuerySpecification query) {
        return this.gapFill.get(NodeRef.of(query));
    }

    public void setGapFillGroupingKeys(QuerySpecification node, List<Expression> gaoFillGroupingKeys) {
        this.gapFillGroupingKeys.put(NodeRef.of(node), gaoFillGroupingKeys);
    }

    public List<Expression> getGapFillGroupingKeys(QuerySpecification query) {
        return this.gapFillGroupingKeys.get(NodeRef.of(query));
    }

    public void setJoinUsing(Join node, JoinUsingAnalysis analysis) {
        this.joinUsing.put(NodeRef.of(node), analysis);
    }

    public JoinUsingAnalysis getJoinUsing(Join node) {
        return this.joinUsing.get(NodeRef.of(node));
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put(NodeRef.of(node), criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(NodeRef.of(join));
    }

    public boolean hasJoinNode() {
        return !this.joinUsing.isEmpty() || !this.joins.isEmpty();
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        SubqueryAnalysis subqueries = this.subQueries.computeIfAbsent(NodeRef.of(node), key -> new SubqueryAnalysis());
        subqueries.addInPredicates(this.dereference(expressionAnalysis.getSubqueryInPredicates()));
        subqueries.addSubqueries(this.dereference(expressionAnalysis.getSubqueries()));
        subqueries.addExistsSubqueries(this.dereference(expressionAnalysis.getExistsSubqueries()));
        subqueries.addQuantifiedComparisons(this.dereference(expressionAnalysis.getQuantifiedComparisons()));
    }

    private <T extends Node> List<T> dereference(Collection<NodeRef<T>> nodeRefs) {
        if (nodeRefs.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)nodeRefs.stream().map(NodeRef::getNode).collect(ImmutableList.toImmutableList());
    }

    public SubqueryAnalysis getSubqueries(Node node) {
        return this.subQueries.computeIfAbsent(NodeRef.of(node), key -> new SubqueryAnalysis());
    }

    public TableSchema getTableHandle(Table table) {
        return this.tables.get(NodeRef.of(table)).getHandle().orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a table reference", table)));
    }

    public Collection<TableSchema> getTables() {
        return (Collection)this.tables.values().stream().map(TableEntry::getHandle).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    public void registerTable(Table table, Optional<TableSchema> handle, QualifiedObjectName name) {
        this.tables.put(NodeRef.of(table), new TableEntry(handle, name));
    }

    public ResolvedField getResolvedField(Expression expression) {
        Preconditions.checkArgument((boolean)this.isColumnReference(expression), (String)"Expression is not a column reference: %s", (Object)expression);
        return this.columnReferences.get(NodeRef.of(expression));
    }

    public boolean isColumnReference(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        return this.columnReferences.containsKey(NodeRef.of(expression));
    }

    public Set<String> getUsedColumns(QualifiedObjectName tableName) {
        for (Map<QualifiedObjectName, Set<String>> map : this.tableColumnReferences.values()) {
            Set<String> fields = map.get(tableName);
            if (fields == null) continue;
            return fields;
        }
        return Collections.emptySet();
    }

    public void addTableColumnReferences(AccessControl accessControl, Identity identity, Multimap<QualifiedObjectName, String> tableColumnMap) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        Map references = this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap());
        tableColumnMap.asMap().forEach((key, value) -> references.computeIfAbsent(key, k -> new HashSet()).addAll(value));
    }

    public void addEmptyColumnReferencesForTable(AccessControl accessControl, Identity identity, QualifiedObjectName table) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap()).computeIfAbsent(table, k -> new HashSet());
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public RelationType getOutputDescriptor() {
        return this.getOutputDescriptor(this.root);
    }

    public RelationType getOutputDescriptor(Node node) {
        return this.getScope(node).getRelationType();
    }

    public void addSourceColumns(Field field, Set<SourceColumn> sourceColumn) {
        this.originColumnDetails.putAll((Object)field, sourceColumn);
    }

    public Set<SourceColumn> getSourceColumns(Field field) {
        return ImmutableSet.copyOf((Collection)this.originColumnDetails.get((Object)field));
    }

    public void addExpressionFields(Expression expression, Collection<Field> fields) {
        this.fieldLineage.putAll(NodeRef.of(expression), fields);
    }

    public Set<SourceColumn> getExpressionSourceColumns(Expression expression) {
        return (Set)this.fieldLineage.get(NodeRef.of(expression)).stream().flatMap(field -> this.getSourceColumns((Field)field).stream()).collect(ImmutableSet.toImmutableSet());
    }

    public void setRelationName(Relation relation, QualifiedName name) {
        this.relationNames.put(NodeRef.of(relation), name);
    }

    public QualifiedName getRelationName(Relation relation) {
        return this.relationNames.get(NodeRef.of(relation));
    }

    public void addAliased(Relation relation) {
        this.aliasedRelations.add(NodeRef.of(relation));
    }

    public boolean isAliased(Relation relation) {
        return this.aliasedRelations.contains(NodeRef.of(relation));
    }

    public void addTableSchema(QualifiedObjectName qualifiedObjectName, Map<Symbol, ColumnSchema> tableColumnSchema) {
        this.tableColumnSchemas.put(qualifiedObjectName, tableColumnSchema);
    }

    public Map<Symbol, ColumnSchema> getTableColumnSchema(QualifiedObjectName qualifiedObjectName) {
        return this.tableColumnSchemas.get(qualifiedObjectName);
    }

    public void addPredicateCoercions(Map<NodeRef<Expression>, PredicateCoercions> coercions) {
        this.predicateCoercions.putAll(coercions);
    }

    public PredicateCoercions getPredicateCoercions(Expression expression) {
        return this.predicateCoercions.get(NodeRef.of(expression));
    }

    public boolean hasValueFilter() {
        return this.hasValueFilter;
    }

    public void setValueFilter(boolean hasValueFilter) {
        this.hasValueFilter = hasValueFilter;
    }

    public boolean hasSortNode() {
        return this.hasSortNode;
    }

    public void setSortNode(boolean hasSortNode) {
        this.hasSortNode = hasSortNode;
    }

    public boolean isEmptyDataSource() {
        return this.emptyDataSource;
    }

    public void setEmptyDataSource(boolean emptyDataSource) {
        this.emptyDataSource = emptyDataSource;
    }

    @Override
    public boolean isFailed() {
        return this.failStatus != null;
    }

    @Override
    public TSStatus getFailStatus() {
        return this.failStatus;
    }

    @Override
    public void setFailStatus(TSStatus failStatus) {
        this.failStatus = failStatus;
    }

    @Override
    public boolean canSkipExecute(MPPQueryContext context) {
        return this.isFinishQueryAfterAnalyze();
    }

    public void setFinishQueryAfterAnalyze() {
        this.finishQueryAfterAnalyze = true;
    }

    @Override
    public void setFinishQueryAfterAnalyze(boolean finishQueryAfterAnalyze) {
        this.finishQueryAfterAnalyze = finishQueryAfterAnalyze;
    }

    @Override
    public boolean isFinishQueryAfterAnalyze() {
        return this.finishQueryAfterAnalyze;
    }

    @Override
    public void setDataPartitionInfo(DataPartition dataPartition) {
        this.dataPartition = dataPartition;
    }

    @Override
    public TsBlock constructResultForMemorySource(MPPQueryContext context) {
        Objects.requireNonNull(this.getStatement(), "root statement is analysis is null");
        StatementMemorySource memorySource = (StatementMemorySource)new TableModelStatementMemorySourceVisitor().process(this.getStatement(), new TableModelStatementMemorySourceContext(context, this));
        this.setRespDatasetHeader(memorySource.getDatasetHeader());
        return memorySource.getTsBlock();
    }

    @Override
    public boolean isQuery() {
        return this.isQuery;
    }

    public void setQuery(boolean query) {
        this.isQuery = query;
    }

    @Override
    public boolean needSetHighestPriority() {
        return this.root instanceof ShowStatement && ((ShowStatement)this.root).getTableName().equals("queries");
    }

    @Override
    public DatasetHeader getRespDatasetHeader() {
        return this.respDatasetHeader;
    }

    public void setRespDatasetHeader(DatasetHeader respDatasetHeader) {
        this.respDatasetHeader = respDatasetHeader;
    }

    @Override
    public String getStatementType() {
        return null;
    }

    @Override
    public SchemaPartition getSchemaPartitionInfo() {
        return this.schemaPartition;
    }

    @Override
    public void setSchemaPartitionInfo(SchemaPartition schemaPartition) {
        this.schemaPartition = schemaPartition;
    }

    @Override
    public DataPartition getDataPartitionInfo() {
        return this.dataPartition;
    }

    public void setDataPartition(DataPartition dataPartition) {
        this.dataPartition = dataPartition;
    }

    public void upsertDataPartition(DataPartition targetDataPartition) {
        if (this.dataPartition == null) {
            this.dataPartition = targetDataPartition;
        } else {
            this.dataPartition.upsertDataPartition(targetDataPartition);
        }
    }

    @Override
    public List<TEndPoint> getRedirectNodeList() {
        return this.redirectNodeList;
    }

    @Override
    public void setRedirectNodeList(List<TEndPoint> redirectNodeList) {
        this.redirectNodeList = redirectNodeList;
    }

    @Override
    public void addEndPointToRedirectNodeList(TEndPoint endPoint) {
        if (this.redirectNodeList == null) {
            this.redirectNodeList = new ArrayList<TEndPoint>();
        }
        this.redirectNodeList.add(endPoint);
    }

    public List<TRegionReplicaSet> getDataRegionReplicaSetWithTimeFilter(String database, IDeviceID deviceId, Filter timeFilter) {
        if (this.dataPartition == null) {
            return Collections.singletonList(DataPartition.NOT_ASSIGNED);
        }
        return this.dataPartition.getDataRegionReplicaSetWithTimeFilter(database, deviceId, timeFilter);
    }

    @Override
    public TimePredicate getConvertedTimePredicate() {
        return null;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    private static class RoutineEntry {
        private final ResolvedFunction function;
        private final String authorization;

        public RoutineEntry(ResolvedFunction function, String authorization) {
            this.function = Objects.requireNonNull(function, "function is null");
            this.authorization = Objects.requireNonNull(authorization, "authorization is null");
        }

        public ResolvedFunction getFunction() {
            return this.function;
        }

        public String getAuthorization() {
            return this.authorization;
        }
    }

    public static class GroupingSetAnalysis {
        private final List<Expression> originalExpressions;
        private final List<List<Set<FieldId>>> cubes;
        private final List<List<Set<FieldId>>> rollups;
        private final List<List<Set<FieldId>>> ordinarySets;
        private final List<Expression> complexExpressions;

        public GroupingSetAnalysis(List<Expression> originalExpressions, List<List<Set<FieldId>>> cubes, List<List<Set<FieldId>>> rollups, List<List<Set<FieldId>>> ordinarySets, List<Expression> complexExpressions) {
            this.originalExpressions = ImmutableList.copyOf(originalExpressions);
            this.cubes = ImmutableList.copyOf(cubes);
            this.rollups = ImmutableList.copyOf(rollups);
            this.ordinarySets = ImmutableList.copyOf(ordinarySets);
            this.complexExpressions = ImmutableList.copyOf(complexExpressions);
        }

        public List<Expression> getOriginalExpressions() {
            return this.originalExpressions;
        }

        public List<List<Set<FieldId>>> getCubes() {
            return this.cubes;
        }

        public List<List<Set<FieldId>>> getRollups() {
            return this.rollups;
        }

        public List<List<Set<FieldId>>> getOrdinarySets() {
            return this.ordinarySets;
        }

        public List<Expression> getComplexExpressions() {
            return this.complexExpressions;
        }

        public Set<FieldId> getAllFields() {
            return (Set)Streams.concat((Stream[])new Stream[]{this.cubes.stream().flatMap(Collection::stream).flatMap(Collection::stream), this.rollups.stream().flatMap(Collection::stream).flatMap(Collection::stream), this.ordinarySets.stream().flatMap(Collection::stream).flatMap(Collection::stream)}).collect(ImmutableSet.toImmutableSet());
        }
    }

    public static class FillAnalysis {
        protected final FillPolicy fillMethod;

        protected FillAnalysis(FillPolicy fillMethod) {
            this.fillMethod = fillMethod;
        }

        public FillPolicy getFillMethod() {
            return this.fillMethod;
        }
    }

    public static final class JoinUsingAnalysis {
        private final List<Integer> leftJoinFields;
        private final List<Integer> rightJoinFields;
        private final List<Integer> otherLeftFields;
        private final List<Integer> otherRightFields;

        JoinUsingAnalysis(List<Integer> leftJoinFields, List<Integer> rightJoinFields, List<Integer> otherLeftFields, List<Integer> otherRightFields) {
            this.leftJoinFields = ImmutableList.copyOf(leftJoinFields);
            this.rightJoinFields = ImmutableList.copyOf(rightJoinFields);
            this.otherLeftFields = ImmutableList.copyOf(otherLeftFields);
            this.otherRightFields = ImmutableList.copyOf(otherRightFields);
            Preconditions.checkArgument((leftJoinFields.size() == rightJoinFields.size() ? 1 : 0) != 0, (Object)"Expected join fields for left and right to have the same size");
        }

        public List<Integer> getLeftJoinFields() {
            return this.leftJoinFields;
        }

        public List<Integer> getRightJoinFields() {
            return this.rightJoinFields;
        }

        public List<Integer> getOtherLeftFields() {
            return this.otherLeftFields;
        }

        public List<Integer> getOtherRightFields() {
            return this.otherRightFields;
        }
    }

    public static class SubqueryAnalysis {
        private final List<InPredicate> inPredicatesSubqueries = new ArrayList<InPredicate>();
        private final List<SubqueryExpression> subqueries = new ArrayList<SubqueryExpression>();
        private final List<ExistsPredicate> existsSubqueries = new ArrayList<ExistsPredicate>();
        private final List<QuantifiedComparisonExpression> quantifiedComparisonSubqueries = new ArrayList<QuantifiedComparisonExpression>();

        public void addInPredicates(List<InPredicate> expressions) {
            this.inPredicatesSubqueries.addAll(expressions);
        }

        public void addSubqueries(List<SubqueryExpression> expressions) {
            this.subqueries.addAll(expressions);
        }

        public void addExistsSubqueries(List<ExistsPredicate> expressions) {
            this.existsSubqueries.addAll(expressions);
        }

        public void addQuantifiedComparisons(List<QuantifiedComparisonExpression> expressions) {
            this.quantifiedComparisonSubqueries.addAll(expressions);
        }

        public List<InPredicate> getInPredicatesSubqueries() {
            return Collections.unmodifiableList(this.inPredicatesSubqueries);
        }

        public List<SubqueryExpression> getSubqueries() {
            return Collections.unmodifiableList(this.subqueries);
        }

        public List<ExistsPredicate> getExistsSubqueries() {
            return Collections.unmodifiableList(this.existsSubqueries);
        }

        public List<QuantifiedComparisonExpression> getQuantifiedComparisonSubqueries() {
            return Collections.unmodifiableList(this.quantifiedComparisonSubqueries);
        }
    }

    private static class TableEntry {
        private final Optional<TableSchema> handle;
        private final QualifiedObjectName name;

        public TableEntry(Optional<TableSchema> handle, QualifiedObjectName name) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Optional<TableSchema> getHandle() {
            return this.handle;
        }

        public QualifiedObjectName getName() {
            return this.name;
        }
    }

    public static final class AccessControlInfo {
        private final AccessControl accessControl;
        private final Identity identity;

        public AccessControlInfo(AccessControl accessControl, Identity identity) {
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public AccessControl getAccessControl() {
            return this.accessControl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccessControlInfo that = (AccessControlInfo)o;
            return Objects.equals(this.accessControl, that.accessControl) && Objects.equals(this.identity, that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.accessControl, this.identity);
        }

        public String toString() {
            return String.format("AccessControl: %s, Identity: %s", this.accessControl.getClass(), this.identity);
        }
    }

    public static class PredicateCoercions {
        private final Type valueType;
        private final Optional<Type> valueCoercion;
        private final Optional<Type> subqueryCoercion;

        public PredicateCoercions(Type valueType, Optional<Type> valueCoercion, Optional<Type> subqueryCoercion) {
            this.valueType = Objects.requireNonNull(valueType, "valueType is null");
            this.valueCoercion = Objects.requireNonNull(valueCoercion, "valueCoercion is null");
            this.subqueryCoercion = Objects.requireNonNull(subqueryCoercion, "subqueryCoercion is null");
        }

        public Type getValueType() {
            return this.valueType;
        }

        public Optional<Type> getValueCoercion() {
            return this.valueCoercion;
        }

        public Optional<Type> getSubqueryCoercion() {
            return this.subqueryCoercion;
        }
    }

    public static class LinearFillAnalysis
    extends FillAnalysis {
        private final FieldReference fieldReference;
        @Nullable
        private final List<FieldReference> groupingKeys;

        public LinearFillAnalysis(FieldReference fieldReference, List<FieldReference> groupingKeys) {
            super(FillPolicy.LINEAR);
            Objects.requireNonNull(fieldReference, "fieldReference is null");
            this.fieldReference = fieldReference;
            this.groupingKeys = groupingKeys;
        }

        public FieldReference getFieldReference() {
            return this.fieldReference;
        }

        public Optional<List<FieldReference>> getGroupingKeys() {
            return Optional.ofNullable(this.groupingKeys);
        }
    }

    public static class PreviousFillAnalysis
    extends FillAnalysis {
        @Nullable
        private final TimeDuration timeBound;
        @Nullable
        private final FieldReference fieldReference;
        @Nullable
        private final List<FieldReference> groupingKeys;

        public PreviousFillAnalysis(TimeDuration timeBound, FieldReference fieldReference, List<FieldReference> groupingKeys) {
            super(FillPolicy.PREVIOUS);
            this.timeBound = timeBound;
            this.fieldReference = fieldReference;
            this.groupingKeys = groupingKeys;
        }

        public Optional<TimeDuration> getTimeBound() {
            return Optional.ofNullable(this.timeBound);
        }

        public Optional<FieldReference> getFieldReference() {
            return Optional.ofNullable(this.fieldReference);
        }

        public Optional<List<FieldReference>> getGroupingKeys() {
            return Optional.ofNullable(this.groupingKeys);
        }
    }

    public static class ValueFillAnalysis
    extends FillAnalysis {
        private final Literal filledValue;

        public ValueFillAnalysis(Literal filledValue) {
            super(FillPolicy.CONSTANT);
            Objects.requireNonNull(filledValue, "filledValue is null");
            this.filledValue = filledValue;
        }

        public Literal getFilledValue() {
            return this.filledValue;
        }
    }

    @Immutable
    public static final class SelectExpression {
        private final Expression expression;
        private final Optional<List<Expression>> unfoldedExpressions;

        public SelectExpression(Expression expression, Optional<List<Expression>> unfoldedExpressions) {
            this.expression = Objects.requireNonNull(expression, "expression is null");
            this.unfoldedExpressions = Objects.requireNonNull(unfoldedExpressions);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Optional<List<Expression>> getUnfoldedExpressions() {
            return this.unfoldedExpressions;
        }
    }

    public static class SourceColumn {
        private final QualifiedObjectName tableName;
        private final String columnName;

        public SourceColumn(QualifiedObjectName tableName, String columnName) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        }

        public QualifiedObjectName getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columnName);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SourceColumn entry = (SourceColumn)obj;
            return Objects.equals(this.tableName, entry.tableName) && Objects.equals(this.columnName, entry.columnName);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("columnName", (Object)this.columnName).toString();
        }
    }
}

