/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AI;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.model.ModelInferenceDescriptor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InferenceNode
extends SingleChildProcessNode {
    private final ModelInferenceDescriptor modelInferenceDescriptor;
    private final List<String> targetColumnNames;

    public InferenceNode(PlanNodeId id, PlanNode child, ModelInferenceDescriptor modelInferenceDescriptor, List<String> targetColumnNames) {
        super(id, child);
        this.modelInferenceDescriptor = modelInferenceDescriptor;
        this.targetColumnNames = targetColumnNames;
    }

    public InferenceNode(PlanNodeId id, ModelInferenceDescriptor modelInferenceDescriptor, List<String> inputColumnNames) {
        super(id);
        this.modelInferenceDescriptor = modelInferenceDescriptor;
        this.targetColumnNames = inputColumnNames;
    }

    public ModelInferenceDescriptor getModelInferenceDescriptor() {
        return this.modelInferenceDescriptor;
    }

    public List<String> getInputColumnNames() {
        return this.targetColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInference(this, context);
    }

    @Override
    public PlanNode clone() {
        return new InferenceNode(this.getPlanNodeId(), this.child, this.modelInferenceDescriptor, this.targetColumnNames);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.modelInferenceDescriptor.getOutputColumnNames();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INFERENCE.serialize(byteBuffer);
        this.modelInferenceDescriptor.serialize(byteBuffer);
        ReadWriteIOUtils.writeStringList(this.targetColumnNames, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INFERENCE.serialize(stream);
        this.modelInferenceDescriptor.serialize(stream);
        ReadWriteIOUtils.writeStringList(this.targetColumnNames, (OutputStream)stream);
    }

    public static InferenceNode deserialize(ByteBuffer buffer) {
        ModelInferenceDescriptor modelInferenceDescriptor = ModelInferenceDescriptor.deserialize(buffer);
        List inputColumnNames = ReadWriteIOUtils.readStringList((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new InferenceNode(planNodeId, modelInferenceDescriptor, inputColumnNames);
    }

    public String toString() {
        return "InferenceNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InferenceNode that = (InferenceNode)o;
        return this.modelInferenceDescriptor.equals(that.modelInferenceDescriptor) && this.targetColumnNames.equals(that.targetColumnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelInferenceDescriptor, this.targetColumnNames);
    }
}

