/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config;

import java.security.AccessControlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CreateFunctionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CreatePipePluginTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.DropFunctionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.DropPipePluginTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterIdTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowFunctionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowPipePluginsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowVariablesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableAddColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableDropColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableRenameColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableRenameTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableSetPropertiesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ClearCacheTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DeleteDeviceTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DescribeTableDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DescribeTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DropDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DropTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowAINodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowConfigNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowDataNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowTablesDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowTablesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.UseDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentDatabaseTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentSqlDialectTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentTimestampTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentUserTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowVersionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.FlushTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.KillQueryTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.SetConfigurationTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.StartRepairDataTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.StopRepairDataTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.AlterPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.CreatePipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.DropPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.ShowPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.StartPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.StopPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.CreateTopicTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.DropTopicTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.ShowSubscriptionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.ShowTopicsTask;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableHeaderSchemaValidator;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AddColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ClearCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ColumnDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DeleteDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DescribeTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Flush;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.KillQuery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetConfiguration;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetProperties;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowAINodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCluster;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowClusterId;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowConfigNodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentSqlDialect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentTimestamp;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDataNodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowFunctions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipePlugins;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowRegions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowSubscriptions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTopics;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVariables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVersion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartRepairData;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopRepairData;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Use;
import org.apache.iotdb.db.queryengine.plan.relational.sql.rewrite.StatementRewrite;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.FlushStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.SetConfigurationStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StartRepairDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StopRepairDataStatement;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;

public class TableConfigTaskVisitor
extends AstVisitor<IConfigTask, MPPQueryContext> {
    public static final String DATABASE_NOT_SPECIFIED = "database is not specified";
    private final IClientSession clientSession;
    private final Metadata metadata;
    private final AccessControl accessControl;

    public TableConfigTaskVisitor(IClientSession clientSession, Metadata metadata, AccessControl accessControl) {
        this.clientSession = clientSession;
        this.metadata = metadata;
        this.accessControl = accessControl;
    }

    @Override
    protected IConfigTask visitNode(Node node, MPPQueryContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
    }

    @Override
    protected IConfigTask visitCreateDB(CreateDB node, MPPQueryContext context) {
        return this.visitDatabaseStatement(node, context);
    }

    @Override
    protected IConfigTask visitAlterDB(AlterDB node, MPPQueryContext context) {
        return this.visitDatabaseStatement(node, context);
    }

    private IConfigTask visitDatabaseStatement(DatabaseStatement node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        TDatabaseSchema schema = new TDatabaseSchema();
        schema.setIsTableModel(true);
        String dbName = node.getDbName();
        TableConfigTaskVisitor.validateDatabaseName(dbName);
        this.accessControl.checkCanCreateDatabase(context.getSession().getUserName(), dbName);
        schema.setName(dbName);
        block22: for (Property property : node.getProperties()) {
            String key = property.getName().getValue().toLowerCase(Locale.ENGLISH);
            if (property.isSetToDefault()) {
                switch (key) {
                    case "time_partition_interval": 
                    case "schema_region_group_num": 
                    case "data_region_group_num": {
                        continue block22;
                    }
                    case "ttl": {
                        if (node.getType() != DatabaseSchemaStatement.DatabaseSchemaStatementType.ALTER) continue block22;
                        schema.setTTL(Long.MAX_VALUE);
                        continue block22;
                    }
                }
                throw new SemanticException("Unsupported database property key: " + key);
            }
            Expression value = property.getNonDefaultValue();
            switch (key) {
                case "ttl": {
                    Optional<String> strValue = this.parseStringFromLiteralIfBinary(value);
                    if (strValue.isPresent()) {
                        if (!strValue.get().equalsIgnoreCase("INF")) {
                            throw new SemanticException("ttl value must be 'INF' or a long literal, but now is: " + value);
                        }
                        if (node.getType() != DatabaseSchemaStatement.DatabaseSchemaStatementType.ALTER) continue block22;
                        schema.setTTL(Long.MAX_VALUE);
                        continue block22;
                    }
                    schema.setTTL(this.parseLongFromLiteral(value, "ttl"));
                    continue block22;
                }
                case "time_partition_interval": {
                    schema.setTimePartitionInterval(this.parseLongFromLiteral(value, "time_partition_interval"));
                    continue block22;
                }
                case "schema_region_group_num": {
                    schema.setMinSchemaRegionGroupNum(this.parseIntFromLiteral(value, "schema_region_group_num"));
                    continue block22;
                }
                case "data_region_group_num": {
                    schema.setMinDataRegionGroupNum(this.parseIntFromLiteral(value, "data_region_group_num"));
                    continue block22;
                }
            }
            throw new SemanticException("Unsupported database property key: " + key);
        }
        return node.getType() == DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE ? new CreateDBTask(schema, node.exists()) : new AlterDBTask(schema, node.exists());
    }

    @Override
    protected IConfigTask visitUse(Use node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkCanShowOrUseDatabase(context.getSession().getUserName(), node.getDatabaseId().getValue());
        return new UseDBTask(node, this.clientSession);
    }

    @Override
    protected IConfigTask visitDropDB(DropDB node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        InformationSchemaUtils.checkDBNameInWrite(node.getDbName().getValue());
        this.accessControl.checkCanDropDatabase(context.getSession().getUserName(), node.getDbName().getValue());
        return new DropDBTask(node);
    }

    @Override
    protected IConfigTask visitShowDB(ShowDB node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowDBTask(node, databaseName -> {
            try {
                this.accessControl.checkCanShowOrUseDatabase(context.getSession().getUserName(), (String)databaseName);
                return true;
            }
            catch (AccessControlException e) {
                return false;
            }
        });
    }

    @Override
    protected IConfigTask visitShowCluster(ShowCluster showCluster, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        ShowClusterStatement treeStatement = new ShowClusterStatement();
        treeStatement.setDetails(showCluster.getDetails().orElse(false));
        return new ShowClusterTask(treeStatement);
    }

    @Override
    protected IConfigTask visitShowRegions(ShowRegions showRegions, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        ShowRegionStatement treeStatement = new ShowRegionStatement();
        treeStatement.setRegionType(showRegions.getRegionType());
        treeStatement.setStorageGroups(showRegions.getDatabases());
        treeStatement.setNodeIds(showRegions.getNodeIds());
        return new ShowRegionTask(treeStatement, true);
    }

    @Override
    protected IConfigTask visitShowDataNodes(ShowDataNodes showDataNodesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new ShowDataNodesTask();
    }

    @Override
    protected IConfigTask visitShowConfigNodes(ShowConfigNodes showConfigNodesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new ShowConfigNodesTask();
    }

    @Override
    protected IConfigTask visitShowAINodes(ShowAINodes showAINodesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new ShowAINodesTask();
    }

    @Override
    protected IConfigTask visitClearCache(ClearCache clearCacheStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new ClearCacheTask(clearCacheStatement);
    }

    @Override
    protected IConfigTask visitCreateTable(CreateTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getName(), true);
        TsTable table = new TsTable((String)databaseTablePair.getRight());
        table.setProps(this.convertPropertiesToMap(node.getProperties(), false));
        boolean hasTimeColumn = false;
        for (ColumnDefinition columnDefinition : node.getElements()) {
            TSDataType dataType;
            String columnName;
            TsTableColumnCategory category = columnDefinition.getColumnCategory();
            if (this.checkTimeColumnIdempotent(category, columnName = columnDefinition.getName().getValue(), dataType = this.getDataType(columnDefinition.getType())) && !hasTimeColumn) {
                hasTimeColumn = true;
                continue;
            }
            if (table.getColumnSchema(columnName) != null) {
                throw new SemanticException(String.format("Columns in table shall not share the same name %s.", columnName));
            }
            table.addColumnSchema(TableHeaderSchemaValidator.generateColumnSchema(category, columnName, dataType));
        }
        return new CreateTableTask(table, (String)databaseTablePair.getLeft(), node.isIfNotExists());
    }

    private boolean checkTimeColumnIdempotent(TsTableColumnCategory category, String columnName, TSDataType dataType) {
        if (category == TsTableColumnCategory.TIME || columnName.equals("time")) {
            if (category == TsTableColumnCategory.TIME && columnName.equals("time") && dataType == TSDataType.TIMESTAMP) {
                return true;
            }
            if (dataType == TSDataType.TIMESTAMP) {
                throw new SemanticException("The time column category shall be bounded with column name 'time'.");
            }
            throw new SemanticException("The time column's type shall be 'timestamp'.");
        }
        return false;
    }

    @Override
    protected IConfigTask visitRenameTable(RenameTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getSource(), true);
        String oldName = (String)databaseTablePair.getRight();
        String newName = node.getTarget().getValue();
        if (oldName.equals(newName)) {
            throw new SemanticException("The table's old name shall not be equal to the new one.");
        }
        return new AlterTableRenameTableTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight(), node.getTarget().getValue(), context.getQueryId().getId(), node.tableIfExists());
    }

    @Override
    protected IConfigTask visitAddColumn(AddColumn node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTableName(), true);
        ColumnDefinition definition = node.getColumn();
        return new AlterTableAddColumnTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight(), Collections.singletonList(TableHeaderSchemaValidator.generateColumnSchema(definition.getColumnCategory(), definition.getName().getValue(), this.getDataType(definition.getType()))), context.getQueryId().getId(), node.tableIfExists(), node.columnIfNotExists());
    }

    @Override
    protected IConfigTask visitRenameColumn(RenameColumn node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTable(), true);
        String oldName = node.getSource().getValue();
        String newName = node.getTarget().getValue();
        if (oldName.equals(newName)) {
            throw new SemanticException("The column's old name shall not be equal to the new one.");
        }
        return new AlterTableRenameColumnTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight(), node.getSource().getValue(), node.getTarget().getValue(), context.getQueryId().getId(), node.tableIfExists(), node.columnIfExists());
    }

    @Override
    protected IConfigTask visitDropColumn(DropColumn node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTable(), true);
        return new AlterTableDropColumnTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight(), node.getField().getValue(), context.getQueryId().getId(), node.tableIfExists(), node.columnIfExists());
    }

    @Override
    protected IConfigTask visitSetProperties(SetProperties node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getName(), true);
        return new AlterTableSetPropertiesTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight(), this.convertPropertiesToMap(node.getProperties(), true), context.getQueryId().getId(), node.ifExists());
    }

    public static void validateDatabaseName(String dbName) throws SemanticException {
        InformationSchemaUtils.checkDBNameInWrite(dbName);
        if (dbName.contains(".") || !IoTDBConfig.STORAGE_GROUP_PATTERN.matcher(dbName).matches() || dbName.length() > 64) {
            throw new SemanticException(new IllegalPathException(dbName, dbName.length() > 64 ? "the length of database name shall not exceed 64" : "the database name can only contain english or chinese characters, numbers, backticks and underscores."));
        }
    }

    public Pair<String, String> splitQualifiedName(QualifiedName name, boolean isWrite) {
        String database = this.clientSession.getDatabaseName();
        if (name.getPrefix().isPresent()) {
            database = name.getPrefix().get().toString();
        }
        if (database == null) {
            throw new SemanticException(DATABASE_NOT_SPECIFIED);
        }
        if (isWrite) {
            InformationSchemaUtils.checkDBNameInWrite(database);
        }
        return new Pair((Object)database, (Object)name.getSuffix());
    }

    private Map<String, String> convertPropertiesToMap(List<Property> propertyList, boolean serializeDefault) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Property property : propertyList) {
            String key = property.getName().getValue().toLowerCase(Locale.ENGLISH);
            if (TsTable.TABLE_ALLOWED_PROPERTIES.contains(key)) {
                if (!property.isSetToDefault()) {
                    Expression value = property.getNonDefaultValue();
                    Optional<String> strValue = this.parseStringFromLiteralIfBinary(value);
                    if (strValue.isPresent()) {
                        if (!strValue.get().equalsIgnoreCase("INF")) {
                            throw new SemanticException("ttl value must be 'INF' or a long literal, but now is: " + value);
                        }
                        map.put(key, strValue.get().toUpperCase(Locale.ENGLISH));
                        continue;
                    }
                    map.put(key, String.valueOf(this.parseLongFromLiteral(value, "ttl")));
                    continue;
                }
                if (!serializeDefault) continue;
                map.put(key, null);
                continue;
            }
            throw new SemanticException("Table property '" + key + "' is currently not allowed.");
        }
        return map;
    }

    private TSDataType getDataType(DataType dataType) {
        try {
            return InternalTypeManager.getTSDataType(this.metadata.getType(TypeSignatureTranslator.toTypeSignature(dataType)));
        }
        catch (TypeNotFoundException e) {
            throw new SemanticException(String.format("Unknown type: %s", dataType));
        }
    }

    @Override
    protected IConfigTask visitDropTable(DropTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTableName(), true);
        return new DropTableTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight(), context.getQueryId().getId(), node.isExists());
    }

    @Override
    protected IConfigTask visitDeleteDevice(DeleteDevice node, MPPQueryContext context) {
        new Analyzer(context, context.getSession(), new StatementAnalyzerFactory(this.metadata, null, this.accessControl), Collections.emptyList(), Collections.emptyMap(), StatementRewrite.NOOP, WarningCollector.NOOP).analyze(node);
        return new DeleteDeviceTask(node, context.getQueryId().getId(), context.getSession());
    }

    @Override
    protected IConfigTask visitShowTables(ShowTables node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        String database = this.clientSession.getDatabaseName();
        if (node.getDbName().isPresent()) {
            database = node.getDbName().get().getValue();
        }
        if (database == null) {
            throw new SemanticException(DATABASE_NOT_SPECIFIED);
        }
        return node.isDetails() ? new ShowTablesDetailsTask(database) : new ShowTablesTask(database);
    }

    @Override
    protected IConfigTask visitDescribeTable(DescribeTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTable(), false);
        return node.isDetails() ? new DescribeTableDetailsTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight()) : new DescribeTableTask((String)databaseTablePair.getLeft(), (String)databaseTablePair.getRight());
    }

    @Override
    protected IConfigTask visitFlush(Flush node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new FlushTask((FlushStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitSetConfiguration(SetConfiguration node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new SetConfigurationTask((SetConfigurationStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitStartRepairData(StartRepairData node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new StartRepairDataTask((StartRepairDataStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitStopRepairData(StopRepairData node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new StopRepairDataTask((StopRepairDataStatement)node.getInnerTreeStatement());
    }

    private Optional<String> parseStringFromLiteralIfBinary(Object value) {
        return value instanceof Literal && ((Literal)value).getTsValue() instanceof Binary ? Optional.of(((Binary)((Literal)value).getTsValue()).getStringValue(TSFileConfig.STRING_CHARSET)) : Optional.empty();
    }

    private long parseLongFromLiteral(Object value, String name) {
        if (!(value instanceof LongLiteral)) {
            throw new SemanticException(name + " value must be a LongLiteral, but now is " + (Objects.nonNull(value) ? value.getClass().getSimpleName() : null) + ", value: " + value);
        }
        long parsedValue = ((LongLiteral)value).getParsedValue();
        if (parsedValue < 0L) {
            throw new SemanticException(name + " value must be equal to or greater than 0, but now is: " + value);
        }
        return parsedValue;
    }

    private int parseIntFromLiteral(Object value, String name) {
        if (!(value instanceof LongLiteral)) {
            throw new SemanticException(name + " value must be a LongLiteral, but now is " + (Objects.nonNull(value) ? value.getClass().getSimpleName() : null) + ", value: " + value);
        }
        long parsedValue = ((LongLiteral)value).getParsedValue();
        if (parsedValue < 0L) {
            throw new SemanticException(name + " value must be equal to or greater than 0, but now is: " + value);
        }
        if (parsedValue > Integer.MAX_VALUE) {
            throw new SemanticException(name + " value must be lower than " + Integer.MAX_VALUE + ", but now is: " + value);
        }
        return (int)parsedValue;
    }

    @Override
    protected IConfigTask visitCreatePipe(CreatePipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        for (String ExtractorAttribute : node.getExtractorAttributes().keySet()) {
            if (!ExtractorAttribute.startsWith("__system")) continue;
            throw new SemanticException(String.format("Failed to create pipe %s, setting %s is not allowed.", node.getPipeName(), ExtractorAttribute));
        }
        node.getExtractorAttributes().put("__system.sql-dialect", "table");
        return new CreatePipeTask(node);
    }

    @Override
    protected IConfigTask visitAlterPipe(AlterPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        for (String ExtractorAttribute : node.getExtractorAttributes().keySet()) {
            if (!ExtractorAttribute.startsWith("__system")) continue;
            throw new SemanticException(String.format("Failed to alter pipe %s, modifying %s is not allowed.", node.getPipeName(), ExtractorAttribute));
        }
        if (node.isReplaceAllExtractorAttributes()) {
            node.getExtractorAttributes().put("__system.sql-dialect", "table");
        }
        return new AlterPipeTask(node);
    }

    @Override
    protected IConfigTask visitDropPipe(DropPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new DropPipeTask(node);
    }

    @Override
    protected IConfigTask visitStartPipe(StartPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new StartPipeTask(node);
    }

    @Override
    protected IConfigTask visitStopPipe(StopPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new StopPipeTask(node);
    }

    @Override
    protected IConfigTask visitShowPipes(ShowPipes node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowPipeTask(node);
    }

    @Override
    protected IConfigTask visitCreatePipePlugin(CreatePipePlugin node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (node.getUriString() != null && ExecutableManager.isUriTrusted((String)node.getUriString())) {
            return new CreatePipePluginTask(node);
        }
        throw new SemanticException(ExecutableManager.getUnTrustedUriErrorMsg((String)node.getUriString()));
    }

    @Override
    protected IConfigTask visitDropPipePlugin(DropPipePlugin node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new DropPipePluginTask(node);
    }

    @Override
    protected IConfigTask visitShowPipePlugins(ShowPipePlugins node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowPipePluginsTask();
    }

    @Override
    protected IConfigTask visitCreateTopic(CreateTopic node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        node.getTopicAttributes().put("__system.sql-dialect", "table");
        return new CreateTopicTask(node);
    }

    @Override
    protected IConfigTask visitDropTopic(DropTopic node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new DropTopicTask(node);
    }

    @Override
    protected IConfigTask visitShowTopics(ShowTopics node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowTopicsTask(node);
    }

    @Override
    protected IConfigTask visitShowSubscriptions(ShowSubscriptions node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowSubscriptionsTask(node);
    }

    @Override
    protected IConfigTask visitShowCurrentUser(ShowCurrentUser node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentUserTask(context.getSession().getUserName());
    }

    @Override
    protected IConfigTask visitShowCurrentSqlDialect(ShowCurrentSqlDialect node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentSqlDialectTask(context.getSession().getSqlDialect().name());
    }

    @Override
    protected IConfigTask visitShowCurrentDatabase(ShowCurrentDatabase node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentDatabaseTask(context.getSession().getDatabaseName().orElse(null));
    }

    @Override
    protected IConfigTask visitShowVersion(ShowVersion node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowVersionTask();
    }

    @Override
    protected IConfigTask visitShowVariables(ShowVariables node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new ShowVariablesTask();
    }

    @Override
    protected IConfigTask visitShowClusterId(ShowClusterId node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserHasMaintainPrivilege(context.getSession().getUserName());
        return new ShowClusterIdTask();
    }

    @Override
    protected IConfigTask visitShowCurrentTimestamp(ShowCurrentTimestamp node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentTimestampTask();
    }

    @Override
    protected IConfigTask visitKillQuery(KillQuery node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new KillQueryTask(node);
    }

    @Override
    protected IConfigTask visitCreateFunction(CreateFunction node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (node.getUriString().map(ExecutableManager::isUriTrusted).orElse(true).booleanValue()) {
            return new CreateFunctionTask(node);
        }
        throw new SemanticException(ExecutableManager.getUnTrustedUriErrorMsg((String)node.getUriString().get()));
    }

    @Override
    protected IConfigTask visitShowFunctions(ShowFunctions node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowFunctionsTask(Model.TABLE);
    }

    @Override
    protected IConfigTask visitDropFunction(DropFunction node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new DropFunctionTask(Model.TABLE, node.getUdfName());
    }
}

