/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.queryengine.plan.analyze.ColumnPaginationController;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedAggregationAnalyze;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.TemplatedConcatRemoveUnExistentMeasurementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedAnalyze {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplatedAnalyze.class);

    private TemplatedAnalyze() {
    }

    public static boolean canBuildPlanUseTemplate(Analysis analysis, QueryStatement queryStatement, IPartitionFetcher partitionFetcher, ISchemaTree schemaTree, MPPQueryContext context, List<PartialPath> deviceList) {
        if (queryStatement.getGroupByComponent() != null || queryStatement.isSelectInto() || queryStatement.hasFill() || schemaTree.hasNormalTimeSeries()) {
            return false;
        }
        List<Template> templates = schemaTree.getUsingTemplates();
        if (templates.size() != 1 || templates.get(0) == null) {
            return false;
        }
        Template template = templates.get(0);
        if (queryStatement.isAggregationQuery()) {
            return TemplatedAggregationAnalyze.canBuildAggregationPlanUseTemplate(analysis, queryStatement, partitionFetcher, schemaTree, context, template, deviceList);
        }
        ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset());
        for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            Expression expression = resultColumn.getExpression();
            if ("*".equals(expression.getOutputSymbol())) {
                for (Map.Entry<String, IMeasurementSchema> entry : template.getSchemaMap().entrySet()) {
                    if (paginationController.hasCurOffset()) {
                        paginationController.consumeOffset();
                        continue;
                    }
                    if (!paginationController.hasCurLimit()) break;
                    String measurementName = entry.getKey();
                    TimeSeriesOperand measurementPath = new TimeSeriesOperand(new PartialPath(new String[]{measurementName}), entry.getValue().getType());
                    context.reserveMemoryForFrontEnd(measurementPath.ramBytesUsed());
                    outputExpressions.add((Pair<Expression, String>)new Pair((Object)measurementPath, null));
                    paginationController.consumeLimit();
                }
                if (queryStatement.getSelectComponent().getResultColumns().size() != 1 || queryStatement.getSeriesOffset() != 0L || queryStatement.getSeriesLimit() != 0L) continue;
                analysis.setTemplateWildCardQuery();
                continue;
            }
            if (expression instanceof TimeSeriesOperand) {
                String measurementName = ((TimeSeriesOperand)expression).getPath().getMeasurement();
                if (!template.getSchemaMap().containsKey(measurementName)) continue;
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) break;
                TimeSeriesOperand measurementPath = new TimeSeriesOperand(new PartialPath(new String[]{measurementName}), template.getSchemaMap().get(measurementName).getType());
                context.reserveMemoryForFrontEnd(measurementPath.ramBytesUsed());
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)measurementPath, (Object)resultColumn.getAlias()));
                continue;
            }
            return false;
        }
        if (queryStatement.hasOrderByExpression()) {
            return false;
        }
        TemplatedAnalyze.analyzeSelect(queryStatement, analysis, outputExpressions, template);
        TemplatedAnalyze.analyzeDeviceToWhere(analysis, queryStatement);
        if (analysis.getWhereExpression() != null && analysis.getWhereExpression().equals(ConstantOperand.FALSE)) {
            AnalyzeVisitor.analyzeOutput(analysis, queryStatement, outputExpressions);
            analysis.setFinishQueryAfterAnalyze(true);
            return true;
        }
        if (deviceList.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return true;
        }
        analysis.setDeviceList(deviceList);
        TemplatedAnalyze.analyzeDeviceToOrderBy(analysis, queryStatement, schemaTree, deviceList, context);
        TemplatedAnalyze.analyzeDeviceToSourceTransform(analysis);
        TemplatedAnalyze.analyzeDeviceToSource(analysis);
        TemplatedAnalyze.analyzeDeviceViewOutput(analysis, queryStatement);
        AnalyzeVisitor.analyzeFill(analysis, queryStatement);
        AnalyzeVisitor.analyzeOutput(analysis, queryStatement, outputExpressions);
        context.generateGlobalTimeFilter(analysis);
        TemplatedAnalyze.analyzeDataPartition(analysis, schemaTree, partitionFetcher, context);
        return true;
    }

    private static void analyzeSelect(QueryStatement queryStatement, Analysis analysis, List<Pair<Expression, String>> outputExpressions, Template template) {
        ArrayList<String> measurementList = new ArrayList<String>();
        ArrayList<IMeasurementSchema> measurementSchemaList = new ArrayList<IMeasurementSchema>();
        LinkedHashSet<Expression> selectExpressions = new LinkedHashSet<Expression>();
        selectExpressions.add(AnalyzeVisitor.DEVICE_EXPRESSION);
        if (queryStatement.isOutputEndTime()) {
            selectExpressions.add(AnalyzeVisitor.END_TIME_EXPRESSION);
        }
        for (Pair<Expression, String> pair : outputExpressions) {
            if (selectExpressions.contains(pair.left)) continue;
            selectExpressions.add((Expression)pair.left);
            String measurementName = ((TimeSeriesOperand)pair.getLeft()).getPath().getMeasurement();
            measurementList.add(measurementName);
            measurementSchemaList.add(template.getSchema(measurementName));
        }
        analysis.setOutputExpressions(outputExpressions);
        analysis.setSelectExpressions(selectExpressions);
        analysis.setDeviceTemplate(template);
        analysis.setMeasurementList(measurementList);
        analysis.setMeasurementSchemaList(measurementSchemaList);
    }

    static List<PartialPath> analyzeFrom(QueryStatement queryStatement, ISchemaTree schemaTree) {
        List<PartialPath> devicePatternList = queryStatement.getFromComponent().getPrefixPaths();
        HashSet deviceSet = new HashSet();
        for (PartialPath devicePattern : devicePatternList) {
            deviceSet.addAll(schemaTree.getMatchedDevices(devicePattern).stream().map(DeviceSchemaInfo::getDevicePath).collect(Collectors.toList()));
        }
        return queryStatement.getResultDeviceOrder() == Ordering.ASC ? deviceSet.stream().sorted().collect(Collectors.toList()) : deviceSet.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    static void analyzeDeviceToWhere(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.hasWhere()) {
            return;
        }
        analysis.setNoWhereAndAggregation(false);
        Expression wherePredicate = (Expression)new TemplatedConcatRemoveUnExistentMeasurementVisitor().process(queryStatement.getWhereCondition().getPredicate(), analysis.getDeviceTemplate().getSchemaMap());
        wherePredicate = PredicateUtils.simplifyPredicate(wherePredicate);
        if (!wherePredicate.equals(ConstantOperand.TRUE)) {
            analysis.setWhereExpression(wherePredicate);
            TSDataType outputType = ExpressionTypeAnalyzer.analyzeExpressionForTemplatedQuery(analysis, wherePredicate);
            if (outputType != TSDataType.BOOLEAN) {
                throw new SemanticException(String.format("The output type of the expression in WHERE clause should be BOOLEAN, actual data type: %s.", outputType));
            }
        }
    }

    static void analyzeDeviceToOrderBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet, MPPQueryContext queryContext) {
        if (!queryStatement.hasOrderByExpression()) {
            return;
        }
        LinkedHashMap<IDeviceID, Set<Expression>> deviceToOrderByExpressions = new LinkedHashMap<IDeviceID, Set<Expression>>();
        LinkedHashMap<IDeviceID, List<SortItem>> deviceToSortItems = new LinkedHashMap<IDeviceID, List<SortItem>>();
        LinkedHashSet<Expression> deviceViewOrderByExpression = new LinkedHashSet<Expression>();
        for (PartialPath device : deviceSet) {
            LinkedHashSet<Expression> orderByExpressionsForOneDevice = new LinkedHashSet<Expression>();
            for (Expression expressionForItem : queryStatement.getExpressionSortItemList()) {
                List<Expression> expressions = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(expressionForItem, device, schemaTree, queryContext);
                if (expressions.isEmpty()) {
                    throw new SemanticException(String.format("%s in order by clause doesn't exist.", expressionForItem.getExpressionString()));
                }
                if (expressions.size() > 1) {
                    throw new SemanticException(String.format("%s in order by clause shouldn't refer to more than one timeseries.", expressionForItem.getExpressionString()));
                }
                expressionForItem = expressions.get(0);
                TSDataType dataType = AnalyzeVisitor.analyzeExpressionType(analysis, expressionForItem);
                if (!dataType.isComparable()) {
                    throw new SemanticException(String.format("The data type of %s is not comparable", dataType));
                }
                Expression deviceViewExpression = ExpressionAnalyzer.getMeasurementExpression(expressionForItem, analysis);
                AnalyzeVisitor.analyzeExpressionType(analysis, deviceViewExpression);
                deviceViewOrderByExpression.add(deviceViewExpression);
                orderByExpressionsForOneDevice.add(expressionForItem);
            }
            deviceToSortItems.put(device.getIDeviceIDAsFullDevice(), queryStatement.getUpdatedSortItems(orderByExpressionsForOneDevice));
            deviceToOrderByExpressions.put(device.getIDeviceID(), orderByExpressionsForOneDevice);
        }
        analysis.setOrderByExpressions(deviceViewOrderByExpression);
        queryStatement.updateSortItems(deviceViewOrderByExpression);
        analysis.setDeviceToSortItems(deviceToSortItems);
        analysis.setDeviceToOrderByExpressions(deviceToOrderByExpressions);
    }

    private static void analyzeDeviceToSourceTransform(Analysis analysis) {
        analysis.setDeviceToSourceTransformExpressions(analysis.getDeviceToSelectExpressions());
    }

    static void analyzeDeviceViewOutput(Analysis analysis, QueryStatement queryStatement) {
        Set<Expression> selectExpressions = analysis.getSelectExpressions();
        LinkedHashSet<Expression> deviceViewOutputExpressions = new LinkedHashSet<Expression>();
        if (queryStatement.isAggregationQuery()) {
            deviceViewOutputExpressions.add(AnalyzeVisitor.DEVICE_EXPRESSION);
            if (queryStatement.isOutputEndTime()) {
                deviceViewOutputExpressions.add(AnalyzeVisitor.END_TIME_EXPRESSION);
            }
            for (Expression selectExpression : selectExpressions) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(selectExpression));
            }
            if (queryStatement.hasHaving()) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(analysis.getHavingExpression()));
            }
            if (queryStatement.hasOrderByExpression()) {
                for (Expression orderByExpression : analysis.getOrderByExpressions()) {
                    deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(orderByExpression));
                }
            }
        } else {
            deviceViewOutputExpressions.addAll(selectExpressions);
            if (queryStatement.hasOrderByExpression()) {
                deviceViewOutputExpressions.addAll(analysis.getOrderByExpressions());
            }
        }
        analysis.setDeviceViewOutputExpressions(deviceViewOutputExpressions);
        analysis.setDeviceViewSpecialProcess(AnalyzeVisitor.analyzeDeviceViewSpecialProcess(deviceViewOutputExpressions, queryStatement, analysis));
    }

    private static void analyzeDeviceToSource(Analysis analysis) {
        analysis.setDeviceToSourceExpressions(analysis.getDeviceToSelectExpressions());
        analysis.setDeviceToOutputExpressions(analysis.getDeviceToSelectExpressions());
    }

    static void analyzeDataPartition(Analysis analysis, ISchemaTree schemaTree, IPartitionFetcher partitionFetcher, MPPQueryContext context) {
        Set<IDeviceID> deviceSet = analysis.getDeviceList().stream().map(PartialPath::getIDeviceIDAsFullDevice).collect(Collectors.toSet());
        DataPartition dataPartition = TemplatedAnalyze.fetchDataPartitionByDevices(deviceSet, schemaTree, context, partitionFetcher);
        analysis.setDataPartitionInfo(dataPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataPartition fetchDataPartitionByDevices(Set<IDeviceID> deviceSet, ISchemaTree schemaTree, MPPQueryContext context, IPartitionFetcher partitionFetcher) {
        long startTime = System.nanoTime();
        try {
            DataPartition dataPartition;
            Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> res = AnalyzeVisitor.getTimePartitionSlotList(context.getGlobalTimeFilter(), context);
            if (((List)res.left).isEmpty() && Boolean.FALSE.equals(((Pair)res.right).left)) {
                DataPartition dataPartition2 = new DataPartition(Collections.emptyMap(), AnalyzeVisitor.CONFIG.getSeriesPartitionExecutorClass(), AnalyzeVisitor.CONFIG.getSeriesPartitionSlotNum());
                return dataPartition2;
            }
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            for (IDeviceID deviceID : deviceSet) {
                DataPartitionQueryParam queryParam = new DataPartitionQueryParam(deviceID, (List)res.left, ((Boolean)((Pair)res.right).left).booleanValue(), ((Boolean)((Pair)res.right).right).booleanValue());
                sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedDatabase(deviceID), key -> new ArrayList()).add(queryParam);
            }
            if (((Boolean)((Pair)res.right).left).booleanValue() || ((Boolean)((Pair)res.right).right).booleanValue()) {
                dataPartition = partitionFetcher.getDataPartitionWithUnclosedTimeRange(sgNameToQueryParamsMap);
                return dataPartition;
            }
            dataPartition = partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            return dataPartition;
        }
        finally {
            QueryPlanCostMetricSet.getInstance().recordPlanCost("tree", "partition_fetcher", System.nanoTime() - startTime);
        }
    }
}

