/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.metric;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SeriesScanCostMetricSet
implements IMetricSet {
    public static final String LOAD_TIMESERIES_METADATA = "load_timeseries_metadata";
    public static final String LOAD_ALIGNED_TIMESERIES_METADATA = "load_aligned_timeseries_metadata";
    public static final String ALIGNED = "aligned";
    public static final String NON_ALIGNED = "non_aligned";
    public static final String MEM = "mem";
    public static final String DISK = "disk";
    public static final String MEM_AND_DISK = "mem_and_disk";
    public static final String SEQUENCE = "sequence";
    public static final String UNSEQUENCE = "unsequence";
    public static final String SEQ_AND_UNSEQ = "seq_and_unseq";
    public static final String BLOOM_FILTER = "bloom_filter";
    public static final String TIMESERIES_METADATA = "timeseries_metadata";
    public static final String CHUNK = "chunk";
    private Histogram loadBloomFilterFromCacheCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadBloomFilterFromDiskCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Counter loadBloomFilterActualIOSizeCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Timer loadBloomFilterTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Histogram loadTimeSeriesMetadataDiskSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataDiskUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataMemSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataMemUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataAlignedDiskSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataAlignedDiskUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataAlignedMemSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataAlignedMemUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Timer loadTimeSeriesMetadataDiskSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeSeriesMetadataDiskUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeSeriesMetadataMemSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeSeriesMetadataMemUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeSeriesMetadataAlignedDiskSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeSeriesMetadataAlignedDiskUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeSeriesMetadataAlignedMemSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeSeriesMetadataAlignedMemUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Histogram loadTimeSeriesMetadataFromCacheCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadTimeSeriesMetadataFromDiskCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Counter loadTimeSeriesMetadataActualIOSizeCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private static final String READ_TIMESERIES_METADATA = "read_timeseries_metadata";
    private static final String CACHE = "cache";
    private static final String FILE = "file";
    private static final String NULL = "null";
    public static final String READ_TIMESERIES_METADATA_CACHE = "read_timeseries_metadata_cache";
    public static final String READ_TIMESERIES_METADATA_FILE = "read_timeseries_metadata_file";
    private Timer readTimeseriesMetadataCacheTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer readTimeseriesMetadataFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String TIMESERIES_METADATA_MODIFICATION = "timeseries_metadata_modification";
    private static final String HISTOGRAM_TIMESERIES_METADATA_MODIFICATION = "histogram_timeseries_metadata_modification";
    public static final String TIMESERIES_METADATA_MODIFICATION_ALIGNED = "timeseries_metadata_modification_aligned";
    public static final String TIMESERIES_METADATA_MODIFICATION_NONALIGNED = "timeseries_metadata_modification_non_aligned";
    private Histogram timeseriesMetadataModificationAlignedHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram timeseriesMetadataModificationNonAlignedHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Timer timeseriesMetadataModificationAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer timeseriesMetadataModificationNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String LOAD_CHUNK_METADATA_LIST = "load_chunk_metadata_list";
    public static final String LOAD_CHUNK_METADATA_LIST_ALIGNED_MEM = "load_chunk_metadata_list_aligned_mem";
    public static final String LOAD_CHUNK_METADATA_LIST_ALIGNED_DISK = "load_chunk_metadata_list_aligned_disk";
    public static final String LOAD_CHUNK_METADATA_LIST_NONALIGNED_MEM = "load_chunk_metadata_list_non_aligned_mem";
    public static final String LOAD_CHUNK_METADATA_LIST_NONALIGNED_DISK = "load_chunk_metadata_list_non_aligned_disk";
    private Timer loadChunkMetadataListAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadChunkMetadataListAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadChunkMetadataListNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadChunkMetadataListNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String CHUNK_METADATA_MODIFICATION = "chunk_metadata_modification";
    public static final String CHUNK_METADATA_MODIFICATION_ALIGNED_MEM = "chunk_metadata_modification_aligned_mem";
    public static final String CHUNK_METADATA_MODIFICATION_ALIGNED_DISK = "chunk_metadata_modification_aligned_disk";
    public static final String CHUNK_METADATA_MODIFICATION_NONALIGNED_MEM = "chunk_metadata_modification_non_aligned_mem";
    public static final String CHUNK_METADATA_MODIFICATION_NONALIGNED_DISK = "chunk_metadata_modification_non_aligned_disk";
    private Timer chunkMetadataModificationAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataModificationAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataModificationNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataModificationNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String CHUNK_METADATA_FILTER = "chunk_metadata_filter";
    public static final String CHUNK_METADATA_FILTER_ALIGNED_MEM = "chunk_metadata_filter_aligned_mem";
    public static final String CHUNK_METADATA_FILTER_ALIGNED_DISK = "chunk_metadata_filter_aligned_disk";
    public static final String CHUNK_METADATA_FILTER_NONALIGNED_MEM = "chunk_metadata_filter_non_aligned_mem";
    public static final String CHUNK_METADATA_FILTER_NONALIGNED_DISK = "chunk_metadata_filter_non_aligned_disk";
    private Timer chunkMetadataFilterAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataFilterAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataFilterNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataFilterNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String CONSTRUCT_CHUNK_READER = "construct_chunk_reader";
    private static final String HISTOGRAM_CONSTRUCT_CHUNK_READER = "histogram_construct_chunk_reader";
    private Histogram constructChunkReadersAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram constructChunkReadersAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram constructChunkReadersNonAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram constructChunkReadersNonAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Timer constructChunkReadersAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer constructChunkReadersAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer constructChunkReadersNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer constructChunkReadersNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Histogram loadChunkFromCacheCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram loadChunkFromDiskCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Counter loadChunkActualIOSizeCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private static final String READ_CHUNK = "read_chunk";
    private static final String ALL = "all";
    public static final String READ_CHUNK_CACHE = "read_chunk_cache";
    public static final String READ_CHUNK_FILE = "read_chunk_file";
    private Timer readChunkCacheTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer readChunkFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String INIT_CHUNK_READER = "init_chunk_reader";
    public static final String INIT_CHUNK_READER_ALIGNED_MEM = "init_chunk_reader_aligned_mem";
    public static final String INIT_CHUNK_READER_ALIGNED_DISK = "init_chunk_reader_aligned_disk";
    public static final String INIT_CHUNK_READER_NONALIGNED_MEM = "init_chunk_reader_non_aligned_mem";
    public static final String INIT_CHUNK_READER_NONALIGNED_DISK = "init_chunk_reader_non_aligned_disk";
    private Timer initChunkReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer initChunkReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer initChunkReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer initChunkReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String BUILD_TSBLOCK_FROM_PAGE_READER = "build_tsblock_from_page_reader";
    private static final String HISTOGRAM_BUILD_TSBLOCK_FROM_PAGE_READER = "histogram_build_tsblock_from_page_reader";
    private static final String PAGE_READER_MAX_USED_MEMORY_SIZE = "page_reader_max_used_memory_size";
    private Histogram pageReadersDecodeAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram pageReadersDecodeAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram pageReadersDecodeNonAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram pageReadersDecodeNonAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram pageReaderMaxMemoryHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Timer pageReadersDecodeAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer pageReadersDecodeAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer pageReadersDecodeNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer pageReadersDecodeNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String BUILD_TSBLOCK_FROM_MERGE_READER = "build_tsblock_from_merge_reader";
    public static final String BUILD_TSBLOCK_FROM_MERGE_READER_ALIGNED = "build_tsblock_from_merge_reader_aligned";
    public static final String BUILD_TSBLOCK_FROM_MERGE_READER_NONALIGNED = "build_tsblock_from_merge_reader_non_aligned";
    private Timer buildTsBlockFromMergeReaderAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer buildTsBlockFromMergeReaderNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    public static SeriesScanCostMetricSet getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void recordBloomFilterMetrics(long loadBloomFilterFromCacheCount, long loadBloomFilterFromDiskCount, long loadBloomFilterActualIOSize, long loadBloomFilterNanoTime) {
        this.loadBloomFilterFromCacheCountHistogram.update(loadBloomFilterFromCacheCount);
        this.loadBloomFilterFromDiskCountHistogram.update(loadBloomFilterFromDiskCount);
        this.loadBloomFilterActualIOSizeCounter.inc(loadBloomFilterActualIOSize);
        this.loadBloomFilterTime.updateNanos(loadBloomFilterNanoTime);
    }

    private void bindBloomFilter(AbstractMetricService metricService) {
        this.loadBloomFilterFromCacheCountHistogram = metricService.getOrCreateHistogram(Metric.METRIC_QUERY_CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), BLOOM_FILTER, Tag.FROM.toString(), CACHE});
        this.loadBloomFilterFromDiskCountHistogram = metricService.getOrCreateHistogram(Metric.METRIC_QUERY_CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), BLOOM_FILTER, Tag.FROM.toString(), DISK});
        this.loadBloomFilterActualIOSizeCounter = metricService.getOrCreateCounter(Metric.QUERY_DISK_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), BLOOM_FILTER});
        this.loadBloomFilterTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BLOOM_FILTER, Tag.TYPE.toString(), SEQ_AND_UNSEQ, Tag.FROM.toString(), MEM_AND_DISK});
    }

    private void unbindBloomFilter(AbstractMetricService metricService) {
        this.loadBloomFilterFromCacheCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadBloomFilterFromDiskCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadBloomFilterActualIOSizeCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.loadBloomFilterTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.HISTOGRAM, Metric.METRIC_QUERY_CACHE.toString(), new String[]{Tag.TYPE.toString(), BLOOM_FILTER, Tag.FROM.toString(), CACHE});
        metricService.remove(MetricType.HISTOGRAM, Metric.METRIC_QUERY_CACHE.toString(), new String[]{Tag.TYPE.toString(), BLOOM_FILTER, Tag.FROM.toString(), DISK});
        metricService.remove(MetricType.COUNTER, Metric.QUERY_DISK_READ.toString(), new String[]{Tag.TYPE.toString(), BLOOM_FILTER});
        metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), BLOOM_FILTER, Tag.TYPE.toString(), SEQ_AND_UNSEQ, Tag.FROM.toString(), MEM_AND_DISK});
    }

    public void recordNonAlignedTimeSeriesMetadataCount(long c1, long c2, long c3, long c4) {
        this.loadTimeSeriesMetadataDiskSeqHistogram.update(c1);
        this.loadTimeSeriesMetadataDiskUnSeqHistogram.update(c2);
        this.loadTimeSeriesMetadataMemSeqHistogram.update(c3);
        this.loadTimeSeriesMetadataMemUnSeqHistogram.update(c4);
    }

    public void recordNonAlignedTimeSeriesMetadataTime(long t1, long t2, long t3, long t4) {
        this.loadTimeSeriesMetadataDiskSeqTime.updateNanos(t1);
        this.loadTimeSeriesMetadataDiskUnSeqTime.updateNanos(t2);
        this.loadTimeSeriesMetadataMemSeqTime.updateNanos(t3);
        this.loadTimeSeriesMetadataMemUnSeqTime.updateNanos(t4);
    }

    public void recordAlignedTimeSeriesMetadataCount(long c1, long c2, long c3, long c4) {
        this.loadTimeSeriesMetadataAlignedDiskSeqHistogram.update(c1);
        this.loadTimeSeriesMetadataAlignedDiskUnSeqHistogram.update(c2);
        this.loadTimeSeriesMetadataAlignedMemSeqHistogram.update(c3);
        this.loadTimeSeriesMetadataAlignedMemUnSeqHistogram.update(c4);
    }

    public void recordAlignedTimeSeriesMetadataTime(long t1, long t2, long t3, long t4) {
        this.loadTimeSeriesMetadataAlignedDiskSeqTime.updateNanos(t1);
        this.loadTimeSeriesMetadataAlignedDiskUnSeqTime.updateNanos(t2);
        this.loadTimeSeriesMetadataAlignedMemSeqTime.updateNanos(t3);
        this.loadTimeSeriesMetadataAlignedMemUnSeqTime.updateNanos(t4);
    }

    public void recordTimeSeriesMetadataMetrics(long loadTimeSeriesMetadataFromCacheCount, long loadTimeSeriesMetadataFromDiskCount, long loadTimeSeriesMetadataActualIOSize) {
        this.loadTimeSeriesMetadataFromCacheCountHistogram.update(loadTimeSeriesMetadataFromCacheCount);
        this.loadTimeSeriesMetadataFromDiskCountHistogram.update(loadTimeSeriesMetadataFromDiskCount);
        this.loadTimeSeriesMetadataActualIOSizeCounter.inc(loadTimeSeriesMetadataActualIOSize);
    }

    private void bindTimeseriesMetadata(AbstractMetricService metricService) {
        this.loadTimeSeriesMetadataDiskSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataDiskUnSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataMemSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), MEM});
        this.loadTimeSeriesMetadataMemUnSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), MEM});
        this.loadTimeSeriesMetadataDiskSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataDiskUnSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataMemSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), MEM});
        this.loadTimeSeriesMetadataMemUnSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), MEM});
    }

    private void bindAlignedTimeseriesMetadata(AbstractMetricService metricService) {
        this.loadTimeSeriesMetadataAlignedDiskSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataAlignedDiskUnSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataAlignedMemSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), MEM});
        this.loadTimeSeriesMetadataAlignedMemUnSeqHistogram = metricService.getOrCreateHistogram(Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), MEM});
        this.loadTimeSeriesMetadataAlignedDiskSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataAlignedDiskUnSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataAlignedMemSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), SEQUENCE, Tag.FROM.toString(), MEM});
        this.loadTimeSeriesMetadataAlignedMemUnSeqTime = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), UNSEQUENCE, Tag.FROM.toString(), MEM});
    }

    private void bindTimeSeriesMetadataCache(AbstractMetricService metricService) {
        this.loadTimeSeriesMetadataFromCacheCountHistogram = metricService.getOrCreateHistogram(Metric.METRIC_QUERY_CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TIMESERIES_METADATA, Tag.FROM.toString(), CACHE});
        this.loadTimeSeriesMetadataFromDiskCountHistogram = metricService.getOrCreateHistogram(Metric.METRIC_QUERY_CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TIMESERIES_METADATA, Tag.FROM.toString(), DISK});
        this.loadTimeSeriesMetadataActualIOSizeCounter = metricService.getOrCreateCounter(Metric.QUERY_DISK_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), TIMESERIES_METADATA});
    }

    private void unbindTimeSeriesMetadataCache(AbstractMetricService metricService) {
        this.loadTimeSeriesMetadataFromCacheCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataFromDiskCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataActualIOSizeCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        metricService.remove(MetricType.HISTOGRAM, Metric.METRIC_QUERY_CACHE.toString(), new String[]{Tag.TYPE.toString(), TIMESERIES_METADATA, Tag.FROM.toString(), CACHE});
        metricService.remove(MetricType.HISTOGRAM, Metric.METRIC_QUERY_CACHE.toString(), new String[]{Tag.TYPE.toString(), TIMESERIES_METADATA, Tag.FROM.toString(), DISK});
        metricService.remove(MetricType.COUNTER, Metric.QUERY_DISK_READ.toString(), new String[]{Tag.TYPE.toString(), TIMESERIES_METADATA});
    }

    private void unbindTimeseriesMetadata(AbstractMetricService metricService) {
        this.loadTimeSeriesMetadataDiskSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataDiskUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataMemSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataMemUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataAlignedDiskSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataAlignedDiskUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataAlignedMemSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataAlignedMemUnSeqHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadTimeSeriesMetadataDiskSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeSeriesMetadataDiskUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeSeriesMetadataMemSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeSeriesMetadataMemUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeSeriesMetadataAlignedDiskSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeSeriesMetadataAlignedDiskUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeSeriesMetadataAlignedMemSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeSeriesMetadataAlignedMemUnSeqTime = DoNothingMetricManager.DO_NOTHING_TIMER;
        for (String type : Arrays.asList(ALIGNED, NON_ALIGNED)) {
            for (String from : Arrays.asList(MEM, DISK)) {
                for (String stage : Arrays.asList(LOAD_TIMESERIES_METADATA, LOAD_ALIGNED_TIMESERIES_METADATA)) {
                    metricService.remove(MetricType.HISTOGRAM, Metric.METRIC_LOAD_TIME_SERIES_METADATA.toString(), new String[]{Tag.STAGE.toString(), stage, Tag.TYPE.toString(), type, Tag.FROM.toString(), from});
                    metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), LOAD_ALIGNED_TIMESERIES_METADATA, Tag.TYPE.toString(), type, Tag.FROM.toString(), from});
                }
            }
        }
    }

    private void bindReadTimeseriesMetadata(AbstractMetricService metricService) {
        this.readTimeseriesMetadataCacheTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_TIMESERIES_METADATA, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), CACHE});
        this.readTimeseriesMetadataFileTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_TIMESERIES_METADATA, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), FILE});
    }

    private void unbindReadTimeseriesMetadata(AbstractMetricService metricService) {
        this.readTimeseriesMetadataCacheTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.readTimeseriesMetadataFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(CACHE, FILE).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), READ_TIMESERIES_METADATA, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), from}));
    }

    public void recordTimeSeriesMetadataModification(long alignedCount, long nonAlignedCount, long alignedTime, long nonAlignedTime) {
        this.timeseriesMetadataModificationAlignedHistogram.update(alignedCount);
        this.timeseriesMetadataModificationNonAlignedHistogram.update(nonAlignedCount);
        this.timeseriesMetadataModificationAlignedTimer.updateNanos(alignedTime);
        this.timeseriesMetadataModificationNonAlignedTimer.updateNanos(nonAlignedTime);
    }

    private void bindTimeseriesMetadataModification(AbstractMetricService metricService) {
        this.timeseriesMetadataModificationAlignedHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), NULL});
        this.timeseriesMetadataModificationNonAlignedHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), NULL});
        this.timeseriesMetadataModificationAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), NULL});
        this.timeseriesMetadataModificationNonAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), NULL});
    }

    private void unbindTimeseriesMetadataModification(AbstractMetricService metricService) {
        this.timeseriesMetadataModificationAlignedHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.timeseriesMetadataModificationNonAlignedHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.timeseriesMetadataModificationAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.timeseriesMetadataModificationNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), type, Tag.FROM.toString(), NULL}));
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> metricService.remove(MetricType.HISTOGRAM, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), HISTOGRAM_TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), type, Tag.FROM.toString(), NULL}));
    }

    private void bindLoadChunkMetadataList(AbstractMetricService metricService) {
        this.loadChunkMetadataListAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.loadChunkMetadataListAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.loadChunkMetadataListNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.loadChunkMetadataListNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindLoadChunkMetadataList(AbstractMetricService metricService) {
        this.loadChunkMetadataListAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadChunkMetadataListAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadChunkMetadataListNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadChunkMetadataListNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindChunkMetadataModification(AbstractMetricService metricService) {
        this.constructChunkReadersAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReadersAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.constructChunkReadersNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReadersNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindChunkMetadataModification(AbstractMetricService metricService) {
        this.chunkMetadataModificationAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataModificationAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataModificationNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataModificationNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindChunkMetadataFilter(AbstractMetricService metricService) {
        this.chunkMetadataModificationAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.chunkMetadataModificationAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.chunkMetadataModificationNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
        this.chunkMetadataModificationNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
    }

    private void unbindChunkMetadataFilter(AbstractMetricService metricService) {
        this.chunkMetadataFilterAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataFilterAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataFilterNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataFilterNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    public void recordConstructChunkReadersCount(long alignedMemCount, long alignedDiskCount, long nonAlignedMemCount, long nonAlignedDiskCount) {
        this.constructChunkReadersAlignedMemHistogram.update(alignedMemCount);
        this.constructChunkReadersAlignedDiskHistogram.update(alignedDiskCount);
        this.constructChunkReadersNonAlignedMemHistogram.update(nonAlignedMemCount);
        this.constructChunkReadersNonAlignedDiskHistogram.update(nonAlignedDiskCount);
    }

    public void recordConstructChunkReadersTime(long alignedMemTime, long alignedDiskTime, long nonAlignedMemTime, long nonAlignedDiskTime) {
        this.constructChunkReadersAlignedMemTimer.updateNanos(alignedMemTime);
        this.constructChunkReadersAlignedDiskTimer.updateNanos(alignedDiskTime);
        this.constructChunkReadersNonAlignedMemTimer.updateNanos(nonAlignedMemTime);
        this.constructChunkReadersNonAlignedDiskTimer.updateNanos(nonAlignedDiskTime);
    }

    public void recordChunkMetrics(long loadChunkFromCacheCount, long loadChunkFromDiskCount, long loadChunkActualIOSize) {
        this.loadChunkFromCacheCountHistogram.update(loadChunkFromCacheCount);
        this.loadChunkFromDiskCountHistogram.update(loadChunkFromDiskCount);
        this.loadChunkActualIOSizeCounter.inc(loadChunkActualIOSize);
    }

    private void bindChunk(AbstractMetricService metricService) {
        this.loadChunkFromCacheCountHistogram = metricService.getOrCreateHistogram(Metric.METRIC_QUERY_CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), CHUNK, Tag.FROM.toString(), CACHE});
        this.loadChunkFromDiskCountHistogram = metricService.getOrCreateHistogram(Metric.METRIC_QUERY_CACHE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), CHUNK, Tag.FROM.toString(), DISK});
        this.loadChunkActualIOSizeCounter = metricService.getOrCreateCounter(Metric.QUERY_DISK_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), CHUNK});
    }

    private void unbindChunk(AbstractMetricService metricService) {
        this.loadChunkFromCacheCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadChunkFromDiskCountHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.loadChunkActualIOSizeCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;
        metricService.remove(MetricType.HISTOGRAM, Metric.METRIC_QUERY_CACHE.toString(), new String[]{Tag.TYPE.toString(), CHUNK, Tag.FROM.toString(), CACHE});
        metricService.remove(MetricType.HISTOGRAM, Metric.METRIC_QUERY_CACHE.toString(), new String[]{Tag.TYPE.toString(), CHUNK, Tag.FROM.toString(), DISK});
        metricService.remove(MetricType.COUNTER, Metric.QUERY_DISK_READ.toString(), new String[]{Tag.TYPE.toString(), CHUNK});
    }

    private void bindConstructChunkReader(AbstractMetricService metricService) {
        this.constructChunkReadersAlignedMemHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReadersAlignedDiskHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.constructChunkReadersNonAlignedMemHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReadersNonAlignedDiskHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
        this.constructChunkReadersAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReadersAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.constructChunkReadersNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReadersNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindConstructChunkReader(AbstractMetricService metricService) {
        this.constructChunkReadersAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.constructChunkReadersAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.constructChunkReadersNonAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.constructChunkReadersNonAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.constructChunkReadersAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.constructChunkReadersAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.constructChunkReadersNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.constructChunkReadersNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        for (String type : Arrays.asList(ALIGNED, NON_ALIGNED)) {
            for (String from : Arrays.asList(MEM, DISK)) {
                metricService.remove(MetricType.HISTOGRAM, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), HISTOGRAM_CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from});
                metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from});
            }
        }
    }

    private void bindReadChunk(AbstractMetricService metricService) {
        this.readChunkCacheTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_CHUNK_CACHE, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), CACHE});
        this.readChunkFileTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_CHUNK_FILE, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), FILE});
    }

    private void unbindReadChunk(AbstractMetricService metricService) {
        this.readChunkCacheTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.readChunkFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(CACHE, FILE).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), "read_chunk_" + from, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), from}));
    }

    private void bindInitChunkReader(AbstractMetricService metricService) {
        this.initChunkReaderAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.initChunkReaderAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.initChunkReaderNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.initChunkReaderNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindInitChunkReader(AbstractMetricService metricService) {
        this.initChunkReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.initChunkReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.initChunkReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.initChunkReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        for (String type : Arrays.asList(ALIGNED, NON_ALIGNED)) {
            for (String from : Arrays.asList(MEM, DISK)) {
                metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from});
            }
        }
    }

    public void recordPageReadersDecompressCount(long alignedMemCount, long alignedDiskCount, long nonAlignedMemCount, long nonAlignedDiskCount) {
        this.pageReadersDecodeAlignedMemHistogram.update(alignedMemCount);
        this.pageReadersDecodeAlignedDiskHistogram.update(alignedDiskCount);
        this.pageReadersDecodeNonAlignedMemHistogram.update(nonAlignedMemCount);
        this.pageReadersDecodeNonAlignedDiskHistogram.update(nonAlignedDiskCount);
    }

    public void recordPageReadersDecompressTime(long alignedMemTime, long alignedDiskTime, long nonAlignedMemTime, long nonAlignedDiskTime) {
        this.pageReadersDecodeAlignedMemTimer.updateNanos(alignedMemTime);
        this.pageReadersDecodeAlignedDiskTimer.updateNanos(alignedDiskTime);
        this.pageReadersDecodeNonAlignedMemTimer.updateNanos(nonAlignedMemTime);
        this.pageReadersDecodeNonAlignedDiskTimer.updateNanos(nonAlignedDiskTime);
    }

    public void updatePageReaderMemoryUsage(long memorySize) {
        this.pageReaderMaxMemoryHistogram.update(memorySize);
    }

    private void bindTsBlockFromPageReader(AbstractMetricService metricService) {
        this.pageReadersDecodeAlignedMemHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.pageReadersDecodeAlignedDiskHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.pageReadersDecodeNonAlignedMemHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.pageReadersDecodeNonAlignedDiskHistogram = metricService.getOrCreateHistogram(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), HISTOGRAM_BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
        this.pageReadersDecodeAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.pageReadersDecodeAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.pageReadersDecodeNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.pageReadersDecodeNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
        this.pageReaderMaxMemoryHistogram = metricService.getOrCreateHistogram(Metric.MEMORY_USAGE_MONITOR.toString(), MetricLevel.IMPORTANT, new String[]{Tag.TYPE.toString(), PAGE_READER_MAX_USED_MEMORY_SIZE});
    }

    private void unbindTsBlockFromPageReader(AbstractMetricService metricService) {
        this.pageReadersDecodeAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.pageReadersDecodeAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.pageReadersDecodeNonAlignedMemHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.pageReadersDecodeNonAlignedDiskHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.pageReaderMaxMemoryHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.pageReadersDecodeAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.pageReadersDecodeAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.pageReadersDecodeNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.pageReadersDecodeNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        for (String type : Arrays.asList(ALIGNED, NON_ALIGNED)) {
            for (String from : Arrays.asList(MEM, DISK)) {
                metricService.remove(MetricType.HISTOGRAM, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), HISTOGRAM_BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from});
                metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from});
            }
        }
        metricService.remove(MetricType.HISTOGRAM, Metric.MEMORY_USAGE_MONITOR.toString(), new String[]{Tag.TYPE.toString(), PAGE_READER_MAX_USED_MEMORY_SIZE});
    }

    private void bindBuildTsBlockFromMergeReader(AbstractMetricService metricService) {
        this.buildTsBlockFromMergeReaderAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_MERGE_READER, Tag.FROM.toString(), NULL, Tag.TYPE.toString(), ALIGNED});
        this.buildTsBlockFromMergeReaderNonAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_MERGE_READER, Tag.FROM.toString(), NULL, Tag.TYPE.toString(), NON_ALIGNED});
    }

    private void unbindBuildTsBlockFromMergeReader(AbstractMetricService metricService) {
        this.buildTsBlockFromMergeReaderAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.buildTsBlockFromMergeReaderNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_MERGE_READER, Tag.FROM.toString(), NULL, Tag.TYPE.toString(), type}));
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindBloomFilter(metricService);
        this.bindTimeseriesMetadata(metricService);
        this.bindAlignedTimeseriesMetadata(metricService);
        this.bindTimeSeriesMetadataCache(metricService);
        this.bindReadTimeseriesMetadata(metricService);
        this.bindTimeseriesMetadataModification(metricService);
        this.bindLoadChunkMetadataList(metricService);
        this.bindChunkMetadataModification(metricService);
        this.bindChunkMetadataFilter(metricService);
        this.bindConstructChunkReader(metricService);
        this.bindReadChunk(metricService);
        this.bindChunk(metricService);
        this.bindInitChunkReader(metricService);
        this.bindTsBlockFromPageReader(metricService);
        this.bindBuildTsBlockFromMergeReader(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindBloomFilter(metricService);
        this.unbindTimeseriesMetadata(metricService);
        this.unbindTimeSeriesMetadataCache(metricService);
        this.unbindReadTimeseriesMetadata(metricService);
        this.unbindTimeseriesMetadataModification(metricService);
        this.unbindLoadChunkMetadataList(metricService);
        this.unbindChunkMetadataModification(metricService);
        this.unbindChunkMetadataFilter(metricService);
        this.unbindConstructChunkReader(metricService);
        this.unbindReadChunk(metricService);
        this.unbindChunk(metricService);
        this.unbindInitChunkReader(metricService);
        this.unbindTsBlockFromPageReader(metricService);
        this.unbindBuildTsBlockFromMergeReader(metricService);
    }

    public void recordSeriesScanCost(String type, long cost) {
        switch (type) {
            case "timeseries_metadata_modification_aligned": {
                this.timeseriesMetadataModificationAlignedTimer.updateNanos(cost);
                break;
            }
            case "timeseries_metadata_modification_non_aligned": {
                this.timeseriesMetadataModificationNonAlignedTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_aligned_mem": {
                this.loadChunkMetadataListAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_aligned_disk": {
                this.loadChunkMetadataListAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_non_aligned_mem": {
                this.loadChunkMetadataListNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_non_aligned_disk": {
                this.loadChunkMetadataListNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_aligned_mem": {
                this.chunkMetadataFilterAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_aligned_disk": {
                this.chunkMetadataFilterAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_non_aligned_mem": {
                this.chunkMetadataFilterNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_non_aligned_disk": {
                this.chunkMetadataFilterNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_aligned_mem": {
                this.chunkMetadataModificationAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_aligned_disk": {
                this.chunkMetadataModificationAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_non_aligned_mem": {
                this.chunkMetadataModificationNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_non_aligned_disk": {
                this.chunkMetadataModificationNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_aligned_mem": {
                this.initChunkReaderAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_aligned_disk": {
                this.initChunkReaderAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_non_aligned_mem": {
                this.initChunkReaderNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_non_aligned_disk": {
                this.initChunkReaderNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_merge_reader_aligned": {
                this.buildTsBlockFromMergeReaderAlignedTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_merge_reader_non_aligned": {
                this.buildTsBlockFromMergeReaderNonAlignedTimer.updateNanos(cost);
                break;
            }
            case "read_timeseries_metadata_cache": {
                this.readTimeseriesMetadataCacheTimer.updateNanos(cost);
                break;
            }
            case "read_timeseries_metadata_file": {
                this.readTimeseriesMetadataFileTimer.updateNanos(cost);
                break;
            }
            case "read_chunk_cache": {
                this.readChunkCacheTimer.updateNanos(cost);
                break;
            }
            case "read_chunk_file": {
                this.readChunkFileTimer.updateNanos(cost);
                break;
            }
        }
    }

    private SeriesScanCostMetricSet() {
    }

    private static class InstanceHolder {
        private static final SeriesScanCostMetricSet INSTANCE = new SeriesScanCostMetricSet();

        private InstanceHolder() {
        }
    }
}

