/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ISchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class SchemaQueryScanOperator<T extends ISchemaInfo>
implements SourceOperator {
    private static final long DEFAULT_MAX_TS_BLOCK_SIZE_IN_BYTES;
    private static final long MAX_SIZE;
    private static final long INSTANCE_SIZE;
    protected PlanNodeId sourceId;
    protected OperatorContext operatorContext;
    private final ISchemaSource<T> schemaSource;
    private long limit = -1L;
    private long offset = 0L;
    private String database;
    private final List<TSDataType> outputDataTypes;
    private ISchemaReader<T> schemaReader;
    private final TsBlockBuilder tsBlockBuilder;
    private ListenableFuture<?> isBlocked;
    private TsBlock next;
    private boolean isFinished;
    private long count = 0L;

    public SchemaQueryScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, ISchemaSource<T> schemaSource) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.schemaSource = schemaSource;
        this.outputDataTypes = schemaSource.getInfoQueryColumnHeaders().stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        this.tsBlockBuilder = new TsBlockBuilder(this.outputDataTypes);
    }

    protected ISchemaReader<T> createSchemaReader() {
        return this.schemaSource.getSchemaReader(((SchemaDriverContext)this.operatorContext.getDriverContext()).getSchemaRegion());
    }

    private void setColumns(T element, TsBlockBuilder builder) {
        this.schemaSource.transformToTsBlockColumns(element, builder, this.getDatabase());
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked == null) {
            this.isBlocked = this.tryGetNext();
        }
        return this.isBlocked;
    }

    private ListenableFuture<?> tryGetNext() {
        if (this.schemaReader == null) {
            this.schemaReader = this.createSchemaReader();
        }
        try {
            block7: {
                while (true) {
                    ListenableFuture<?> readerBlocked;
                    if (!(readerBlocked = this.schemaReader.isBlocked()).isDone()) {
                        SettableFuture settableFuture = SettableFuture.create();
                        readerBlocked.addListener(() -> {
                            this.next = this.tsBlockBuilder.build();
                            this.tsBlockBuilder.reset();
                            settableFuture.set(null);
                        }, MoreExecutors.directExecutor());
                        return settableFuture;
                    }
                    if (!this.schemaReader.hasNext() || this.limit >= 0L && this.count >= this.offset + this.limit) break block7;
                    T element = this.schemaReader.next();
                    if (++this.count <= this.offset) continue;
                    this.setColumns(element, this.tsBlockBuilder);
                    if (this.tsBlockBuilder.getRetainedSizeInBytes() >= MAX_SIZE) break;
                }
                this.next = this.tsBlockBuilder.build();
                this.tsBlockBuilder.reset();
                return NOT_BLOCKED;
            }
            if (this.tsBlockBuilder.isEmpty()) {
                this.next = null;
                this.isFinished = true;
            } else {
                this.next = this.tsBlockBuilder.build();
            }
            this.tsBlockBuilder.reset();
            return NOT_BLOCKED;
        }
        catch (Exception e) {
            throw new SchemaExecutionException((Throwable)e);
        }
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        TsBlock ret = this.next;
        this.next = null;
        this.isBlocked = null;
        return ret;
    }

    @Override
    public boolean hasNext() throws Exception {
        this.isBlocked().get();
        if (!this.schemaReader.isSuccess()) {
            throw new SchemaExecutionException(this.schemaReader.getFailure());
        }
        return this.next != null;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.isFinished;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return DEFAULT_MAX_TS_BLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return DEFAULT_MAX_TS_BLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    protected String getDatabase() {
        if (this.database == null) {
            this.database = ((SchemaDriverContext)this.operatorContext.getDriverContext()).getSchemaRegion().getDatabaseFullPath();
        }
        return this.database;
    }

    @Override
    public void close() throws Exception {
        if (this.schemaReader != null) {
            this.schemaReader.close();
            this.schemaReader = null;
        }
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId) + RamUsageEstimator.sizeOf((String)this.database);
    }

    static {
        MAX_SIZE = DEFAULT_MAX_TS_BLOCK_SIZE_IN_BYTES = (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
        INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SchemaQueryScanOperator.class);
    }
}

