/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.session;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfo;
import org.apache.iotdb.service.rpc.thrift.TSConnectionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class IClientSession {
    private long id;
    private IoTDBConstant.ClientVersion clientVersion;
    private ZoneId zoneId;
    private TimeZone timeZone;
    private String username;
    private boolean login = false;
    private long logInTime;
    private SqlDialect sqlDialect = SqlDialect.TREE;
    @Nullable
    private String databaseName;

    public abstract String getClientAddress();

    public abstract int getClientPort();

    abstract TSConnectionType getConnectionType();

    abstract String getConnectionId();

    public void setClientVersion(IoTDBConstant.ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public IoTDBConstant.ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        this.timeZone = TimeZone.getTimeZone(zoneId);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.zoneId = timeZone.toZoneId();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public void setLogInTime(long logInTime) {
        this.logInTime = logInTime;
    }

    public long getLogInTime() {
        return this.logInTime;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        return String.format("%d-%s:%s", this.getId(), this.getUsername(), this.getConnectionId());
    }

    public TSConnectionInfo convertToTSConnectionInfo() {
        return new TSConnectionInfo(this.getUsername(), this.getLogInTime(), this.getConnectionId(), this.getConnectionType());
    }

    public abstract Iterable<Long> getStatementIds();

    public abstract void addStatementId(long var1);

    public abstract Set<Long> removeStatementId(long var1);

    public abstract void addQueryId(Long var1, long var2);

    public abstract void removeQueryId(Long var1, Long var2);

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
    }

    public static enum SqlDialect {
        TREE(0),
        TABLE(1);

        private final byte dialect;

        private SqlDialect(byte dialect) {
            this.dialect = dialect;
        }

        public byte getDialect() {
            return this.dialect;
        }

        public void serialize(DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((byte)this.dialect, (OutputStream)stream);
        }

        public void serialize(ByteBuffer buffer) {
            ReadWriteIOUtils.write((byte)this.dialect, (ByteBuffer)buffer);
        }

        public static SqlDialect deserializeFrom(ByteBuffer buffer) {
            byte b = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
            switch (b) {
                case 0: {
                    return TREE;
                }
                case 1: {
                    return TABLE;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown sql dialect: %s", b));
        }
    }
}

