/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.LongConsumer;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileInput;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.tsfile.file.IMetadataIndexEntry;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.TsFileInput;
import org.apache.tsfile.utils.Pair;

public class CompactionTsFileReader
extends TsFileSequenceReader {
    private long metadataOffset = 0L;
    CompactionType compactionType;
    private volatile boolean readingAlignedSeries = false;

    public CompactionTsFileReader(String file, CompactionType compactionType) throws IOException {
        super(file);
        this.tsFileInput = new CompactionTsFileInput(this.tsFileInput);
        this.compactionType = compactionType;
        this.metadataOffset = this.readFileMetadata().getMetaOffset();
    }

    protected ByteBuffer readData(long position, int totalSize, LongConsumer ioSizeRecorder) throws IOException {
        this.acquireReadDataSizeWithCompactionReadRateLimiter(totalSize);
        ByteBuffer buffer = super.readData(position, totalSize, ioSizeRecorder);
        if (position >= this.metadataOffset) {
            CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, totalSize);
        } else {
            CompactionMetrics.getInstance().recordReadInfo(this.compactionType, this.readingAlignedSeries ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, totalSize);
        }
        return buffer;
    }

    public void markStartOfAlignedSeries() {
        this.readingAlignedSeries = true;
    }

    public void markEndOfAlignedSeries() {
        this.readingAlignedSeries = false;
    }

    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        return super.readMemChunk(metaData);
    }

    public ChunkHeader readChunkHeader(long position) throws IOException {
        return ChunkHeader.deserializeFrom((TsFileInput)this.tsFileInput, (long)position);
    }

    public InputStream wrapAsInputStream() throws IOException {
        return this.tsFileInput.wrapAsInputStream();
    }

    public Map<String, Pair<TimeseriesMetadata, Pair<Long, Long>>> getTimeseriesMetadataAndOffsetByDevice(MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        LinkedHashMap<String, Pair<TimeseriesMetadata, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Pair<TimeseriesMetadata, Pair<Long, Long>>>();
        List childrenEntryList = measurementNode.getChildren();
        for (int i = 0; i < childrenEntryList.size(); ++i) {
            long startOffset = ((IMetadataIndexEntry)childrenEntryList.get(i)).getOffset();
            long endOffset = i == childrenEntryList.size() - 1 ? measurementNode.getEndOffset() : ((IMetadataIndexEntry)childrenEntryList.get(i + 1)).getOffset();
            ByteBuffer nextBuffer = this.readData(startOffset, endOffset);
            if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (nextBuffer.hasRemaining()) {
                    int metadataStartOffset = nextBuffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom((ByteBuffer)nextBuffer, excludedMeasurementIds, (boolean)needChunkMetadata);
                    timeseriesMetadataOffsetMap.put(timeseriesMetadata.getMeasurementId(), (Pair<TimeseriesMetadata, Pair<Long, Long>>)new Pair((Object)timeseriesMetadata, (Object)new Pair((Object)(startOffset + (long)metadataStartOffset), (Object)(startOffset + (long)nextBuffer.position()))));
                }
                continue;
            }
            MetadataIndexNode nextLayerMeasurementNode = MetadataIndexNode.deserializeFrom((ByteBuffer)nextBuffer, (boolean)false);
            timeseriesMetadataOffsetMap.putAll(this.getTimeseriesMetadataAndOffsetByDevice(nextLayerMeasurementNode, excludedMeasurementIds, needChunkMetadata));
        }
        return timeseriesMetadataOffsetMap;
    }

    public Map<String, Pair<Long, Long>> getTimeseriesMetadataOffsetByDevice(MetadataIndexNode measurementNode) throws IOException {
        LinkedHashMap<String, Pair<Long, Long>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Pair<Long, Long>>();
        List childrenEntryList = measurementNode.getChildren();
        for (int i = 0; i < childrenEntryList.size(); ++i) {
            long endOffset;
            long startOffset = ((IMetadataIndexEntry)childrenEntryList.get(i)).getOffset();
            long l = endOffset = i == childrenEntryList.size() - 1 ? measurementNode.getEndOffset() : ((IMetadataIndexEntry)childrenEntryList.get(i + 1)).getOffset();
            if (measurementNode.getNodeType().equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                timeseriesMetadataOffsetMap.put(((IMetadataIndexEntry)childrenEntryList.get(i)).getCompareKey().toString(), (Pair<Long, Long>)new Pair((Object)startOffset, (Object)endOffset));
                continue;
            }
            ByteBuffer nextBuffer = this.readData(startOffset, endOffset);
            MetadataIndexNode nextLayerMeasurementNode = MetadataIndexNode.deserializeFrom((ByteBuffer)nextBuffer, (boolean)false);
            timeseriesMetadataOffsetMap.putAll(this.getTimeseriesMetadataOffsetByDevice(nextLayerMeasurementNode));
        }
        return timeseriesMetadataOffsetMap;
    }

    private void acquireReadDataSizeWithCompactionReadRateLimiter(int readDataSize) {
        CompactionTaskManager.getInstance().getCompactionReadOperationRateLimiter().acquire(1);
        CompactionTaskManager.getInstance().getCompactionReadRateLimiter().acquire(readDataSize);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

