/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SubscriptionBlockingPendingQueue;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.iotdb.rpc.subscription.payload.poll.TabletsPayload;
import org.apache.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPrefetchingTabletQueue
extends SubscriptionPrefetchingQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPrefetchingTabletQueue.class);

    public SubscriptionPrefetchingTabletQueue(String brokerId, String topicName, SubscriptionBlockingPendingQueue inputPendingQueue, AtomicLong commitIdGenerator) {
        super(brokerId, topicName, inputPendingQueue, commitIdGenerator, SubscriptionConfig.getInstance().getSubscriptionPrefetchTabletBatchMaxDelayInMs(), SubscriptionConfig.getInstance().getSubscriptionPrefetchTabletBatchMaxSizeInBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionEvent pollTablets(String consumerId, SubscriptionCommitContext commitContext, int offset) {
        this.acquireReadLock();
        try {
            SubscriptionEvent subscriptionEvent = this.isClosed() ? null : this.pollTabletsInternal(consumerId, commitContext, offset);
            return subscriptionEvent;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private @NonNull SubscriptionEvent pollTabletsInternal(String consumerId, SubscriptionCommitContext commitContext, int offset) {
        AtomicReference eventRef = new AtomicReference();
        this.inFlightEvents.compute(new Pair((Object)consumerId, (Object)commitContext), (key, ev) -> {
            if (Objects.isNull(ev)) {
                String errorMessage = String.format("SubscriptionPrefetchingTabletQueue %s is currently not transferring any tablet to consumer %s, commit context: %s, offset: %s", this, consumerId, commitContext, offset);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return null;
            }
            if (ev.isCommitted()) {
                ev.cleanUp(false);
                String errorMessage = String.format("outdated poll request after commit, consumer id: %s, commit context: %s, offset: %s, prefetching queue: %s", consumerId, commitContext, offset, this);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return null;
            }
            if (!Objects.equals(ev.getLastPolledConsumerId(), consumerId)) {
                String errorMessage = String.format("inconsistent polled consumer id, current: %s, incoming: %s, commit context: %s, offset: %s, prefetching queue: %s", ev.getLastPolledConsumerId(), consumerId, commitContext, offset, this);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return ev;
            }
            SubscriptionPollResponse response = ev.getCurrentResponse();
            if (Objects.isNull(response)) {
                String errorMessage = String.format("current response is null when fetching next response, consumer id: %s commit context: %s, offset: %s, prefetching queue: %s", consumerId, commitContext, offset, this);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return ev;
            }
            SubscriptionPollPayload payload = response.getPayload();
            short responseType = response.getResponseType();
            if (!SubscriptionPollResponseType.isValidatedResponseType((short)responseType)) {
                String errorMessage = String.format("unexpected response type: %s", responseType);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return ev;
            }
            switch (SubscriptionPollResponseType.valueOf((short)responseType)) {
                case TABLETS: {
                    if (Objects.equals(offset, ((TabletsPayload)payload).getNextOffset())) break;
                    String errorMessage = String.format("inconsistent offset, current: %s, incoming: %s, consumer: %s, prefetching queue: %s", ((TabletsPayload)payload).getNextOffset(), offset, consumerId, this);
                    LOGGER.warn(errorMessage);
                    eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                    return ev;
                }
                default: {
                    String errorMessage = String.format("unexpected response type: %s", responseType);
                    LOGGER.warn(errorMessage);
                    eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                    return ev;
                }
            }
            try {
                this.executeReceiverSubtask(() -> {
                    ev.fetchNextResponse(offset);
                    return null;
                }, SubscriptionAgent.receiver().remainingMs());
                ev.recordLastPolledTimestamp();
                eventRef.set(ev);
            }
            catch (Exception e) {
                String errorMessage = String.format("exception occurred when fetching next response: %s, consumer id: %s, commit context: %s, offset: %s, prefetching queue: %s", e, consumerId, commitContext, offset, this);
                LOGGER.warn(errorMessage, (Throwable)e);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
            }
            return ev;
        });
        return (SubscriptionEvent)eventRef.get();
    }

    @Override
    protected boolean onEvent(TsFileInsertionEvent event) {
        return this.batches.onEvent((EnrichedEvent)event, this::prefetchEvent);
    }

    public String toString() {
        return "SubscriptionPrefetchingTabletQueue" + this.coreReportMessage();
    }
}

