/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ErrorPayload
implements SubscriptionPollPayload {
    private transient String errorMessage;
    private transient boolean critical;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public ErrorPayload() {
    }

    public ErrorPayload(String errorMessage, boolean critical) {
        this.errorMessage = errorMessage;
        this.critical = critical;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.errorMessage, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.critical, (OutputStream)stream);
    }

    @Override
    public SubscriptionPollPayload deserialize(ByteBuffer buffer) {
        this.errorMessage = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.critical = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorPayload that = (ErrorPayload)obj;
        return Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.critical, that.critical);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessage, this.critical);
    }

    public String toString() {
        return "ErrorPayload{errorMessage=" + this.errorMessage + ", critical=" + this.critical + "}";
    }
}

