/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkGroupHeader;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MeasurementMetadataIndexEntry;
import org.apache.tsfile.file.metadata.MetadataIndexConstructor;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.TsFileMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.writer.FlushChunkMetadataListener;
import org.apache.tsfile.write.writer.LocalTsFileOutput;
import org.apache.tsfile.write.writer.TsFileOutput;
import org.apache.tsfile.write.writer.tsmiterator.TSMIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileIOWriter
implements AutoCloseable {
    protected static final byte[] MAGIC_STRING_BYTES;
    public static final byte VERSION_NUMBER_BYTE;
    protected static final TSFileConfig TS_FILE_CONFIG;
    private static final Logger logger;
    private static final Logger resourceLogger;
    protected TsFileOutput out;
    protected boolean canWrite = true;
    protected File file;
    protected ChunkMetadata currentChunkMetadata;
    protected List<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
    protected List<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
    private long markedPosition;
    private IDeviceID currentChunkGroupDeviceId;
    private long minPlanIndex;
    private long maxPlanIndex;
    protected long maxMetadataSize;
    protected long currentChunkMetadataSize = 0L;
    protected File chunkMetadataTempFile;
    protected LocalTsFileOutput tempOutput;
    protected volatile boolean hasChunkMetadataInDisk = false;
    protected int pathCount = 0;
    private Path lastSerializePath = null;
    protected LinkedList<Long> endPosInCMTForDevice = new LinkedList();
    private volatile int chunkMetadataCount = 0;
    public static final String CHUNK_METADATA_TEMP_FILE_SUFFIX = ".meta";
    private final List<FlushChunkMetadataListener> flushListeners = new ArrayList<FlushChunkMetadataListener>();

    protected TsFileIOWriter() {
    }

    public TsFileIOWriter(File file) throws IOException {
        this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(file.getPath(), false);
        this.file = file;
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} writer is opened.", (Object)file.getName());
        }
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput output) throws IOException {
        this.out = output;
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput output, boolean test) {
        this.out = output;
    }

    public TsFileIOWriter(File file, long maxMetadataSize) throws IOException {
        this(file);
        this.maxMetadataSize = maxMetadataSize;
        this.chunkMetadataTempFile = new File(file.getAbsolutePath() + CHUNK_METADATA_TEMP_FILE_SUFFIX);
    }

    public void addFlushListener(FlushChunkMetadataListener listener) {
        this.flushListeners.add(listener);
    }

    public void writeBytesToStream(PublicBAOS bytes) throws IOException {
        bytes.writeTo(this.out.wrapAsStream());
    }

    protected void startFile() throws IOException {
        this.out.write(MAGIC_STRING_BYTES);
        this.out.write(VERSION_NUMBER_BYTE);
    }

    public int startChunkGroup(IDeviceID deviceId) throws IOException {
        this.currentChunkGroupDeviceId = deviceId;
        if (logger.isDebugEnabled()) {
            logger.debug("start chunk group:{}, file position {}", (Object)deviceId, (Object)this.out.getPosition());
        }
        this.chunkMetadataList = new ArrayList<ChunkMetadata>();
        ChunkGroupHeader chunkGroupHeader = new ChunkGroupHeader(this.currentChunkGroupDeviceId);
        return chunkGroupHeader.serializeTo(this.out.wrapAsStream());
    }

    public void endChunkGroup() throws IOException {
        if (this.currentChunkGroupDeviceId == null || this.chunkMetadataList.isEmpty()) {
            return;
        }
        this.chunkGroupMetadataList.add(new ChunkGroupMetadata(this.currentChunkGroupDeviceId, this.chunkMetadataList));
        this.currentChunkGroupDeviceId = null;
        this.chunkMetadataList = null;
        this.out.flush();
    }

    public boolean isWritingChunkGroup() {
        return this.currentChunkGroupDeviceId != null;
    }

    public void startFlushChunk(String measurementId, CompressionType compressionCodecName, TSDataType tsDataType, TSEncoding encodingType, Statistics<? extends Serializable> statistics, int dataSize, int numOfPages, int mask) throws IOException {
        this.currentChunkMetadata = new ChunkMetadata(measurementId, tsDataType, this.out.getPosition(), statistics);
        this.currentChunkMetadata.setMask((byte)mask);
        ChunkHeader header = new ChunkHeader(measurementId, dataSize, tsDataType, compressionCodecName, encodingType, numOfPages, mask);
        header.serializeTo(this.out.wrapAsStream());
    }

    public void writeChunk(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        ChunkHeader chunkHeader = chunk.getHeader();
        this.currentChunkMetadata = new ChunkMetadata(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), this.out.getPosition(), chunkMetadata.getStatistics());
        chunkHeader.serializeTo(this.out.wrapAsStream());
        this.out.write(chunk.getData());
        this.endCurrentChunk();
        if (logger.isDebugEnabled()) {
            logger.debug("end flushing a chunk:{}, totalvalue:{}", (Object)chunkHeader.getMeasurementID(), (Object)chunkMetadata.getNumOfPoints());
        }
    }

    public void writeEmptyValueChunk(String measurementId, CompressionType compressionType, TSDataType tsDataType, TSEncoding encodingType, Statistics<? extends Serializable> statistics) throws IOException {
        this.currentChunkMetadata = new ChunkMetadata(measurementId, tsDataType, this.out.getPosition(), statistics);
        this.currentChunkMetadata.setMask((byte)64);
        ChunkHeader emptyChunkHeader = new ChunkHeader(measurementId, 0, tsDataType, compressionType, encodingType, 0, 64);
        emptyChunkHeader.serializeTo(this.out.wrapAsStream());
        this.endCurrentChunk();
    }

    public void writeChunk(Chunk chunk) throws IOException {
        ChunkHeader chunkHeader = chunk.getHeader();
        this.currentChunkMetadata = new ChunkMetadata(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), this.out.getPosition(), chunk.getChunkStatistic());
        chunkHeader.serializeTo(this.out.wrapAsStream());
        this.out.write(chunk.getData());
        this.endCurrentChunk();
    }

    public void endCurrentChunk() {
        this.currentChunkMetadataSize += this.currentChunkMetadata.getRetainedSizeInBytes();
        ++this.chunkMetadataCount;
        this.chunkMetadataList.add(this.currentChunkMetadata);
        this.currentChunkMetadata = null;
    }

    public void endFile() throws IOException {
        File chunkMetadataFile;
        this.checkInMemoryPathCount();
        this.readChunkMetadataAndConstructIndexTree();
        long footerIndex = this.out.getPosition();
        if (logger.isDebugEnabled()) {
            logger.debug("start to flush the footer,file pos:{}", (Object)footerIndex);
        }
        this.out.write(MAGIC_STRING_BYTES);
        this.out.force();
        this.out.close();
        if (resourceLogger.isDebugEnabled() && this.file != null) {
            resourceLogger.debug("{} writer is closed.", (Object)this.file.getName());
        }
        if (this.file != null && (chunkMetadataFile = new File(this.file.getAbsolutePath() + CHUNK_METADATA_TEMP_FILE_SUFFIX)).exists()) {
            FileUtils.delete((File)chunkMetadataFile);
        }
        this.canWrite = false;
    }

    private void checkInMemoryPathCount() {
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            this.pathCount += chunkGroupMetadata.getChunkMetadataList().size();
        }
    }

    private void readChunkMetadataAndConstructIndexTree() throws IOException {
        if (this.tempOutput != null) {
            this.tempOutput.close();
        }
        long metaOffset = this.out.getPosition();
        ReadWriteIOUtils.write((byte)2, this.out.wrapAsStream());
        TSMIterator tsmIterator = this.hasChunkMetadataInDisk ? TSMIterator.getTSMIteratorInDisk(this.chunkMetadataTempFile, this.chunkGroupMetadataList, this.endPosInCMTForDevice) : TSMIterator.getTSMIteratorInMemory(this.chunkGroupMetadataList);
        TreeMap<IDeviceID, MetadataIndexNode> deviceMetadataIndexMap = new TreeMap<IDeviceID, MetadataIndexNode>();
        ArrayDeque<MetadataIndexNode> measurementMetadataIndexQueue = new ArrayDeque<MetadataIndexNode>();
        IDeviceID currentDevice = null;
        IDeviceID prevDevice = null;
        Path currentPath = null;
        MetadataIndexNode currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
        int seriesIdxForCurrDevice = 0;
        BloomFilter filter = BloomFilter.getEmptyBloomFilter(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate(), this.pathCount);
        while (tsmIterator.hasNext()) {
            Pair<Path, TimeseriesMetadata> timeseriesMetadataPair = tsmIterator.next();
            TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)timeseriesMetadataPair.right;
            currentPath = (Path)timeseriesMetadataPair.left;
            filter.add(currentPath.getFullPath());
            currentDevice = currentPath.getIDeviceID();
            if (!currentDevice.equals(prevDevice)) {
                if (prevDevice != null) {
                    MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, this.out);
                    deviceMetadataIndexMap.put(prevDevice, MetadataIndexConstructor.generateRootNode(measurementMetadataIndexQueue, this.out, MetadataIndexNodeType.INTERNAL_MEASUREMENT));
                    currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
                }
                measurementMetadataIndexQueue = new ArrayDeque();
                seriesIdxForCurrDevice = 0;
            }
            if (seriesIdxForCurrDevice % TS_FILE_CONFIG.getMaxDegreeOfIndexNode() == 0) {
                if (currentIndexNode.isFull()) {
                    MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, this.out);
                    currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
                }
                if (timeseriesMetadata.getTsDataType() != TSDataType.VECTOR) {
                    currentIndexNode.addEntry(new MeasurementMetadataIndexEntry(currentPath.getMeasurement(), this.out.getPosition()));
                } else {
                    currentIndexNode.addEntry(new MeasurementMetadataIndexEntry("", this.out.getPosition()));
                }
            }
            prevDevice = currentDevice;
            ++seriesIdxForCurrDevice;
            timeseriesMetadata.serializeTo(this.out.wrapAsStream());
        }
        MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, this.out);
        if (prevDevice != null) {
            deviceMetadataIndexMap.put(prevDevice, MetadataIndexConstructor.generateRootNode(measurementMetadataIndexQueue, this.out, MetadataIndexNodeType.INTERNAL_MEASUREMENT));
        }
        MetadataIndexNode metadataIndex = MetadataIndexConstructor.checkAndBuildLevelIndex(deviceMetadataIndexMap, this.out);
        TsFileMetadata tsFileMetadata = new TsFileMetadata();
        tsFileMetadata.setMetadataIndex(metadataIndex);
        tsFileMetadata.setMetaOffset(metaOffset);
        int size = tsFileMetadata.serializeTo(this.out.wrapAsStream());
        ReadWriteIOUtils.write(size += tsFileMetadata.serializeBloomFilter(this.out.wrapAsStream(), filter), this.out.wrapAsStream());
    }

    public long getPos() throws IOException {
        return this.out.getPosition();
    }

    public Map<IDeviceID, List<ChunkMetadata>> getDeviceChunkMetadataMap() {
        HashMap<IDeviceID, List<ChunkMetadata>> deviceChunkMetadataMap = new HashMap<IDeviceID, List<ChunkMetadata>>();
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            deviceChunkMetadataMap.computeIfAbsent(chunkGroupMetadata.getDevice(), k -> new ArrayList()).addAll(chunkGroupMetadata.getChunkMetadataList());
        }
        return deviceChunkMetadataMap;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public void mark() throws IOException {
        this.markedPosition = this.getPos();
    }

    public void reset() throws IOException {
        this.out.truncate(this.markedPosition);
    }

    @Override
    public void close() throws IOException {
        this.canWrite = false;
        this.out.close();
        if (this.tempOutput != null) {
            this.tempOutput.close();
        }
    }

    void writeSeparatorMaskForTest() throws IOException {
        this.out.write(new byte[]{2});
    }

    void writeChunkGroupMarkerForTest() throws IOException {
        this.out.write(new byte[]{0});
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void writePlanIndices() throws IOException {
        ReadWriteIOUtils.write((byte)4, this.out.wrapAsStream());
        ReadWriteIOUtils.write(this.minPlanIndex, this.out.wrapAsStream());
        ReadWriteIOUtils.write(this.maxPlanIndex, this.out.wrapAsStream());
        this.out.flush();
    }

    public void truncate(long offset) throws IOException {
        this.out.truncate(offset);
    }

    public TsFileOutput getIOWriterOut() {
        return this.out;
    }

    public List<ChunkMetadata> getChunkMetadataListOfCurrentDeviceInMemory() {
        return this.chunkMetadataList;
    }

    public Map<IDeviceID, List<TimeseriesMetadata>> getDeviceTimeseriesMetadataMap() {
        TreeMap<IDeviceID, List<TimeseriesMetadata>> deviceTimeseriesMetadataMap = new TreeMap<IDeviceID, List<TimeseriesMetadata>>();
        TreeMap<IDeviceID, Map> chunkMetadataMap = new TreeMap<IDeviceID, Map>();
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                chunkMetadataMap.computeIfAbsent(chunkGroupMetadata.getDevice(), x -> new TreeMap()).computeIfAbsent(chunkMetadata.getMeasurementUid(), x -> new ArrayList()).add(chunkMetadata);
            }
        }
        for (IDeviceID device : chunkMetadataMap.keySet()) {
            Map seriesToChunkMetadataMap = (Map)chunkMetadataMap.get(device);
            for (Map.Entry entry : seriesToChunkMetadataMap.entrySet()) {
                try {
                    deviceTimeseriesMetadataMap.computeIfAbsent(device, x -> new ArrayList()).add(TSMIterator.constructOneTimeseriesMetadata((String)entry.getKey(), (List)entry.getValue()));
                }
                catch (IOException e) {
                    logger.error("Failed to get device timeseries metadata map", (Throwable)e);
                    return null;
                }
            }
        }
        return deviceTimeseriesMetadataMap;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    public long getMaxMetadataSize() {
        return this.maxMetadataSize;
    }

    public void setMaxMetadataSize(long maxMetadataSize) {
        this.maxMetadataSize = maxMetadataSize;
    }

    public int checkMetadataSizeAndMayFlush() throws IOException {
        if (this.currentChunkMetadataSize > this.maxMetadataSize) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Flushing chunk metadata, total size is {}, count is {}, avg size is {}", new Object[]{this.currentChunkMetadataSize, this.chunkMetadataCount, this.currentChunkMetadataSize / (long)this.chunkMetadataCount});
                }
                return this.sortAndFlushChunkMetadata();
            }
            catch (IOException e) {
                logger.error("Meets exception when flushing metadata to temp file for {}", (Object)this.file, (Object)e);
                throw e;
            }
        }
        return 0;
    }

    protected int sortAndFlushChunkMetadata() throws IOException {
        int writtenSize = 0;
        List<Pair<Path, List<IChunkMetadata>>> sortedChunkMetadataList = TSMIterator.sortChunkMetadata(this.chunkGroupMetadataList, this.currentChunkGroupDeviceId, this.chunkMetadataList);
        if (this.tempOutput == null) {
            this.tempOutput = new LocalTsFileOutput(new FileOutputStream(this.chunkMetadataTempFile));
        }
        this.hasChunkMetadataInDisk = true;
        ArrayList<Pair<Pair<IDeviceID, String>, List<IChunkMetadata>>> sortedChunkMetadataListForCallBack = new ArrayList<Pair<Pair<IDeviceID, String>, List<IChunkMetadata>>>();
        for (Pair<Path, List<IChunkMetadata>> pair : sortedChunkMetadataList) {
            boolean isNewPath;
            Path seriesPath = (Path)pair.left;
            boolean bl = isNewPath = !seriesPath.equals(this.lastSerializePath);
            if (isNewPath) {
                ++this.pathCount;
            }
            List iChunkMetadataList = (List)pair.right;
            writtenSize += this.writeChunkMetadataToTempFile(iChunkMetadataList, seriesPath, isNewPath);
            this.lastSerializePath = seriesPath;
            sortedChunkMetadataListForCallBack.add(new Pair<Pair<IDeviceID, String>, List>(new Pair<IDeviceID, String>(seriesPath.getIDeviceID(), seriesPath.getMeasurement()), iChunkMetadataList));
            logger.debug("Flushing {}", (Object)seriesPath);
        }
        for (FlushChunkMetadataListener listener : this.flushListeners) {
            listener.onFlush(sortedChunkMetadataListForCallBack);
        }
        this.chunkGroupMetadataList.clear();
        if (this.chunkMetadataList != null) {
            this.chunkMetadataList.clear();
        }
        this.chunkMetadataCount = 0;
        this.currentChunkMetadataSize = 0L;
        return writtenSize;
    }

    private int writeChunkMetadataToTempFile(List<IChunkMetadata> iChunkMetadataList, Path seriesPath, boolean isNewPath) throws IOException {
        int writtenSize = 0;
        if (this.lastSerializePath == null || !seriesPath.getDevice().equals(this.lastSerializePath.getDevice())) {
            this.endPosInCMTForDevice.add(this.tempOutput.getPosition());
            writtenSize += ReadWriteIOUtils.write(seriesPath.getDevice(), this.tempOutput.wrapAsStream());
        }
        if (isNewPath && !iChunkMetadataList.isEmpty()) {
            writtenSize += ReadWriteIOUtils.writeVar(seriesPath.getMeasurement(), this.tempOutput.wrapAsStream());
            writtenSize += ReadWriteIOUtils.write(iChunkMetadataList.get(0).getDataType(), this.tempOutput.wrapAsStream());
        }
        PublicBAOS buffer = new PublicBAOS();
        int totalSize = 0;
        for (IChunkMetadata chunkMetadata : iChunkMetadataList) {
            totalSize += chunkMetadata.serializeTo(buffer, true);
        }
        writtenSize += ReadWriteIOUtils.write(totalSize, this.tempOutput.wrapAsStream());
        buffer.writeTo(this.tempOutput);
        return writtenSize += buffer.size();
    }

    public List<ChunkGroupMetadata> getChunkGroupMetadataList() {
        return this.chunkGroupMetadataList;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public TsFileOutput getTsFileOutput() {
        return this.out;
    }

    static {
        TS_FILE_CONFIG = TSFileDescriptor.getInstance().getConfig();
        logger = LoggerFactory.getLogger(TsFileIOWriter.class);
        resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
        MAGIC_STRING_BYTES = BytesUtils.stringToBytes("TsFile");
        VERSION_NUMBER_BYTE = (byte)3;
    }
}

