/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.agent.task;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MetaProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.PipeTask;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.agent.task.PipeConfigNodeTask;
import org.apache.iotdb.confignode.manager.pipe.agent.task.PipeConfigNodeTaskBuilder;
import org.apache.iotdb.confignode.manager.pipe.agent.task.PipeConfigNodeTaskStage;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningFilter;
import org.apache.iotdb.confignode.manager.pipe.metric.overview.PipeConfigNodeRemainingTimeMetrics;
import org.apache.iotdb.confignode.manager.pipe.metric.source.PipeConfigRegionExtractorMetrics;
import org.apache.iotdb.confignode.manager.pipe.resource.PipeConfigNodeResourceManager;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaRespExceptionMessage;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigNodeTaskAgent
extends PipeTaskAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigNodeTaskAgent.class);

    protected boolean isShutdown() {
        return PipeConfigNodeAgent.runtime().isShutdown();
    }

    protected void thawRate(String pipeName, long creationTime) {
        PipeConfigNodeRemainingTimeMetrics.getInstance().thawRate(pipeName + "_" + creationTime);
    }

    protected void freezeRate(String pipeName, long creationTime) {
        PipeConfigNodeRemainingTimeMetrics.getInstance().freezeRate(pipeName + "_" + creationTime);
    }

    protected Map<Integer, PipeTask> buildPipeTasks(PipeMeta pipeMetaFromConfigNode) throws IllegalPathException {
        return new PipeConfigNodeTaskBuilder(pipeMetaFromConfigNode).build();
    }

    protected void createPipeTask(int consensusGroupId, PipeStaticMeta pipeStaticMeta, PipeTaskMeta pipeTaskMeta) throws IllegalPathException {
        if (consensusGroupId == Integer.MIN_VALUE && pipeTaskMeta.getLeaderNodeId() == ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId() && !ConfigRegionListeningFilter.parseListeningPlanTypeSet(pipeStaticMeta.getExtractorParameters()).isEmpty()) {
            PipeConfigNodeTask pipeTask = new PipeConfigNodeTask(new PipeConfigNodeTaskStage(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime(), pipeStaticMeta.getExtractorParameters().getAttribute(), pipeStaticMeta.getProcessorParameters().getAttribute(), pipeStaticMeta.getConnectorParameters().getAttribute(), pipeTaskMeta));
            pipeTask.create();
            this.pipeTaskManager.addPipeTask(pipeStaticMeta, consensusGroupId, (PipeTask)pipeTask);
        }
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupId2TaskMetaMap().put(consensusGroupId, pipeTaskMeta);
    }

    public void stopAllPipesWithCriticalException() {
        super.stopAllPipesWithCriticalException(ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId());
    }

    protected TPushPipeMetaRespExceptionMessage handleSinglePipeMetaChangesInternal(PipeMeta pipeMetaFromCoordinator) {
        try {
            return PipeConfigNodeAgent.runtime().isLeaderReady() ? super.handleSinglePipeMetaChangesInternal(pipeMetaFromCoordinator.deepCopy4TaskAgent()) : null;
        }
        catch (Exception e) {
            return new TPushPipeMetaRespExceptionMessage(pipeMetaFromCoordinator.getStaticMeta().getPipeName(), e.getMessage(), System.currentTimeMillis());
        }
    }

    protected TPushPipeMetaRespExceptionMessage handleDropPipeInternal(String pipeName) {
        return PipeConfigNodeAgent.runtime().isLeaderReady() ? super.handleDropPipeInternal(pipeName) : null;
    }

    protected List<TPushPipeMetaRespExceptionMessage> handlePipeMetaChangesInternal(List<PipeMeta> pipeMetaListFromCoordinator) {
        if (this.isShutdown() || !PipeConfigNodeAgent.runtime().isLeaderReady()) {
            return Collections.emptyList();
        }
        try {
            List exceptionMessages = super.handlePipeMetaChangesInternal(pipeMetaListFromCoordinator.stream().map(pipeMeta -> {
                try {
                    return pipeMeta.deepCopy4TaskAgent();
                }
                catch (Exception e) {
                    throw new PipeException("failed to deep copy pipeMeta", (Throwable)e);
                }
            }).collect(Collectors.toList()));
            this.clearConfigRegionListeningQueueIfNecessary(pipeMetaListFromCoordinator);
            return exceptionMessages;
        }
        catch (Exception e) {
            throw new PipeException("failed to handle pipe meta changes", (Throwable)e);
        }
    }

    private void clearConfigRegionListeningQueueIfNecessary(List<PipeMeta> pipeMetaListFromCoordinator) {
        AtomicLong listeningQueueNewFirstIndex = new AtomicLong(Long.MAX_VALUE);
        for (PipeMeta pipeMetaFromCoordinator : pipeMetaListFromCoordinator) {
            ConcurrentMap groupId2TaskMetaMap = pipeMetaFromCoordinator.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            for (Integer regionId : groupId2TaskMetaMap.keySet()) {
                if (regionId != Integer.MIN_VALUE) continue;
                ProgressIndex progressIndex = ((PipeTaskMeta)groupId2TaskMetaMap.get(regionId)).getProgressIndex();
                if (progressIndex instanceof MetaProgressIndex) {
                    if (((MetaProgressIndex)progressIndex).getIndex() + 1L >= listeningQueueNewFirstIndex.get()) continue;
                    listeningQueueNewFirstIndex.set(((MetaProgressIndex)progressIndex).getIndex() + 1L);
                    continue;
                }
                listeningQueueNewFirstIndex.set(0L);
            }
        }
        if (listeningQueueNewFirstIndex.get() < Long.MAX_VALUE) {
            PipeConfigNodeAgent.runtime().listener().removeBefore(listeningQueueNewFirstIndex.get());
        }
    }

    protected void collectPipeMetaListInternal(TPipeHeartbeatReq req, TPipeHeartbeatResp resp) throws TException {
        if (this.isShutdown() || !PipeConfigNodeAgent.runtime().isLeaderReady()) {
            return;
        }
        LOGGER.info("Received pipe heartbeat request {} from config coordinator.", (Object)req.heartbeatId);
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        ArrayList<Long> pipeRemainingEventCountList = new ArrayList<Long>();
        ArrayList<Double> pipeRemainingTimeList = new ArrayList<Double>();
        try {
            Optional logger = PipeConfigNodeResourceManager.log().schedule(PipeConfigNodeTaskAgent.class, PipeConfig.getInstance().getPipeMetaReportMaxLogNumPerRound(), PipeConfig.getInstance().getPipeMetaReportMaxLogIntervalRounds(), this.pipeMetaKeeper.getPipeMetaCount());
            for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
                pipeMetaBinaryList.add(pipeMeta.serialize());
                PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
                long remainingEventCount = PipeConfigRegionExtractorMetrics.getInstance().getRemainingEventCount(staticMeta.getPipeName(), staticMeta.getCreationTime());
                double estimatedRemainingTime = PipeConfigNodeRemainingTimeMetrics.getInstance().getRemainingTime(staticMeta.getPipeName(), staticMeta.getCreationTime());
                pipeRemainingEventCountList.add(remainingEventCount);
                pipeRemainingTimeList.add(estimatedRemainingTime);
                logger.ifPresent(l -> l.info("Reporting pipe meta: {}, remainingEventCount: {}, estimatedRemainingTime: {}", new Object[]{pipeMeta.coreReportMessage(), remainingEventCount, estimatedRemainingTime}));
            }
            LOGGER.info("Reported {} pipe metas.", (Object)pipeMetaBinaryList.size());
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
        resp.setPipeMetaList(pipeMetaBinaryList);
        resp.setPipeRemainingEventCountList(pipeRemainingEventCountList);
        resp.setPipeRemainingTimeList(pipeRemainingTimeList);
    }
}

