/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFIntegral
implements UDTF {
    private static final String TIME_UNIT_KEY = "unit";
    private static final String TIME_UNIT_MS = "1S";
    private static final String TIME_UNIT_S = "1s";
    private static final String TIME_UNIT_M = "1m";
    private static final String TIME_UNIT_H = "1H";
    private static final String TIME_UNIT_D = "1d";
    long unitTime;
    long lastTime = -1L;
    double lastValue;
    double integralValue = 0.0;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validate(unit -> TIME_UNIT_D.equals(unit) || TIME_UNIT_H.equals(unit) || TIME_UNIT_M.equals(unit) || TIME_UNIT_S.equals(unit) || TIME_UNIT_MS.equals(unit), "Unknown time unit input", (Object)validator.getParameters().getStringOrDefault(TIME_UNIT_KEY, TIME_UNIT_S));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        switch (parameters.getStringOrDefault(TIME_UNIT_KEY, TIME_UNIT_S)) {
            case "1S": {
                this.unitTime = 1L;
                break;
            }
            case "1s": {
                this.unitTime = 1000L;
                break;
            }
            case "1m": {
                this.unitTime = 60000L;
                break;
            }
            case "1H": {
                this.unitTime = 3600000L;
                break;
            }
            case "1d": {
                this.unitTime = 86400000L;
                break;
            }
            default: {
                throw new UDFException("Unknown time unit input: " + parameters.getStringOrDefault(TIME_UNIT_KEY, TIME_UNIT_S));
            }
        }
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        long nowTime = row.getTime();
        double nowValue = Util.getValueAsDouble(row);
        if (Double.isFinite(nowValue)) {
            if (this.lastTime >= 0L) {
                this.integralValue += (this.lastValue + nowValue) * (double)(nowTime - this.lastTime) / 2.0 / (double)this.unitTime;
            }
            this.lastTime = nowTime;
            this.lastValue = nowValue;
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        collector.putDouble(0L, this.integralValue);
    }
}

