/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractDatabaseMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.snapshot.MemMTreeSnapshotUtil;
import org.apache.iotdb.db.schemaengine.schemaregion.tag.TagLogFile;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRStatementGenerator
implements Iterator<Statement>,
Iterable<Statement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SRStatementGenerator.class);
    private IMemMNode curNode;
    private Exception lastExcept = null;
    private final InputStream inputStream;
    private final FileChannel tagFileChannel;
    private final Deque<IMemMNode> ancestors = new ArrayDeque<IMemMNode>();
    private final Deque<Integer> restChildrenNum = new ArrayDeque<Integer>();
    private final PartialPath databaseFullPath;
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private final Deque<Statement> statements = new ArrayDeque<Statement>();
    private final MNodeTranslater translater = new MNodeTranslater();
    private final MemMTreeSnapshotUtil.MNodeDeserializer deserializer = new MemMTreeSnapshotUtil.MNodeDeserializer();
    private int nodeCount = 0;

    public SRStatementGenerator(File mtreeFile, File tagFile, PartialPath databaseFullPath) throws IOException {
        this.inputStream = Files.newInputStream(mtreeFile.toPath(), new OpenOption[0]);
        this.tagFileChannel = tagFile != null ? FileChannel.open(tagFile.toPath(), StandardOpenOption.READ) : null;
        this.databaseFullPath = databaseFullPath;
        Byte version = ReadWriteIOUtils.readByte((InputStream)this.inputStream);
        this.curNode = SRStatementGenerator.deserializeMNode(this.ancestors, this.restChildrenNum, this.deserializer, this.inputStream);
        ++this.nodeCount;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.statements.isEmpty()) {
            return true;
        }
        if (this.lastExcept != null) {
            return false;
        }
        while (!this.ancestors.isEmpty()) {
            int childNum = this.restChildrenNum.pop();
            if (childNum == 0) {
                IMemMNode node = this.ancestors.pop();
                if (node.isDevice() && node.getAsDeviceMNode().isAligned()) {
                    Statement stmt = this.genAlignedTimeseriesStatement(node, this.databaseFullPath.getDevicePath().concatPath(node.getPartialPath()));
                    this.statements.push(stmt);
                }
                this.cleanMtreeNode(node);
                if (this.statements.isEmpty()) continue;
                return true;
            }
            this.restChildrenNum.push(childNum - 1);
            try {
                this.curNode = SRStatementGenerator.deserializeMNode(this.ancestors, this.restChildrenNum, this.deserializer, this.inputStream);
                ++this.nodeCount;
            }
            catch (IOException ioe) {
                this.lastExcept = ioe;
                try {
                    this.inputStream.close();
                    this.tagFileChannel.close();
                }
                catch (IOException e) {
                    this.lastExcept = e;
                }
                return false;
            }
            List stmts = (List)this.curNode.accept(this.translater, this.databaseFullPath.getDevicePath().concatPath(this.curNode.getPartialPath()));
            if (stmts != null) {
                this.statements.addAll(stmts);
            }
            if (this.statements.isEmpty()) continue;
            return true;
        }
        try {
            this.inputStream.close();
            if (this.tagFileChannel != null) {
                this.tagFileChannel.close();
            }
        }
        catch (IOException e) {
            this.lastExcept = e;
        }
        return false;
    }

    @Override
    public Statement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.statements.pop();
    }

    public void checkException() throws IOException {
        if (this.lastExcept != null) {
            throw new IOException(this.lastExcept);
        }
    }

    private void cleanMtreeNode(IMNode node) {
        IMNodeContainer children = node.getAsInternalMNode().getChildren();
        this.nodeCount -= children.size();
        node.getChildren().clear();
    }

    private static IMemMNode deserializeMNode(Deque<IMemMNode> ancestors, Deque<Integer> restChildrenNum, MemMTreeSnapshotUtil.MNodeDeserializer deserializer, InputStream inputStream) throws IOException {
        IMemMNode node;
        int childrenNum;
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        switch (type) {
            case 0: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeInternalMNode(inputStream);
                break;
            }
            case 1: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupMNode(inputStream);
                break;
            }
            case 3: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeEntityMNode(inputStream);
                break;
            }
            case 4: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupEntityMNode(inputStream);
                break;
            }
            case 2: {
                childrenNum = 0;
                node = deserializer.deserializeMeasurementMNode(inputStream);
                break;
            }
            case 5: {
                childrenNum = 0;
                node = deserializer.deserializeLogicalViewMNode(inputStream);
                break;
            }
            default: {
                throw new IOException("Unrecognized MNode type" + type);
            }
        }
        if (!ancestors.isEmpty()) {
            IMemMNode parent = ancestors.peek();
            node.setParent(ancestors.peek());
            parent.addChild(node);
        }
        if (childrenNum > 0 || SchemaConstant.isStorageGroupType((byte)type)) {
            ancestors.push(node);
            restChildrenNum.push(childrenNum);
        }
        return node;
    }

    private static List<Statement> genActivateTemplateStatement(IMNode node, PartialPath path) {
        if (node.getAsDeviceMNode().isUseTemplate()) {
            return Collections.singletonList(new ActivateTemplateStatement(path));
        }
        return null;
    }

    private Statement genAlignedTimeseriesStatement(IMNode node, PartialPath path) {
        IMNodeContainer measurements = node.getAsInternalMNode().getChildren();
        if (node.getAsDeviceMNode().isAligned()) {
            CreateAlignedTimeSeriesStatement stmt = new CreateAlignedTimeSeriesStatement();
            stmt.setDevicePath(path);
            boolean hasMeasurement = false;
            for (IMemMNode measurement : measurements.values()) {
                if (!measurement.isMeasurement() || measurement.getAsMeasurementMNode().isLogicalView()) continue;
                hasMeasurement = true;
                stmt.addMeasurement(measurement.getName());
                stmt.addDataType(measurement.getAsMeasurementMNode().getDataType());
                if (measurement.getAlias() != null) {
                    stmt.addAliasList(measurement.getAlias());
                } else {
                    stmt.addAliasList(null);
                }
                stmt.addEncoding(measurement.getAsMeasurementMNode().getSchema().getEncodingType());
                stmt.addCompressor(measurement.getAsMeasurementMNode().getSchema().getCompressor());
                if (measurement.getAsMeasurementMNode().getOffset() >= 0L) {
                    try {
                        Pair<Map<String, String>, Map<String, String>> tagsAndAttributes = this.getTagsAndAttributes(measurement.getAsMeasurementMNode().getOffset());
                        if (tagsAndAttributes != null) {
                            stmt.addAttributesList((Map)tagsAndAttributes.right);
                            stmt.addTagsList((Map)tagsAndAttributes.left);
                        }
                    }
                    catch (IOException ioException) {
                        this.lastExcept = ioException;
                        LOGGER.warn("Error when parse tag and attributes file of node path {}", (Object)path, (Object)ioException);
                    }
                    measurement.getAsMeasurementMNode().setOffset(0L);
                    continue;
                }
                stmt.addAttributesList(null);
                stmt.addTagsList(null);
            }
            return hasMeasurement ? stmt : null;
        }
        return null;
    }

    private Pair<Map<String, String>, Map<String, String>> getTagsAndAttributes(long offset) throws IOException {
        if (this.tagFileChannel != null) {
            ByteBuffer byteBuffer = TagLogFile.parseByteBuffer(this.tagFileChannel, offset);
            Pair tagsAndAttributes = new Pair((Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer), (Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
            return tagsAndAttributes;
        }
        LOGGER.warn("Measurement has set attributes or tags, but not find snapshot files");
        return null;
    }

    private class MNodeTranslater
    extends MNodeVisitor<List<Statement>, PartialPath> {
        private MNodeTranslater() {
        }

        public List<Statement> visitBasicMNode(IMNode<?> node, PartialPath path) {
            if (node.isDevice()) {
                return SRStatementGenerator.genActivateTemplateStatement(node, path);
            }
            return null;
        }

        public List<Statement> visitDatabaseMNode(AbstractDatabaseMNode<?, ? extends IMNode<?>> node, PartialPath path) {
            if (node.isDevice()) {
                return SRStatementGenerator.genActivateTemplateStatement(node, path);
            }
            return null;
        }

        public List<Statement> visitMeasurementMNode(AbstractMeasurementMNode<?, ? extends IMNode<?>> node, PartialPath path) {
            if (node.isLogicalView()) {
                ArrayList<Statement> statementList = new ArrayList<Statement>();
                CreateLogicalViewStatement stmt = new CreateLogicalViewStatement();
                LogicalViewSchema viewSchema = (LogicalViewSchema)node.getAsMeasurementMNode().getSchema();
                if (viewSchema != null) {
                    stmt.setTargetFullPaths(Collections.singletonList(path));
                    stmt.setViewExpressions(Collections.singletonList(viewSchema.getExpression()));
                    statementList.add(stmt);
                }
                if (node.getOffset() >= 0L) {
                    AlterTimeSeriesStatement alterTimeSeriesStatement = new AlterTimeSeriesStatement(true);
                    alterTimeSeriesStatement.setAlterType(AlterTimeSeriesStatement.AlterType.UPSERT);
                    alterTimeSeriesStatement.setPath(path);
                    try {
                        Pair tagsAndAttribute = SRStatementGenerator.this.getTagsAndAttributes(node.getOffset());
                        if (tagsAndAttribute != null) {
                            alterTimeSeriesStatement.setTagsMap((Map)tagsAndAttribute.left);
                            alterTimeSeriesStatement.setAttributesMap((Map)tagsAndAttribute.right);
                            statementList.add(alterTimeSeriesStatement);
                        }
                    }
                    catch (IOException ioException) {
                        SRStatementGenerator.this.lastExcept = ioException;
                        LOGGER.warn("Error when parse tag and attributes file of node path {}", (Object)path, (Object)ioException);
                    }
                }
                return statementList;
            }
            if (node.getParent().getAsDeviceMNode().isAligned()) {
                return null;
            }
            CreateTimeSeriesStatement stmt = new CreateTimeSeriesStatement();
            stmt.setPath(path);
            stmt.setAlias(node.getAlias());
            stmt.setCompressor(node.getAsMeasurementMNode().getSchema().getCompressor());
            stmt.setDataType(node.getDataType());
            stmt.setEncoding(node.getAsMeasurementMNode().getSchema().getEncodingType());
            if (node.getOffset() >= 0L) {
                try {
                    Pair tagsAndAttributes = SRStatementGenerator.this.getTagsAndAttributes(node.getOffset());
                    if (tagsAndAttributes != null) {
                        stmt.setTags((Map)tagsAndAttributes.left);
                        stmt.setAttributes((Map)tagsAndAttributes.right);
                    }
                }
                catch (IOException ioException) {
                    SRStatementGenerator.this.lastExcept = ioException;
                    LOGGER.warn("Error when parser tag and attributes files", (Throwable)ioException);
                }
                node.setOffset(0L);
            }
            return Collections.singletonList(stmt);
        }
    }
}

