/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionEventBinaryCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionEventBinaryCache.class);
    private final AtomicDouble memoryUsageCheatFactor = new AtomicDouble(1.0);
    private final LoadingCache<SubscriptionPollResponse, ByteBuffer> cache;

    ByteBuffer serialize(SubscriptionPollResponse response) throws IOException {
        try {
            return (ByteBuffer)this.cache.get((Object)response);
        }
        catch (Exception e) {
            LOGGER.warn("SubscriptionEventBinaryCache raised an exception while serializing SubscriptionPollResponse: {}", (Object)response, (Object)e);
            throw new IOException(e);
        }
    }

    Optional<ByteBuffer> trySerialize(SubscriptionPollResponse response) {
        try {
            return Optional.of(this.serialize(response));
        }
        catch (IOException e) {
            LOGGER.warn("Subscription: something unexpected happened when serializing SubscriptionPollResponse: {}", (Object)response, (Object)e);
            return Optional.empty();
        }
    }

    void invalidate(SubscriptionPollResponse response) {
        this.cache.invalidate((Object)response);
    }

    void invalidateAll(Iterable<SubscriptionPollResponse> responses) {
        this.cache.invalidateAll(responses);
    }

    static SubscriptionEventBinaryCache getInstance() {
        return SubscriptionEventBinaryCacheHolder.INSTANCE;
    }

    private SubscriptionEventBinaryCache() {
        long initMemorySizeInBytes = PipeDataNodeResourceManager.memory().getTotalMemorySizeInBytes() / 20L;
        long maxMemorySizeInBytes = (long)((float)PipeDataNodeResourceManager.memory().getTotalMemorySizeInBytes() * PipeConfig.getInstance().getSubscriptionCacheMemoryUsagePercentage());
        PipeMemoryBlock allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(initMemorySizeInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 1L)).setShrinkCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.updateAndGet(factor -> factor * ((double)oldMemory.longValue() / (double)newMemory.longValue()));
            LOGGER.info("SubscriptionEventBinaryCache.allocatedMemoryBlock has shrunk from {} to {}.", oldMemory, newMemory);
        }).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, maxMemorySizeInBytes)).setExpandCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.updateAndGet(factor -> factor / ((double)newMemory.longValue() / (double)oldMemory.longValue()));
            LOGGER.info("SubscriptionEventBinaryCache.allocatedMemoryBlock has expanded from {} to {}.", oldMemory, newMemory);
        });
        this.cache = Caffeine.newBuilder().maximumWeight(allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((message, buffer) -> (int)((double)buffer.capacity() * this.memoryUsageCheatFactor.get())).recordStats().build(response -> SubscriptionPollResponse.serialize((SubscriptionPollResponse)response));
    }

    private static class SubscriptionEventBinaryCacheHolder {
        private static final SubscriptionEventBinaryCache INSTANCE = new SubscriptionEventBinaryCache();

        private SubscriptionEventBinaryCacheHolder() {
        }
    }
}

