/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionBlockingPendingQueue;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeTsFilePlainEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.poll.FileInitPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FilePiecePayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPrefetchingTsFileQueue
extends SubscriptionPrefetchingQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPrefetchingTsFileQueue.class);

    public SubscriptionPrefetchingTsFileQueue(String brokerId, String topicName, SubscriptionBlockingPendingQueue inputPendingQueue, AtomicLong commitIdGenerator) {
        super(brokerId, topicName, inputPendingQueue, commitIdGenerator, SubscriptionConfig.getInstance().getSubscriptionPrefetchTsFileBatchMaxDelayInMs(), SubscriptionConfig.getInstance().getSubscriptionPrefetchTsFileBatchMaxSizeInBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionEvent pollTsFile(String consumerId, SubscriptionCommitContext commitContext, long writingOffset) {
        this.acquireReadLock();
        try {
            SubscriptionEvent subscriptionEvent = this.isClosed() ? null : this.pollTsFileInternal(consumerId, commitContext, writingOffset);
            return subscriptionEvent;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public @NonNull SubscriptionEvent pollTsFileInternal(String consumerId, SubscriptionCommitContext commitContext, long writingOffset) {
        AtomicReference eventRef = new AtomicReference();
        this.inFlightEvents.compute(new Pair((Object)consumerId, (Object)commitContext), (key, ev) -> {
            if (Objects.isNull(ev)) {
                String errorMessage = String.format("SubscriptionPrefetchingTsFileQueue %s is currently not transferring any file to consumer %s, commit context: %s, writing offset: %s", this, consumerId, commitContext, writingOffset);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return null;
            }
            if (ev.isCommitted()) {
                ev.cleanUp();
                String errorMessage = String.format("outdated poll request after commit, consumer id: %s, commit context: %s, writing offset: %s, prefetching queue: %s", consumerId, commitContext, writingOffset, this);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return null;
            }
            if (!Objects.equals(ev.getLastPolledConsumerId(), consumerId)) {
                String errorMessage = String.format("inconsistent polled consumer id, current: %s, incoming: %s, commit context: %s, writing offset: %s, prefetching queue: %s", ev.getLastPolledConsumerId(), consumerId, commitContext, writingOffset, this);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return ev;
            }
            SubscriptionPollResponse response = ev.getCurrentResponse();
            SubscriptionPollPayload payload = response.getPayload();
            short responseType = response.getResponseType();
            if (!SubscriptionPollResponseType.isValidatedResponseType((short)responseType)) {
                String errorMessage = String.format("unexpected response type: %s", responseType);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return ev;
            }
            String fileName = ev.getFileName();
            switch (SubscriptionPollResponseType.valueOf((short)responseType)) {
                case FILE_INIT: {
                    if (!Objects.equals(fileName, ((FileInitPayload)payload).getFileName())) {
                        String errorMessage = String.format("inconsistent file name, current: %s, incoming: %s, consumer: %s, writing offset: %s, prefetching queue: %s", ((FileInitPayload)payload).getFileName(), fileName, consumerId, writingOffset, this);
                        LOGGER.warn(errorMessage);
                        eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                        return ev;
                    }
                    if (writingOffset == 0L) break;
                    String errorMessage = String.format("inconsistent offset, current: %s, incoming: %s, consumer: %s, file name: %s, prefetching queue: %s", 0, writingOffset, consumerId, fileName, this);
                    LOGGER.warn(errorMessage);
                    eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                    return ev;
                }
                case FILE_PIECE: {
                    if (!Objects.equals(fileName, ((FilePiecePayload)payload).getFileName())) {
                        String errorMessage = String.format("inconsistent file name, current: %s, incoming: %s, consumer: %s, writing offset: %s, prefetching queue: %s", ((FilePiecePayload)payload).getFileName(), fileName, consumerId, writingOffset, this);
                        LOGGER.warn(errorMessage);
                        eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                        return ev;
                    }
                    if (writingOffset == ((FilePiecePayload)payload).getNextWritingOffset()) break;
                    String errorMessage = String.format("inconsistent offset, current: %s, incoming: %s, consumer: %s, file name: %s, prefetching queue: %s", ((FilePiecePayload)payload).getNextWritingOffset(), writingOffset, consumerId, fileName, this);
                    LOGGER.warn(errorMessage);
                    eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                    return ev;
                }
                case FILE_SEAL: {
                    String errorMessage = String.format("poll after sealing, consumer: %s, file name: %s, writing offset: %s, prefetching queue: %s", consumerId, fileName, writingOffset, this);
                    LOGGER.warn(errorMessage);
                    eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                    return ev;
                }
                default: {
                    String errorMessage = String.format("unexpected response type: %s", responseType);
                    LOGGER.warn(errorMessage);
                    eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                    return ev;
                }
            }
            try {
                ev.fetchNextResponse();
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred when SubscriptionPrefetchingTsFileQueue {} transferring file (with event {}) to consumer {}", new Object[]{this, ev, consumerId, e});
                String errorMessage = String.format("Exception occurred when SubscriptionPrefetchingTsFileQueue %s transferring file (with event %s) to consumer %s: %s", this, ev, consumerId, e);
                LOGGER.warn(errorMessage);
                eventRef.set(this.generateSubscriptionPollErrorResponse(errorMessage));
                return ev;
            }
            ev.recordLastPolledTimestamp();
            eventRef.set(ev);
            return ev;
        });
        return (SubscriptionEvent)eventRef.get();
    }

    @Override
    protected boolean onEvent(TsFileInsertionEvent event) {
        SubscriptionCommitContext commitContext = this.generateSubscriptionCommitContext();
        SubscriptionEvent ev = new SubscriptionEvent((SubscriptionPipeEvents)new SubscriptionPipeTsFilePlainEvent((PipeTsFileInsertionEvent)event), new SubscriptionPollResponse(SubscriptionPollResponseType.FILE_INIT.getType(), (SubscriptionPollPayload)new FileInitPayload(((PipeTsFileInsertionEvent)event).getTsFile().getName()), commitContext));
        super.enqueueEventToPrefetchingQueue(ev);
        return true;
    }

    public String toString() {
        return "SubscriptionPrefetchingTsFileQueue" + this.coreReportMessage();
    }
}

