/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.subscription.receiver.SubscriptionReceiver;
import org.apache.iotdb.db.subscription.receiver.SubscriptionReceiverV1;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionReceiverAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionReceiverAgent.class);
    private final ThreadLocal<SubscriptionReceiver> receiverThreadLocal = new ThreadLocal();
    private static final Map<Byte, Supplier<SubscriptionReceiver>> RECEIVER_CONSTRUCTORS = new HashMap<Byte, Supplier<SubscriptionReceiver>>();

    SubscriptionReceiverAgent() {
        RECEIVER_CONSTRUCTORS.put(PipeSubscribeRequestVersion.VERSION_1.getVersion(), SubscriptionReceiverV1::new);
    }

    public TPipeSubscribeResp handle(TPipeSubscribeReq req) {
        byte reqVersion = req.getVersion();
        if (RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) {
            return this.getReceiver(reqVersion).handle(req);
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_VERSION_ERROR, (String)String.format("Unknown PipeSubscribeRequestVersion %s.", reqVersion));
        LOGGER.warn("Subscription: Unknown PipeSubscribeRequestVersion, response status = {}.", (Object)status);
        return new TPipeSubscribeResp(status, PipeSubscribeResponseVersion.VERSION_1.getVersion(), PipeSubscribeResponseType.ACK.getType());
    }

    private SubscriptionReceiver getReceiver(byte reqVersion) {
        if (this.receiverThreadLocal.get() == null) {
            return this.setAndGetReceiver(reqVersion);
        }
        byte receiverThreadLocalVersion = this.receiverThreadLocal.get().getVersion().getVersion();
        if (receiverThreadLocalVersion != reqVersion) {
            LOGGER.warn("The subscription request version {} is different from the client request version {}, the receiver will be reset to the client request version.", (Object)receiverThreadLocalVersion, (Object)reqVersion);
            this.receiverThreadLocal.remove();
            return this.setAndGetReceiver(reqVersion);
        }
        return this.receiverThreadLocal.get();
    }

    private SubscriptionReceiver setAndGetReceiver(byte reqVersion) {
        if (!RECEIVER_CONSTRUCTORS.containsKey(reqVersion)) {
            throw new UnsupportedOperationException(String.format("Unsupported subscription request version %d", reqVersion));
        }
        this.receiverThreadLocal.set(RECEIVER_CONSTRUCTORS.get(reqVersion).get());
        return this.receiverThreadLocal.get();
    }

    public final void handleClientExit() {
        SubscriptionReceiver receiver = this.receiverThreadLocal.get();
        if (receiver != null) {
            receiver.handleExit();
            this.receiverThreadLocal.remove();
        }
    }
}

