/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;

public class LoadTsFileConfigurator {
    private static final String DATABASE_LEVEL_KEY = "database-level";
    private static final int DATABASE_LEVEL_DEFAULT_VALUE = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
    private static final int DATABASE_LEVEL_MIN_VALUE = 1;
    private static final String ON_SUCCESS_KEY = "on-success";
    private static final String ON_SUCCESS_DELETE_VALUE = "delete";
    private static final String ON_SUCCESS_NONE_VALUE = "none";
    private static final Set<String> ON_SUCCESS_VALUE_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("delete", "none")));

    public static void validateParameters(String key, String value) {
        switch (key) {
            case "database-level": {
                LoadTsFileConfigurator.validateDatabaseLevelParam(value);
                break;
            }
            case "on-success": {
                LoadTsFileConfigurator.validateOnSuccessParam(value);
                break;
            }
            default: {
                throw new SemanticException("Invalid parameter '" + key + "' for LOAD TSFILE command.");
            }
        }
    }

    public static void validateDatabaseLevelParam(String databaseLevel) {
        try {
            int level = Integer.parseInt(databaseLevel);
            if (level < 1) {
                throw new SemanticException(String.format("Given database level %d is less than the minimum value %d, please input a valid database level.", level, 1));
            }
        }
        catch (Exception e) {
            throw new SemanticException(String.format("Given database level %s is not a valid integer, please input a valid database level.", databaseLevel));
        }
    }

    public static int parseOrGetDefaultDatabaseLevel(Map<String, String> loadAttributes) {
        return Integer.parseInt(loadAttributes.getOrDefault(DATABASE_LEVEL_KEY, String.valueOf(DATABASE_LEVEL_DEFAULT_VALUE)));
    }

    public static void validateOnSuccessParam(String onSuccess) {
        if (!ON_SUCCESS_VALUE_SET.contains(onSuccess)) {
            throw new SemanticException(String.format("Given on-success value '%s' is not supported, please input a valid on-success value.", onSuccess));
        }
    }

    public static boolean parseOrGetDefaultOnSuccess(Map<String, String> loadAttributes) {
        String value = loadAttributes.get(ON_SUCCESS_KEY);
        return StringUtils.isEmpty((CharSequence)value) || ON_SUCCESS_DELETE_VALUE.equals(value);
    }

    private LoadTsFileConfigurator() {
        throw new IllegalStateException("Utility class");
    }
}

