/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.chunk.AlignedChunkReader;

public class DiskAlignedChunkLoader
implements IChunkLoader {
    private final QueryContext context;
    private final boolean debug;
    private final TsFileResource resource;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public DiskAlignedChunkLoader(QueryContext context, TsFileResource resource) {
        this.context = context;
        this.debug = context.isDebug();
        this.resource = resource;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter globalTimeFilter) throws IOException {
        long t1 = System.nanoTime();
        try {
            AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetaData;
            ChunkMetadata timeChunkMetadata = (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata();
            Chunk timeChunk = ChunkCache.getInstance().get(new ChunkCache.ChunkCacheKey(this.resource.getTsFilePath(), this.resource.getTsFileID(), timeChunkMetadata.getOffsetOfChunkHeader(), this.resource.isClosed()), timeChunkMetadata.getDeleteIntervalList(), timeChunkMetadata.getStatistics(), this.debug);
            ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
            for (IChunkMetadata valueChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                valueChunkList.add(valueChunkMetadata == null ? null : ChunkCache.getInstance().get(new ChunkCache.ChunkCacheKey(this.resource.getTsFilePath(), this.resource.getTsFileID(), valueChunkMetadata.getOffsetOfChunkHeader(), this.resource.isClosed()), valueChunkMetadata.getDeleteIntervalList(), valueChunkMetadata.getStatistics(), this.debug));
            }
            long t2 = System.nanoTime();
            AlignedChunkReader chunkReader = new AlignedChunkReader(timeChunk, valueChunkList, globalTimeFilter);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_aligned_disk", System.nanoTime() - t2);
            AlignedChunkReader alignedChunkReader = chunkReader;
            return alignedChunkReader;
        }
        finally {
            long time = System.nanoTime() - t1;
            this.context.getQueryStatistics().getConstructAlignedChunkReadersDiskCount().getAndAdd(1L);
            this.context.getQueryStatistics().getConstructAlignedChunkReadersDiskTime().getAndAdd(time);
        }
    }

    public TsFileID getTsFileID() {
        return this.resource.getTsFileID();
    }
}

