/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.MemChunkHandleImpl;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.BitMap;

public class MemAlignedChunkHandleImpl
extends MemChunkHandleImpl {
    private final List<BitMap> bitMapOfValue;
    private final List<TimeRange> deletionList;
    private final long[] startEndTime;

    public MemAlignedChunkHandleImpl(IDeviceID deviceID, String measurement, long[] dataOfTimestamp, List<BitMap> bitMapOfValue, List<TimeRange> deletionList, long[] startEndTime) {
        super(deviceID, measurement, dataOfTimestamp);
        this.bitMapOfValue = bitMapOfValue;
        this.deletionList = deletionList;
        this.startEndTime = startEndTime;
    }

    @Override
    public long[] getPageStatisticsTime() {
        return this.startEndTime;
    }

    @Override
    public long[] getDataTime() throws IOException {
        ArrayList<Long> timeList = new ArrayList<Long>();
        int[] deletionCursor = new int[]{0};
        for (int i = 0; i < this.dataOfTimestamp.length; ++i) {
            if (!this.bitMapOfValue.isEmpty()) {
                int arrayIndex = i / PrimitiveArrayManager.ARRAY_SIZE;
                int elementIndex = i % PrimitiveArrayManager.ARRAY_SIZE;
                if (this.bitMapOfValue.get(arrayIndex).isMarked(elementIndex)) continue;
            }
            if (ModificationUtils.isPointDeleted(this.dataOfTimestamp[i], this.deletionList, deletionCursor) || i != this.dataOfTimestamp.length - 1 && this.dataOfTimestamp[i] == this.dataOfTimestamp[i + 1]) continue;
            timeList.add(this.dataOfTimestamp[i]);
        }
        this.hasRead = true;
        return timeList.stream().mapToLong(Long::longValue).toArray();
    }
}

