/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkLoader;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.reader.IPointReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyMemChunk {
    protected final QueryContext context;
    private String measurementUid;
    private TSDataType dataType;
    private static final Logger logger = LoggerFactory.getLogger(ReadOnlyMemChunk.class);
    protected IChunkMetadata cachedMetaData;
    protected TsBlock tsBlock;

    protected ReadOnlyMemChunk(QueryContext context) {
        this.context = context;
    }

    public ReadOnlyMemChunk(QueryContext context, String measurementUid, TSDataType dataType, TSEncoding encoding, TVList tvList, Map<String, String> props, List<TimeRange> deletionList) throws IOException, QueryProcessException {
        this.context = context;
        this.measurementUid = measurementUid;
        this.dataType = dataType;
        int floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
        if (props != null && props.containsKey("max_point_number")) {
            try {
                floatPrecision = Integer.parseInt(props.get("max_point_number"));
            }
            catch (NumberFormatException e) {
                logger.warn("The format of MAX_POINT_NUMBER {}  is not correct. Using default float precision.", (Object)props.get("max_point_number"));
            }
            if (floatPrecision < 0) {
                logger.warn("The MAX_POINT_NUMBER shouldn't be less than 0. Using default float precision {}.", (Object)TSFileDescriptor.getInstance().getConfig().getFloatPrecision());
                floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
            }
        }
        this.tsBlock = tvList.buildTsBlock(floatPrecision, encoding, deletionList);
        this.initChunkMetaFromTsBlock();
    }

    private void initChunkMetaFromTsBlock() throws QueryProcessException {
        Statistics statsByType = Statistics.getStatsByType((TSDataType)this.dataType);
        ChunkMetadata metaData = new ChunkMetadata(this.measurementUid, this.dataType, 0L, statsByType);
        if (!this.isEmpty()) {
            switch (this.dataType) {
                case BOOLEAN: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statsByType.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getBoolean(i));
                    }
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statsByType.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getBinary(i));
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statsByType.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getFloat(i));
                    }
                    break;
                }
                case INT32: 
                case DATE: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statsByType.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getInt(i));
                    }
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statsByType.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getLong(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statsByType.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getDouble(i));
                    }
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataType);
                }
            }
        }
        statsByType.setEmpty(this.isEmpty());
        metaData.setChunkLoader((IChunkLoader)new MemChunkLoader(this.context, this));
        metaData.setVersion(Long.MAX_VALUE);
        this.cachedMetaData = metaData;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public boolean isEmpty() {
        return this.tsBlock.isEmpty();
    }

    public IChunkMetadata getChunkMetaData() {
        return this.cachedMetaData;
    }

    public IPointReader getPointReader() {
        return this.tsBlock.getTsBlockSingleColumnIterator();
    }

    public TsBlock getTsBlock() {
        return this.tsBlock;
    }
}

