/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushStatus;
import org.apache.iotdb.db.storageengine.dataregion.flush.NotifyFlushMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.WritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IChunkHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.MemAlignedChunkHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.MemChunkHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public abstract class AbstractMemTable
implements IMemTable {
    public static final AtomicLong memTableIdCounter = new AtomicLong(-1L);
    private static final int FIXED_SERIALIZED_SIZE = 57;
    private final Map<IDeviceID, IWritableMemChunkGroup> memTableMap;
    private static final DeviceIDFactory deviceIDFactory = DeviceIDFactory.getInstance();
    private boolean shouldFlush = false;
    private boolean reachChunkSizeOrPointNumThreshold = false;
    private volatile FlushStatus flushStatus = FlushStatus.WORKING;
    private final int avgSeriesPointNumThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
    private long memSize = 0L;
    private long tvListRamCost = 0L;
    private int seriesNumber = 0;
    private long totalPointsNum = 0L;
    private long totalPointsNumThreshold = 0L;
    private long maxPlanIndex = Long.MIN_VALUE;
    private long minPlanIndex = Long.MAX_VALUE;
    private final long memTableId = memTableIdCounter.incrementAndGet();
    private final long createdTime;
    private long updateTime = this.createdTime = System.currentTimeMillis();
    private long lastTotalPointsNum = this.totalPointsNum;
    private String database;
    private String dataRegionId;
    private static final String METRIC_POINT_IN = Metric.POINTS_IN.toString();
    private final AtomicBoolean isTotallyGeneratedByPipe = new AtomicBoolean(true);

    protected AbstractMemTable() {
        this.database = null;
        this.dataRegionId = null;
        this.memTableMap = new HashMap<IDeviceID, IWritableMemChunkGroup>();
    }

    protected AbstractMemTable(String database, String dataRegionId) {
        this.database = database;
        this.dataRegionId = dataRegionId;
        this.memTableMap = new HashMap<IDeviceID, IWritableMemChunkGroup>();
    }

    protected AbstractMemTable(String database, String dataRegionId, Map<IDeviceID, IWritableMemChunkGroup> memTableMap) {
        this.database = database;
        this.dataRegionId = dataRegionId;
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<IDeviceID, IWritableMemChunkGroup> getMemTableMap() {
        return this.memTableMap;
    }

    private IWritableMemChunkGroup createMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> new WritableMemChunkGroup());
        for (IMeasurementSchema schema : schemaList) {
            if (schema == null || memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memChunkGroup;
    }

    private IWritableMemChunkGroup createAlignedMemChunkGroupIfNotExistAndGet(IDeviceID deviceId, List<IMeasurementSchema> schemaList) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.computeIfAbsent(deviceId, k -> {
            this.seriesNumber += schemaList.size();
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold * (long)schemaList.size();
            return new AlignedWritableMemChunkGroup(schemaList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        });
        for (IMeasurementSchema schema : schemaList) {
            if (schema == null || memChunkGroup.contains(schema.getMeasurementId())) continue;
            ++this.seriesNumber;
            this.totalPointsNumThreshold += (long)this.avgSeriesPointNumThreshold;
        }
        return memChunkGroup;
    }

    @Override
    public void insert(InsertRowNode insertRowNode) {
        String[] measurements = insertRowNode.getMeasurements();
        Object[] values = insertRowNode.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        int nullPointsNumber = 0;
        for (int i = 0; i < insertRowNode.getMeasurements().length; ++i) {
            if (measurements[i] == null || values[i] == null) {
                if (values[i] == null) {
                    ++nullPointsNumber;
                }
                schemaList.add(null);
                continue;
            }
            MeasurementSchema schema = insertRowNode.getMeasurementSchemas()[i];
            schemaList.add((IMeasurementSchema)schema);
            dataTypes.add(schema.getType());
        }
        this.memSize += MemUtils.getRowRecordSize(dataTypes, values);
        this.write(insertRowNode.getDeviceID(), schemaList, insertRowNode.getTime(), values);
        int pointsInserted = insertRowNode.getMeasurements().length - insertRowNode.getFailedMeasurementNumber() - nullPointsNumber;
        this.totalPointsNum += (long)pointsInserted;
        MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        if (!insertRowNode.isGeneratedByRemoteConsensusLeader()) {
            MetricService.getInstance().count((long)pointsInserted, Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        }
    }

    @Override
    public void insertAlignedRow(InsertRowNode insertRowNode) {
        String[] measurements = insertRowNode.getMeasurements();
        Object[] values = insertRowNode.getValues();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < insertRowNode.getMeasurements().length; ++i) {
            if (measurements[i] == null || values[i] == null) {
                schemaList.add(null);
                continue;
            }
            MeasurementSchema schema = insertRowNode.getMeasurementSchemas()[i];
            schemaList.add((IMeasurementSchema)schema);
            dataTypes.add(schema.getType());
        }
        if (schemaList.isEmpty()) {
            return;
        }
        this.memSize += MemUtils.getAlignedRowRecordSize(dataTypes, values);
        this.writeAlignedRow(insertRowNode.getDeviceID(), schemaList, insertRowNode.getTime(), values);
        int pointsInserted = insertRowNode.getMeasurements().length - insertRowNode.getFailedMeasurementNumber();
        this.totalPointsNum += (long)pointsInserted;
        MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        if (!insertRowNode.isGeneratedByRemoteConsensusLeader()) {
            MetricService.getInstance().count((long)pointsInserted, Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        }
    }

    @Override
    public void insertTablet(InsertTabletNode insertTabletNode, int start, int end) throws WriteProcessException {
        try {
            this.writeTabletNode(insertTabletNode, start, end);
            this.memSize += MemUtils.getTabletSize(insertTabletNode, start, end);
            int pointsInserted = (insertTabletNode.getDataTypes().length - insertTabletNode.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
            if (!insertTabletNode.isGeneratedByRemoteConsensusLeader()) {
                MetricService.getInstance().count((long)pointsInserted, Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
            }
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void insertAlignedTablet(InsertTabletNode insertTabletNode, int start, int end) throws WriteProcessException {
        try {
            this.writeAlignedTablet(insertTabletNode, start, end);
            this.memSize += MemUtils.getAlignedTabletSize(insertTabletNode, start, end);
            int pointsInserted = (insertTabletNode.getDataTypes().length - insertTabletNode.getFailedMeasurementNumber()) * (end - start);
            this.totalPointsNum += (long)pointsInserted;
            MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
            if (!insertTabletNode.isGeneratedByRemoteConsensusLeader()) {
                MetricService.getInstance().count((long)pointsInserted, Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), METRIC_POINT_IN, Tag.DATABASE.toString(), this.database, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
            }
        }
        catch (RuntimeException e) {
            throw new WriteProcessException(e);
        }
    }

    @Override
    public void write(IDeviceID deviceId, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        if (memChunkGroup.writeWithFlushCheck(insertTime, objectValue, schemaList)) {
            this.reachChunkSizeOrPointNumThreshold = true;
        }
    }

    @Override
    public void writeAlignedRow(IDeviceID deviceId, List<IMeasurementSchema> schemaList, long insertTime, Object[] objectValue) {
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(deviceId, schemaList);
        if (memChunkGroup.writeWithFlushCheck(insertTime, objectValue, schemaList)) {
            this.reachChunkSizeOrPointNumThreshold = true;
        }
    }

    public void writeTabletNode(InsertTabletNode insertTabletNode, int start, int end) {
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletNode.getMeasurementSchemas().length; ++i) {
            if (insertTabletNode.getColumns()[i] == null) {
                schemaList.add(null);
                continue;
            }
            schemaList.add((IMeasurementSchema)insertTabletNode.getMeasurementSchemas()[i]);
        }
        IWritableMemChunkGroup memChunkGroup = this.createMemChunkGroupIfNotExistAndGet(insertTabletNode.getDeviceID(), schemaList);
        if (memChunkGroup.writeValuesWithFlushCheck(insertTabletNode.getTimes(), insertTabletNode.getColumns(), insertTabletNode.getBitMaps(), schemaList, start, end)) {
            this.reachChunkSizeOrPointNumThreshold = true;
        }
    }

    public void writeAlignedTablet(InsertTabletNode insertTabletNode, int start, int end) {
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
        for (int i = 0; i < insertTabletNode.getMeasurementSchemas().length; ++i) {
            if (insertTabletNode.getColumns()[i] == null) {
                schemaList.add(null);
                continue;
            }
            schemaList.add((IMeasurementSchema)insertTabletNode.getMeasurementSchemas()[i]);
        }
        if (schemaList.isEmpty()) {
            return;
        }
        IWritableMemChunkGroup memChunkGroup = this.createAlignedMemChunkGroupIfNotExistAndGet(insertTabletNode.getDeviceID(), schemaList);
        if (memChunkGroup.writeValuesWithFlushCheck(insertTabletNode.getTimes(), insertTabletNode.getColumns(), insertTabletNode.getBitMaps(), schemaList, start, end)) {
            this.reachChunkSizeOrPointNumThreshold = true;
        }
    }

    @Override
    public boolean checkIfChunkDoesNotExist(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        if (null == memChunkGroup) {
            return true;
        }
        return !memChunkGroup.contains(measurement);
    }

    @Override
    public long getCurrentTVListSize(IDeviceID deviceId, String measurement) {
        IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceId);
        if (null == memChunkGroup) {
            return 0L;
        }
        return memChunkGroup.getCurrentTVListSize(measurement);
    }

    @Override
    public int getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public long getTotalPointsNum() {
        return this.totalPointsNum;
    }

    @Override
    public long size() {
        long sum = 0L;
        for (IWritableMemChunkGroup writableMemChunkGroup : this.memTableMap.values()) {
            sum += writableMemChunkGroup.count();
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public boolean reachChunkSizeOrPointNumThreshold() {
        return this.reachChunkSizeOrPointNumThreshold;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.memSize = 0L;
        this.seriesNumber = 0;
        this.totalPointsNum = 0L;
        this.totalPointsNumThreshold = 0L;
        this.tvListRamCost = 0L;
        this.maxPlanIndex = 0L;
        this.minPlanIndex = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(QueryContext context, PartialPath fullPath, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemtable) throws IOException, QueryProcessException {
        return ResourceByPathUtils.getResourceInstance(fullPath).getReadOnlyMemChunkFromMemTable(context, this, modsToMemtable, ttlLowerBound);
    }

    @Override
    public void queryForSeriesRegionScan(PartialPath fullPath, long ttlLowerBound, Map<String, List<IChunkMetadata>> chunkMetaDataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, List<Pair<Modification, IMemTable>> modsToMemTabled) {
        IDeviceID deviceID = DeviceIDFactory.getInstance().getDeviceID(fullPath.getDevicePath());
        if (fullPath instanceof MeasurementPath) {
            String measurementId = fullPath.getMeasurement();
            if (!this.memTableMap.containsKey(deviceID) || !this.memTableMap.get(deviceID).contains(measurementId)) {
                return;
            }
            List<TimeRange> deletionList = new ArrayList<TimeRange>();
            if (modsToMemTabled != null) {
                deletionList = ModificationUtils.constructDeletionList((MeasurementPath)fullPath, (IMemTable)this, modsToMemTabled, ttlLowerBound);
            }
            this.getMemChunkHandleFromMemTable(deviceID, measurementId, chunkMetaDataMap, memChunkHandleMap, deletionList);
        } else {
            if (!this.memTableMap.containsKey(deviceID)) {
                return;
            }
            ArrayList<List<TimeRange>> deletionList = new ArrayList();
            if (modsToMemTabled != null) {
                deletionList = ModificationUtils.constructDeletionList((AlignedPath)fullPath, (IMemTable)this, modsToMemTabled, ttlLowerBound);
            }
            this.getMemAlignedChunkHandleFromMemTable(deviceID, ((AlignedPath)fullPath).getSchemaList(), chunkMetaDataMap, memChunkHandleMap, deletionList);
        }
    }

    @Override
    public void queryForDeviceRegionScan(IDeviceID deviceID, boolean isAligned, long ttlLowerBound, Map<String, List<IChunkMetadata>> chunkMetadataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, List<Pair<Modification, IMemTable>> modsToMemTabled) throws MetadataException {
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = this.getMemTableMap();
        if (!memTableMap.containsKey(deviceID)) {
            return;
        }
        IWritableMemChunkGroup writableMemChunkGroup = memTableMap.get(deviceID);
        if (isAligned) {
            this.getMemAlignedChunkHandleFromMemTable(deviceID, (AlignedWritableMemChunkGroup)writableMemChunkGroup, chunkMetadataMap, memChunkHandleMap, ttlLowerBound, modsToMemTabled);
        } else {
            this.getMemChunkHandleFromMemTable(deviceID, (WritableMemChunkGroup)writableMemChunkGroup, chunkMetadataMap, memChunkHandleMap, ttlLowerBound, modsToMemTabled);
        }
    }

    private void getMemChunkHandleFromMemTable(IDeviceID deviceID, String measurementId, Map<String, List<IChunkMetadata>> chunkMetadataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, List<TimeRange> deletionList) {
        IWritableMemChunk memChunk = this.memTableMap.get(deviceID).getMemChunkMap().get(measurementId);
        TVList tvListCopy = memChunk.getSortedTvListForQuery();
        long[] timestamps = this.filterDeletedTimestamp(tvListCopy, deletionList);
        chunkMetadataMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(this.buildChunkMetaDataForMemoryChunk(measurementId, timestamps[0], timestamps[tvListCopy.rowCount() - 1], Collections.emptyList()));
        memChunkHandleMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(new MemChunkHandleImpl(deviceID, measurementId, timestamps));
    }

    private void getMemAlignedChunkHandleFromMemTable(IDeviceID deviceID, List<IMeasurementSchema> schemaList, Map<String, List<IChunkMetadata>> chunkMetadataList, Map<String, List<IChunkHandle>> memChunkHandleMap, List<List<TimeRange>> deletionList) {
        AlignedWritableMemChunk alignedMemChunk = ((AlignedWritableMemChunkGroup)this.memTableMap.get(deviceID)).getAlignedMemChunk();
        boolean containsMeasurement = false;
        for (IMeasurementSchema measurementSchema : schemaList) {
            if (!alignedMemChunk.containsMeasurement(measurementSchema.getMeasurementId())) continue;
            containsMeasurement = true;
            break;
        }
        if (!containsMeasurement) {
            return;
        }
        AlignedTVList alignedTVListCopy = (AlignedTVList)alignedMemChunk.getSortedTvListForQuery(schemaList);
        this.buildAlignedMemChunkHandle(deviceID, alignedTVListCopy, deletionList, schemaList, chunkMetadataList, memChunkHandleMap);
    }

    private void getMemAlignedChunkHandleFromMemTable(IDeviceID deviceID, AlignedWritableMemChunkGroup writableMemChunkGroup, Map<String, List<IChunkMetadata>> chunkMetadataList, Map<String, List<IChunkHandle>> memChunkHandleMap, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemTabled) throws IllegalPathException {
        AlignedWritableMemChunk memChunk = writableMemChunkGroup.getAlignedMemChunk();
        List<IMeasurementSchema> schemaList = memChunk.getSchemaList();
        AlignedTVList alignedTVListCopy = (AlignedTVList)memChunk.getSortedTvListForQuery(schemaList);
        ArrayList<List<TimeRange>> deletionList = new ArrayList<List<TimeRange>>();
        if (modsToMemTabled != null) {
            for (IMeasurementSchema schema : schemaList) {
                deletionList.add(ModificationUtils.constructDeletionList(new MeasurementPath(deviceID, schema.getMeasurementId(), schema), (IMemTable)this, modsToMemTabled, ttlLowerBound));
            }
        }
        this.buildAlignedMemChunkHandle(deviceID, alignedTVListCopy, deletionList, schemaList, chunkMetadataList, memChunkHandleMap);
    }

    private void getMemChunkHandleFromMemTable(IDeviceID deviceID, WritableMemChunkGroup writableMemChunkGroup, Map<String, List<IChunkMetadata>> chunkMetadataMap, Map<String, List<IChunkHandle>> memChunkHandleMap, long ttlLowerBound, List<Pair<Modification, IMemTable>> modsToMemTabled) throws IllegalPathException {
        for (Map.Entry<String, IWritableMemChunk> entry : writableMemChunkGroup.getMemChunkMap().entrySet()) {
            String measurementId = entry.getKey();
            IWritableMemChunk writableMemChunk = entry.getValue();
            TVList tvListCopy = writableMemChunk.getSortedTvListForQuery();
            List<TimeRange> deletionList = new ArrayList<TimeRange>();
            if (modsToMemTabled != null) {
                deletionList = ModificationUtils.constructDeletionList(new MeasurementPath(deviceID, measurementId, null), (IMemTable)this, modsToMemTabled, ttlLowerBound);
            }
            long[] timestamps = this.filterDeletedTimestamp(tvListCopy, deletionList);
            chunkMetadataMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(this.buildChunkMetaDataForMemoryChunk(measurementId, timestamps[0], timestamps[tvListCopy.rowCount() - 1], Collections.emptyList()));
            memChunkHandleMap.computeIfAbsent(measurementId, k -> new ArrayList()).add(new MemChunkHandleImpl(deviceID, measurementId, timestamps));
        }
    }

    private void buildAlignedMemChunkHandle(IDeviceID deviceID, AlignedTVList alignedTVList, List<List<TimeRange>> deletionList, List<IMeasurementSchema> schemaList, Map<String, List<IChunkMetadata>> chunkMetadataList, Map<String, List<IChunkHandle>> chunkHandleMap) {
        List<List<BitMap>> bitMaps = alignedTVList.getBitMaps();
        long[] timestamps = alignedTVList.getTimestamps().stream().flatMapToLong(LongStream::of).toArray();
        timestamps = Arrays.copyOfRange(timestamps, 0, alignedTVList.rowCount());
        for (int i = 0; i < schemaList.size(); ++i) {
            String measurement = schemaList.get(i).getMeasurementId();
            List<BitMap> curBitMap = bitMaps == null ? Collections.emptyList() : bitMaps.get(i);
            List<TimeRange> deletion = deletionList == null || deletionList.isEmpty() ? Collections.emptyList() : deletionList.get(i);
            long[] startEndTime = this.calculateStartEndTime(timestamps, curBitMap);
            chunkMetadataList.computeIfAbsent(measurement, k -> new ArrayList()).add(this.buildChunkMetaDataForMemoryChunk(measurement, startEndTime[0], startEndTime[1], deletion));
            chunkHandleMap.computeIfAbsent(measurement, k -> new ArrayList()).add(new MemAlignedChunkHandleImpl(deviceID, measurement, timestamps, curBitMap, deletion, startEndTime));
        }
    }

    private long[] calculateStartEndTime(long[] timestamps, List<BitMap> bitMaps) {
        int elementIndex;
        int arrayIndex;
        int i;
        if (bitMaps.isEmpty()) {
            return new long[]{timestamps[0], timestamps[timestamps.length - 1]};
        }
        long startTime = -1L;
        long endTime = -1L;
        for (i = 0; i < timestamps.length; ++i) {
            arrayIndex = i / PrimitiveArrayManager.ARRAY_SIZE;
            elementIndex = i % PrimitiveArrayManager.ARRAY_SIZE;
            if (bitMaps.get(arrayIndex).isMarked(elementIndex)) continue;
            startTime = timestamps[i];
            break;
        }
        for (i = timestamps.length - 1; i >= 0; --i) {
            arrayIndex = i / PrimitiveArrayManager.ARRAY_SIZE;
            elementIndex = i % PrimitiveArrayManager.ARRAY_SIZE;
            if (bitMaps.get(arrayIndex).isMarked(elementIndex)) continue;
            endTime = timestamps[i];
            break;
        }
        return new long[]{startTime, endTime};
    }

    private IChunkMetadata buildChunkMetaDataForMemoryChunk(String measurement, long startTime, long endTime, List<TimeRange> deletionList) {
        TimeStatistics timeStatistics = new TimeStatistics();
        timeStatistics.setStartTime(startTime);
        timeStatistics.setEndTime(endTime);
        ChunkMetadata chunkMetadata = new ChunkMetadata(measurement, TSDataType.UNKNOWN, 0L, (Statistics)timeStatistics);
        for (TimeRange timeRange : deletionList) {
            chunkMetadata.insertIntoSortedDeletions(timeRange);
        }
        return chunkMetadata;
    }

    private long[] filterDeletedTimestamp(TVList tvList, List<TimeRange> deletionList) {
        if (deletionList.isEmpty()) {
            long[] timestamps = tvList.getTimestamps().stream().flatMapToLong(LongStream::of).toArray();
            return Arrays.copyOfRange(timestamps, 0, tvList.rowCount());
        }
        long lastTime = -1L;
        int[] deletionCursor = new int[]{0};
        int rowCount = tvList.rowCount();
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < rowCount; ++i) {
            long curTime = tvList.getTime(i);
            if (!(ModificationUtils.isPointDeleted(curTime, deletionList, deletionCursor) || i != rowCount - 1 && curTime == lastTime)) {
                result.add(curTime);
            }
            lastTime = curTime;
        }
        return result.stream().mapToLong(Long::longValue).toArray();
    }

    @Override
    public void delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        if (devicePath.hasWildcard()) {
            ArrayList<Pair> targetDeviceList = new ArrayList<Pair>();
            for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
                try {
                    PartialPath devicePathInMemTable = new PartialPath(entry.getKey());
                    if (!devicePath.matchFullPath(devicePathInMemTable)) continue;
                    targetDeviceList.add(new Pair((Object)devicePathInMemTable, (Object)entry.getValue()));
                }
                catch (IllegalPathException illegalPathException) {}
            }
            for (Pair targetDevice : targetDeviceList) {
                this.deleteDataInChunkGroup((IWritableMemChunkGroup)targetDevice.right, originalPath, (PartialPath)targetDevice.left, startTimestamp, endTimestamp);
            }
        } else {
            IWritableMemChunkGroup memChunkGroup = this.memTableMap.get(deviceIDFactory.getDeviceID(devicePath));
            if (memChunkGroup == null) {
                return;
            }
            this.deleteDataInChunkGroup(memChunkGroup, originalPath, devicePath, startTimestamp, endTimestamp);
        }
    }

    private void deleteDataInChunkGroup(IWritableMemChunkGroup memChunkGroup, PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        this.totalPointsNum -= (long)memChunkGroup.delete(originalPath, devicePath, startTimestamp, endTimestamp);
        if (memChunkGroup.getMemChunkMap().isEmpty()) {
            this.memTableMap.remove(deviceIDFactory.getDeviceID(devicePath));
        }
    }

    @Override
    public void addTVListRamCost(long cost) {
        this.tvListRamCost += cost;
    }

    @Override
    public void releaseTVListRamCost(long cost) {
        this.tvListRamCost -= cost;
    }

    @Override
    public long getTVListsRamCost() {
        return this.tvListRamCost;
    }

    @Override
    public void addTextDataSize(long textDataSize) {
        this.memSize += textDataSize;
    }

    @Override
    public void releaseTextDataSize(long textDataSize) {
        this.memSize -= textDataSize;
    }

    @Override
    public void setShouldFlush() {
        this.shouldFlush = true;
    }

    @Override
    public boolean shouldFlush() {
        return this.shouldFlush;
    }

    @Override
    public void release() {
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            entry.getValue().release();
        }
    }

    @Override
    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    @Override
    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    @Override
    public long getMemTableId() {
        return this.memTableId;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getUpdateTime() {
        if (this.lastTotalPointsNum != this.totalPointsNum) {
            this.lastTotalPointsNum = this.totalPointsNum;
            this.updateTime = System.currentTimeMillis();
        }
        return this.updateTime;
    }

    @Override
    public FlushStatus getFlushStatus() {
        return this.flushStatus;
    }

    @Override
    public void setFlushStatus(FlushStatus flushStatus) {
        this.flushStatus = flushStatus;
    }

    @Override
    public int serializedSize() {
        if (this.isSignalMemTable()) {
            return 1;
        }
        int size = 57;
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            size += ReadWriteIOUtils.sizeToWrite((String)((PlainDeviceID)entry.getKey()).toStringID());
            ++size;
            size += entry.getValue().serializedSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(this.isSignalMemTable(), buffer);
        if (this.isSignalMemTable()) {
            return;
        }
        buffer.putInt(this.seriesNumber);
        buffer.putLong(this.memSize);
        buffer.putLong(this.tvListRamCost);
        buffer.putLong(this.totalPointsNum);
        buffer.putLong(this.totalPointsNumThreshold);
        buffer.putLong(this.maxPlanIndex);
        buffer.putLong(this.minPlanIndex);
        buffer.putInt(this.memTableMap.size());
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            WALWriteUtils.write(((PlainDeviceID)entry.getKey()).toStringID(), buffer);
            IWritableMemChunkGroup memChunkGroup = entry.getValue();
            WALWriteUtils.write(memChunkGroup instanceof AlignedWritableMemChunkGroup, buffer);
            memChunkGroup.serializeToWAL(buffer);
        }
    }

    public void deserialize(DataInputStream stream) throws IOException {
        this.seriesNumber = stream.readInt();
        this.memSize = stream.readLong();
        this.tvListRamCost = stream.readLong();
        this.totalPointsNum = stream.readLong();
        this.totalPointsNumThreshold = stream.readLong();
        this.maxPlanIndex = stream.readLong();
        this.minPlanIndex = stream.readLong();
        int memTableMapSize = stream.readInt();
        for (int i = 0; i < memTableMapSize; ++i) {
            IDeviceID deviceID = deviceIDFactory.getDeviceID(ReadWriteIOUtils.readString((InputStream)stream));
            boolean isAligned = ReadWriteIOUtils.readBool((InputStream)stream);
            IWritableMemChunkGroup memChunkGroup = isAligned ? AlignedWritableMemChunkGroup.deserialize(stream) : WritableMemChunkGroup.deserialize(stream);
            this.memTableMap.put(deviceID, memChunkGroup);
        }
    }

    @Override
    public Map<IDeviceID, Long> getMaxTime() {
        HashMap<IDeviceID, Long> latestTimeForEachDevice = new HashMap<IDeviceID, Long>();
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> entry : this.memTableMap.entrySet()) {
            long maxTime = entry.getValue().getMaxTime();
            if (maxTime == Long.MIN_VALUE) continue;
            latestTimeForEachDevice.put(entry.getKey(), maxTime);
        }
        return latestTimeForEachDevice;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getDataRegionId() {
        return this.dataRegionId;
    }

    @Override
    public void setDatabaseAndDataRegionId(String database, String dataRegionId) {
        this.database = database;
        this.dataRegionId = dataRegionId;
    }

    @Override
    public void markAsNotGeneratedByPipe() {
        this.isTotallyGeneratedByPipe.set(false);
    }

    @Override
    public boolean isTotallyGeneratedByPipe() {
        return this.isTotallyGeneratedByPipe.get();
    }

    public static class Factory {
        private Factory() {
        }

        public static IMemTable create(DataInputStream stream) throws IOException {
            AbstractMemTable memTable;
            boolean isSignal = ReadWriteIOUtils.readBool((InputStream)stream);
            if (isSignal) {
                memTable = new NotifyFlushMemTable();
            } else {
                PrimitiveMemTable primitiveMemTable = new PrimitiveMemTable();
                primitiveMemTable.deserialize(stream);
                memTable = primitiveMemTable;
            }
            return memTable;
        }
    }
}

