/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class ReadChunkInnerCompactionEstimator
extends AbstractInnerSpaceEstimator {
    @Override
    public long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        cost += Math.min(taskInfo.getTotalChunkMetadataSize(), (long)(taskInfo.getFileInfoList().size() * taskInfo.getMaxChunkMetadataNumInDevice()) * taskInfo.getMaxChunkMetadataSize());
        return cost += this.fixedMemoryBudget;
    }

    @Override
    public long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        long averageChunkSize = taskInfo.getTotalFileSize() / taskInfo.getTotalChunkNum();
        int batchSize = this.config.getCompactionMaxAlignedSeriesNumInOneBatch();
        int maxConcurrentSeriesNum = Math.min(batchSize <= 0 ? Integer.MAX_VALUE : batchSize, taskInfo.getMaxConcurrentSeriesNum());
        long maxConcurrentSeriesSizeOfTotalFiles = averageChunkSize * (long)taskInfo.getFileInfoList().size() * (long)maxConcurrentSeriesNum * (long)taskInfo.getMaxChunkMetadataNumInSeries() + (long)(maxConcurrentSeriesNum * this.tsFileConfig.getPageSizeInByte());
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * (long)maxConcurrentSeriesNum;
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSizeOfTotalFiles, maxTargetChunkWriterSize);
        long chunkSizeFromSourceFile = (averageChunkSize + (long)this.tsFileConfig.getPageSizeInByte()) * (long)maxConcurrentSeriesNum;
        return targetChunkWriterSize + chunkSizeFromSourceFile + taskInfo.getModificationFileSize();
    }

    @Override
    public long roughEstimateInnerCompactionMemory(List<TsFileResource> resources) throws IOException {
        long metadataCost = CompactionEstimateUtils.roughEstimateMetadataCostInCompaction(resources, CompactionType.INNER_SEQ_COMPACTION);
        if (metadataCost < 0L) {
            return metadataCost;
        }
        int maxConcurrentSeriesNum = Math.max(this.config.getCompactionMaxAlignedSeriesNumInOneBatch(), this.config.getSubCompactionTaskNum());
        long maxChunkSize = this.config.getTargetChunkSize();
        long maxPageSize = this.tsFileConfig.getPageSizeInByte();
        return (long)(2 * maxConcurrentSeriesNum) * (maxChunkSize + maxPageSize) + this.fixedMemoryBudget + metadataCost;
    }
}

