/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class FastCompactionInnerCompactionEstimator
extends AbstractInnerSpaceEstimator {
    @Override
    public long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        cost += Math.min(taskInfo.getTotalChunkMetadataSize(), (long)(taskInfo.getFileInfoList().size() * taskInfo.getMaxChunkMetadataNumInDevice()) * taskInfo.getMaxChunkMetadataSize());
        return cost += this.fixedMemoryBudget;
    }

    @Override
    public long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) throws IOException {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        int batchSize = this.config.getCompactionMaxAlignedSeriesNumInOneBatch();
        long maxConcurrentSeriesNum = Math.max(this.config.getSubCompactionTaskNum(), Math.min(batchSize <= 0 ? Integer.MAX_VALUE : batchSize, taskInfo.getMaxConcurrentSeriesNum()));
        long averageChunkSize = taskInfo.getTotalFileSize() / taskInfo.getTotalChunkNum();
        long maxConcurrentSeriesSizeOfTotalFiles = averageChunkSize * (long)taskInfo.getFileInfoList().size() * maxConcurrentSeriesNum * (long)taskInfo.getMaxChunkMetadataNumInSeries() + maxConcurrentSeriesNum * (long)this.tsFileConfig.getPageSizeInByte();
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * maxConcurrentSeriesNum;
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSizeOfTotalFiles, maxTargetChunkWriterSize);
        long maxConcurrentChunkSizeFromSourceFile = (averageChunkSize + (long)this.tsFileConfig.getPageSizeInByte()) * maxConcurrentSeriesNum * (long)this.calculatingMaxOverlapFileNumInSubCompactionTask(taskInfo.getResources());
        return targetChunkWriterSize + maxConcurrentChunkSizeFromSourceFile + taskInfo.getModificationFileSize();
    }

    @Override
    public long roughEstimateInnerCompactionMemory(List<TsFileResource> resources) throws IOException {
        long metadataCost = CompactionEstimateUtils.roughEstimateMetadataCostInCompaction(resources, resources.get(0).isSeq() ? CompactionType.INNER_SEQ_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION);
        if (metadataCost < 0L) {
            return metadataCost;
        }
        int maxConcurrentSeriesNum = Math.max(this.config.getCompactionMaxAlignedSeriesNumInOneBatch(), this.config.getSubCompactionTaskNum());
        long maxChunkSize = this.config.getTargetChunkSize();
        long maxPageSize = this.tsFileConfig.getPageSizeInByte();
        int maxOverlapFileNum = this.calculatingMaxOverlapFileNumInSubCompactionTask(resources);
        return (long)((maxOverlapFileNum + 1) * maxConcurrentSeriesNum) * (maxChunkSize + maxPageSize) + this.fixedMemoryBudget + metadataCost;
    }
}

