/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.BatchCompactionPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;

public abstract class AbstractCompactionEstimator {
    private static final Map<File, FileInfo> globalFileInfoCacheForFailedCompaction = Collections.synchronizedMap(new LRUMap(IoTDBDescriptor.getInstance().getConfig().getGlobalCompactionFileInfoCacheSize()));
    protected Map<TsFileResource, FileInfo> fileInfoCache = new HashMap<TsFileResource, FileInfo>();
    protected Map<TsFileResource, DeviceTimeIndex> deviceTimeIndexCache = new HashMap<TsFileResource, DeviceTimeIndex>();
    protected IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    protected long fixedMemoryBudget = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion()) + BatchCompactionPlan.maxCachedTimeChunksSize;

    protected abstract long calculatingMetadataMemoryCost(CompactionTaskInfo var1);

    protected abstract long calculatingDataMemoryCost(CompactionTaskInfo var1) throws IOException;

    protected abstract TsFileSequenceReader getReader(String var1) throws IOException;

    protected boolean isAllSourceFileExist(List<TsFileResource> resources) {
        for (TsFileResource resource : resources) {
            if (resource.getStatus() != TsFileResourceStatus.DELETED) continue;
            return false;
        }
        return true;
    }

    protected CompactionTaskInfo calculatingCompactionTaskInfo(List<TsFileResource> resources) throws IOException {
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (TsFileResource resource : resources) {
            FileInfo fileInfo = this.getFileInfoFromCache(resource);
            fileInfoList.add(fileInfo);
        }
        return new CompactionTaskInfo(resources, fileInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo getFileInfoFromCache(TsFileResource resource) throws IOException {
        if (this.fileInfoCache.containsKey(resource)) {
            return this.fileInfoCache.get(resource);
        }
        File file = new File(resource.getTsFilePath());
        Map<File, FileInfo> map = globalFileInfoCacheForFailedCompaction;
        synchronized (map) {
            if (globalFileInfoCacheForFailedCompaction.containsKey(file)) {
                FileInfo fileInfo = globalFileInfoCacheForFailedCompaction.get(file);
                this.fileInfoCache.put(resource, fileInfo);
                return fileInfo;
            }
        }
        try (TsFileSequenceReader reader = this.getReader(resource.getTsFilePath());){
            FileInfo fileInfo = CompactionEstimateUtils.calculateFileInfo(reader);
            this.fileInfoCache.put(resource, fileInfo);
            Object object = globalFileInfoCacheForFailedCompaction;
            synchronized (object) {
                globalFileInfoCacheForFailedCompaction.put(file, fileInfo);
            }
            object = fileInfo;
            return object;
        }
    }

    protected int calculatingMaxOverlapFileNumInSubCompactionTask(List<TsFileResource> resources) throws IOException {
        HashSet<IDeviceID> devices = new HashSet<IDeviceID>();
        ArrayList<DeviceTimeIndex> resourceDevices = new ArrayList<DeviceTimeIndex>(resources.size());
        for (TsFileResource resource2 : resources) {
            DeviceTimeIndex deviceTimeIndex = this.getDeviceTimeIndexFromCache(resource2);
            devices.addAll(deviceTimeIndex.getDevices());
            resourceDevices.add(deviceTimeIndex);
        }
        int maxOverlapFileNumInSubCompactionTask = 1;
        for (IDeviceID device : devices) {
            List resourcesContainsCurrentDevice = resourceDevices.stream().filter(resource -> !resource.definitelyNotContains(device)).sorted(Comparator.comparingLong(resource -> resource.getStartTime(device))).collect(Collectors.toList());
            if (resourcesContainsCurrentDevice.size() < maxOverlapFileNumInSubCompactionTask) continue;
            long maxEndTimeOfCurrentDevice = Long.MIN_VALUE;
            int overlapFileNumOfCurrentDevice = 0;
            for (DeviceTimeIndex resource3 : resourcesContainsCurrentDevice) {
                long deviceStartTimeInCurrentFile = resource3.getStartTime(device);
                long deviceEndTimeInCurrentFile = resource3.getEndTime(device);
                if (deviceStartTimeInCurrentFile <= maxEndTimeOfCurrentDevice) {
                    maxEndTimeOfCurrentDevice = Math.max(maxEndTimeOfCurrentDevice, deviceEndTimeInCurrentFile);
                    maxOverlapFileNumInSubCompactionTask = Math.max(maxOverlapFileNumInSubCompactionTask, ++overlapFileNumOfCurrentDevice);
                    continue;
                }
                maxEndTimeOfCurrentDevice = deviceEndTimeInCurrentFile;
                overlapFileNumOfCurrentDevice = 1;
            }
            if (maxOverlapFileNumInSubCompactionTask != resources.size()) continue;
            return maxOverlapFileNumInSubCompactionTask;
        }
        return maxOverlapFileNumInSubCompactionTask;
    }

    private DeviceTimeIndex getDeviceTimeIndexFromCache(TsFileResource resource) throws IOException {
        if (this.deviceTimeIndexCache.containsKey(resource)) {
            return this.deviceTimeIndexCache.get(resource);
        }
        ITimeIndex timeIndex = resource.getTimeIndex();
        if (timeIndex instanceof FileTimeIndex) {
            timeIndex = CompactionUtils.buildDeviceTimeIndex(resource);
        }
        this.deviceTimeIndexCache.put(resource, (DeviceTimeIndex)timeIndex);
        return (DeviceTimeIndex)timeIndex;
    }

    public void cleanup() {
        this.deviceTimeIndexCache.clear();
        this.fileInfoCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFileInfoFromGlobalFileInfoCache(TsFileResource resource) {
        if (resource == null || resource.getTsFile() == null) {
            return;
        }
        Map<File, FileInfo> map = globalFileInfoCacheForFailedCompaction;
        synchronized (map) {
            globalFileInfoCacheForFailedCompaction.remove(resource.getTsFile());
        }
    }
}

