/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.AlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCrossCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller.AbstractCompactionFlushController;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;

public class FastCrossCompactionWriter
extends AbstractCrossCompactionWriter {
    protected Map<TsFileResource, TsFileSequenceReader> readerMap;

    public FastCrossCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqSourceResources, Map<TsFileResource, TsFileSequenceReader> readerMap) throws IOException {
        super(targetResources, seqSourceResources);
        this.readerMap = readerMap;
    }

    @Override
    public void write(TsBlock tsBlock, int subTaskId) throws IOException {
        throw new RuntimeException("Does not support this method in FastCrossCompactionWriter");
    }

    @Override
    protected TsFileSequenceReader getFileReader(TsFileResource resource) {
        return this.readerMap.get(resource);
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(chunkMetadata.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsChunkSatisfied((IChunkMetadata)chunkMetadata, fileIndex, subTaskId)) {
            return false;
        }
        this.flushNonAlignedChunkToFileWriter((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), chunk, chunkMetadata, subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = chunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId) throws IOException {
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadataElement.chunkMetadata;
        IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
        List valueChunkMetadatas = alignedChunkMetadata.getValueChunkMetadataList();
        Chunk timeChunk = chunkMetadataElement.chunk;
        List<Chunk> valueChunks = chunkMetadataElement.valueChunks;
        this.checkTimeAndMayFlushChunkToCurrentFile(timeChunkMetadata.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsChunkSatisfied(timeChunkMetadata, fileIndex, subTaskId)) {
            return false;
        }
        this.flushAlignedChunkToFileWriter((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), timeChunk, timeChunkMetadata, valueChunks, valueChunkMetadatas, subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = timeChunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushBatchedValueChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId, AbstractCompactionFlushController flushController) throws IOException {
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadataElement.chunkMetadata;
        IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
        List valueChunkMetadatas = alignedChunkMetadata.getValueChunkMetadataList();
        List<Chunk> valueChunks = chunkMetadataElement.valueChunks;
        this.checkTimeAndMayFlushChunkToCurrentFile(timeChunkMetadata.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!flushController.shouldSealChunkWriter()) {
            return false;
        }
        this.sealChunk((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), this.chunkWriters[subTaskId], subTaskId);
        if (!flushController.shouldCompactChunkByDirectlyFlush(timeChunkMetadata)) {
            return false;
        }
        this.flushAlignedChunkToFileWriter((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), null, timeChunkMetadata, valueChunks, valueChunkMetadatas, subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = timeChunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedPage(AlignedPageElement alignedPageElement, int subTaskId) throws IOException, PageException {
        PageHeader timePageHeader = alignedPageElement.getTimePageHeader();
        List<PageHeader> valuePageHeaders = alignedPageElement.getValuePageHeaders();
        ByteBuffer compressedTimePageData = alignedPageElement.getTimePageData();
        List<ByteBuffer> compressedValuePageDatas = alignedPageElement.getValuePageDataList();
        this.checkTimeAndMayFlushChunkToCurrentFile(timePageHeader.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsPageSatisfied(timePageHeader, fileIndex, subTaskId)) {
            return false;
        }
        this.flushAlignedPageToChunkWriter((AlignedChunkWriterImpl)this.chunkWriters[subTaskId], compressedTimePageData, timePageHeader, compressedValuePageDatas, valuePageHeaders, subTaskId);
        this.checkChunkSizeAndMayOpenANewChunk((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), this.chunkWriters[subTaskId], subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = timePageHeader.getEndTime();
        return true;
    }

    @Override
    public boolean flushBatchedValuePage(AlignedPageElement alignedPageElement, int subTaskId, AbstractCompactionFlushController flushController) throws PageException, IOException {
        PageHeader timePageHeader = alignedPageElement.getTimePageHeader();
        List<PageHeader> valuePageHeaders = alignedPageElement.getValuePageHeaders();
        ByteBuffer compressedTimePageData = alignedPageElement.getTimePageData();
        List<ByteBuffer> compressedValuePageDatas = alignedPageElement.getValuePageDataList();
        this.checkTimeAndMayFlushChunkToCurrentFile(timePageHeader.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (flushController.shouldSealChunkWriter()) {
            this.sealChunk((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), this.chunkWriters[subTaskId], subTaskId);
        }
        if (!this.checkIsPageSatisfied(timePageHeader, fileIndex, subTaskId)) {
            return false;
        }
        this.flushAlignedPageToChunkWriter((AlignedChunkWriterImpl)this.chunkWriters[subTaskId], compressedTimePageData, timePageHeader, compressedValuePageDatas, valuePageHeaders, subTaskId);
        this.checkChunkSizeAndMayOpenANewChunk((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), this.chunkWriters[subTaskId], subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = timePageHeader.getEndTime();
        return true;
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) throws IOException, PageException {
        this.checkTimeAndMayFlushChunkToCurrentFile(pageHeader.getStartTime(), subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        if (!this.checkIsPageSatisfied(pageHeader, fileIndex, subTaskId)) {
            return false;
        }
        this.flushNonAlignedPageToChunkWriter((ChunkWriterImpl)this.chunkWriters[subTaskId], compressedPageData, pageHeader, subTaskId);
        this.checkChunkSizeAndMayOpenANewChunk((CompactionTsFileWriter)((Object)this.targetFileWriters.get(fileIndex)), this.chunkWriters[subTaskId], subTaskId);
        this.isDeviceExistedInTargetFiles[fileIndex] = true;
        this.isEmptyFile[fileIndex] = false;
        this.lastTime[subTaskId] = pageHeader.getEndTime();
        return true;
    }

    private boolean checkIsChunkSatisfied(IChunkMetadata chunkMetadata, int fileIndex, int subTaskId) {
        boolean isUnsealedChunkLargeEnough = this.chunkWriters[subTaskId].checkIsChunkSizeOverThreshold(this.chunkSizeLowerBoundInCompaction, this.chunkPointNumLowerBoundInCompaction, true);
        return isUnsealedChunkLargeEnough && (chunkMetadata.getEndTime() <= this.currentDeviceEndTime[fileIndex] || fileIndex == this.targetFileWriters.size() - 1);
    }

    private boolean checkIsPageSatisfied(PageHeader pageHeader, int fileIndex, int subTaskId) {
        boolean isUnsealedPageLargeEnough = this.chunkWriters[subTaskId].checkIsUnsealedPageOverThreshold(this.pageSizeLowerBoundInCompaction, this.pagePointNumLowerBoundInCompaction, true);
        return isUnsealedPageLargeEnough && (pageHeader.getEndTime() <= this.currentDeviceEndTime[fileIndex] || fileIndex == this.targetFileWriters.size() - 1);
    }
}

