/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionLastTimeCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.AlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller.AbstractCompactionFlushController;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.chunk.ValueChunkWriter;

public abstract class AbstractCompactionWriter
implements AutoCloseable {
    protected int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    protected long[] lastTime = new long[this.subTaskNum];
    protected IChunkWriter[] chunkWriters = new IChunkWriter[this.subTaskNum];
    protected int[] chunkPointNumArray = new int[this.subTaskNum];
    protected long targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    protected long targetChunkPointNum = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();
    private final long checkPoint = (this.targetChunkPointNum >= 10L ? this.targetChunkPointNum : 10L) / 10L;
    private long lastCheckIndex = 0L;
    protected long chunkSizeLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
    protected long chunkPointNumLowerBoundInCompaction = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
    protected long pageSizeLowerBoundInCompaction = this.chunkSizeLowerBoundInCompaction / 10L;
    protected long pagePointNumLowerBoundInCompaction = this.chunkPointNumLowerBoundInCompaction / 10L;
    protected boolean isAlign;
    protected IDeviceID deviceId;
    protected String[] measurementId = new String[this.subTaskNum];

    public abstract void startChunkGroup(IDeviceID var1, boolean var2) throws IOException;

    public abstract void endChunkGroup() throws IOException;

    public void startMeasurement(String measurement, IChunkWriter chunkWriter, int subTaskId) {
        this.lastCheckIndex = 0L;
        this.lastTime[subTaskId] = Long.MIN_VALUE;
        this.chunkWriters[subTaskId] = chunkWriter;
        this.measurementId[subTaskId] = measurement;
    }

    public abstract void endMeasurement(int var1) throws IOException;

    public abstract void write(TimeValuePair var1, int var2) throws IOException;

    public abstract void write(TsBlock var1, int var2) throws IOException;

    public abstract void endFile() throws IOException;

    public abstract long getWriterSize() throws IOException;

    public abstract void checkAndMayFlushChunkMetadata() throws IOException;

    protected void writeDataPoint(long timestamp, TsPrimitiveType value, IChunkWriter chunkWriter) {
        if (chunkWriter instanceof ChunkWriterImpl) {
            ChunkWriterImpl chunkWriterImpl = (ChunkWriterImpl)chunkWriter;
            switch (chunkWriterImpl.getDataType()) {
                case TEXT: 
                case STRING: 
                case BLOB: {
                    chunkWriterImpl.write(timestamp, value.getBinary());
                    break;
                }
                case DOUBLE: {
                    chunkWriterImpl.write(timestamp, value.getDouble());
                    break;
                }
                case BOOLEAN: {
                    chunkWriterImpl.write(timestamp, value.getBoolean());
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    chunkWriterImpl.write(timestamp, value.getLong());
                    break;
                }
                case INT32: 
                case DATE: {
                    chunkWriterImpl.write(timestamp, value.getInt());
                    break;
                }
                case FLOAT: {
                    chunkWriterImpl.write(timestamp, value.getFloat());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown data type " + chunkWriterImpl.getDataType());
                }
            }
        } else {
            AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)chunkWriter;
            alignedChunkWriter.write(timestamp, value.getVector());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sealChunk(CompactionTsFileWriter targetWriter, IChunkWriter chunkWriter, int subTaskId) throws IOException {
        CompactionTsFileWriter compactionTsFileWriter = targetWriter;
        synchronized (compactionTsFileWriter) {
            targetWriter.writeChunk(chunkWriter);
        }
        this.chunkPointNumArray[subTaskId] = 0;
    }

    public abstract boolean flushNonAlignedChunk(Chunk var1, ChunkMetadata var2, int var3) throws IOException;

    public abstract boolean flushAlignedChunk(ChunkMetadataElement var1, int var2) throws IOException;

    public abstract boolean flushBatchedValueChunk(ChunkMetadataElement var1, int var2, AbstractCompactionFlushController var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushNonAlignedChunkToFileWriter(CompactionTsFileWriter targetWriter, Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) throws IOException {
        CompactionTsFileWriter compactionTsFileWriter = targetWriter;
        synchronized (compactionTsFileWriter) {
            targetWriter.writeChunk(this.chunkWriters[subTaskId]);
            this.chunkPointNumArray[subTaskId] = 0;
            targetWriter.writeChunk(chunk, chunkMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushAlignedChunkToFileWriter(CompactionTsFileWriter targetWriter, Chunk timeChunk, IChunkMetadata timeChunkMetadata, List<Chunk> valueChunks, List<IChunkMetadata> valueChunkMetadatas, int subTaskId) throws IOException {
        CompactionTsFileWriter compactionTsFileWriter = targetWriter;
        synchronized (compactionTsFileWriter) {
            AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
            targetWriter.writeChunk((IChunkWriter)alignedChunkWriter);
            this.chunkPointNumArray[subTaskId] = 0;
            targetWriter.markStartingWritingAligned();
            if (timeChunk != null) {
                targetWriter.writeChunk(timeChunk, (ChunkMetadata)timeChunkMetadata);
            }
            for (int i = 0; i < valueChunks.size(); ++i) {
                Chunk valueChunk = valueChunks.get(i);
                if (valueChunk == null) {
                    ValueChunkWriter valueChunkWriter = alignedChunkWriter.getValueChunkWriterByIndex(i);
                    targetWriter.writeEmptyValueChunk(valueChunkWriter.getMeasurementId(), valueChunkWriter.getCompressionType(), valueChunkWriter.getDataType(), valueChunkWriter.getEncodingType(), (Statistics<? extends Serializable>)Statistics.getStatsByType((TSDataType)valueChunkWriter.getDataType()));
                    continue;
                }
                targetWriter.writeChunk(valueChunk, (ChunkMetadata)valueChunkMetadatas.get(i));
            }
            targetWriter.markEndingWritingAligned();
        }
    }

    public abstract boolean flushNonAlignedPage(ByteBuffer var1, PageHeader var2, int var3) throws IOException, PageException;

    protected void flushNonAlignedPageToChunkWriter(ChunkWriterImpl chunkWriter, ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) throws PageException {
        chunkWriter.sealCurrentPage();
        chunkWriter.writePageHeaderAndDataIntoBuff(compressedPageData, pageHeader);
        int n = subTaskId;
        this.chunkPointNumArray[n] = (int)((long)this.chunkPointNumArray[n] + pageHeader.getStatistics().getCount());
    }

    public abstract boolean flushAlignedPage(AlignedPageElement var1, int var2) throws IOException, PageException;

    public abstract boolean flushBatchedValuePage(AlignedPageElement var1, int var2, AbstractCompactionFlushController var3) throws PageException, IOException;

    protected void flushAlignedPageToChunkWriter(AlignedChunkWriterImpl alignedChunkWriter, ByteBuffer compressedTimePageData, PageHeader timePageHeader, List<ByteBuffer> compressedValuePageDatas, List<PageHeader> valuePageHeaders, int subTaskId) throws IOException, PageException {
        alignedChunkWriter.sealCurrentPage();
        alignedChunkWriter.writePageHeaderAndDataIntoTimeBuff(compressedTimePageData, timePageHeader);
        for (int i = 0; i < valuePageHeaders.size(); ++i) {
            if (valuePageHeaders.get(i) == null) {
                alignedChunkWriter.getValueChunkWriterByIndex(i).writeEmptyPageToPageBuffer();
                continue;
            }
            alignedChunkWriter.writePageHeaderAndDataIntoValueBuff(compressedValuePageDatas.get(i), valuePageHeaders.get(i), i);
        }
        int n = subTaskId;
        this.chunkPointNumArray[n] = (int)((long)this.chunkPointNumArray[n] + timePageHeader.getStatistics().getCount());
    }

    protected void checkChunkSizeAndMayOpenANewChunk(CompactionTsFileWriter fileWriter, IChunkWriter chunkWriter, int subTaskId) throws IOException {
        if ((long)this.chunkPointNumArray[subTaskId] >= (this.lastCheckIndex + 1L) * this.checkPoint) {
            this.lastCheckIndex = (long)this.chunkPointNumArray[subTaskId] / this.checkPoint;
            if (chunkWriter.checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, false)) {
                this.sealChunk(fileWriter, chunkWriter, subTaskId);
                this.lastCheckIndex = 0L;
            }
        }
    }

    protected long getChunkSize(Chunk chunk) {
        return (long)chunk.getHeader().getSerializedSize() + (long)chunk.getHeader().getDataSize();
    }

    protected void checkPreviousTimestamp(long currentWritingTimestamp, int subTaskId) {
        if (currentWritingTimestamp <= this.lastTime[subTaskId]) {
            throw new CompactionLastTimeCheckFailedException(((PlainDeviceID)this.deviceId).toStringID() + '.' + this.measurementId[subTaskId], currentWritingTimestamp, this.lastTime[subTaskId]);
        }
    }
}

