/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.RepairUnsortedFileCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairDataFileScanUtil;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.RepairUnsortedFileCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;

public class RepairUnsortedFileCompactionTask
extends InnerSpaceCompactionTask {
    private static final AtomicLong lastAllocatedFileTimestamp = new AtomicLong(0x3FFFFFFFFFFFFFFFL);
    private final TsFileResource sourceFile;
    private CountDownLatch latch;

    public static void recoverAllocatedFileTimestamp(long timestamp) {
        if (timestamp > lastAllocatedFileTimestamp.get()) {
            lastAllocatedFileTimestamp.set(timestamp);
        }
    }

    public static long getInitialAllocatedFileTimestamp() {
        return 0x3FFFFFFFFFFFFFFFL;
    }

    public RepairUnsortedFileCompactionTask(long timePartition, TsFileManager tsFileManager, TsFileResource sourceFile, boolean sequence, long serialId) {
        super(timePartition, tsFileManager, Collections.singletonList(sourceFile), sequence, new RepairUnsortedFileCompactionPerformer(), serialId);
        this.sourceFile = sourceFile;
        if (this.sourceFile.getTsFileRepairStatus() != TsFileRepairStatus.NEED_TO_REPAIR_BY_MOVE) {
            this.innerSpaceEstimator = new RepairUnsortedFileCompactionEstimator();
        }
    }

    public RepairUnsortedFileCompactionTask(long timePartition, TsFileManager tsFileManager, TsFileResource sourceFile, CountDownLatch latch, boolean sequence, long serialId) {
        super(timePartition, tsFileManager, Collections.singletonList(sourceFile), sequence, new RepairUnsortedFileCompactionPerformer(), serialId);
        this.sourceFile = sourceFile;
        if (this.sourceFile.getTsFileRepairStatus() != TsFileRepairStatus.NEED_TO_REPAIR_BY_MOVE) {
            this.innerSpaceEstimator = new RepairUnsortedFileCompactionEstimator();
        }
        this.latch = latch;
    }

    @Override
    protected void prepare() throws IOException {
        this.calculateSourceFilesAndTargetFiles();
        this.isHoldingWriteLock = new boolean[this.filesView.sourceFilesInLog.size()];
        Arrays.fill(this.isHoldingWriteLock, false);
        this.logFile = new File(this.filesView.targetFilesInLog.get(0).getTsFilePath() + ".inner-compaction.log");
    }

    @Override
    protected void calculateSourceFilesAndTargetFiles() throws IOException {
        this.filesView.sourceFilesInLog = this.filesView.sourceFilesInCompactionPerformer;
        this.filesView.targetFilesInLog = Collections.singletonList(new TsFileResource(this.generateTargetFile(), TsFileResourceStatus.COMPACTING));
        this.filesView.targetFilesInPerformer = this.filesView.targetFilesInLog;
    }

    private File generateTargetFile() throws IOException {
        String targetFileDir = this.sourceFile.getTsFile().getParentFile().getPath();
        TsFileNameGenerator.TsFileName sourceFileName = TsFileNameGenerator.getTsFileName(this.sourceFile.getTsFile().getName());
        String fileNameStr = String.format("%d-%d-%d-%d.inner", this.sourceFile.isSeq() ? lastAllocatedFileTimestamp.incrementAndGet() : sourceFileName.getTime(), this.sourceFile.isSeq() ? 0L : sourceFileName.getVersion(), sourceFileName.getInnerCompactionCnt() + 1, sourceFileName.getCrossCompactionCnt());
        if (this.sourceFile.isSeq()) {
            int pos = targetFileDir.lastIndexOf("sequence");
            targetFileDir = targetFileDir.substring(0, pos) + "unsequence" + targetFileDir.substring(pos + "sequence".length());
        }
        File targetFile = new File(targetFileDir + File.separator + fileNameStr);
        return targetFile;
    }

    @Override
    protected void prepareTargetFiles() throws IOException {
        CompactionUtils.updateProgressIndex(this.filesView.targetFilesInPerformer, this.filesView.sourceFilesInCompactionPerformer, Collections.emptyList());
        CompactionUtils.moveTargetFile(this.filesView.targetFilesInPerformer, CompactionTaskType.REPAIR, this.storageGroupName + "-" + this.dataRegionId);
        LOGGER.info("{}-{} [InnerSpaceCompactionTask] start to rename mods file", (Object)this.storageGroupName, (Object)this.dataRegionId);
        if (this.sourceFile.getTsFileRepairStatus() == TsFileRepairStatus.NEED_TO_REPAIR_BY_REWRITE) {
            CompactionUtils.combineModsInInnerCompaction(this.filesView.sourceFilesInCompactionPerformer, this.filesView.targetFilesInPerformer);
        } else if (this.sourceFile.modFileExists()) {
            Files.createLink(new File(this.filesView.targetFilesInPerformer.get(0).getModFile().getFilePath()).toPath(), new File(this.sourceFile.getModFile().getFilePath()).toPath());
        }
    }

    @Override
    protected boolean doCompaction() {
        this.calculateRepairMethod();
        if (!this.sourceFile.getTsFileRepairStatus().isRepairCompactionCandidate()) {
            return true;
        }
        boolean isSuccess = super.doCompaction();
        if (!isSuccess) {
            LOGGER.info("Failed to repair file {}", (Object)this.sourceFile.getTsFile().getAbsolutePath());
            this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
        }
        return isSuccess;
    }

    private void calculateRepairMethod() {
        if (this.sourceFile.getTsFileRepairStatus() != TsFileRepairStatus.NEED_TO_CHECK) {
            return;
        }
        RepairDataFileScanUtil repairDataFileScanUtil = new RepairDataFileScanUtil(this.sourceFile, true);
        repairDataFileScanUtil.scanTsFile();
        if (repairDataFileScanUtil.isBrokenFile()) {
            this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
            return;
        }
        if (repairDataFileScanUtil.hasUnsortedData()) {
            this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.NEED_TO_REPAIR_BY_REWRITE);
            return;
        }
        if (this.sourceFile.isSeq()) {
            this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.NEED_TO_REPAIR_BY_MOVE);
            return;
        }
        this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.NORMAL);
    }

    @Override
    public long getEstimatedMemoryCost() {
        if (this.innerSpaceEstimator != null && this.memoryCost == 0L) {
            try {
                this.memoryCost = this.innerSpaceEstimator.estimateInnerCompactionMemory(this.filesView.sourceFilesInCompactionPerformer);
            }
            catch (IOException e) {
                this.innerSpaceEstimator.cleanup();
            }
        }
        if (this.memoryCost > SystemInfo.getInstance().getMemorySizeForCompaction()) {
            this.sourceFile.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
            LOGGER.warn("[RepairUnsortedFileCompactionTask] Can not repair unsorted file {} because the required memory to repair is greater than the total compaction memory budget", (Object)this.sourceFile.getTsFile().getAbsolutePath());
        }
        return this.memoryCost;
    }

    @Override
    public boolean isDiskSpaceCheckPassed() {
        if (this.sourceFile.getTsFileRepairStatus() == TsFileRepairStatus.NEED_TO_REPAIR_BY_MOVE) {
            return true;
        }
        return super.isDiskSpaceCheckPassed();
    }

    @Override
    public void handleTaskCleanup() {
        super.handleTaskCleanup();
        if (this.latch != null) {
            this.latch.countDown();
        }
    }

    @Override
    public CompactionTaskType getCompactionTaskType() {
        return CompactionTaskType.REPAIR;
    }
}

