/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.queryengine.metric.TimeSeriesMetadataCacheMetrics;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesMetadataCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE = config.getAllocateMemoryForTimeSeriesMetaDataCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();
    private final Cache<TimeSeriesMetadataCacheKey, TimeseriesMetadata> lruCache;
    private final AtomicLong entryAverageSize = new AtomicLong(0L);
    private final Map<String, WeakReference<String>> devices = Collections.synchronizedMap(new WeakHashMap());
    private static final String SEPARATOR = "$";

    private TimeSeriesMetadataCache() {
        if (CACHE_ENABLE) {
            logger.info("TimeSeriesMetadataCache size = {}", (Object)MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE).weigher((key, value) -> (int)(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes())).recordStats().build();
        MetricService.getInstance().addMetricSet((IMetricSet)new TimeSeriesMetadataCacheMetrics(this));
    }

    public static TimeSeriesMetadataCache getInstance() {
        return TimeSeriesMetadataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimeseriesMetadata get(String filePath, TimeSeriesMetadataCacheKey key, Set<String> allSensors, boolean ignoreNotExists, boolean debug) throws IOException {
        block18: {
            startTime = System.nanoTime();
            cacheHit = true;
            if (!TimeSeriesMetadataCache.CACHE_ENABLE) {
                cacheHit = false;
                reader = FileReaderManager.getInstance().get(filePath, true);
                bloomFilter = reader.readBloomFilter();
                if (bloomFilter != null && !bloomFilter.contains(((PlainDeviceID)TimeSeriesMetadataCacheKey.access$100(key)).toStringID() + '.' + TimeSeriesMetadataCacheKey.access$200(key))) {
                    var11_12 = null;
                    TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                    return var11_12;
                }
                timeseriesMetadata = reader.readTimeseriesMetadata(TimeSeriesMetadataCacheKey.access$100(key), TimeSeriesMetadataCacheKey.access$200(key), ignoreNotExists);
                var12_15 = timeseriesMetadata == null || timeseriesMetadata.getStatistics().getCount() == 0L ? null : timeseriesMetadata;
                TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                return var12_15;
            }
            timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
            if (timeseriesMetadata != null) ** GOTO lbl45
            if (debug) {
                TimeSeriesMetadataCache.DEBUG_LOGGER.info("Cache miss: {}.{} in file: {}", new Object[]{TimeSeriesMetadataCacheKey.access$100(key), TimeSeriesMetadataCacheKey.access$200(key), filePath});
                TimeSeriesMetadataCache.DEBUG_LOGGER.info("Device: {}, all sensors: {}", (Object)TimeSeriesMetadataCacheKey.access$100(key), allSensors);
            }
            var10_11 /* !! */  = this.devices.computeIfAbsent(((PlainDeviceID)TimeSeriesMetadataCacheKey.access$100(key)).toStringID() + "$" + filePath, (Function<String, WeakReference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(T ), (Ljava/lang/String;)Ljava/lang/ref/WeakReference;)());
            synchronized (var10_11 /* !! */ ) {
                timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
                if (timeseriesMetadata != null) ** GOTO lbl44
                cacheHit = false;
                bloomFilter = BloomFilterCache.getInstance().get(new BloomFilterCache.BloomFilterCacheKey(filePath, TimeSeriesMetadataCacheKey.access$300(key), TimeSeriesMetadataCacheKey.access$400(key), TimeSeriesMetadataCacheKey.access$500(key), TimeSeriesMetadataCacheKey.access$600(key)), debug);
                if (bloomFilter == null || bloomFilter.contains(((PlainDeviceID)TimeSeriesMetadataCacheKey.access$100(key)).toStringID() + "." + TimeSeriesMetadataCacheKey.access$200(key))) ** break block17
                if (debug) {
                    TimeSeriesMetadataCache.DEBUG_LOGGER.info("TimeSeries meta data {} is filter by bloomFilter!", (Object)key);
                }
                var12_16 = null;
            }
            TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
            return var12_16;
            {
                reader = FileReaderManager.getInstance().get(filePath, true);
                timeSeriesMetadataList = reader.readTimeseriesMetadata(TimeSeriesMetadataCacheKey.access$100(key), TimeSeriesMetadataCacheKey.access$200(key), allSensors);
                for (TimeseriesMetadata metadata : timeSeriesMetadataList) {
                    k = new TimeSeriesMetadataCacheKey(TimeSeriesMetadataCacheKey.access$300(key), TimeSeriesMetadataCacheKey.access$400(key), TimeSeriesMetadataCacheKey.access$500(key), TimeSeriesMetadataCacheKey.access$600(key), TimeSeriesMetadataCacheKey.access$100(key), metadata.getMeasurementId());
                    if (metadata.getStatistics().getCount() != 0L) {
                        this.lruCache.put((Object)k, (Object)metadata);
                    }
                    if (!metadata.getMeasurementId().equals(TimeSeriesMetadataCacheKey.access$200(key))) continue;
                    timeseriesMetadata = metadata.getStatistics().getCount() == 0L ? null : metadata;
                }
lbl44:
                // 2 sources

                // MONITOREXIT @DISABLED, blocks:[4, 7] lbl46 : MonitorExitStatement: MONITOREXIT : var10_11 /* !! */ 
lbl45:
                // 2 sources

                if (timeseriesMetadata != null) break block18;
                if (debug) {
                    TimeSeriesMetadataCache.DEBUG_LOGGER.info("The file doesn't have this time series {}.", (Object)key);
                }
                var10_11 /* !! */  = null;
                TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                return var10_11 /* !! */ ;
            }
        }
        if (debug) {
            TimeSeriesMetadataCache.DEBUG_LOGGER.info("Get timeseries: {}.{}  metadata in file: {}  from cache: {}.", new Object[]{TimeSeriesMetadataCacheKey.access$100(key), TimeSeriesMetadataCacheKey.access$200(key), filePath, timeseriesMetadata});
        }
        var10_11 /* !! */  = new TimeseriesMetadata(timeseriesMetadata);
        TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
        return var10_11 /* !! */ ;
        {
            catch (Throwable var18_22) {
                TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                throw var18_22;
            }
        }
    }

    public double calculateTimeSeriesMetadataHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public long getAverageSize() {
        return this.entryAverageSize.get();
    }

    public double calculateBloomFilterHitRatio() {
        return BloomFilterCache.getInstance().calculateBloomFilterHitRatio();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public void remove(TimeSeriesMetadataCacheKey key) {
        this.lruCache.invalidate((Object)key);
    }

    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    private static class TimeSeriesMetadataCacheHolder {
        private static final TimeSeriesMetadataCache INSTANCE = new TimeSeriesMetadataCache();

        private TimeSeriesMetadataCacheHolder() {
        }
    }

    public static class TimeSeriesMetadataCacheKey {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeSeriesMetadataCacheKey.class) + RamUsageEstimator.shallowSizeOfInstance(String.class);
        private final int regionId;
        private final long timePartitionId;
        private final long tsFileVersion;
        private final long compactionVersion;
        private final IDeviceID device;
        private final String measurement;

        public TimeSeriesMetadataCacheKey(TsFileID tsFileID, IDeviceID device, String measurement) {
            this.regionId = tsFileID.regionId;
            this.timePartitionId = tsFileID.timePartitionId;
            this.tsFileVersion = tsFileID.fileVersion;
            this.compactionVersion = tsFileID.compactionVersion;
            this.device = device;
            this.measurement = measurement;
        }

        public TimeSeriesMetadataCacheKey(int regionId, long timePartitionId, long tsFileVersion, long compactionVersion, IDeviceID device, String measurement) {
            this.regionId = regionId;
            this.timePartitionId = timePartitionId;
            this.tsFileVersion = tsFileVersion;
            this.compactionVersion = compactionVersion;
            this.device = device;
            this.measurement = measurement;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + this.device.ramBytesUsed() + RamUsageEstimator.sizeOfCharArray((int)this.measurement.length());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesMetadataCacheKey that = (TimeSeriesMetadataCacheKey)o;
            return this.regionId == that.regionId && this.timePartitionId == that.timePartitionId && this.tsFileVersion == that.tsFileVersion && this.compactionVersion == that.compactionVersion && Objects.equals(this.device, that.device) && Objects.equals(this.measurement, that.measurement);
        }

        public int hashCode() {
            return Objects.hash(this.regionId, this.timePartitionId, this.tsFileVersion, this.compactionVersion, this.device, this.measurement);
        }

        public String toString() {
            return "TimeSeriesMetadataCacheKey{regionId=" + this.regionId + ", timePartitionId=" + this.timePartitionId + ", tsFileVersion=" + this.tsFileVersion + ", compactionVersion=" + this.compactionVersion + ", device='" + ((PlainDeviceID)this.device).toStringID() + '\'' + ", measurement='" + this.measurement + '\'' + '}';
        }

        static /* synthetic */ IDeviceID access$100(TimeSeriesMetadataCacheKey x0) {
            return x0.device;
        }

        static /* synthetic */ String access$200(TimeSeriesMetadataCacheKey x0) {
            return x0.measurement;
        }

        static /* synthetic */ int access$300(TimeSeriesMetadataCacheKey x0) {
            return x0.regionId;
        }

        static /* synthetic */ long access$400(TimeSeriesMetadataCacheKey x0) {
            return x0.timePartitionId;
        }

        static /* synthetic */ long access$500(TimeSeriesMetadataCacheKey x0) {
            return x0.tsFileVersion;
        }

        static /* synthetic */ long access$600(TimeSeriesMetadataCacheKey x0) {
            return x0.compactionVersion;
        }
    }
}

