/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.metric.ChunkCacheMetrics;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_CHUNK_CACHE = CONFIG.getAllocateMemoryForChunkCache();
    private static final boolean CACHE_ENABLE = CONFIG.isMetaDataCacheEnable();
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();
    private final LoadingCache<ChunkCacheKey, Chunk> lruCache;

    private ChunkCache() {
        if (CACHE_ENABLE) {
            LOGGER.info("ChunkCache size = {}", (Object)MEMORY_THRESHOLD_IN_CHUNK_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_CHUNK_CACHE).weigher((key, chunk) -> (int)(key.getRetainedSizeInBytes() + chunk.getRetainedSizeInBytes())).recordStats().build(key -> {
            long startTime = System.nanoTime();
            try {
                TsFileSequenceReader reader = FileReaderManager.getInstance().get(key.getFilePath(), ((ChunkCacheKey)key).closed);
                Chunk chunk = reader.readMemChunk(((ChunkCacheKey)key).offsetOfChunkHeader);
                chunk.getHeader().setMeasurementID(null);
                Chunk chunk2 = chunk;
                return chunk2;
            }
            finally {
                SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("read_chunk_file", System.nanoTime() - startTime);
            }
        });
        MetricService.getInstance().addMetricSet((IMetricSet)new ChunkCacheMetrics(this));
    }

    public double getHitRate() {
        return this.lruCache.stats().hitRate() * 100.0;
    }

    public static ChunkCache getInstance() {
        return ChunkCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk get(ChunkCacheKey chunkCacheKey, List<TimeRange> timeRangeList, Statistics chunkStatistic, boolean debug) throws IOException {
        long startTime = System.nanoTime();
        try {
            if (!CACHE_ENABLE) {
                TsFileSequenceReader reader = FileReaderManager.getInstance().get(chunkCacheKey.getFilePath(), true);
                Chunk chunk = reader.readMemChunk(chunkCacheKey.offsetOfChunkHeader);
                Chunk chunk2 = new Chunk(chunk.getHeader(), chunk.getData().duplicate(), timeRangeList, chunkStatistic);
                return chunk2;
            }
            Chunk chunk = (Chunk)this.lruCache.get((Object)chunkCacheKey);
            if (debug) {
                DEBUG_LOGGER.info("get chunk from cache whose key is: {}", (Object)chunkCacheKey);
            }
            Chunk chunk3 = new Chunk(chunk.getHeader(), chunk.getData().duplicate(), timeRangeList, chunkStatistic);
            return chunk3;
        }
        finally {
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("read_chunk_all", System.nanoTime() - startTime);
        }
    }

    public double calculateChunkHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_CHUNK_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    private static class ChunkCacheHolder {
        private static final ChunkCache INSTANCE = new ChunkCache();

        private ChunkCacheHolder() {
        }
    }

    public static class ChunkCacheKey {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ChunkCacheKey.class);
        private final String filePath;
        private final int regionId;
        private final long timePartitionId;
        private final long tsFileVersion;
        private final long compactionVersion;
        private final long offsetOfChunkHeader;
        private final boolean closed;

        public ChunkCacheKey(String filePath, TsFileID tsfileId, long offsetOfChunkHeader, boolean closed) {
            this.filePath = filePath;
            this.regionId = tsfileId.regionId;
            this.timePartitionId = tsfileId.timePartitionId;
            this.tsFileVersion = tsfileId.fileVersion;
            this.compactionVersion = tsfileId.compactionVersion;
            this.offsetOfChunkHeader = offsetOfChunkHeader;
            this.closed = closed;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkCacheKey that = (ChunkCacheKey)o;
            return this.regionId == that.regionId && this.timePartitionId == that.timePartitionId && this.tsFileVersion == that.tsFileVersion && this.compactionVersion == that.compactionVersion && this.offsetOfChunkHeader == that.offsetOfChunkHeader;
        }

        public int hashCode() {
            return Objects.hash(this.regionId, this.timePartitionId, this.tsFileVersion, this.compactionVersion, this.offsetOfChunkHeader);
        }

        public String toString() {
            return "ChunkCacheKey{filePath='" + this.filePath + '\'' + ", regionId=" + this.regionId + ", timePartitionId=" + this.timePartitionId + ", tsFileVersion=" + this.tsFileVersion + ", compactionVersion=" + this.compactionVersion + ", offsetOfChunkHeader=" + this.offsetOfChunkHeader + '}';
        }
    }
}

