/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.BloomFilter;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_BLOOM_FILTER_CACHE = CONFIG.getAllocateMemoryForBloomFilterCache();
    private static final boolean CACHE_ENABLE = CONFIG.isMetaDataCacheEnable();
    private final AtomicLong entryAverageSize = new AtomicLong(0L);
    private final LoadingCache<BloomFilterCacheKey, BloomFilter> lruCache;

    private BloomFilterCache() {
        if (CACHE_ENABLE) {
            LOGGER.info("BloomFilterCache size = {}", (Object)MEMORY_THRESHOLD_IN_BLOOM_FILTER_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_BLOOM_FILTER_CACHE).weigher((key, bloomFilter) -> (int)(key.getRetainedSizeInBytes() + bloomFilter.getRetainedSizeInBytes())).recordStats().build(key -> {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(((BloomFilterCacheKey)key).filePath, true);
            return reader.readBloomFilter();
        });
    }

    public static BloomFilterCache getInstance() {
        return BloomFilterCacheHolder.INSTANCE;
    }

    public BloomFilter get(BloomFilterCacheKey key) throws IOException {
        return this.get(key, false);
    }

    public BloomFilter get(BloomFilterCacheKey key, boolean debug) throws IOException {
        if (!CACHE_ENABLE) {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(key.filePath, true);
            return reader.readBloomFilter();
        }
        BloomFilter bloomFilter = (BloomFilter)this.lruCache.get((Object)key);
        if (debug) {
            DEBUG_LOGGER.info("get bloomFilter from cache where filePath is: {}", (Object)key.filePath);
        }
        return bloomFilter;
    }

    public double calculateBloomFilterHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_BLOOM_FILTER_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public long getAverageSize() {
        return this.entryAverageSize.get();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public void remove(BloomFilterCacheKey key) {
        this.lruCache.invalidate((Object)key);
    }

    public BloomFilter getIfPresent(BloomFilterCacheKey key) {
        return (BloomFilter)this.lruCache.getIfPresent((Object)key);
    }

    private static class BloomFilterCacheHolder {
        private static final BloomFilterCache INSTANCE = new BloomFilterCache();

        private BloomFilterCacheHolder() {
        }
    }

    public static class BloomFilterCacheKey {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(BloomFilterCacheKey.class);
        private final String filePath;
        private final int regionId;
        private final long timePartitionId;
        private final long tsFileVersion;
        private final long compactionVersion;

        public BloomFilterCacheKey(String filePath, int regionId, long timePartitionId, long tsFileVersion, long compactionVersion) {
            this.filePath = filePath;
            this.regionId = regionId;
            this.timePartitionId = timePartitionId;
            this.tsFileVersion = tsFileVersion;
            this.compactionVersion = compactionVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BloomFilterCacheKey that = (BloomFilterCacheKey)o;
            return this.regionId == that.regionId && this.timePartitionId == that.timePartitionId && this.tsFileVersion == that.tsFileVersion && this.compactionVersion == that.compactionVersion;
        }

        public int hashCode() {
            return Objects.hash(this.regionId, this.timePartitionId, this.tsFileVersion, this.compactionVersion);
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE;
        }
    }
}

