/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.file;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileMetrics.class);
    private final AtomicReference<AbstractMetricService> metricService = new AtomicReference();
    private final AtomicBoolean hasRemainData = new AtomicBoolean(false);
    private static final String SEQUENCE = "seq";
    private static final String UNSEQUENCE = "unseq";
    private static final String LEVEL = "level";
    private static final String FILE_GLOBAL_COUNT = "file_global_count";
    private static final String FILE_GLOBAL_SIZE = "file_global_size";
    private static final String FILE_LEVEL_COUNT = "file_level_count";
    private static final String FILE_LEVEL_SIZE = "file_level_size";
    private final Map<String, Map<String, Pair<Long, Gauge>>> seqFileSizeMap = new ConcurrentHashMap<String, Map<String, Pair<Long, Gauge>>>();
    private final Map<String, Map<String, Pair<Long, Gauge>>> unseqFileSizeMap = new ConcurrentHashMap<String, Map<String, Pair<Long, Gauge>>>();
    private final Map<String, Map<String, Pair<Integer, Gauge>>> seqFileCountMap = new ConcurrentHashMap<String, Map<String, Pair<Integer, Gauge>>>();
    private final Map<String, Map<String, Pair<Integer, Gauge>>> unseqFileCountMap = new ConcurrentHashMap<String, Map<String, Pair<Integer, Gauge>>>();
    private final Map<Integer, Pair<Integer, Gauge>> seqLevelTsFileCountMap = new ConcurrentHashMap<Integer, Pair<Integer, Gauge>>();
    private final Map<Integer, Pair<Integer, Gauge>> unseqLevelTsFileCountMap = new ConcurrentHashMap<Integer, Pair<Integer, Gauge>>();
    private final Map<Integer, Pair<Long, Gauge>> seqLevelTsFileSizeMap = new ConcurrentHashMap<Integer, Pair<Long, Gauge>>();
    private final Map<Integer, Pair<Long, Gauge>> unseqLevelTsFileSizeMap = new ConcurrentHashMap<Integer, Pair<Long, Gauge>>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService.set(metricService);
        this.checkIfThereRemainingData();
    }

    public void unbindFrom(AbstractMetricService metricService) {
    }

    public void addTsFile(String database, String regionId, long size, boolean seq, String name) {
        this.updateGlobalTsFileCountAndSize(database, regionId, 1, size, seq);
        try {
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(name);
            int level = tsFileName.getInnerCompactionCnt();
            this.updateLevelTsFileCountAndSize(size, 1, seq, level);
        }
        catch (IOException e) {
            LOGGER.warn("Unexpected error occurred when getting tsfile name", (Throwable)e);
        }
    }

    public void deleteFile(boolean seq, List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            String name = tsFileResource.getTsFile().getName();
            long size = tsFileResource.getTsFileSize();
            this.updateGlobalTsFileCountAndSize(tsFileResource.getDatabaseName(), tsFileResource.getDataRegionId(), -1, -size, seq);
            try {
                TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(name);
                int level = tsFileName.getInnerCompactionCnt();
                this.updateLevelTsFileCountAndSize(-size, -1, seq, level);
            }
            catch (IOException e) {
                LOGGER.warn("Unexpected error occurred when getting tsfile name", (Throwable)e);
            }
        }
    }

    public void deleteRegion(String database, String regionId) {
        Arrays.asList(this.seqFileCountMap, this.unseqFileCountMap).forEach(map -> this.deleteRegionFromMap((Map)map, database, regionId));
        Arrays.asList(this.seqFileSizeMap, this.unseqFileSizeMap).forEach(map -> this.deleteRegionFromMap((Map)map, database, regionId));
    }

    private <T> void deleteRegionFromMap(Map<String, Map<String, T>> map, String database, String regionId) {
        map.computeIfPresent(database, (k, v) -> {
            v.remove(regionId);
            return v.isEmpty() ? null : v;
        });
    }

    private void updateGlobalTsFileCountAndSize(String database, String regionId, int countDelta, long sizeDelta, boolean seq) {
        this.updateGlobalTsFileCountMap(seq ? this.seqFileCountMap : this.unseqFileCountMap, seq ? SEQUENCE : UNSEQUENCE, database, regionId, countDelta);
        this.updateGlobalTsFileSizeMap(seq ? this.seqFileSizeMap : this.unseqFileSizeMap, seq ? SEQUENCE : UNSEQUENCE, database, regionId, sizeDelta);
    }

    private void updateGlobalTsFileCountMap(Map<String, Map<String, Pair<Integer, Gauge>>> map, String orderStr, String database, String regionId, int value) {
        Map innerMap = map.computeIfAbsent(database, k -> new ConcurrentHashMap());
        innerMap.compute(regionId, (k, v) -> {
            if (v == null) {
                v = new Pair((Object)value, null);
            } else {
                v.setLeft((Object)((Integer)v.getLeft() + value));
            }
            if (v.getRight() == null) {
                if (this.metricService.get() != null) {
                    v.setRight((Object)this.getOrCreateGlobalTsFileCountGauge(orderStr, database, regionId));
                } else {
                    this.hasRemainData.set(true);
                }
            }
            if (v.getRight() != null) {
                ((Gauge)v.getRight()).set((long)((Integer)v.getLeft()).intValue());
            }
            return v;
        });
    }

    public Gauge getOrCreateGlobalTsFileCountGauge(String orderStr, String database, String regionId) {
        return this.metricService.get().getOrCreateGauge(FILE_GLOBAL_COUNT, MetricLevel.CORE, new String[]{Tag.NAME.toString(), orderStr, Tag.DATABASE.toString(), database, Tag.REGION.toString(), regionId});
    }

    private void updateGlobalTsFileSizeMap(Map<String, Map<String, Pair<Long, Gauge>>> map, String orderStr, String database, String regionId, long value) {
        Map innerMap = map.computeIfAbsent(database, k -> new ConcurrentHashMap());
        innerMap.compute(regionId, (k, v) -> {
            if (v == null) {
                v = new Pair((Object)value, null);
            } else {
                v.setLeft((Object)((Long)v.getLeft() + value));
            }
            if (v.getRight() == null) {
                if (this.metricService.get() != null) {
                    v.setRight((Object)this.getOrCreateGlobalTsFileSizeGauge(orderStr, database, regionId));
                } else {
                    this.hasRemainData.set(true);
                }
            }
            if (v.getRight() != null) {
                ((Gauge)v.getRight()).set(((Long)v.getLeft()).longValue());
            }
            return v;
        });
    }

    public Gauge getOrCreateGlobalTsFileSizeGauge(String orderStr, String database, String regionId) {
        return this.metricService.get().getOrCreateGauge(FILE_GLOBAL_SIZE, MetricLevel.CORE, new String[]{Tag.NAME.toString(), orderStr, Tag.DATABASE.toString(), database, Tag.REGION.toString(), regionId});
    }

    private void updateLevelTsFileCountAndSize(long sizeDelta, int countDelta, boolean seq, int level) {
        this.updateLevelTsFileCountMap(seq ? this.seqLevelTsFileCountMap : this.unseqLevelTsFileCountMap, seq ? SEQUENCE : UNSEQUENCE, level, countDelta);
        this.updateLevelTsFileSizeMap(seq ? this.seqLevelTsFileSizeMap : this.unseqLevelTsFileSizeMap, seq ? SEQUENCE : UNSEQUENCE, level, sizeDelta);
    }

    private void updateLevelTsFileCountMap(Map<Integer, Pair<Integer, Gauge>> map, String orderStr, int level, int value) {
        map.compute(level, (k, v) -> {
            if (v == null) {
                v = new Pair((Object)value, null);
            } else {
                v.setLeft((Object)((Integer)v.getLeft() + value));
            }
            if (v.getRight() == null) {
                if (this.metricService.get() != null) {
                    v.setRight((Object)this.getOrCreateLevelTsFileCountGauge(orderStr, level));
                } else {
                    this.hasRemainData.set(true);
                }
            }
            if (v.getRight() != null) {
                ((Gauge)v.getRight()).set((long)((Integer)v.getLeft()).intValue());
            }
            return v;
        });
    }

    public Gauge getOrCreateLevelTsFileCountGauge(String orderStr, int level) {
        return this.metricService.get().getOrCreateGauge(FILE_LEVEL_COUNT, MetricLevel.CORE, new String[]{Tag.NAME.toString(), orderStr, LEVEL, String.valueOf(level)});
    }

    private void updateLevelTsFileSizeMap(Map<Integer, Pair<Long, Gauge>> map, String orderStr, int level, long value) {
        map.compute(level, (k, v) -> {
            if (v == null) {
                v = new Pair((Object)value, null);
            } else {
                v.setLeft((Object)((Long)v.getLeft() + value));
            }
            if (v.getRight() == null) {
                if (this.metricService.get() != null) {
                    v.setRight((Object)this.getOrCreateLevelTsFileSizeGauge(orderStr, level));
                } else {
                    this.hasRemainData.set(true);
                }
            }
            if (v.getRight() != null) {
                ((Gauge)v.getRight()).set(((Long)v.getLeft()).longValue());
            }
            return v;
        });
    }

    public Gauge getOrCreateLevelTsFileSizeGauge(String orderStr, int level) {
        return this.metricService.get().getOrCreateGauge(FILE_LEVEL_SIZE, MetricLevel.CORE, new String[]{Tag.NAME.toString(), orderStr, LEVEL, String.valueOf(level)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfThereRemainingData() {
        if (this.hasRemainData.get()) {
            TsFileMetrics tsFileMetrics = this;
            synchronized (tsFileMetrics) {
                if (this.hasRemainData.get()) {
                    this.hasRemainData.set(false);
                    this.updateRemainData(true);
                    this.updateRemainData(false);
                }
            }
        }
    }

    private synchronized void updateRemainData(boolean seq) {
        for (Map.Entry<String, Map<String, Pair<Integer, Gauge>>> entry : (seq ? this.seqFileCountMap : this.unseqFileCountMap).entrySet()) {
            for (Map.Entry<String, Pair<Integer, Gauge>> entry2 : entry.getValue().entrySet()) {
                this.updateGlobalTsFileCountMap(seq ? this.seqFileCountMap : this.unseqFileCountMap, seq ? SEQUENCE : UNSEQUENCE, entry.getKey(), entry2.getKey(), 0);
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : (seq ? this.seqFileSizeMap : this.unseqFileSizeMap).entrySet()) {
            for (Map.Entry<String, Object> entry3 : entry.getValue().entrySet()) {
                this.updateGlobalTsFileSizeMap(seq ? this.seqFileSizeMap : this.unseqFileSizeMap, seq ? SEQUENCE : UNSEQUENCE, entry.getKey(), entry3.getKey(), 0L);
            }
        }
        for (Map.Entry<Object, Map<Object, Object>> entry : (seq ? this.seqLevelTsFileCountMap : this.unseqLevelTsFileCountMap).entrySet()) {
            this.updateLevelTsFileCountMap(seq ? this.seqLevelTsFileCountMap : this.unseqLevelTsFileCountMap, seq ? SEQUENCE : UNSEQUENCE, (Integer)entry.getKey(), 0);
        }
        for (Map.Entry<Object, Map<Object, Object>> entry : (seq ? this.seqLevelTsFileSizeMap : this.unseqLevelTsFileSizeMap).entrySet()) {
            this.updateLevelTsFileSizeMap(seq ? this.seqLevelTsFileSizeMap : this.unseqLevelTsFileSizeMap, seq ? SEQUENCE : UNSEQUENCE, (Integer)entry.getKey(), 0L);
        }
    }

    public long getFileCount(boolean seq) {
        long fileCount = 0L;
        for (Map.Entry<String, Map<String, Pair<Integer, Gauge>>> entry : (seq ? this.seqFileCountMap : this.unseqFileCountMap).entrySet()) {
            for (Map.Entry<String, Pair<Integer, Gauge>> regionEntry : entry.getValue().entrySet()) {
                fileCount += (long)((Integer)regionEntry.getValue().getLeft()).intValue();
            }
        }
        return fileCount;
    }
}

