/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;

public class InsertMultiTabletsStatement
extends InsertBaseStatement {
    List<InsertTabletStatement> insertTabletStatementList;

    public InsertMultiTabletsStatement() {
        this.statementType = StatementType.MULTI_BATCH_INSERT;
    }

    public List<InsertTabletStatement> getInsertTabletStatementList() {
        return this.insertTabletStatementList;
    }

    public void setInsertTabletStatementList(List<InsertTabletStatement> insertTabletStatementList) {
        this.insertTabletStatementList = insertTabletStatementList;
    }

    public List<PartialPath> getDevicePaths() {
        ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
        for (InsertTabletStatement insertTabletStatement : this.insertTabletStatementList) {
            partialPaths.add(insertTabletStatement.devicePath);
        }
        return partialPaths;
    }

    public List<String[]> getMeasurementsList() {
        ArrayList<String[]> measurementsList = new ArrayList<String[]>();
        for (InsertTabletStatement insertTabletStatement : this.insertTabletStatementList) {
            measurementsList.add(insertTabletStatement.measurements);
        }
        return measurementsList;
    }

    @Override
    public boolean isEmpty() {
        return this.insertTabletStatementList.isEmpty();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertMultiTablets(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        for (InsertTabletStatement insertTabletStatement : this.insertTabletStatementList) {
            result.addAll(insertTabletStatement.getPaths());
        }
        return result;
    }

    @Override
    public ISchemaValidation getSchemaValidation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ISchemaValidation> getSchemaValidationList() {
        return this.insertTabletStatementList.stream().map(InsertTabletStatement::getSchemaValidation).collect(Collectors.toList());
    }

    @Override
    public void updateAfterSchemaValidation(MPPQueryContext context) {
        for (InsertTabletStatement insertTabletStatement : this.insertTabletStatementList) {
            if (this.hasFailedMeasurements() || !insertTabletStatement.hasFailedMeasurements()) continue;
            this.failedMeasurementIndex2Info = insertTabletStatement.failedMeasurementIndex2Info;
        }
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        return false;
    }

    @Override
    public void semanticCheck() {
        for (InsertTabletStatement insertTabletStatement : this.insertTabletStatementList) {
            insertTabletStatement.semanticCheck();
        }
    }

    @Override
    public long getMinTime() {
        throw new NotImplementedException();
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        throw new NotImplementedException();
    }

    @Override
    public InsertBaseStatement removeLogicalView() {
        ArrayList<InsertTabletStatement> mergedList = new ArrayList<InsertTabletStatement>();
        boolean needSplit = false;
        for (InsertTabletStatement child : this.insertTabletStatementList) {
            List<InsertTabletStatement> childSplitResult = child.getSplitList();
            needSplit = needSplit || child.isNeedSplit();
            mergedList.addAll(childSplitResult);
        }
        if (!needSplit) {
            return this;
        }
        InsertMultiTabletsStatement splitResult = new InsertMultiTabletsStatement();
        splitResult.setInsertTabletStatementList(mergedList);
        return splitResult;
    }
}

