/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.udf.builtin.BuiltinScalarFunction;
import org.apache.iotdb.commons.udf.builtin.BuiltinTimeSeriesGeneratingFunction;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.GroupByLevelHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.UnknownExpressionTypeException;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.CaseWhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.BindTypeForTimeSeriesOperandVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.CollectAggregationExpressionsVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.CollectSourceExpressionsVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionNormalizeVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.GetMeasurementExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.LowercaseNormalizeVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReplaceRawPathWithGroupedPathVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ReplaceSubTreeWithViewVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.BindSchemaForExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.BindSchemaForPredicateVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.ConcatDeviceAndBindSchemaForExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.ConcatDeviceAndBindSchemaForPredicateVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.ConcatExpressionWithSuffixPathsVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;

public class ExpressionAnalyzer {
    private static final String RAW_AGGREGATION_HYBRID_ERROR_MSG = "Raw data and aggregation result hybrid calculation is not supported.";
    private static final String CONSTANT_COLUMN_ERROR_MSG = "Constant column is not supported.";

    private ExpressionAnalyzer() {
    }

    public static void checkIsAllMeasurement(Expression expression) {
        if (expression instanceof TernaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((TernaryExpression)expression).getFirstExpression());
            ExpressionAnalyzer.checkIsAllMeasurement(((TernaryExpression)expression).getSecondExpression());
            ExpressionAnalyzer.checkIsAllMeasurement(((TernaryExpression)expression).getThirdExpression());
        } else if (expression instanceof BinaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((BinaryExpression)expression).getLeftExpression());
            ExpressionAnalyzer.checkIsAllMeasurement(((BinaryExpression)expression).getRightExpression());
        } else if (expression instanceof UnaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((UnaryExpression)expression).getExpression());
        } else if (expression instanceof FunctionExpression) {
            for (Expression childExpression : expression.getExpressions()) {
                ExpressionAnalyzer.checkIsAllMeasurement(childExpression);
            }
        } else if (expression instanceof CaseWhenThenExpression) {
            for (Expression childExpression : expression.getExpressions()) {
                ExpressionAnalyzer.checkIsAllMeasurement(childExpression);
            }
        } else if (expression instanceof TimeSeriesOperand) {
            PartialPath path = ((TimeSeriesOperand)expression).getPath();
            if (path.getNodes().length > 1 || path.getFullPath().equals("**")) {
                throw new SemanticException("the suffix paths can only be measurement or one-level wildcard");
            }
        } else if (!(expression instanceof TimestampOperand || expression instanceof ConstantOperand || expression instanceof NullOperand)) {
            throw new UnknownExpressionTypeException(expression.getExpressionType());
        }
    }

    public static ResultColumn.ColumnType identifyOutputColumnType(Expression expression, boolean isRoot) {
        if (expression instanceof TernaryExpression) {
            ResultColumn.ColumnType firstType = ExpressionAnalyzer.identifyOutputColumnType(((TernaryExpression)expression).getFirstExpression(), false);
            ResultColumn.ColumnType secondType = ExpressionAnalyzer.identifyOutputColumnType(((TernaryExpression)expression).getSecondExpression(), false);
            ResultColumn.ColumnType thirdType = ExpressionAnalyzer.identifyOutputColumnType(((TernaryExpression)expression).getThirdExpression(), false);
            boolean rawFlag = false;
            boolean aggregationFlag = false;
            if (firstType == ResultColumn.ColumnType.RAW || secondType == ResultColumn.ColumnType.RAW || thirdType == ResultColumn.ColumnType.RAW) {
                rawFlag = true;
            }
            if (firstType == ResultColumn.ColumnType.AGGREGATION || secondType == ResultColumn.ColumnType.AGGREGATION || thirdType == ResultColumn.ColumnType.AGGREGATION) {
                aggregationFlag = true;
            }
            if (rawFlag && aggregationFlag) {
                throw new SemanticException(RAW_AGGREGATION_HYBRID_ERROR_MSG);
            }
            if (firstType == ResultColumn.ColumnType.CONSTANT && secondType == ResultColumn.ColumnType.CONSTANT && thirdType == ResultColumn.ColumnType.CONSTANT) {
                throw new SemanticException(CONSTANT_COLUMN_ERROR_MSG);
            }
            if (firstType != ResultColumn.ColumnType.CONSTANT) {
                return firstType;
            }
            if (secondType != ResultColumn.ColumnType.CONSTANT) {
                return secondType;
            }
            return thirdType;
        }
        if (expression instanceof BinaryExpression) {
            ResultColumn.ColumnType leftType = ExpressionAnalyzer.identifyOutputColumnType(((BinaryExpression)expression).getLeftExpression(), false);
            ResultColumn.ColumnType rightType = ExpressionAnalyzer.identifyOutputColumnType(((BinaryExpression)expression).getRightExpression(), false);
            if (leftType == ResultColumn.ColumnType.RAW && rightType == ResultColumn.ColumnType.AGGREGATION || leftType == ResultColumn.ColumnType.AGGREGATION && rightType == ResultColumn.ColumnType.RAW) {
                throw new SemanticException(RAW_AGGREGATION_HYBRID_ERROR_MSG);
            }
            if (isRoot && leftType == ResultColumn.ColumnType.CONSTANT && rightType == ResultColumn.ColumnType.CONSTANT) {
                throw new SemanticException(CONSTANT_COLUMN_ERROR_MSG);
            }
            if (leftType != ResultColumn.ColumnType.CONSTANT) {
                return leftType;
            }
            return rightType;
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.identifyOutputColumnType(((UnaryExpression)expression).getExpression(), false);
        }
        if (expression instanceof FunctionExpression) {
            ResultColumn.ColumnType columnType2;
            int i;
            List<Expression> inputExpressions = expression.getExpressions();
            if (expression.isAggregationFunctionExpression()) {
                for (Expression inputExpression : inputExpressions) {
                    if (ExpressionAnalyzer.identifyOutputColumnType(inputExpression, false) != ResultColumn.ColumnType.AGGREGATION) continue;
                    throw new SemanticException("Aggregation results cannot be as input of the aggregation function.");
                }
                return ResultColumn.ColumnType.AGGREGATION;
            }
            ResultColumn.ColumnType checkedType = null;
            int lastCheckedIndex = 0;
            for (i = 0; i < inputExpressions.size(); ++i) {
                columnType2 = ExpressionAnalyzer.identifyOutputColumnType(inputExpressions.get(i), false);
                if (columnType2 == ResultColumn.ColumnType.CONSTANT) continue;
                checkedType = columnType2;
                lastCheckedIndex = i;
                break;
            }
            if (checkedType == null) {
                throw new SemanticException(String.format("Input of '%s' is illegal.", ((FunctionExpression)expression).getFunctionName()));
            }
            for (i = lastCheckedIndex; i < inputExpressions.size(); ++i) {
                columnType2 = ExpressionAnalyzer.identifyOutputColumnType(inputExpressions.get(i), false);
                if (columnType2 == ResultColumn.ColumnType.CONSTANT || columnType2 == checkedType) continue;
                throw new SemanticException(String.format("Raw data and aggregation result hybrid input of '%s' is not supported.", ((FunctionExpression)expression).getFunctionName()));
            }
            return checkedType;
        }
        if (expression instanceof CaseWhenThenExpression) {
            CaseWhenThenExpression caseExpression = (CaseWhenThenExpression)expression;
            List typeList = caseExpression.getExpressions().stream().map(e -> ExpressionAnalyzer.identifyOutputColumnType(e, false)).collect(Collectors.toList());
            boolean rawFlag = typeList.stream().anyMatch(columnType -> columnType == ResultColumn.ColumnType.RAW);
            boolean aggregationFlag = typeList.stream().anyMatch(columnType -> columnType == ResultColumn.ColumnType.AGGREGATION);
            if (rawFlag && aggregationFlag) {
                throw new SemanticException(RAW_AGGREGATION_HYBRID_ERROR_MSG);
            }
            boolean allConst = typeList.stream().allMatch(columnType -> columnType == ResultColumn.ColumnType.CONSTANT);
            if (allConst) {
                throw new SemanticException(CONSTANT_COLUMN_ERROR_MSG);
            }
            for (ResultColumn.ColumnType type : typeList) {
                if (type == ResultColumn.ColumnType.CONSTANT) continue;
                return type;
            }
            throw new IllegalArgumentException("shouldn't attach here");
        }
        if (expression instanceof TimeSeriesOperand || expression instanceof TimestampOperand) {
            return ResultColumn.ColumnType.RAW;
        }
        if (expression instanceof ConstantOperand || expression instanceof NullOperand) {
            return ResultColumn.ColumnType.CONSTANT;
        }
        throw new UnknownExpressionTypeException(expression.getExpressionType());
    }

    public static List<Expression> concatExpressionWithSuffixPaths(Expression expression, List<PartialPath> prefixPaths, PathPatternTree patternTree, MPPQueryContext queryContext) {
        return (List)new ConcatExpressionWithSuffixPathsVisitor().process(expression, new ConcatExpressionWithSuffixPathsVisitor.Context(prefixPaths, patternTree, queryContext));
    }

    public static List<PartialPath> concatExpressionWithSuffixPaths(Expression expression, List<PartialPath> prefixPaths) {
        HashSet<PartialPath> resultPaths = new HashSet<PartialPath>();
        if (expression instanceof TernaryExpression) {
            List<PartialPath> firstExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getFirstExpression(), prefixPaths);
            List<PartialPath> secondExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getSecondExpression(), prefixPaths);
            List<PartialPath> thirdExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getThirdExpression(), prefixPaths);
            resultPaths.addAll(firstExpressions);
            resultPaths.addAll(secondExpressions);
            resultPaths.addAll(thirdExpressions);
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof BinaryExpression) {
            List<PartialPath> leftExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getLeftExpression(), prefixPaths);
            List<PartialPath> rightExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getRightExpression(), prefixPaths);
            resultPaths.addAll(leftExpressions);
            resultPaths.addAll(rightExpressions);
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof UnaryExpression) {
            List<PartialPath> childExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((UnaryExpression)expression).getExpression(), prefixPaths);
            resultPaths.addAll(childExpressions);
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof FunctionExpression) {
            for (Expression suffixExpression : expression.getExpressions()) {
                resultPaths.addAll(ExpressionAnalyzer.concatExpressionWithSuffixPaths(suffixExpression, prefixPaths));
            }
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)expression).getPath();
            ArrayList<PartialPath> actualPaths = new ArrayList<PartialPath>();
            if (rawPath.getFullPath().startsWith("root.")) {
                actualPaths.add(rawPath);
            } else {
                for (PartialPath prefixPath : prefixPaths) {
                    PartialPath concatPath = prefixPath.concatPath(rawPath);
                    actualPaths.add(concatPath);
                }
            }
            return actualPaths;
        }
        if (expression instanceof CaseWhenThenExpression) {
            return expression.getExpressions().stream().map(expression1 -> ExpressionAnalyzer.concatExpressionWithSuffixPaths(expression1, prefixPaths)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (expression instanceof TimestampOperand || expression instanceof ConstantOperand || expression instanceof NullOperand) {
            return new ArrayList<PartialPath>();
        }
        throw new UnknownExpressionTypeException(expression.getExpressionType());
    }

    public static void constructPatternTreeFromExpression(Expression predicate, List<PartialPath> prefixPaths, PathPatternTree patternTree) {
        if (predicate instanceof TernaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((TernaryExpression)predicate).getFirstExpression(), prefixPaths, patternTree);
            ExpressionAnalyzer.constructPatternTreeFromExpression(((TernaryExpression)predicate).getSecondExpression(), prefixPaths, patternTree);
            ExpressionAnalyzer.constructPatternTreeFromExpression(((TernaryExpression)predicate).getThirdExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof BinaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((BinaryExpression)predicate).getLeftExpression(), prefixPaths, patternTree);
            ExpressionAnalyzer.constructPatternTreeFromExpression(((BinaryExpression)predicate).getRightExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof UnaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((UnaryExpression)predicate).getExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof FunctionExpression) {
            for (Expression suffixExpression : predicate.getExpressions()) {
                ExpressionAnalyzer.constructPatternTreeFromExpression(suffixExpression, prefixPaths, patternTree);
            }
        } else if (predicate instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)predicate).getPath();
            if (rawPath.getFullPath().startsWith("root.")) {
                patternTree.appendPathPattern(rawPath);
                return;
            }
            for (PartialPath prefixPath : prefixPaths) {
                PartialPath concatPath = prefixPath.concatPath(rawPath);
                patternTree.appendPathPattern(concatPath);
            }
        } else if (predicate instanceof CaseWhenThenExpression) {
            predicate.getExpressions().forEach(expression -> ExpressionAnalyzer.constructPatternTreeFromExpression(expression, prefixPaths, patternTree));
        } else if (!(predicate instanceof TimestampOperand || predicate instanceof ConstantOperand || predicate instanceof NullOperand)) {
            throw new UnknownExpressionTypeException(predicate.getExpressionType());
        }
    }

    public static List<Expression> bindSchemaForExpression(Expression expression, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        return (List)new BindSchemaForExpressionVisitor().process(expression, new BindSchemaForExpressionVisitor.Context(schemaTree, queryContext));
    }

    public static List<Expression> bindSchemaForPredicate(Expression predicate, List<PartialPath> prefixPaths, ISchemaTree schemaTree, boolean isRoot, MPPQueryContext queryContext) {
        return (List)new BindSchemaForPredicateVisitor().process(predicate, new BindSchemaForPredicateVisitor.Context(prefixPaths, schemaTree, isRoot, queryContext));
    }

    public static Expression replaceRawPathWithGroupedPath(Expression expression, GroupByLevelHelper.RawPathToGroupedPathMap rawPathToGroupedPathMap, UnaryOperator<PartialPath> pathTransformer) {
        return (Expression)new ReplaceRawPathWithGroupedPathVisitor().process(expression, new ReplaceRawPathWithGroupedPathVisitor.Context(rawPathToGroupedPathMap, pathTransformer));
    }

    public static List<Expression> concatDeviceAndBindSchemaForExpression(Expression expression, PartialPath devicePath, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        return (List)new ConcatDeviceAndBindSchemaForExpressionVisitor().process(expression, new ConcatDeviceAndBindSchemaForExpressionVisitor.Context(devicePath, schemaTree, queryContext));
    }

    public static List<Expression> concatDeviceAndBindSchemaForPredicate(Expression predicate, PartialPath devicePath, ISchemaTree schemaTree, boolean isWhere, MPPQueryContext queryContext) {
        return (List)new ConcatDeviceAndBindSchemaForPredicateVisitor().process(predicate, new ConcatDeviceAndBindSchemaForPredicateVisitor.Context(devicePath, schemaTree, isWhere, queryContext));
    }

    public static List<Expression> searchSourceExpressions(Expression expression) {
        return (List)new CollectSourceExpressionsVisitor().process(expression, null);
    }

    public static Expression replaceSubTreeWithView(Expression expression, Analysis analysis) {
        return new ReplaceSubTreeWithViewVisitor().process(expression, analysis);
    }

    public static List<Expression> searchAggregationExpressions(Expression expression) {
        return (List)new CollectAggregationExpressionsVisitor().process(expression, null);
    }

    public static Expression normalizeExpression(Expression expression) {
        return new ExpressionNormalizeVisitor(true).process(expression, null);
    }

    public static Expression normalizeExpression(Expression expression, boolean removeViewPath) {
        return new ExpressionNormalizeVisitor(removeViewPath).process(expression, null);
    }

    public static Expression toLowerCaseExpression(Expression expression) {
        return (Expression)new LowercaseNormalizeVisitor().process(expression, null);
    }

    public static boolean checkIsNeedTransform(Expression expression) {
        if (expression instanceof TernaryExpression) {
            return true;
        }
        if (expression instanceof BinaryExpression) {
            return true;
        }
        if (expression instanceof UnaryExpression) {
            return true;
        }
        if (expression instanceof FunctionExpression) {
            return !expression.isAggregationFunctionExpression();
        }
        if (expression instanceof TimeSeriesOperand) {
            return false;
        }
        if (expression instanceof ConstantOperand) {
            return false;
        }
        if (expression instanceof NullOperand) {
            return true;
        }
        if (expression instanceof CaseWhenThenExpression) {
            return true;
        }
        if (expression instanceof TimestampOperand) {
            return false;
        }
        throw new UnknownExpressionTypeException(expression.getExpressionType());
    }

    public static String getDeviceNameInSourceExpression(Expression expression) {
        if (!(expression instanceof TimeSeriesOperand)) {
            throw new IllegalArgumentException("unsupported expression type for source expression: " + (Object)((Object)expression.getExpressionType()));
        }
        return ((TimeSeriesOperand)expression).getPath().getDevice();
    }

    public static Expression getMeasurementExpression(Expression expression, Analysis analysis) {
        return new GetMeasurementExpressionVisitor().process(expression, analysis);
    }

    public static Expression bindTypeForTimeSeriesOperand(Expression predicate, List<ColumnHeader> columnHeaders) {
        return (Expression)new BindTypeForTimeSeriesOperandVisitor().process(predicate, columnHeaders);
    }

    public static boolean isDeviceViewNeedSpecialProcess(Expression expression, Analysis analysis) {
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternaryExpression = (TernaryExpression)expression;
            return ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(ternaryExpression.getFirstExpression(), analysis) || ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(ternaryExpression.getSecondExpression(), analysis) || ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(ternaryExpression.getThirdExpression(), analysis);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(binaryExpression.getLeftExpression(), analysis) || ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(binaryExpression.getRightExpression(), analysis);
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(((UnaryExpression)expression).getExpression(), analysis);
        }
        if (expression instanceof FunctionExpression) {
            String functionName = ((FunctionExpression)expression).getFunctionName().toLowerCase();
            if (!expression.isMappable(analysis.getExpressionTypes()) || BuiltinScalarFunction.DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS.contains(functionName) || BuiltinTimeSeriesGeneratingFunction.DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS.contains(functionName)) {
                return true;
            }
            for (Expression child : expression.getExpressions()) {
                if (!ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(child, analysis)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof CaseWhenThenExpression) {
            for (Expression subexpression : expression.getExpressions()) {
                if (!ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(subexpression, analysis)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof LeafOperand) {
            return false;
        }
        throw new UnknownExpressionTypeException(expression.getExpressionType());
    }

    public static boolean checkIsScalarExpression(Expression expression, Analysis analysis) {
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternaryExpression = (TernaryExpression)expression;
            return ExpressionAnalyzer.checkIsScalarExpression(ternaryExpression.getFirstExpression(), analysis) && ExpressionAnalyzer.checkIsScalarExpression(ternaryExpression.getSecondExpression(), analysis) && ExpressionAnalyzer.checkIsScalarExpression(ternaryExpression.getThirdExpression(), analysis);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return ExpressionAnalyzer.checkIsScalarExpression(binaryExpression.getLeftExpression(), analysis) && ExpressionAnalyzer.checkIsScalarExpression(binaryExpression.getRightExpression(), analysis);
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.checkIsScalarExpression(((UnaryExpression)expression).getExpression(), analysis);
        }
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            if (!functionExpression.isMappable(analysis.getExpressionTypes()) || BuiltinScalarFunction.DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS.contains(functionExpression.getFunctionName())) {
                return false;
            }
            List<Expression> inputExpressions = functionExpression.getExpressions();
            for (Expression inputExpression : inputExpressions) {
                if (ExpressionAnalyzer.checkIsScalarExpression(inputExpression, analysis)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof CaseWhenThenExpression) {
            for (Expression subexpression : expression.getExpressions()) {
                if (ExpressionAnalyzer.checkIsScalarExpression(subexpression, analysis)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof LeafOperand) {
            return true;
        }
        throw new UnknownExpressionTypeException(expression.getExpressionType());
    }
}

