/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.slidingwindow.SlidingWindowAggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.SingleInputAggregationOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class SlidingWindowAggregationOperator
extends SingleInputAggregationOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SlidingWindowAggregationOperator.class);
    private final ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private final ITimeRangeIterator subTimeRangeIterator;
    private TimeRange curSubTimeRange;
    private final boolean outputEndTime;

    public SlidingWindowAggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, Operator child, boolean ascending, boolean outputEndTime, GroupByTimeParameter groupByTimeParameter, long maxReturnSize) {
        super(operatorContext, aggregators, child, ascending, maxReturnSize);
        Preconditions.checkArgument((groupByTimeParameter != null ? 1 : 0) != 0, (Object)"GroupByTimeParameter cannot be null in SlidingWindowAggregationOperator");
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        if (outputEndTime) {
            dataTypes.add(TSDataType.INT64);
        }
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.resultTsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.timeRangeIterator = timeRangeIterator;
        this.outputEndTime = outputEndTime;
        this.subTimeRangeIterator = AggregationUtil.initTimeRangeIterator(groupByTimeParameter, ascending, true);
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    protected boolean calculateNextAggregationResult() throws Exception {
        if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
            this.curTimeRange = this.timeRangeIterator.nextTimeRange();
            for (Aggregator aggregator : this.aggregators) {
                ((SlidingWindowAggregator)aggregator).updateTimeRange(this.curTimeRange);
            }
        }
        while (!this.isCalculationDone()) {
            if (this.inputTsBlock == null) {
                if (this.child.hasNextWithTimer() && this.canCallNext) {
                    this.inputTsBlock = this.child.nextWithTimer();
                    this.canCallNext = false;
                } else {
                    if (!this.child.hasNextWithTimer()) break;
                    return false;
                }
            }
            this.calculateFromCachedData();
        }
        this.updateResultTsBlock();
        return true;
    }

    private boolean isCalculationDone() {
        if (this.curSubTimeRange == null) {
            if (!this.subTimeRangeIterator.hasNextTimeRange()) {
                return true;
            }
            this.curSubTimeRange = this.subTimeRangeIterator.nextTimeRange();
        }
        return this.ascending ? this.curSubTimeRange.getMin() > this.curTimeRange.getMax() : this.curSubTimeRange.getMax() < this.curTimeRange.getMin();
    }

    private void calculateFromCachedData() {
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return;
        }
        for (Aggregator aggregator : this.aggregators) {
            ((SlidingWindowAggregator)aggregator).processTsBlock(this.inputTsBlock);
        }
        this.inputTsBlock = this.inputTsBlock.skipFirst();
        if (this.inputTsBlock.isEmpty()) {
            this.inputTsBlock = null;
        }
        this.curSubTimeRange = null;
    }

    @Override
    protected void updateResultTsBlock() {
        if (!this.outputEndTime) {
            AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime());
        } else {
            AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime(), this.curTimeRange.getMax());
        }
        this.curTimeRange = null;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.resultTsBlockBuilder.getRetainedSizeInBytes();
    }
}

