/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.thrift.impl;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TLoadSample;
import org.apache.iotdb.common.rpc.thrift.TNodeLocations;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSender;
import org.apache.iotdb.common.rpc.thrift.TServiceType;
import org.apache.iotdb.common.rpc.thrift.TSetConfigurationReq;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSettleReq;
import org.apache.iotdb.common.rpc.thrift.TShowConfigurationResp;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResp;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResult;
import org.apache.iotdb.commons.client.request.AsyncRequestContext;
import org.apache.iotdb.commons.client.request.TestConnectionUtils;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.ConfigurationFileUtils;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.client.cn.DnToCnInternalServiceAsyncRequestManager;
import org.apache.iotdb.db.protocol.client.cn.DnToCnRequestType;
import org.apache.iotdb.db.protocol.client.dn.DataNodeExternalServiceAsyncRequestManager;
import org.apache.iotdb.db.protocol.client.dn.DataNodeMPPServiceAsyncRequestManager;
import org.apache.iotdb.db.protocol.client.dn.DnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.db.protocol.client.dn.DnToDnRequestType;
import org.apache.iotdb.db.protocol.session.InternalClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.protocol.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.queryengine.execution.executor.RegionReadExecutor;
import org.apache.iotdb.db.queryengine.execution.executor.RegionWriteExecutor;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.SchemaSourceFactory;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.DataNodeSchemaLockManager;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ConstructSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeleteTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.PreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackPreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.ConstructLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.DeleteLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.RollbackLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedNonWritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileScheduler;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.service.DataNode;
import org.apache.iotdb.db.service.RegionMigrateService;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTaskStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.settle.SettleRequestHandler;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeSpaceQuotaManager;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeThrottleQuotaManager;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.trigger.executor.TriggerExecutor;
import org.apache.iotdb.db.trigger.executor.TriggerFireResult;
import org.apache.iotdb.db.trigger.service.TriggerManagementService;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.iotdb.mpp.rpc.thrift.TActiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TAlterViewReq;
import org.apache.iotdb.mpp.rpc.thrift.TCancelFragmentInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCancelPlanFragmentReq;
import org.apache.iotdb.mpp.rpc.thrift.TCancelQueryReq;
import org.apache.iotdb.mpp.rpc.thrift.TCancelResp;
import org.apache.iotdb.mpp.rpc.thrift.TCheckSchemaRegionUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCheckSchemaRegionUsingTemplateResp;
import org.apache.iotdb.mpp.rpc.thrift.TCheckTimeSeriesExistenceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCheckTimeSeriesExistenceResp;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListWithTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TConstructViewSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateResp;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePipePluginInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TDeactivateTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteDataForDeleteSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteViewSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TDisableDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropPipePluginInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TExecuteCQ;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceInfoReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsResp;
import org.apache.iotdb.mpp.rpc.thrift.TFetchSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchSchemaBlackListResp;
import org.apache.iotdb.mpp.rpc.thrift.TFireTriggerReq;
import org.apache.iotdb.mpp.rpc.thrift.TFireTriggerResp;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceInfoResp;
import org.apache.iotdb.mpp.rpc.thrift.TInactiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TLoadCommandReq;
import org.apache.iotdb.mpp.rpc.thrift.TLoadResp;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaRespExceptionMessage;
import org.apache.iotdb.mpp.rpc.thrift.TPushMultiPipeMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushMultiTopicMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaRespExceptionMessage;
import org.apache.iotdb.mpp.rpc.thrift.TPushSingleConsumerGroupMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushSinglePipeMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushSingleTopicMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaRespExceptionMessage;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeResp;
import org.apache.iotdb.mpp.rpc.thrift.TRegionMigrateResult;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.apache.iotdb.mpp.rpc.thrift.TResetPeerListReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListWithTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackViewSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TSchemaFetchRequest;
import org.apache.iotdb.mpp.rpc.thrift.TSchemaFetchResponse;
import org.apache.iotdb.mpp.rpc.thrift.TSendBatchPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendBatchPlanNodeResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeResp;
import org.apache.iotdb.mpp.rpc.thrift.TTsFilePieceReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTriggerLocationReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.thrift.TException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeInternalRPCServiceImpl
implements IDataNodeRPCService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeInternalRPCServiceImpl.class);
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final SchemaEngine schemaEngine = SchemaEngine.getInstance();
    private final StorageEngine storageEngine = StorageEngine.getInstance();
    private final DataNodeRegionManager regionManager = DataNodeRegionManager.getInstance();
    private final DataNodeSpaceQuotaManager spaceQuotaManager = DataNodeSpaceQuotaManager.getInstance();
    private final DataNodeThrottleQuotaManager throttleQuotaManager = DataNodeThrottleQuotaManager.getInstance();
    private final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private static final String SYSTEM = "system";

    public DataNodeInternalRPCServiceImpl() {
        this.partitionFetcher = ClusterPartitionFetcher.getInstance();
        this.schemaFetcher = ClusterSchemaFetcher.getInstance();
    }

    public TSendFragmentInstanceResp sendFragmentInstance(TSendFragmentInstanceReq req) {
        FragmentInstance fragmentInstance;
        LOGGER.debug("receive FragmentInstance to group[{}]", (Object)req.getConsensusGroupId());
        ConsensusGroupId groupId = null;
        if (req.consensusGroupId != null) {
            try {
                groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
            }
            catch (Exception e) {
                LOGGER.warn("Deserialize ConsensusGroupId failed. ", (Throwable)e);
                TSendFragmentInstanceResp resp = new TSendFragmentInstanceResp(false);
                resp.setMessage("Deserialize ConsensusGroupId failed: " + e.getMessage());
                return resp;
            }
        }
        try {
            fragmentInstance = FragmentInstance.deserializeFrom(req.fragmentInstance.body);
        }
        catch (Exception e) {
            LOGGER.warn("Deserialize FragmentInstance failed.", (Throwable)e);
            TSendFragmentInstanceResp resp = new TSendFragmentInstanceResp(false);
            resp.setMessage("Deserialize FragmentInstance failed: " + e.getMessage());
            return resp;
        }
        RegionReadExecutor executor = new RegionReadExecutor();
        RegionExecutionResult executionResult = groupId == null ? executor.execute(fragmentInstance) : executor.execute(groupId, fragmentInstance);
        TSendFragmentInstanceResp resp = new TSendFragmentInstanceResp();
        resp.setAccepted(executionResult.isAccepted());
        resp.setMessage(executionResult.getMessage());
        resp.setNeedRetry(executionResult.isReadNeedRetry());
        resp.setStatus(executionResult.getStatus());
        return resp;
    }

    public TSendBatchPlanNodeResp sendBatchPlanNode(TSendBatchPlanNodeReq req) {
        List responses = req.getRequests().stream().map(request -> {
            ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)request.getConsensusGroupId());
            PlanNode planNode = PlanNodeType.deserialize(request.planNode.body);
            RegionWriteExecutor executor = new RegionWriteExecutor();
            TSendSinglePlanNodeResp resp = new TSendSinglePlanNodeResp();
            RegionExecutionResult executionResult = executor.execute(groupId, planNode);
            resp.setAccepted(executionResult.isAccepted());
            resp.setMessage(executionResult.getMessage());
            resp.setStatus(executionResult.getStatus());
            return resp;
        }).collect(Collectors.toList());
        return new TSendBatchPlanNodeResp(responses);
    }

    public TFragmentInstanceInfoResp fetchFragmentInstanceInfo(TFetchFragmentInstanceInfoReq req) {
        FragmentInstanceId instanceId = FragmentInstanceId.fromThrift(req.fragmentInstanceId);
        FragmentInstanceInfo info = FragmentInstanceManager.getInstance().getInstanceInfo(instanceId);
        if (info != null) {
            TFragmentInstanceInfoResp resp = new TFragmentInstanceInfoResp(info.getState().toString());
            resp.setEndTime(info.getEndTime());
            resp.setFailedMessages((List)ImmutableList.of((Object)info.getMessage()));
            try {
                ArrayList<ByteBuffer> failureInfoList = new ArrayList<ByteBuffer>();
                for (FragmentInstanceFailureInfo failureInfo : info.getFailureInfoList()) {
                    failureInfoList.add(failureInfo.serialize());
                }
                resp.setFailureInfoList(failureInfoList);
                info.getErrorCode().ifPresent(arg_0 -> ((TFragmentInstanceInfoResp)resp).setErrorCode(arg_0));
                return resp;
            }
            catch (IOException e) {
                return resp;
            }
        }
        return new TFragmentInstanceInfoResp(FragmentInstanceState.NO_SUCH_INSTANCE.toString());
    }

    public TCancelResp cancelQuery(TCancelQueryReq req) {
        try (SetThreadName threadName = new SetThreadName(req.getQueryId());){
            List taskIds = req.getFragmentInstanceIds().stream().map(FragmentInstanceId::fromThrift).collect(Collectors.toList());
            for (FragmentInstanceId taskId : taskIds) {
                FragmentInstanceManager.getInstance().cancelTask(taskId, req.hasThrowable);
            }
            TCancelResp tCancelResp = new TCancelResp(true);
            return tCancelResp;
        }
    }

    public TCancelResp cancelPlanFragment(TCancelPlanFragmentReq req) {
        throw new NotImplementedException();
    }

    public TCancelResp cancelFragmentInstance(TCancelFragmentInstanceReq req) {
        throw new NotImplementedException();
    }

    public TSchemaFetchResponse fetchSchema(TSchemaFetchRequest req) {
        throw new UnsupportedOperationException();
    }

    public TLoadResp sendTsFilePieceNode(TTsFilePieceReq req) {
        LOGGER.info("Receive load node from uuid {}.", (Object)req.uuid);
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.consensusGroupId);
        LoadTsFilePieceNode pieceNode = (LoadTsFilePieceNode)PlanNodeType.deserialize(req.body);
        if (pieceNode == null) {
            return this.createTLoadResp(new TSStatus(TSStatusCode.DESERIALIZE_PIECE_OF_TSFILE_ERROR.getStatusCode()));
        }
        TSStatus resultStatus = StorageEngine.getInstance().writeLoadTsFileNode((DataRegionId)groupId, pieceNode, req.uuid);
        return this.createTLoadResp(resultStatus);
    }

    public TLoadResp sendLoadCommand(TLoadCommandReq req) {
        RecoverProgressIndex progressIndex;
        if (req.isSetProgressIndex()) {
            progressIndex = ProgressIndexType.deserializeFrom((ByteBuffer)ByteBuffer.wrap(req.getProgressIndex()));
        } else {
            progressIndex = PipeDataNodeAgent.runtime().getNextProgressIndexForTsFileLoad();
            LOGGER.info("Use local generated load progress index {} for uuid {}.", (Object)progressIndex, (Object)req.uuid);
        }
        return this.createTLoadResp(StorageEngine.getInstance().executeLoadCommand(LoadTsFileScheduler.LoadCommand.values()[req.commandType], req.uuid, req.isSetIsGeneratedByPipe() && req.isGeneratedByPipe, (ProgressIndex)progressIndex));
    }

    private TLoadResp createTLoadResp(TSStatus resultStatus) {
        boolean isAccepted = RpcUtils.SUCCESS_STATUS.equals(resultStatus);
        TLoadResp loadResp = new TLoadResp(isAccepted);
        if (!isAccepted) {
            loadResp.setMessage(resultStatus.getMessage());
            loadResp.setStatus(resultStatus);
        }
        return loadResp;
    }

    public TSStatus createSchemaRegion(TCreateSchemaRegionReq req) {
        return this.regionManager.createSchemaRegion(req.getRegionReplicaSet(), req.getStorageGroup());
    }

    public TSStatus createDataRegion(TCreateDataRegionReq req) {
        return this.regionManager.createDataRegion(req.getRegionReplicaSet(), req.getStorageGroup());
    }

    public TSStatus invalidatePartitionCache(TInvalidateCacheReq req) {
        ClusterPartitionFetcher.getInstance().invalidAllCache();
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus invalidateLastCache(String database) {
        DataNodeSchemaCache.getInstance().invalidateLastCacheInDataRegion(database);
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus invalidateSchemaCache(TInvalidateCacheReq req) {
        DataNodeSchemaCache.getInstance().takeWriteLock();
        try {
            DataNodeSchemaCache.getInstance().invalidate(req.getFullPath());
            ClusterTemplateManager.getInstance().invalid(req.getFullPath());
            LOGGER.info("Schema cache of {} has been invalidated", (Object)req.getFullPath());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            DataNodeSchemaCache.getInstance().releaseWriteLock();
        }
    }

    public TSStatus constructSchemaBlackList(TConstructSchemaBlackListReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        AtomicLong preDeletedNum = new AtomicLong(0L);
        TSStatus executionResult = this.executeSchemaBlackListTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            String storageGroup = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId())).getDatabaseFullPath();
            PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, storageGroup);
            if (filteredPatternTree.isEmpty()) {
                return new TSStatus(TSStatusCode.ONLY_LOGICAL_VIEW.getStatusCode());
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            TSStatus status = executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), new ConstructSchemaBlackListNode(new PlanNodeId(""), filteredPatternTree)).getStatus();
            if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.code == TSStatusCode.ONLY_LOGICAL_VIEW.getStatusCode()) {
                preDeletedNum.getAndAdd(Long.parseLong(status.getMessage()));
            }
            return status;
        });
        executionResult.setMessage(String.valueOf(preDeletedNum.get()));
        return executionResult;
    }

    public TSStatus rollbackSchemaBlackList(TRollbackSchemaBlackListReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            String storageGroup = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId())).getDatabaseFullPath();
            PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, storageGroup);
            if (filteredPatternTree.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), new RollbackSchemaBlackListNode(new PlanNodeId(""), filteredPatternTree)).getStatus();
        });
    }

    public TSStatus invalidateMatchedSchemaCache(TInvalidateMatchedSchemaCacheReq req) {
        DataNodeSchemaCache cache = DataNodeSchemaCache.getInstance();
        DataNodeSchemaLockManager.getInstance().takeWriteLock(SchemaLockType.VALIDATE_VS_DELETION);
        cache.takeWriteLock();
        try {
            cache.invalidate(PathPatternTree.deserialize((ByteBuffer)req.pathPatternTree).getAllPathPatterns());
        }
        finally {
            cache.releaseWriteLock();
            DataNodeSchemaLockManager.getInstance().releaseWriteLock(SchemaLockType.VALIDATE_VS_DELETION);
        }
        return RpcUtils.SUCCESS_STATUS;
    }

    public TFetchSchemaBlackListResp fetchSchemaBlackList(TFetchSchemaBlackListReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)req.pathPatternTree);
        TFetchSchemaBlackListResp resp = new TFetchSchemaBlackListResp();
        PathPatternTree result = new PathPatternTree();
        for (TConsensusGroupId consensusGroupId : req.getSchemaRegionIdList()) {
            try {
                ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId()));
                PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, schemaRegion.getDatabaseFullPath());
                if (filteredPatternTree.isEmpty()) continue;
                for (PartialPath path : schemaRegion.fetchSchemaBlackList(filteredPatternTree)) {
                    result.appendFullPath(path);
                }
            }
            catch (MetadataException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                return resp;
            }
        }
        resp.setStatus(RpcUtils.SUCCESS_STATUS);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        result.constructTree();
        try {
            result.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        resp.setPathPatternTree(outputStream.toByteArray());
        return resp;
    }

    public TSStatus deleteDataForDeleteSchema(TDeleteDataForDeleteSchemaReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        List pathList = patternTree.getAllPathPatterns();
        return this.executeInternalSchemaTask(req.getDataRegionIdList(), consensusGroupId -> {
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new DataRegionId(consensusGroupId.getId()), req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe() ? new PipeEnrichedDeleteDataNode(new DeleteDataNode(new PlanNodeId(""), pathList, Long.MIN_VALUE, Long.MAX_VALUE)) : new DeleteDataNode(new PlanNodeId(""), pathList, Long.MIN_VALUE, Long.MAX_VALUE)).getStatus();
        });
    }

    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            String storageGroup = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId())).getDatabaseFullPath();
            PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, storageGroup);
            if (filteredPatternTree.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe() ? new PipeEnrichedNonWritePlanNode(new DeleteTimeSeriesNode(new PlanNodeId(""), filteredPatternTree)) : new DeleteTimeSeriesNode(new PlanNodeId(""), filteredPatternTree)).getStatus();
        });
    }

    public TSStatus constructSchemaBlackListWithTemplate(TConstructSchemaBlackListWithTemplateReq req) throws TException {
        AtomicInteger preDeactivateTemplateNum = new AtomicInteger(0);
        Map<PartialPath, List<Integer>> templateSetInfo = this.transformTemplateSetInfo(req.getTemplateSetInfo());
        TSStatus executionResult = this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            Map<PartialPath, List<Integer>> filteredTemplateSetInfo = this.filterTemplateSetInfo(templateSetInfo, (TConsensusGroupId)consensusGroupId);
            if (filteredTemplateSetInfo.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            TSStatus status = executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), new PreDeactivateTemplateNode(new PlanNodeId(""), filteredTemplateSetInfo)).getStatus();
            if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                preDeactivateTemplateNum.getAndAdd(Integer.parseInt(status.getMessage()));
            }
            return status;
        });
        executionResult.setMessage(String.valueOf(preDeactivateTemplateNum.get()));
        return executionResult;
    }

    private Map<PartialPath, List<Integer>> transformTemplateSetInfo(Map<String, List<Integer>> rawTemplateSetInfo) {
        HashMap<PartialPath, List<Integer>> result = new HashMap<PartialPath, List<Integer>>();
        rawTemplateSetInfo.forEach((k, v) -> {
            try {
                result.put(new PartialPath(k), (List<Integer>)v);
            }
            catch (IllegalPathException illegalPathException) {
                // empty catch block
            }
        });
        return result;
    }

    private Map<PartialPath, List<Integer>> filterTemplateSetInfo(Map<PartialPath, List<Integer>> templateSetInfo, TConsensusGroupId consensusGroupId) {
        HashMap<PartialPath, List<Integer>> result = new HashMap<PartialPath, List<Integer>>();
        PartialPath storageGroupPath = this.getStorageGroupPath(consensusGroupId);
        if (null != storageGroupPath) {
            PartialPath storageGroupPattern = storageGroupPath.concatNode("**");
            templateSetInfo.forEach((k, v) -> {
                if (storageGroupPattern.overlapWith(k) || storageGroupPath.overlapWith(k)) {
                    result.put((PartialPath)k, (List<Integer>)v);
                }
            });
        }
        return result;
    }

    private PartialPath getStorageGroupPath(TConsensusGroupId consensusGroupId) {
        PartialPath storageGroupPath = null;
        try {
            storageGroupPath = new PartialPath(this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId())).getDatabaseFullPath());
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        return storageGroupPath;
    }

    public TSStatus rollbackSchemaBlackListWithTemplate(TRollbackSchemaBlackListWithTemplateReq req) {
        Map<PartialPath, List<Integer>> templateSetInfo = this.transformTemplateSetInfo(req.getTemplateSetInfo());
        return this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            Map<PartialPath, List<Integer>> filteredTemplateSetInfo = this.filterTemplateSetInfo(templateSetInfo, (TConsensusGroupId)consensusGroupId);
            if (filteredTemplateSetInfo.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), new RollbackPreDeactivateTemplateNode(new PlanNodeId(""), filteredTemplateSetInfo)).getStatus();
        });
    }

    public TSStatus deactivateTemplate(TDeactivateTemplateReq req) throws TException {
        Map<PartialPath, List<Integer>> templateSetInfo = this.transformTemplateSetInfo(req.getTemplateSetInfo());
        return this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            Map<PartialPath, List<Integer>> filteredTemplateSetInfo = this.filterTemplateSetInfo(templateSetInfo, (TConsensusGroupId)consensusGroupId);
            if (filteredTemplateSetInfo.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe() ? new PipeEnrichedNonWritePlanNode(new DeactivateTemplateNode(new PlanNodeId(""), filteredTemplateSetInfo)) : new DeactivateTemplateNode(new PlanNodeId(""), filteredTemplateSetInfo)).getStatus();
        });
    }

    public TCountPathsUsingTemplateResp countPathsUsingTemplate(TCountPathsUsingTemplateReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)req.patternTree);
        TCountPathsUsingTemplateResp resp = new TCountPathsUsingTemplateResp();
        AtomicLong result = new AtomicLong(0L);
        resp.setStatus(this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            ReentrantReadWriteLock readWriteLock = this.regionManager.getRegionLock((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()));
            readWriteLock.writeLock().lock();
            try {
                ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId()));
                PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, schemaRegion.getDatabaseFullPath());
                if (filteredPatternTree.isEmpty()) {
                    TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
                    return tSStatus;
                }
                result.getAndAdd(schemaRegion.countPathsUsingTemplate(req.getTemplateId(), filteredPatternTree));
                TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
                return tSStatus;
            }
            catch (MetadataException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
                return tSStatus;
            }
            finally {
                readWriteLock.writeLock().unlock();
            }
        }));
        resp.setCount(result.get());
        return resp;
    }

    public TCheckSchemaRegionUsingTemplateResp checkSchemaRegionUsingTemplate(TCheckSchemaRegionUsingTemplateReq req) {
        TCheckSchemaRegionUsingTemplateResp resp = new TCheckSchemaRegionUsingTemplateResp();
        AtomicBoolean result = new AtomicBoolean(false);
        resp.setStatus(this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            ReentrantReadWriteLock readWriteLock = this.regionManager.getRegionLock((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()));
            readWriteLock.writeLock().lock();
            try {
                ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId()));
                if (schemaRegion.getSchemaRegionStatistics().getTemplateActivatedNumber() > 0) {
                    result.set(true);
                }
                TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
                return tSStatus;
            }
            finally {
                readWriteLock.writeLock().unlock();
            }
        }));
        resp.setResult(result.get());
        return resp;
    }

    public TCheckTimeSeriesExistenceResp checkTimeSeriesExistence(TCheckTimeSeriesExistenceReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)req.patternTree);
        TCheckTimeSeriesExistenceResp resp = new TCheckTimeSeriesExistenceResp();
        TSStatus status = this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            ReentrantReadWriteLock readWriteLock = this.regionManager.getRegionLock((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()));
            readWriteLock.writeLock().lock();
            try {
                ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId()));
                PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, schemaRegion.getDatabaseFullPath());
                if (filteredPatternTree.isEmpty()) {
                    TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
                    return tSStatus;
                }
                for (PartialPath pattern : filteredPatternTree.getAllPathPatterns()) {
                    ISchemaSource<ITimeSeriesSchemaInfo> schemaSource = SchemaSourceFactory.getTimeSeriesSchemaCountSource(pattern, false, null, null, SchemaConstant.ALL_MATCH_SCOPE);
                    try {
                        ISchemaReader<ITimeSeriesSchemaInfo> schemaReader;
                        block15: {
                            TSStatus tSStatus;
                            schemaReader = schemaSource.getSchemaReader(schemaRegion);
                            try {
                                if (!schemaReader.hasNext()) break block15;
                                tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.TIMESERIES_ALREADY_EXIST);
                                if (schemaReader == null) return tSStatus;
                            }
                            catch (Throwable throwable) {
                                if (schemaReader == null) throw throwable;
                                try {
                                    schemaReader.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            schemaReader.close();
                            return tSStatus;
                        }
                        if (schemaReader == null) continue;
                        schemaReader.close();
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                        TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
                        readWriteLock.writeLock().unlock();
                        return tSStatus;
                    }
                }
                TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
                return tSStatus;
            }
            finally {
                readWriteLock.writeLock().unlock();
            }
        });
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setStatus(RpcUtils.SUCCESS_STATUS);
            resp.setExists(false);
        } else if (status.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            boolean hasFailure = false;
            for (TSStatus subStatus : status.getSubStatus()) {
                if (subStatus.getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                    resp.setExists(true);
                    continue;
                }
                if (subStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                hasFailure = true;
                break;
            }
            if (hasFailure) {
                resp.setStatus(status);
            } else {
                resp.setStatus(RpcUtils.SUCCESS_STATUS);
            }
        } else {
            resp.setStatus(status);
        }
        return resp;
    }

    public TSStatus constructViewSchemaBlackList(TConstructViewSchemaBlackListReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        AtomicInteger preDeletedNum = new AtomicInteger(0);
        TSStatus executionResult = this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            String storageGroup = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId())).getDatabaseFullPath();
            PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, storageGroup);
            if (filteredPatternTree.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            TSStatus status = executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), new ConstructLogicalViewBlackListNode(new PlanNodeId(""), filteredPatternTree)).getStatus();
            if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                preDeletedNum.getAndAdd(Integer.parseInt(status.getMessage()));
            }
            return status;
        });
        executionResult.setMessage(String.valueOf(preDeletedNum.get()));
        return executionResult;
    }

    public TSStatus rollbackViewSchemaBlackList(TRollbackViewSchemaBlackListReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            String storageGroup = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId())).getDatabaseFullPath();
            PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, storageGroup);
            if (filteredPatternTree.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), new RollbackLogicalViewBlackListNode(new PlanNodeId(""), filteredPatternTree)).getStatus();
        });
    }

    public TSStatus deleteViewSchema(TDeleteViewSchemaReq req) {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.executeInternalSchemaTask(req.getSchemaRegionIdList(), consensusGroupId -> {
            String storageGroup = this.schemaEngine.getSchemaRegion(new SchemaRegionId(consensusGroupId.getId())).getDatabaseFullPath();
            PathPatternTree filteredPatternTree = this.filterPathPatternTree(patternTree, storageGroup);
            if (filteredPatternTree.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe() ? new PipeEnrichedNonWritePlanNode(new DeleteLogicalViewNode(new PlanNodeId(""), filteredPatternTree)) : new DeleteLogicalViewNode(new PlanNodeId(""), filteredPatternTree)).getStatus();
        });
    }

    public TSStatus alterView(TAlterViewReq req) {
        List consensusGroupIdList = req.getSchemaRegionIdList();
        List viewBinaryList = req.getViewBinaryList();
        HashMap schemaRegionRequestMap = new HashMap();
        for (int i = 0; i < consensusGroupIdList.size(); ++i) {
            ByteBuffer byteBuffer = (ByteBuffer)viewBinaryList.get(i);
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            HashMap<PartialPath, ViewExpression> viewMap = new HashMap<PartialPath, ViewExpression>();
            for (int j = 0; j < size; ++j) {
                viewMap.put((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer), ViewExpression.deserialize((ByteBuffer)byteBuffer));
            }
            schemaRegionRequestMap.put((TConsensusGroupId)consensusGroupIdList.get(i), viewMap);
        }
        return this.executeInternalSchemaTask(consensusGroupIdList, consensusGroupId -> {
            RegionWriteExecutor executor = new RegionWriteExecutor();
            return executor.execute((ConsensusGroupId)new SchemaRegionId(consensusGroupId.getId()), req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe() ? new PipeEnrichedNonWritePlanNode(new AlterLogicalViewNode(new PlanNodeId(""), (Map)schemaRegionRequestMap.get(consensusGroupId))) : new AlterLogicalViewNode(new PlanNodeId(""), (Map)schemaRegionRequestMap.get(consensusGroupId))).getStatus();
        });
    }

    public TPushPipeMetaResp pushPipeMeta(TPushPipeMetaReq req) {
        ArrayList<PipeMeta> pipeMetas = new ArrayList<PipeMeta>();
        for (ByteBuffer byteBuffer : req.getPipeMetas()) {
            pipeMetas.add(PipeMeta.deserialize((ByteBuffer)byteBuffer));
        }
        try {
            List exceptionMessages = PipeDataNodeAgent.task().handlePipeMetaChanges(pipeMetas);
            return exceptionMessages.isEmpty() ? new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())) : new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(exceptionMessages);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred when pushing pipe meta", (Throwable)e);
            return new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode()));
        }
    }

    public TPushPipeMetaResp pushSinglePipeMeta(TPushSinglePipeMetaReq req) {
        try {
            TPushPipeMetaRespExceptionMessage exceptionMessage;
            if (req.isSetPipeNameToDrop()) {
                exceptionMessage = PipeDataNodeAgent.task().handleDropPipe(req.getPipeNameToDrop());
            } else if (req.isSetPipeMeta()) {
                PipeMeta pipeMeta = PipeMeta.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPipeMeta()));
                exceptionMessage = PipeDataNodeAgent.task().handleSinglePipeMetaChanges(pipeMeta);
            } else {
                throw new Exception("Invalid TPushSinglePipeMetaReq");
            }
            return exceptionMessage == null ? new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())) : new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(Collections.singletonList(exceptionMessage));
        }
        catch (Exception e) {
            LOGGER.error("Error occurred when pushing single pipe meta", (Throwable)e);
            return new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode()));
        }
    }

    public TPushPipeMetaResp pushMultiPipeMeta(TPushMultiPipeMetaReq req) {
        boolean hasException = false;
        ArrayList<TPushPipeMetaRespExceptionMessage> exceptionMessages = new ArrayList<TPushPipeMetaRespExceptionMessage>();
        try {
            if (req.isSetPipeNamesToDrop()) {
                for (String pipeNameToDrop : req.getPipeNamesToDrop()) {
                    TPushPipeMetaRespExceptionMessage message = PipeDataNodeAgent.task().handleDropPipe(pipeNameToDrop);
                    exceptionMessages.add(message);
                    if (message == null) continue;
                    hasException = true;
                    break;
                }
            } else if (req.isSetPipeMetas()) {
                for (ByteBuffer byteBuffer : req.getPipeMetas()) {
                    PipeMeta pipeMeta = PipeMeta.deserialize((ByteBuffer)byteBuffer);
                    TPushPipeMetaRespExceptionMessage message = PipeDataNodeAgent.task().handleSinglePipeMetaChanges(pipeMeta);
                    exceptionMessages.add(message);
                    if (message == null) continue;
                    hasException = true;
                    break;
                }
            } else {
                throw new Exception("Invalid TPushMultiPipeMetaReq");
            }
            return hasException ? new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(exceptionMessages) : new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when pushing multi pipe meta", (Throwable)e);
            return new TPushPipeMetaResp().setStatus(new TSStatus(TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(exceptionMessages);
        }
    }

    public TPushTopicMetaResp pushTopicMeta(TPushTopicMetaReq req) {
        ArrayList<TopicMeta> topicMetas = new ArrayList<TopicMeta>();
        for (ByteBuffer byteBuffer : req.getTopicMetas()) {
            topicMetas.add(TopicMeta.deserialize((ByteBuffer)byteBuffer));
        }
        try {
            TPushTopicMetaRespExceptionMessage exceptionMessage = SubscriptionAgent.topic().handleTopicMetaChanges(topicMetas);
            return exceptionMessage == null ? new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())) : new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(Collections.singletonList(exceptionMessage));
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when pushing topic meta", (Throwable)e);
            return new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode()));
        }
    }

    public TPushTopicMetaResp pushSingleTopicMeta(TPushSingleTopicMetaReq req) {
        try {
            TPushTopicMetaRespExceptionMessage exceptionMessage;
            if (req.isSetTopicNameToDrop()) {
                exceptionMessage = SubscriptionAgent.topic().handleDropTopic(req.getTopicNameToDrop());
            } else if (req.isSetTopicMeta()) {
                exceptionMessage = SubscriptionAgent.topic().handleSingleTopicMetaChanges(TopicMeta.deserialize((ByteBuffer)ByteBuffer.wrap(req.getTopicMeta())));
            } else {
                throw new SubscriptionException("Invalid request " + req + " from config node.");
            }
            return exceptionMessage == null ? new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())) : new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(Collections.singletonList(exceptionMessage));
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when pushing single topic meta", (Throwable)e);
            return new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode()));
        }
    }

    public TPushTopicMetaResp pushMultiTopicMeta(TPushMultiTopicMetaReq req) {
        boolean hasException = false;
        ArrayList<TPushTopicMetaRespExceptionMessage> exceptionMessages = new ArrayList<TPushTopicMetaRespExceptionMessage>();
        try {
            if (req.isSetTopicNamesToDrop()) {
                for (String topicNameToDrop : req.getTopicNamesToDrop()) {
                    TPushTopicMetaRespExceptionMessage message = SubscriptionAgent.topic().handleDropTopic(topicNameToDrop);
                    exceptionMessages.add(message);
                    if (message == null) continue;
                    hasException = true;
                    break;
                }
            } else if (req.isSetTopicMetas()) {
                for (ByteBuffer byteBuffer : req.getTopicMetas()) {
                    TopicMeta topicMeta = TopicMeta.deserialize((ByteBuffer)byteBuffer);
                    TPushTopicMetaRespExceptionMessage message = SubscriptionAgent.topic().handleSingleTopicMetaChanges(topicMeta);
                    exceptionMessages.add(message);
                    if (message == null) continue;
                    hasException = true;
                    break;
                }
            } else {
                throw new Exception("Invalid TPushMultiTopicMetaReq");
            }
            return hasException ? new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(exceptionMessages) : new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when pushing multi topic meta", (Throwable)e);
            return new TPushTopicMetaResp().setStatus(new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(exceptionMessages);
        }
    }

    public TPushConsumerGroupMetaResp pushConsumerGroupMeta(TPushConsumerGroupMetaReq req) {
        ArrayList<ConsumerGroupMeta> consumerGroupMetas = new ArrayList<ConsumerGroupMeta>();
        for (ByteBuffer byteBuffer : req.getConsumerGroupMetas()) {
            consumerGroupMetas.add(ConsumerGroupMeta.deserialize((ByteBuffer)byteBuffer));
        }
        try {
            TPushConsumerGroupMetaRespExceptionMessage exceptionMessage = SubscriptionAgent.consumer().handleConsumerGroupMetaChanges(consumerGroupMetas);
            return exceptionMessage == null ? new TPushConsumerGroupMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())) : new TPushConsumerGroupMetaResp().setStatus(new TSStatus(TSStatusCode.CONSUMER_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(Collections.singletonList(exceptionMessage));
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when pushing consumer group meta", (Throwable)e);
            return new TPushConsumerGroupMetaResp().setStatus(new TSStatus(TSStatusCode.CONSUMER_PUSH_META_ERROR.getStatusCode()));
        }
    }

    public TPushConsumerGroupMetaResp pushSingleConsumerGroupMeta(TPushSingleConsumerGroupMetaReq req) {
        try {
            TPushConsumerGroupMetaRespExceptionMessage exceptionMessage;
            if (req.isSetConsumerGroupNameToDrop()) {
                exceptionMessage = SubscriptionAgent.consumer().handleDropConsumerGroup(req.getConsumerGroupNameToDrop());
            } else if (req.isSetConsumerGroupMeta()) {
                exceptionMessage = SubscriptionAgent.consumer().handleSingleConsumerGroupMetaChanges(ConsumerGroupMeta.deserialize((ByteBuffer)ByteBuffer.wrap(req.getConsumerGroupMeta())));
            } else {
                throw new SubscriptionException("Invalid request " + req + " from config node.");
            }
            return exceptionMessage == null ? new TPushConsumerGroupMetaResp().setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())) : new TPushConsumerGroupMetaResp().setStatus(new TSStatus(TSStatusCode.CONSUMER_PUSH_META_ERROR.getStatusCode())).setExceptionMessages(Collections.singletonList(exceptionMessage));
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when pushing single consumer group meta", (Throwable)e);
            return new TPushConsumerGroupMetaResp().setStatus(new TSStatus(TSStatusCode.CONSUMER_PUSH_META_ERROR.getStatusCode()));
        }
    }

    public TPipeHeartbeatResp pipeHeartbeat(TPipeHeartbeatReq req) throws TException {
        TPipeHeartbeatResp resp = new TPipeHeartbeatResp();
        PipeDataNodeAgent.task().collectPipeMetaList(req, resp);
        return resp;
    }

    private TSStatus executeSchemaBlackListTask(List<TConsensusGroupId> consensusGroupIdList, Function<TConsensusGroupId, TSStatus> executeOnOneRegion) {
        List statusList = Collections.synchronizedList(new ArrayList());
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        consensusGroupIdList.parallelStream().forEach(consensusGroupId -> {
            TSStatus status = (TSStatus)executeOnOneRegion.apply((TConsensusGroupId)consensusGroupId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.ONLY_LOGICAL_VIEW.getStatusCode()) {
                hasFailure.set(true);
            }
            statusList.add(status);
        });
        if (hasFailure.get()) {
            return RpcUtils.getStatus(statusList);
        }
        return statusList.stream().filter(tsStatus -> tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()).findFirst().orElse(new TSStatus(TSStatusCode.ONLY_LOGICAL_VIEW.getStatusCode()));
    }

    private TSStatus executeInternalSchemaTask(List<TConsensusGroupId> consensusGroupIdList, Function<TConsensusGroupId, TSStatus> executeOnOneRegion) {
        List statusList = Collections.synchronizedList(new ArrayList());
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        consensusGroupIdList.parallelStream().forEach(consensusGroupId -> {
            TSStatus status = (TSStatus)executeOnOneRegion.apply((TConsensusGroupId)consensusGroupId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                hasFailure.set(true);
            }
            statusList.add(status);
        });
        if (hasFailure.get()) {
            return RpcUtils.getStatus(statusList);
        }
        return RpcUtils.SUCCESS_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus executeCQ(TExecuteCQ req) {
        InternalClientSession session = new InternalClientSession(req.cqId);
        SESSION_MANAGER.registerSession(session);
        SESSION_MANAGER.supplySession(session, req.getUsername(), ZoneId.of(req.getZoneId()), IoTDBConstant.ClientVersion.V_1_0);
        String executedSQL = req.queryBody;
        try {
            QueryStatement s = (QueryStatement)StatementGenerator.createStatement(req.queryBody, session.getZoneId());
            if (s == null) {
                TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)"This operation type is not supported");
                return tSStatus;
            }
            LogicAndExpression timeFilter = new LogicAndExpression(new GreaterEqualExpression(new TimestampOperand(), new ConstantOperand(TSDataType.INT64, String.valueOf(req.startTime))), new LessThanExpression(new TimestampOperand(), new ConstantOperand(TSDataType.INT64, String.valueOf(req.endTime))));
            if (s.getWhereCondition() != null) {
                s.getWhereCondition().setPredicate(new LogicAndExpression(timeFilter, s.getWhereCondition().getPredicate()));
            } else {
                s.setWhereCondition(new WhereCondition(timeFilter));
            }
            if (s.getGroupByTimeComponent() != null) {
                s.getGroupByTimeComponent().setStartTime(req.startTime);
                s.getGroupByTimeComponent().setEndTime(req.endTime);
                s.getGroupByTimeComponent().setLeftCRightO(true);
            }
            executedSQL = String.join((CharSequence)" ", s.constructFormattedSQL().split("\n")).replaceAll(" +", " ");
            long queryId = SESSION_MANAGER.requestQueryId(session, SESSION_MANAGER.requestStatementId(session));
            ExecutionResult result = COORDINATOR.executeForTreeModel(s, queryId, SESSION_MANAGER.getSessionInfo(session), executedSQL, this.partitionFetcher, this.schemaFetcher, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                TSStatus tSStatus = result.status;
                return tSStatus;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                if (queryExecution != null) {
                    Optional<TsBlock> optionalTsBlock;
                    while ((optionalTsBlock = queryExecution.getBatchResult()).isPresent()) {
                    }
                }
                TSStatus tSStatus = result.status;
                threadName.close();
                return tSStatus;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    TSStatus tSStatus = ErrorHandlingUtils.onQueryException(e, "\"" + executedSQL + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT));
                    return tSStatus;
                }
            }
        }
        finally {
            SESSION_MANAGER.closeSession(session, COORDINATOR::cleanupQueryExecution);
            SESSION_MANAGER.removeCurrSession();
        }
    }

    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) throws TException {
        return this.spaceQuotaManager.setSpaceQuota(req);
    }

    public TSStatus setThrottleQuota(TSetThrottleQuotaReq req) throws TException {
        return this.throttleQuotaManager.setThrottleQuota(req);
    }

    public TFetchFragmentInstanceStatisticsResp fetchFragmentInstanceStatistics(TFetchFragmentInstanceStatisticsReq req) throws TException {
        TFetchFragmentInstanceStatisticsResp resp;
        FragmentInstanceManager fragmentInstanceManager = FragmentInstanceManager.getInstance();
        try {
            resp = fragmentInstanceManager.getFragmentInstanceStatistics(FragmentInstanceId.fromThrift(req.getFragmentInstanceId()));
            resp.setStatus(RpcUtils.SUCCESS_STATUS);
        }
        catch (Exception e) {
            resp = new TFetchFragmentInstanceStatisticsResp();
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXPLAIN_ANALYZE_FETCH_ERROR, (String)e.getMessage()));
            LOGGER.error(e.getMessage());
        }
        return resp;
    }

    public TTestConnectionResp submitTestConnectionTask(TNodeLocations nodeLocations) throws TException {
        return new TTestConnectionResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), Stream.of(this.testAllConfigNodeConnection(nodeLocations.getConfigNodeLocations()), this.testAllDataNodeInternalServiceConnection(nodeLocations.getDataNodeLocations()), this.testAllDataNodeMPPServiceConnection(nodeLocations.getDataNodeLocations()), this.testAllDataNodeExternalServiceConnection(nodeLocations.getDataNodeLocations())).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private static <Location, RequestType> List<TTestConnectionResult> testConnections(List<Location> nodeLocations, Function<Location, Integer> getId, Function<Location, TEndPoint> getEndPoint, TServiceType serviceType, RequestType requestType, Consumer<AsyncRequestContext<Object, TSStatus, RequestType, Location>> sendRequest) {
        TSender sender = new TSender().setDataNodeLocation(IoTDBDescriptor.getInstance().getConfig().generateLocalDataNodeLocation());
        return TestConnectionUtils.testConnectionsImpl(nodeLocations, (TSender)sender, getId, getEndPoint, (TServiceType)serviceType, requestType, sendRequest);
    }

    private List<TTestConnectionResult> testAllConfigNodeConnection(List<TConfigNodeLocation> configNodeLocations) {
        return DataNodeInternalRPCServiceImpl.testConnections(configNodeLocations, TConfigNodeLocation::getConfigNodeId, TConfigNodeLocation::getInternalEndPoint, TServiceType.ConfigNodeInternalService, DnToCnRequestType.TEST_CONNECTION, handler -> DnToCnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequest((AsyncRequestContext)handler));
    }

    private List<TTestConnectionResult> testAllDataNodeInternalServiceConnection(List<TDataNodeLocation> dataNodeLocations) {
        return DataNodeInternalRPCServiceImpl.testConnections(dataNodeLocations, TDataNodeLocation::getDataNodeId, TDataNodeLocation::getInternalEndPoint, TServiceType.DataNodeInternalService, DnToDnRequestType.TEST_CONNECTION, handler -> DnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequest((AsyncRequestContext)handler));
    }

    private List<TTestConnectionResult> testAllDataNodeMPPServiceConnection(List<TDataNodeLocation> dataNodeLocations) {
        return DataNodeInternalRPCServiceImpl.testConnections(dataNodeLocations, TDataNodeLocation::getDataNodeId, TDataNodeLocation::getMPPDataExchangeEndPoint, TServiceType.DataNodeMPPService, DnToDnRequestType.TEST_CONNECTION, handler -> DataNodeMPPServiceAsyncRequestManager.getInstance().sendAsyncRequest((AsyncRequestContext)handler));
    }

    private List<TTestConnectionResult> testAllDataNodeExternalServiceConnection(List<TDataNodeLocation> dataNodeLocations) {
        return DataNodeInternalRPCServiceImpl.testConnections(dataNodeLocations, TDataNodeLocation::getDataNodeId, TDataNodeLocation::getClientRpcEndPoint, TServiceType.DataNodeExternalService, DnToDnRequestType.TEST_CONNECTION, handler -> DataNodeExternalServiceAsyncRequestManager.getInstance().sendAsyncRequest((AsyncRequestContext)handler));
    }

    public TSStatus testConnectionEmptyRPC() throws TException {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private PathPatternTree filterPathPatternTree(PathPatternTree patternTree, String storageGroup) {
        PathPatternTree filteredPatternTree = new PathPatternTree();
        try {
            PartialPath storageGroupPattern = new PartialPath(storageGroup).concatNode("**");
            for (PartialPath pathPattern : patternTree.getOverlappedPathPatterns(storageGroupPattern)) {
                filteredPatternTree.appendPathPattern(pathPattern);
            }
            filteredPatternTree.constructTree();
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        return filteredPatternTree;
    }

    public TDataNodeHeartbeatResp getDataNodeHeartBeat(TDataNodeHeartbeatReq req) throws TException {
        TDataNodeHeartbeatResp resp = new TDataNodeHeartbeatResp();
        if (req.isNeedJudgeLeader()) {
            resp.setConsensusLogicalTimeMap(this.getLogicalClockMap());
            resp.setJudgedLeaders(this.getJudgedLeaders());
        }
        if (req.isNeedSamplingLoad()) {
            TLoadSample loadSample = new TLoadSample();
            double cpuLoad = MetricService.getInstance().getAutoGauge(SystemMetric.SYS_CPU_LOAD.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), SYSTEM}).getValue();
            if (cpuLoad != 0.0) {
                loadSample.setCpuUsageRate(cpuLoad);
            }
            double usedMemory = this.getMemory("jvm.memory.used.bytes");
            double maxMemory = this.getMemory("jvm.memory.max.bytes");
            if (usedMemory != 0.0 && maxMemory != 0.0) {
                loadSample.setMemoryUsageRate(usedMemory * 100.0 / maxMemory);
            }
            this.sampleDiskLoad(loadSample);
            resp.setLoadSample(loadSample);
        }
        AuthorityChecker.getAuthorityFetcher().refreshToken();
        resp.setHeartbeatTimestamp(req.getHeartbeatTimestamp());
        resp.setStatus(this.commonConfig.getNodeStatus().getStatus());
        if (this.commonConfig.getStatusReason() != null) {
            resp.setStatusReason(this.commonConfig.getStatusReason());
        }
        if (req.getSchemaRegionIds() != null) {
            this.spaceQuotaManager.updateSpaceQuotaUsage(req.getSpaceQuotaUsage());
            resp.setRegionDeviceUsageMap(this.schemaEngine.countDeviceNumBySchemaRegion(req.getSchemaRegionIds()));
            resp.setRegionSeriesUsageMap(this.schemaEngine.countTimeSeriesNumBySchemaRegion(req.getSchemaRegionIds()));
        }
        if (req.getDataRegionIds() != null) {
            this.spaceQuotaManager.setDataRegionIds(req.getDataRegionIds());
            resp.setRegionDisk(this.spaceQuotaManager.getRegionDisk());
        }
        SchemaEngine.getInstance().updateAndFillSchemaCountMap(req, resp);
        if (req.isNeedPipeMetaList()) {
            PipeDataNodeAgent.task().collectPipeMetaList(resp);
        }
        if (req.isSetConfigNodeEndPoints() && ConfigNodeInfo.getInstance().updateConfigNodeList(new ArrayList<TEndPoint>(req.getConfigNodeEndPoints()))) {
            resp.setConfirmedConfigNodeEndPoints(req.getConfigNodeEndPoints());
        }
        return resp;
    }

    public TSStatus updateRegionCache(TRegionRouteReq req) {
        boolean result = ClusterPartitionFetcher.getInstance().updateRegionCache(req);
        if (result) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PARTITION_CACHE_UPDATE_ERROR);
    }

    private Map<TConsensusGroupId, Boolean> getJudgedLeaders() {
        HashMap<TConsensusGroupId, Boolean> result = new HashMap<TConsensusGroupId, Boolean>();
        DataRegionConsensusImpl.getInstance().getAllConsensusGroupIds().forEach(groupId -> result.put(groupId.convertToTConsensusGroupId(), DataRegionConsensusImpl.getInstance().isLeader(groupId)));
        SchemaRegionConsensusImpl.getInstance().getAllConsensusGroupIds().forEach(groupId -> result.put(groupId.convertToTConsensusGroupId(), SchemaRegionConsensusImpl.getInstance().isLeader(groupId)));
        return result;
    }

    private Map<TConsensusGroupId, Long> getLogicalClockMap() {
        HashMap<TConsensusGroupId, Long> result = new HashMap<TConsensusGroupId, Long>();
        DataRegionConsensusImpl.getInstance().getAllConsensusGroupIds().forEach(groupId -> result.put(groupId.convertToTConsensusGroupId(), DataRegionConsensusImpl.getInstance().getLogicalClock(groupId)));
        SchemaRegionConsensusImpl.getInstance().getAllConsensusGroupIds().forEach(groupId -> result.put(groupId.convertToTConsensusGroupId(), SchemaRegionConsensusImpl.getInstance().getLogicalClock(groupId)));
        return result;
    }

    private long getLogicalClock(TConsensusGroupId groupId) {
        switch (groupId.getType()) {
            case DataRegion: {
                return DataRegionConsensusImpl.getInstance().getLogicalClock(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)groupId));
            }
            case SchemaRegion: {
                return SchemaRegionConsensusImpl.getInstance().getLogicalClock(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)groupId));
            }
        }
        throw new IllegalArgumentException("Unknown consensus group type: " + groupId.getType());
    }

    private double getMemory(String gaugeName) {
        double result = 0.0;
        try {
            AutoGauge gauge;
            List<String> heapIds = Arrays.asList("PS Eden Space", "PS Old Eden", "Ps Survivor Space");
            List<String> noHeapIds = Arrays.asList("Code Cache", "Compressed Class Space", "Metaspace");
            for (String id : heapIds) {
                gauge = MetricService.getInstance().getAutoGauge(gaugeName, MetricLevel.IMPORTANT, new String[]{"id", id, "area", "heap"});
                result += gauge.getValue();
            }
            for (String id : noHeapIds) {
                gauge = MetricService.getInstance().getAutoGauge(gaugeName, MetricLevel.IMPORTANT, new String[]{"id", id, "area", "noheap"});
                result += gauge.getValue();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get memory from metric because: ", (Throwable)e);
            return 0.0;
        }
        return result;
    }

    private void sampleDiskLoad(TLoadSample loadSample) {
        double availableDisk = MetricService.getInstance().getAutoGauge(SystemMetric.SYS_DISK_AVAILABLE_SPACE.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), SYSTEM}).getValue();
        double totalDisk = MetricService.getInstance().getAutoGauge(SystemMetric.SYS_DISK_TOTAL_SPACE.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), SYSTEM}).getValue();
        if (availableDisk != 0.0 && totalDisk != 0.0) {
            double freeDiskRatio = availableDisk / totalDisk;
            loadSample.setFreeDiskSpace(availableDisk);
            loadSample.setDiskUsageRate(1.0 - freeDiskRatio);
            if (freeDiskRatio < this.commonConfig.getDiskSpaceWarningThreshold()) {
                LOGGER.warn("The available disk space is : {}, the total disk space is : {}, and the remaining disk usage ratio: {} is less than disk_space_warning_threshold: {}, set system to readonly!", new Object[]{RamUsageEstimator.humanReadableUnits((long)((long)availableDisk)), RamUsageEstimator.humanReadableUnits((long)((long)totalDisk)), freeDiskRatio, this.commonConfig.getDiskSpaceWarningThreshold()});
                this.commonConfig.setNodeStatus(NodeStatus.ReadOnly);
                this.commonConfig.setStatusReason("DiskFull");
            } else if (NodeStatus.ReadOnly.equals((Object)this.commonConfig.getNodeStatus()) && "DiskFull".equals(this.commonConfig.getStatusReason())) {
                this.commonConfig.setNodeStatus(NodeStatus.Running);
                this.commonConfig.setStatusReason(null);
            }
        }
    }

    public TSStatus invalidatePermissionCache(TInvalidatePermissionCacheReq req) {
        if (AuthorityChecker.invalidateCache(req.getUsername(), req.getRoleName())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CLEAR_PERMISSION_CACHE_ERROR);
    }

    public TSStatus merge() throws TException {
        try {
            this.storageEngine.mergeAll();
        }
        catch (StorageEngineException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus startRepairData() throws TException {
        if (!this.storageEngine.isReadyForNonReadWriteFunctions()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"not all sg is ready");
        }
        IoTDBConfig iotdbConfig = IoTDBDescriptor.getInstance().getConfig();
        if (!iotdbConfig.isEnableSeqSpaceCompaction() || !iotdbConfig.isEnableUnseqSpaceCompaction()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"cannot start repair task because inner space compaction is not enabled");
        }
        try {
            if (this.storageEngine.repairData()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            if (CompactionScheduleTaskManager.getRepairTaskManagerInstance().getRepairTaskStatus() == RepairTaskStatus.STOPPING) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"previous repair task is still stopping");
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"already have a running repair task");
        }
        catch (StorageEngineException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
    }

    public TSStatus stopRepairData() throws TException {
        try {
            this.storageEngine.stopRepairData();
        }
        catch (StorageEngineException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus flush(TFlushReq req) throws TException {
        try {
            this.storageEngine.operateFlush(req);
        }
        catch (Exception e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus clearCache() throws TException {
        try {
            this.storageEngine.clearCache();
        }
        catch (Exception e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus setConfiguration(TSetConfigurationReq req) {
        return StorageEngine.getInstance().setConfiguration(req);
    }

    public TSStatus settle(TSettleReq req) throws TException {
        return SettleRequestHandler.getInstance().handleSettleRequest(req);
    }

    public TSStatus loadConfiguration() throws TException {
        try {
            IoTDBDescriptor.getInstance().loadHotModifiedProps();
        }
        catch (Exception e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TShowConfigurationResp showConfiguration() {
        TShowConfigurationResp resp = new TShowConfigurationResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), "");
        try {
            URL propsUrl = IoTDBDescriptor.getPropsUrl("iotdb-system.properties");
            resp.setContent(ConfigurationFileUtils.readConfigFileContent((URL)propsUrl));
        }
        catch (Exception e) {
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage()));
        }
        return resp;
    }

    public TSStatus setSystemStatus(String status) throws TException {
        try {
            this.commonConfig.setNodeStatus(NodeStatus.parse((String)status));
            if (this.commonConfig.getNodeStatus().equals((Object)NodeStatus.Removing)) {
                PipeDataNodeAgent.runtime().stop();
            }
        }
        catch (Exception e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus killQueryInstance(String queryId) {
        Coordinator coordinator = Coordinator.getInstance();
        if (queryId == null) {
            coordinator.getAllQueryExecutions().forEach(IQueryExecution::cancel);
        } else {
            Optional<IQueryExecution> queryExecution = coordinator.getAllQueryExecutions().stream().filter(iQueryExecution -> iQueryExecution.getQueryId().equals(queryId)).findAny();
            if (queryExecution.isPresent()) {
                queryExecution.get().cancel();
            } else {
                return new TSStatus(TSStatusCode.NO_SUCH_QUERY.getStatusCode()).setMessage("No such query");
            }
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus setTTL(TSetTTLReq req) throws TException {
        try {
            return this.storageEngine.setTTL(req);
        }
        catch (IllegalPathException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
    }

    public TSStatus updateTemplate(TUpdateTemplateReq req) {
        switch (TemplateInternalRPCUpdateType.getType(req.type)) {
            case ADD_TEMPLATE_SET_INFO: {
                DataNodeSchemaLockManager.getInstance().takeWriteLock(SchemaLockType.TIMESERIES_VS_TEMPLATE);
                try {
                    ClusterTemplateManager.getInstance().addTemplateSetInfo(req.getTemplateInfo());
                    break;
                }
                finally {
                    DataNodeSchemaLockManager.getInstance().releaseWriteLock(SchemaLockType.TIMESERIES_VS_TEMPLATE);
                }
            }
            case INVALIDATE_TEMPLATE_SET_INFO: {
                ClusterTemplateManager.getInstance().invalidateTemplateSetInfo(req.getTemplateInfo());
                break;
            }
            case ADD_TEMPLATE_PRE_SET_INFO: {
                ClusterTemplateManager.getInstance().addTemplatePreSetInfo(req.getTemplateInfo());
                break;
            }
            case COMMIT_TEMPLATE_SET_INFO: {
                ClusterTemplateManager.getInstance().commitTemplatePreSetInfo(req.getTemplateInfo());
                break;
            }
            case UPDATE_TEMPLATE_INFO: {
                ClusterTemplateManager.getInstance().updateTemplateInfo(req.getTemplateInfo());
                break;
            }
            default: {
                LOGGER.warn("Unsupported type {} when updating template", (Object)req.type);
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.ILLEGAL_PARAMETER);
            }
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus deleteRegion(TConsensusGroupId tconsensusGroupId) {
        ConsensusGroupId consensusGroupId;
        block6: {
            consensusGroupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)tconsensusGroupId);
            if (consensusGroupId instanceof DataRegionId) {
                block5: {
                    try {
                        DataRegionConsensusImpl.getInstance().deleteLocalPeer(consensusGroupId);
                    }
                    catch (ConsensusException e) {
                        if (e instanceof ConsensusGroupNotExistException) break block5;
                        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.DELETE_REGION_ERROR, (String)e.getMessage());
                    }
                }
                return this.regionManager.deleteDataRegion((DataRegionId)consensusGroupId);
            }
            try {
                SchemaRegionConsensusImpl.getInstance().deleteLocalPeer(consensusGroupId);
            }
            catch (ConsensusException e) {
                if (e instanceof ConsensusGroupNotExistException) break block6;
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.DELETE_REGION_ERROR, (String)e.getMessage());
            }
        }
        return this.regionManager.deleteSchemaRegion((SchemaRegionId)consensusGroupId);
    }

    public TRegionLeaderChangeResp changeRegionLeader(TRegionLeaderChangeReq req) {
        LOGGER.info("[ChangeRegionLeader] {}", (Object)req);
        TRegionLeaderChangeResp resp = new TRegionLeaderChangeResp();
        TSStatus successStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        TConsensusGroupId tgId = req.getRegionId();
        ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)tgId);
        TEndPoint newNode = this.getConsensusEndPoint(req.getNewLeaderNode(), regionId);
        Peer newLeaderPeer = new Peer(regionId, req.getNewLeaderNode().getDataNodeId(), newNode);
        if (this.isLeader(regionId)) {
            String msg = "[ChangeRegionLeader] The current DataNode: " + req.getNewLeaderNode().getDataNodeId() + " is already the leader of RegionGroup: " + regionId + ", skip leader transfer.";
            LOGGER.info(msg);
            resp.setStatus(successStatus.setMessage(msg));
            resp.setConsensusLogicalTimestamp(this.getLogicalClock(req.getRegionId()));
            return resp;
        }
        LOGGER.info("[ChangeRegionLeader] Start change the leader of RegionGroup: {} to DataNode: {}", (Object)regionId, (Object)req.getNewLeaderNode().getDataNodeId());
        resp.setStatus(this.transferLeader(regionId, newLeaderPeer));
        resp.setConsensusLogicalTimestamp(this.getLogicalClock(req.getRegionId()));
        return resp;
    }

    private TSStatus transferLeader(ConsensusGroupId regionId, Peer newLeaderPeer) {
        TSStatus status;
        block4: {
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            try {
                if (regionId instanceof DataRegionId) {
                    DataRegionConsensusImpl.getInstance().transferLeader(regionId, newLeaderPeer);
                    break block4;
                }
                if (regionId instanceof SchemaRegionId) {
                    SchemaRegionConsensusImpl.getInstance().transferLeader(regionId, newLeaderPeer);
                    break block4;
                }
                status.setCode(TSStatusCode.REGION_LEADER_CHANGE_ERROR.getStatusCode());
                status.setMessage("[ChangeRegionLeader] Error Region type: " + regionId);
                return status;
            }
            catch (ConsensusException e) {
                LOGGER.warn("[ChangeRegionLeader] Failed to change the leader of RegionGroup: {}", (Object)regionId, (Object)e);
                status.setCode(TSStatusCode.REGION_LEADER_CHANGE_ERROR.getStatusCode());
                status.setMessage(e.getMessage());
                return status;
            }
        }
        status.setMessage("[ChangeRegionLeader] Successfully change the leader of RegionGroup: " + regionId + " to " + newLeaderPeer.getNodeId());
        return status;
    }

    private boolean isLeader(ConsensusGroupId regionId) {
        if (regionId instanceof DataRegionId) {
            return DataRegionConsensusImpl.getInstance().isLeader(regionId);
        }
        if (regionId instanceof SchemaRegionId) {
            return SchemaRegionConsensusImpl.getInstance().isLeader(regionId);
        }
        LOGGER.warn("region {} type is illegal", (Object)regionId);
        return false;
    }

    public TSStatus createNewRegionPeer(TCreatePeerReq req) {
        ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getRegionId());
        List<Peer> peers = req.getRegionLocations().stream().map(location -> new Peer(regionId, location.getDataNodeId(), this.getConsensusEndPoint((TDataNodeLocation)location, regionId))).collect(Collectors.toList());
        TSStatus status = this.createNewRegion(regionId, req.getStorageGroup());
        if (!this.isSucceed(status)) {
            return status;
        }
        return this.createNewRegionPeer(regionId, peers);
    }

    public TSStatus addRegionPeer(TMaintainPeerReq req) {
        TConsensusGroupId regionId = req.getRegionId();
        String selectedDataNodeIP = req.getDestNode().getInternalEndPoint().getIp();
        boolean submitSucceed = RegionMigrateService.getInstance().submitAddRegionPeerTask(req);
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        if (submitSucceed) {
            LOGGER.info("Successfully submit addRegionPeer task for region: {}, target DataNode: {}", (Object)regionId, (Object)selectedDataNodeIP);
            return status;
        }
        status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
        status.setMessage("Submit addRegionPeer task failed, region: " + regionId);
        return status;
    }

    public TSStatus removeRegionPeer(TMaintainPeerReq req) {
        TConsensusGroupId regionId = req.getRegionId();
        String selectedDataNodeIP = req.getDestNode().getInternalEndPoint().getIp();
        boolean submitSucceed = RegionMigrateService.getInstance().submitRemoveRegionPeerTask(req);
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        if (submitSucceed) {
            LOGGER.info("Successfully submit removeRegionPeer task for region: {}, DataNode to be removed: {}", (Object)regionId, (Object)selectedDataNodeIP);
            return status;
        }
        status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
        status.setMessage("Submit removeRegionPeer task failed, region: " + regionId);
        return status;
    }

    public TSStatus deleteOldRegionPeer(TMaintainPeerReq req) {
        TConsensusGroupId regionId = req.getRegionId();
        String selectedDataNodeIP = req.getDestNode().getInternalEndPoint().getIp();
        boolean submitSucceed = RegionMigrateService.getInstance().submitDeleteOldRegionPeerTask(req);
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        if (submitSucceed) {
            LOGGER.info("Successfully submit deleteOldRegionPeer task for region: {}, DataNode to be removed: {}", (Object)regionId, (Object)selectedDataNodeIP);
            return status;
        }
        status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
        status.setMessage("Submit deleteOldRegionPeer task failed, region: " + regionId);
        return status;
    }

    public TSStatus resetPeerList(TResetPeerListReq req) throws TException {
        return RegionMigrateService.getInstance().resetPeerList(req);
    }

    public TRegionMigrateResult getRegionMaintainResult(long taskId) throws TException {
        return RegionMigrateService.getInstance().getRegionMaintainResult(taskId);
    }

    private TSStatus createNewRegion(ConsensusGroupId regionId, String storageGroup) {
        return this.regionManager.createNewRegion(regionId, storageGroup);
    }

    public TSStatus createFunction(TCreateFunctionInstanceReq req) {
        try {
            UDFInformation udfInformation = UDFInformation.deserialize((ByteBuffer)req.udfInformation);
            UDFManagementService.getInstance().register(udfInformation, req.jarFile);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.CREATE_UDF_ON_DATANODE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropFunction(TDropFunctionInstanceReq req) {
        try {
            UDFManagementService.getInstance().deregister(req.getFunctionName(), req.isNeedToDeleteJar());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.DROP_UDF_ON_DATANODE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus createTriggerInstance(TCreateTriggerInstanceReq req) {
        TriggerInformation triggerInformation = TriggerInformation.deserialize((ByteBuffer)req.triggerInformation);
        try {
            TriggerManagementService.getInstance().register(triggerInformation, req.jarFile);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when creating trigger instance for trigger: {}. The cause is {}.", (Object)triggerInformation.getTriggerName(), (Object)e);
            return new TSStatus(TSStatusCode.CREATE_TRIGGER_INSTANCE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus activeTriggerInstance(TActiveTriggerInstanceReq req) {
        try {
            TriggerManagementService.getInstance().activeTrigger(req.triggerName);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred during active trigger instance for trigger: {}. The cause is {}.", (Object)req.triggerName, (Object)e);
            return new TSStatus(TSStatusCode.ACTIVE_TRIGGER_INSTANCE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus inactiveTriggerInstance(TInactiveTriggerInstanceReq req) {
        try {
            TriggerManagementService.getInstance().inactiveTrigger(req.triggerName);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when try to inactive trigger instance for trigger: {}. The cause is {}. ", (Object)req.triggerName, (Object)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus dropTriggerInstance(TDropTriggerInstanceReq req) {
        try {
            TriggerManagementService.getInstance().dropTrigger(req.triggerName, req.needToDeleteJarFile);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when dropping trigger instance for trigger: {}. The cause is {}.", (Object)req.triggerName, (Object)e);
            return new TSStatus(TSStatusCode.DROP_TRIGGER_INSTANCE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus updateTriggerLocation(TUpdateTriggerLocationReq req) {
        try {
            TriggerManagementService.getInstance().updateLocationOfStatefulTrigger(req.triggerName, req.newLocation);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred when updating Location for trigger: {}. The cause is {}.", (Object)req.triggerName, (Object)e);
            return new TSStatus(TSStatusCode.UPDATE_TRIGGER_LOCATION_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TFireTriggerResp fireTrigger(TFireTriggerReq req) {
        String triggerName = req.getTriggerName();
        TriggerExecutor executor = TriggerManagementService.getInstance().getExecutor(triggerName);
        if (executor == null) {
            return new TFireTriggerResp(false, TriggerFireResult.FAILED_NO_TERMINATION.getId());
        }
        TriggerFireResult result = TriggerFireResult.SUCCESS;
        try {
            boolean fireResult = executor.fire(Tablet.deserialize((ByteBuffer)req.tablet), TriggerEvent.construct((byte)req.getTriggerEvent()));
            if (!fireResult) {
                result = executor.getFailureStrategy().equals((Object)FailureStrategy.PESSIMISTIC) ? TriggerFireResult.TERMINATION : TriggerFireResult.FAILED_NO_TERMINATION;
            }
        }
        catch (Exception e) {
            result = executor.getFailureStrategy().equals((Object)FailureStrategy.PESSIMISTIC) ? TriggerFireResult.TERMINATION : TriggerFireResult.FAILED_NO_TERMINATION;
        }
        return new TFireTriggerResp(true, result.getId());
    }

    private TEndPoint getConsensusEndPoint(TDataNodeLocation nodeLocation, ConsensusGroupId regionId) {
        if (regionId instanceof DataRegionId) {
            return nodeLocation.getDataRegionConsensusEndPoint();
        }
        return nodeLocation.getSchemaRegionConsensusEndPoint();
    }

    public TSStatus createPipePlugin(TCreatePipePluginInstanceReq req) {
        try {
            PipePluginMeta pipePluginMeta = PipePluginMeta.deserialize((ByteBuffer)req.pipePluginMeta);
            PipeDataNodeAgent.plugin().register(pipePluginMeta, req.jarFile);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.CREATE_PIPE_PLUGIN_ON_DATANODE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropPipePlugin(TDropPipePluginInstanceReq req) {
        try {
            PipeDataNodeAgent.plugin().deregister(req.getPipePluginName(), req.isNeedToDeleteJar());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.DROP_PIPE_PLUGIN_ON_DATANODE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    private boolean isSucceed(TSStatus status) {
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    private TSStatus createNewRegionPeer(ConsensusGroupId regionId, List<Peer> peers) {
        TSStatus status;
        block4: {
            LOGGER.info("{}, Start to createNewRegionPeer {} to region {}", new Object[]{"[REGION_MIGRATE_PROCESS]", peers, regionId});
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            try {
                if (regionId instanceof DataRegionId) {
                    List<Object> createPeers = "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass()) ? Collections.emptyList() : peers;
                    DataRegionConsensusImpl.getInstance().createLocalPeer(regionId, createPeers);
                } else {
                    List<Object> createPeers = "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(IoTDBDescriptor.getInstance().getConfig().getSchemaRegionConsensusProtocolClass()) ? Collections.emptyList() : peers;
                    SchemaRegionConsensusImpl.getInstance().createLocalPeer(regionId, createPeers);
                }
            }
            catch (ConsensusException e) {
                if (e instanceof ConsensusGroupAlreadyExistException) break block4;
                LOGGER.warn("{}, CreateNewRegionPeer error, peers: {}, regionId: {}, errorMessage", new Object[]{"[REGION_MIGRATE_PROCESS]", peers, regionId, e});
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage(e.getMessage());
                return status;
            }
        }
        LOGGER.info("{}, Succeed to createNewRegionPeer {} for region {}", new Object[]{"[REGION_MIGRATE_PROCESS]", peers, regionId});
        status.setMessage("createNewRegionPeer succeed, regionId: " + regionId);
        return status;
    }

    public TSStatus disableDataNode(TDisableDataNodeReq req) {
        LOGGER.info("start disable data node in the request: {}", (Object)req);
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        status.setMessage("disable datanode succeed");
        ClusterPartitionFetcher.getInstance().invalidAllCache();
        DataNodeSchemaCache.getInstance().takeWriteLock();
        try {
            DataNodeSchemaCache.getInstance().cleanUp();
        }
        finally {
            DataNodeSchemaCache.getInstance().releaseWriteLock();
        }
        DataNodeDevicePathCache.getInstance().cleanUp();
        return status;
    }

    public TSStatus stopDataNode() {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        LOGGER.info("Execute stopDataNode RPC method");
        new Thread(() -> {
            try {
                TimeUnit.SECONDS.sleep(20L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Meets InterruptedException in stopDataNode RPC method");
            }
            finally {
                LOGGER.info("Executing system.exit(0) in stopDataNode RPC method after 20 seconds");
                System.exit(0);
            }
        }).start();
        try {
            DataNode.getInstance().stop();
            status.setMessage("stop datanode succeed");
        }
        catch (Exception e) {
            LOGGER.warn("Stop Data Node error", (Throwable)e);
            status.setCode(TSStatusCode.DATANODE_STOP_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        return status;
    }

    public void handleClientExit() {
    }
}

