/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class PipeStatementExceptionVisitor
extends StatementVisitor<TSStatus, Exception> {
    @Override
    public TSStatus visitNode(StatementNode node, Exception context) {
        return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).setMessage(context.getMessage());
    }

    @Override
    public TSStatus visitLoadFile(LoadTsFileStatement loadTsFileStatement, Exception context) {
        if (context instanceof LoadRuntimeOutOfMemoryException) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context instanceof SemanticException) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(loadTsFileStatement, context);
    }

    @Override
    public TSStatus visitCreateTimeseries(CreateTimeSeriesStatement statement, Exception context) {
        return this.visitGeneralCreateTimeSeries(statement, context);
    }

    @Override
    public TSStatus visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement statement, Exception context) {
        return this.visitGeneralCreateTimeSeries(statement, context);
    }

    @Override
    public TSStatus visitCreateMultiTimeSeries(CreateMultiTimeSeriesStatement statement, Exception context) {
        return this.visitGeneralCreateTimeSeries(statement, context);
    }

    @Override
    public TSStatus visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement statement, Exception context) {
        return this.visitGeneralCreateTimeSeries(statement, context);
    }

    @Override
    public TSStatus visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesStatement statement, Exception context) {
        return this.visitGeneralCreateTimeSeries(statement, context);
    }

    private TSStatus visitGeneralCreateTimeSeries(Statement statement, Exception context) {
        if (context instanceof SemanticException) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (this.isAutoCreateConflict(context)) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getCause().getMessage());
        }
        return (TSStatus)this.visitStatement(statement, context);
    }

    @Override
    public TSStatus visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, Exception context) {
        return this.visitGeneralActivateTemplate(activateTemplateStatement, context);
    }

    @Override
    public TSStatus visitBatchActivateTemplate(BatchActivateTemplateStatement batchActivateTemplateStatement, Exception context) {
        return this.visitGeneralActivateTemplate(batchActivateTemplateStatement, context);
    }

    private TSStatus visitGeneralActivateTemplate(Statement activateTemplateStatement, Exception context) {
        if (context instanceof MetadataException || context instanceof StatementAnalyzeException) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (this.isAutoCreateConflict(context)) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getCause().getMessage());
        }
        return (TSStatus)this.visitStatement(activateTemplateStatement, context);
    }

    private boolean isAutoCreateConflict(Exception e) {
        return e instanceof RuntimeException && e.getCause() instanceof IoTDBException && e.getCause().getMessage().contains("already been created as database");
    }
}

