/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.agent.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeSchemaRegionConnectorMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSchemaRegionConnectorMetrics.class);
    private volatile AbstractMetricService metricService;
    private final ConcurrentMap<String, PipeConnectorSubtask> connectorMap = new ConcurrentHashMap<String, PipeConnectorSubtask>();
    private final ConcurrentMap<String, Rate> schemaRateMap = new ConcurrentHashMap<String, Rate>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.connectorMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String taskID) {
        this.createRate(taskID);
    }

    private void createRate(String taskID) {
        PipeConnectorSubtask connector = (PipeConnectorSubtask)((Object)this.connectorMap.get(taskID));
        this.schemaRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_CONNECTOR_SCHEMA_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.connectorMap.keySet()).forEach(this::deregister);
        if (!this.connectorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe schema region connector metrics, connector map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeRate(taskID);
    }

    private void removeRate(String taskID) {
        PipeConnectorSubtask connector = (PipeConnectorSubtask)((Object)this.connectorMap.get(taskID));
        this.metricService.remove(MetricType.RATE, Metric.PIPE_CONNECTOR_SCHEMA_TRANSFER.toString(), new String[]{Tag.NAME.toString(), connector.getAttributeSortedString(), Tag.CREATION_TIME.toString(), String.valueOf(connector.getCreationTime())});
        this.schemaRateMap.remove(taskID);
    }

    public void register(@NonNull PipeConnectorSubtask pipeConnectorSubtask) {
        String taskID = pipeConnectorSubtask.getTaskID();
        this.connectorMap.putIfAbsent(taskID, pipeConnectorSubtask);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String taskID) {
        if (!this.connectorMap.containsKey(taskID)) {
            LOGGER.warn("Failed to deregister pipe schema region connector metrics, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(taskID);
        }
        this.connectorMap.remove(taskID);
    }

    public void markSchemaEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = (Rate)this.schemaRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe schema region write plan event, PipeConnectorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public static PipeSchemaRegionConnectorMetrics getInstance() {
        return PipeSchemaRegionConnectorMetricsHolder.INSTANCE;
    }

    private PipeSchemaRegionConnectorMetrics() {
    }

    private static class PipeSchemaRegionConnectorMetricsHolder {
        private static final PipeSchemaRegionConnectorMetrics INSTANCE = new PipeSchemaRegionConnectorMetrics();

        private PipeSchemaRegionConnectorMetricsHolder() {
        }
    }
}

