/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.agent.task.subtask.processor.PipeProcessorSubtask;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeProcessorMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeProcessorMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, PipeProcessorSubtask> processorMap = new HashMap<String, PipeProcessorSubtask>();
    private final Map<String, Rate> tabletRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> tsFileRateMap = new ConcurrentHashMap<String, Rate>();
    private final Map<String, Rate> pipeHeartbeatRateMap = new ConcurrentHashMap<String, Rate>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.processorMap.keySet());
        for (String taskID : taskIDs) {
            this.createMetrics(taskID);
        }
    }

    private void createMetrics(String taskID) {
        this.createRate(taskID);
    }

    private void createRate(String taskID) {
        PipeProcessorSubtask processor = this.processorMap.get(taskID);
        this.tabletRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_PROCESSOR_TABLET_PROCESS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), processor.getPipeName(), Tag.REGION.toString(), String.valueOf(processor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(processor.getCreationTime())}));
        this.tsFileRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_PROCESSOR_TSFILE_PROCESS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), processor.getPipeName(), Tag.REGION.toString(), String.valueOf(processor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(processor.getCreationTime())}));
        this.pipeHeartbeatRateMap.put(taskID, this.metricService.getOrCreateRate(Metric.PIPE_PROCESSOR_HEARTBEAT_PROCESS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), processor.getPipeName(), Tag.REGION.toString(), String.valueOf(processor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(processor.getCreationTime())}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet taskIDs = ImmutableSet.copyOf(this.processorMap.keySet());
        for (String taskID : taskIDs) {
            this.deregister(taskID);
        }
        if (!this.processorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe processor metrics, processor map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeRate(taskID);
    }

    private void removeRate(String taskID) {
        PipeProcessorSubtask processor = this.processorMap.get(taskID);
        this.metricService.remove(MetricType.RATE, Metric.PIPE_PROCESSOR_TABLET_PROCESS.toString(), new String[]{Tag.NAME.toString(), processor.getPipeName(), Tag.REGION.toString(), String.valueOf(processor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(processor.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_PROCESSOR_TSFILE_PROCESS.toString(), new String[]{Tag.NAME.toString(), processor.getPipeName(), Tag.REGION.toString(), String.valueOf(processor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(processor.getCreationTime())});
        this.metricService.remove(MetricType.RATE, Metric.PIPE_PROCESSOR_HEARTBEAT_PROCESS.toString(), new String[]{Tag.NAME.toString(), processor.getPipeName(), Tag.REGION.toString(), String.valueOf(processor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(processor.getCreationTime())});
        this.tabletRateMap.remove(taskID);
        this.tsFileRateMap.remove(taskID);
        this.pipeHeartbeatRateMap.remove(taskID);
    }

    public void register(@NonNull PipeProcessorSubtask pipeProcessorSubtask) {
        String taskID = pipeProcessorSubtask.getTaskID();
        this.processorMap.putIfAbsent(taskID, pipeProcessorSubtask);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String taskID) {
        if (!this.processorMap.containsKey(taskID)) {
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(taskID);
        }
        this.processorMap.remove(taskID);
    }

    public void markTabletEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.tabletRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe processor tablet event, PipeProcessorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markTsFileEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.tsFileRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe processor tsfile event, PipeProcessorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public void markPipeHeartbeatEvent(String taskID) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        Rate rate = this.pipeHeartbeatRateMap.get(taskID);
        if (rate == null) {
            LOGGER.info("Failed to mark pipe processor heartbeat event, PipeProcessorSubtask({}) does not exist", (Object)taskID);
            return;
        }
        rate.mark();
    }

    public static PipeProcessorMetrics getInstance() {
        return PipeProcessorMetricsHolder.INSTANCE;
    }

    private PipeProcessorMetrics() {
    }

    private static class PipeProcessorMetricsHolder {
        private static final PipeProcessorMetrics INSTANCE = new PipeProcessorMetrics();

        private PipeProcessorMetricsHolder() {
        }
    }
}

