/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.extractor.schemaregion.IoTDBSchemaRegionExtractor;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeRemainingEventAndTimeOperator;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeRemainingEventAndTimeMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeRemainingEventAndTimeMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, PipeDataNodeRemainingEventAndTimeOperator> remainingEventAndTimeOperatorMap = new ConcurrentHashMap<String, PipeDataNodeRemainingEventAndTimeOperator>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.remainingEventAndTimeOperatorMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String pipeID) {
        this.createAutoGauge(pipeID);
    }

    private void createAutoGauge(String pipeID) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        this.metricService.createAutoGauge(Metric.PIPE_DATANODE_REMAINING_EVENT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)operator, PipeDataNodeRemainingEventAndTimeOperator::getRemainingEvents, new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_DATANODE_REMAINING_TIME.toString(), MetricLevel.IMPORTANT, (Object)operator, PipeDataNodeRemainingEventAndTimeOperator::getRemainingTime, new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.remainingEventAndTimeOperatorMap.keySet()).forEach(this::deregister);
        if (!this.remainingEventAndTimeOperatorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe remaining event and time metrics, RemainingEventAndTimeOperator map not empty");
        }
    }

    private void removeMetrics(String pipeID) {
        this.removeAutoGauge(pipeID);
    }

    private void removeAutoGauge(String pipeID) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_DATANODE_REMAINING_EVENT_COUNT.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_DATANODE_REMAINING_TIME.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.remainingEventAndTimeOperatorMap.remove(pipeID);
    }

    public void register(IoTDBSchemaRegionExtractor extractor) {
        String pipeID = extractor.getPipeName() + "_" + extractor.getCreationTime();
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeID, k -> new PipeDataNodeRemainingEventAndTimeOperator(extractor.getPipeName(), extractor.getCreationTime())).register(extractor);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(pipeID);
        }
    }

    public void increaseTabletEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).increaseTabletEventCount();
    }

    public void decreaseTabletEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).decreaseTabletEventCount();
    }

    public void increaseTsFileEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).increaseTsFileEventCount();
    }

    public void decreaseTsFileEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).decreaseTsFileEventCount();
    }

    public void increaseHeartbeatEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).increaseHeartbeatEventCount();
    }

    public void decreaseHeartbeatEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).decreaseHeartbeatEventCount();
    }

    public void thawRate(String pipeID) {
        if (!this.remainingEventAndTimeOperatorMap.containsKey(pipeID)) {
            return;
        }
        this.remainingEventAndTimeOperatorMap.get(pipeID).thawRate(true);
    }

    public void freezeRate(String pipeID) {
        if (!this.remainingEventAndTimeOperatorMap.containsKey(pipeID)) {
            return;
        }
        this.remainingEventAndTimeOperatorMap.get(pipeID).freezeRate(true);
    }

    public void deregister(String pipeID) {
        if (!this.remainingEventAndTimeOperatorMap.containsKey(pipeID)) {
            LOGGER.warn("Failed to deregister pipe remaining event and time metrics, RemainingEventAndTimeOperator({}) does not exist", (Object)pipeID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(pipeID);
        }
    }

    public void markRegionCommit(String pipeID, boolean isDataRegion) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        if (Objects.isNull((Object)operator)) {
            LOGGER.warn("Failed to mark pipe region commit, RemainingEventAndTimeOperator({}) does not exist", (Object)pipeID);
            return;
        }
        if (isDataRegion) {
            operator.markDataRegionCommit();
        } else {
            operator.markSchemaRegionCommit();
        }
    }

    public void markTsFileCollectInvocationCount(String pipeID, long collectInvocationCount) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        if (Objects.isNull((Object)operator)) {
            return;
        }
        operator.markTsFileCollectInvocationCount(collectInvocationCount);
    }

    public Pair<Long, Double> getRemainingEventAndTime(String pipeName, long creationTime) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime));
        return new Pair((Object)operator.getRemainingEvents(), (Object)operator.getRemainingTime());
    }

    public static PipeDataNodeRemainingEventAndTimeMetrics getInstance() {
        return PipeDataNodeRemainingEventAndTimeMetricsHolder.INSTANCE;
    }

    private PipeDataNodeRemainingEventAndTimeMetrics() {
        PipeEventCommitManager.getInstance().setCommitRateMarker(this::markRegionCommit);
    }

    private static class PipeDataNodeRemainingEventAndTimeMetricsHolder {
        private static final PipeDataNodeRemainingEventAndTimeMetrics INSTANCE = new PipeDataNodeRemainingEventAndTimeMetrics();

        private PipeDataNodeRemainingEventAndTimeMetricsHolder() {
        }
    }
}

