/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.heartbeat;

import com.lmax.disruptor.RingBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeRemainingEventAndTimeMetrics;
import org.apache.iotdb.db.pipe.metric.PipeHeartbeatEventMetrics;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatEvent
extends EnrichedEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatEvent.class);
    private final String dataRegionId;
    private long timePublished;
    private long timeAssigned;
    private long timeProcessed;
    private long timeTransferred;
    private int disruptorSize;
    private int extractorQueueTabletSize;
    private int extractorQueueTsFileSize;
    private int extractorQueueSize;
    private int connectorQueueTabletSize;
    private int connectorQueueTsFileSize;
    private int connectorQueueSize;
    private final boolean shouldPrintMessage;

    public PipeHeartbeatEvent(String dataRegionId, boolean shouldPrintMessage) {
        super(null, 0L, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
        this.dataRegionId = dataRegionId;
        this.shouldPrintMessage = shouldPrintMessage;
    }

    public PipeHeartbeatEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, String dataRegionId, long timePublished, boolean shouldPrintMessage) {
        super(pipeName, creationTime, pipeTaskMeta, null, Long.MIN_VALUE, Long.MAX_VALUE);
        this.dataRegionId = dataRegionId;
        this.timePublished = timePublished;
        this.shouldPrintMessage = shouldPrintMessage;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeRemainingEventAndTimeMetrics.getInstance().increaseHeartbeatEventCount(this.pipeName, this.creationTime);
        }
        return true;
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeRemainingEventAndTimeMetrics.getInstance().decreaseHeartbeatEventCount(this.pipeName, this.creationTime);
            if (this.shouldPrintMessage && LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.toString());
            }
        }
        return true;
    }

    public ProgressIndex getProgressIndex() {
        return MinimumProgressIndex.INSTANCE;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeHeartbeatEvent(pipeName, creationTime, pipeTaskMeta, this.dataRegionId, this.timePublished, this.shouldPrintMessage);
    }

    public boolean isGeneratedByPipe() {
        return false;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return true;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        return true;
    }

    public boolean isShouldPrintMessage() {
        return this.shouldPrintMessage;
    }

    public void onPublished() {
        if (this.shouldPrintMessage) {
            this.timePublished = System.currentTimeMillis();
        }
    }

    public void onAssigned() {
        if (this.shouldPrintMessage) {
            this.timeAssigned = System.currentTimeMillis();
            if (this.timePublished != 0L) {
                PipeHeartbeatEventMetrics.getInstance().recordPublishedToAssignedTime(this.timeAssigned - this.timePublished);
            }
        }
    }

    public void onProcessed() {
        if (this.shouldPrintMessage) {
            this.timeProcessed = System.currentTimeMillis();
            if (this.timeAssigned != 0L) {
                PipeHeartbeatEventMetrics.getInstance().recordAssignedToProcessedTime(this.timeProcessed - this.timeAssigned);
            }
        }
    }

    public void onTransferred() {
        if (this.shouldPrintMessage) {
            this.timeTransferred = System.currentTimeMillis();
            if (this.timeProcessed != 0L) {
                PipeHeartbeatEventMetrics.getInstance().recordProcessedToTransferredTime(this.timeTransferred - this.timeProcessed);
            }
        }
    }

    public void recordDisruptorSize(RingBuffer<?> ringBuffer) {
        if (this.shouldPrintMessage) {
            this.disruptorSize = ringBuffer.getBufferSize() - (int)ringBuffer.remainingCapacity();
        }
    }

    public void recordExtractorQueueSize(UnboundedBlockingPendingQueue<Event> pendingQueue) {
        if (this.shouldPrintMessage) {
            this.extractorQueueTabletSize = pendingQueue.getTabletInsertionEventCount();
            this.extractorQueueTsFileSize = pendingQueue.getTsFileInsertionEventCount();
            this.extractorQueueSize = pendingQueue.size();
        }
    }

    public void recordConnectorQueueSize(UnboundedBlockingPendingQueue<Event> pendingQueue) {
        if (this.shouldPrintMessage) {
            this.connectorQueueTabletSize = pendingQueue.getTabletInsertionEventCount();
            this.connectorQueueTsFileSize = pendingQueue.getTsFileInsertionEventCount();
            this.connectorQueueSize = pendingQueue.size();
        }
    }

    public boolean needToCommit() {
        return false;
    }

    public String toString() {
        String unknownMessage = "Unknown";
        String startTimeMessage = this.timePublished != 0L ? DateTimeUtils.convertLongToDate(this.timePublished, "ms") : "Unknown";
        String publishedToAssignedMessage = this.timeAssigned != 0L && this.timePublished != 0L ? this.timeAssigned - this.timePublished + "ms" : "Unknown";
        String assignedToProcessedMessage = this.timeProcessed != 0L && this.timeAssigned != 0L ? this.timeProcessed - this.timeAssigned + "ms" : "Unknown";
        String processedToTransferredMessage = this.timeTransferred != 0L && this.timeProcessed != 0L ? this.timeTransferred - this.timeProcessed + "ms" : "Unknown";
        String totalTimeMessage = this.timeTransferred != 0L && this.timePublished != 0L ? this.timeTransferred - this.timePublished + "ms" : "Unknown";
        String disruptorSizeMessage = Integer.toString(this.disruptorSize);
        String extractorQueueTabletSizeMessage = this.timeAssigned != 0L ? Integer.toString(this.extractorQueueTabletSize) : "Unknown";
        String extractorQueueTsFileSizeMessage = this.timeAssigned != 0L ? Integer.toString(this.extractorQueueTsFileSize) : "Unknown";
        String extractorQueueSizeMessage = this.timeAssigned != 0L ? Integer.toString(this.extractorQueueSize) : "Unknown";
        String connectorQueueTabletSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.connectorQueueTabletSize) : "Unknown";
        String connectorQueueTsFileSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.connectorQueueTsFileSize) : "Unknown";
        String connectorQueueSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.connectorQueueSize) : "Unknown";
        return "PipeHeartbeatEvent{pipeName='" + this.pipeName + "', dataRegionId=" + this.dataRegionId + ", startTime=" + startTimeMessage + ", publishedToAssigned=" + publishedToAssignedMessage + ", assignedToProcessed=" + assignedToProcessedMessage + ", processedToTransferred=" + processedToTransferredMessage + ", totalTimeCost=" + totalTimeMessage + ", disruptorSize=" + disruptorSizeMessage + ", extractorQueueTabletSize=" + extractorQueueTabletSizeMessage + ", extractorQueueTsFileSize=" + extractorQueueTsFileSizeMessage + ", extractorQueueSize=" + extractorQueueSizeMessage + ", connectorQueueTabletSize=" + connectorQueueTabletSizeMessage + ", connectorQueueTsFileSize=" + connectorQueueTsFileSizeMessage + ", connectorQueueSize=" + connectorQueueSizeMessage + "}";
    }
}

