/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.opcua;

import java.nio.file.Paths;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.db.pipe.connector.protocol.opcua.OpcUaServerBuilder;
import org.apache.iotdb.db.pipe.connector.util.PipeTabletEventSorter;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class OpcUaNameSpace
extends ManagedNamespaceWithLifecycle {
    public static final String NAMESPACE_URI = "urn:apache:iotdb:opc-server";
    private final boolean isClientServerModel;
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServerBuilder builder;

    OpcUaNameSpace(OpcUaServer server, boolean isClientServerModel, final OpcUaServerBuilder builder) {
        super(server, NAMESPACE_URI);
        this.isClientServerModel = isClientServerModel;
        this.builder = builder;
        this.subscriptionModel = new SubscriptionModel(server, (AttributeServices)this);
        this.getLifecycleManager().addLifecycle((Lifecycle)this.subscriptionModel);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            public void startup() {
            }

            public void shutdown() {
                OpcUaNameSpace.this.getServer().shutdown();
                builder.close();
            }
        });
    }

    void transfer(Tablet tablet) throws UaException {
        if (this.isClientServerModel) {
            this.transferTabletForClientServerModel(tablet);
        } else {
            this.transferTabletForPubSubModel(tablet);
        }
    }

    private void transferTabletForClientServerModel(Tablet tablet) {
        new PipeTabletEventSorter(tablet).deduplicateAndSortTimestampsIfNecessary();
        String[] segments = tablet.deviceId.split("\\.");
        if (segments.length == 0) {
            throw new PipeRuntimeCriticalException("The segments of tablets must exist");
        }
        StringBuilder currentStr = new StringBuilder();
        UaFolderNode folderNode = null;
        for (String segment : segments) {
            currentStr.append(segment);
            NodeId folderNodeId = this.newNodeId(currentStr.toString());
            currentStr.append("/");
            if (!this.getNodeManager().containsNode(folderNodeId)) {
                UaFolderNode nextFolderNode = new UaFolderNode(this.getNodeContext(), folderNodeId, this.newQualifiedName(segment), LocalizedText.english((String)segment));
                this.getNodeManager().addNode((Node)nextFolderNode);
                if (Objects.nonNull(folderNode)) {
                    folderNode.addOrganizes((UaNode)nextFolderNode);
                } else {
                    nextFolderNode.addReference(new Reference(folderNodeId, Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
                }
                folderNode = nextFolderNode;
                continue;
            }
            folderNode = (UaFolderNode)this.getNodeManager().getNode(folderNodeId).orElseThrow(() -> new PipeRuntimeCriticalException(String.format("The folder node for %s does not exist.", tablet.deviceId)));
        }
        String currentFolder = currentStr.toString();
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            UaVariableNode measurementNode;
            MeasurementSchema measurementSchema = (MeasurementSchema)tablet.getSchemas().get(i);
            String name = measurementSchema.getMeasurementId();
            TSDataType type = measurementSchema.getType();
            NodeId nodeId = this.newNodeId(currentFolder + name);
            if (!this.getNodeManager().containsNode(nodeId)) {
                measurementNode = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId(currentFolder + name)).setAccessLevel((Set)AccessLevel.READ_WRITE).setUserAccessLevel((Set)AccessLevel.READ_ONLY).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english((String)name)).setDataType(this.convertToOpcDataType(type)).setTypeDefinition(Identifiers.BaseDataVariableType).build();
                this.getNodeManager().addNode((Node)measurementNode);
                folderNode.addOrganizes((UaNode)measurementNode);
            } else {
                measurementNode = (UaVariableNode)this.getNodeManager().getNode(nodeId).orElseThrow(() -> new PipeRuntimeCriticalException(String.format("The Node %s does not exist.", nodeId)));
            }
            int lastNonnullIndex = -1;
            for (int j = 0; j < tablet.rowSize; ++j) {
                if (tablet.bitMaps[i].isMarked(j)) continue;
                lastNonnullIndex = j;
                break;
            }
            if (lastNonnullIndex == -1) continue;
            long utcTimestamp = OpcUaNameSpace.timestampToUtc(tablet.timestamps[lastNonnullIndex]);
            if (!Objects.isNull(measurementNode.getValue()) && Objects.requireNonNull(measurementNode.getValue().getSourceTime()).getUtcTime() >= utcTimestamp) continue;
            measurementNode.setValue(new DataValue(new Variant(OpcUaNameSpace.getTabletObjectValue4Opc(tablet.values[i], lastNonnullIndex, type)), StatusCode.GOOD, new DateTime(utcTimestamp), new DateTime()));
        }
    }

    private static Object getTabletObjectValue4Opc(Object column, int rowIndex, TSDataType type) {
        switch (type) {
            case BOOLEAN: {
                return ((boolean[])column)[rowIndex];
            }
            case INT32: {
                return ((int[])column)[rowIndex];
            }
            case DATE: {
                return new DateTime((java.util.Date)Date.valueOf(((LocalDate[])column)[rowIndex]));
            }
            case INT64: {
                return ((long[])column)[rowIndex];
            }
            case TIMESTAMP: {
                return new DateTime(OpcUaNameSpace.timestampToUtc(((long[])column)[rowIndex]));
            }
            case FLOAT: {
                return Float.valueOf(((float[])column)[rowIndex]);
            }
            case DOUBLE: {
                return ((double[])column)[rowIndex];
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return ((Binary[])column)[rowIndex].toString();
            }
        }
        throw new UnSupportedDataTypeException("UnSupported dataType " + type);
    }

    private static long timestampToUtc(long timeStamp) {
        return TimestampPrecisionUtils.currPrecision.toNanos(timeStamp) / 100L + 116444736000000000L;
    }

    private void transferTabletForPubSubModel(Tablet tablet) throws UaException {
        BaseEventTypeNode eventNode = this.getServer().getEventFactory().createEvent(new NodeId(this.getNamespaceIndex(), UUID.randomUUID()), Identifiers.BaseEventType);
        for (int columnIndex = 0; columnIndex < tablet.getSchemas().size(); ++columnIndex) {
            TSDataType dataType = ((MeasurementSchema)tablet.getSchemas().get(columnIndex)).getType();
            eventNode.setSourceName(tablet.deviceId + "." + ((MeasurementSchema)tablet.getSchemas().get(columnIndex)).getMeasurementId());
            eventNode.setSourceNode(this.convertToOpcDataType(dataType));
            for (int rowIndex = 0; rowIndex < tablet.rowSize; ++rowIndex) {
                if (tablet.bitMaps[columnIndex].isMarked(rowIndex)) continue;
                eventNode.setTime(new DateTime(OpcUaNameSpace.timestampToUtc(tablet.timestamps[rowIndex])));
                switch (dataType) {
                    case BOOLEAN: {
                        eventNode.setMessage(LocalizedText.english((String)Boolean.toString(((boolean[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case INT32: {
                        eventNode.setMessage(LocalizedText.english((String)Integer.toString(((int[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case DATE: {
                        eventNode.setMessage(LocalizedText.english((String)((LocalDate[])tablet.values[columnIndex])[rowIndex].atStartOfDay(ZoneId.systemDefault()).toString()));
                        break;
                    }
                    case INT64: {
                        eventNode.setMessage(LocalizedText.english((String)Long.toString(((long[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case TIMESTAMP: {
                        eventNode.setMessage(LocalizedText.english((String)DateTimeUtils.convertLongToDate(((long[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case FLOAT: {
                        eventNode.setMessage(LocalizedText.english((String)Float.toString(((float[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case DOUBLE: {
                        eventNode.setMessage(LocalizedText.english((String)Double.toString(((double[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        eventNode.setMessage(LocalizedText.english((String)((Binary[])tablet.values[columnIndex])[rowIndex].toString()));
                        break;
                    }
                    default: {
                        throw new PipeRuntimeNonCriticalException("Unsupported data type: " + ((MeasurementSchema)tablet.getSchemas().get(columnIndex)).getType());
                    }
                }
                this.getServer().getEventBus().post((Object)eventNode);
            }
        }
        eventNode.delete();
    }

    private NodeId convertToOpcDataType(TSDataType type) {
        switch (type) {
            case BOOLEAN: {
                return Identifiers.Boolean;
            }
            case INT32: {
                return Identifiers.Int32;
            }
            case DATE: 
            case TIMESTAMP: {
                return Identifiers.DateTime;
            }
            case INT64: {
                return Identifiers.Int64;
            }
            case FLOAT: {
                return Identifiers.Float;
            }
            case DOUBLE: {
                return Identifiers.Double;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return Identifiers.String;
            }
        }
        throw new PipeRuntimeNonCriticalException("Unsupported data type: " + type);
    }

    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    void checkEquals(String user, String password, String securityDir, boolean enableAnonymousAccess) {
        this.builder.checkEquals(user, password, Paths.get(securityDir, new String[0]), enableAnonymousAccess);
    }
}

