/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClientManager;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferHandshakeV2Req;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.client.IoTDBDataNodeCacheLeaderClientManager;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataNodeSyncClientManager
extends IoTDBSyncClientManager
implements IoTDBDataNodeCacheLeaderClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeSyncClientManager.class);

    public IoTDBDataNodeSyncClientManager(List<TEndPoint> endPoints, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache, String loadBalanceStrategy, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy) {
        super(endPoints, useSSL, trustStorePath, trustStorePwd, useLeaderCache, loadBalanceStrategy, shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy);
    }

    protected PipeTransferDataNodeHandshakeV1Req buildHandshakeV1Req() throws IOException {
        return PipeTransferDataNodeHandshakeV1Req.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    protected PipeTransferHandshakeV2Req buildHandshakeV2Req(Map<String, String> params) throws IOException {
        return PipeTransferDataNodeHandshakeV2Req.toTPipeTransferReq(params);
    }

    protected String getClusterId() {
        return IoTDBDescriptor.getInstance().getConfig().getClusterId();
    }

    public Pair<IoTDBSyncClient, Boolean> getClient(String deviceId) {
        TEndPoint endPoint = LEADER_CACHE_MANAGER.getLeaderEndPoint(deviceId);
        return this.useLeaderCache && endPoint != null && this.endPoint2ClientAndStatus.containsKey(endPoint) && Boolean.TRUE.equals(((Pair)this.endPoint2ClientAndStatus.get(endPoint)).getRight()) ? (Pair)this.endPoint2ClientAndStatus.get(endPoint) : this.getClient();
    }

    public Pair<IoTDBSyncClient, Boolean> getClient(TEndPoint endPoint) {
        return this.useLeaderCache && endPoint != null && this.endPoint2ClientAndStatus.containsKey(endPoint) && Boolean.TRUE.equals(((Pair)this.endPoint2ClientAndStatus.get(endPoint)).getRight()) ? (Pair)this.endPoint2ClientAndStatus.get(endPoint) : this.getClient();
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        if (!this.useLeaderCache || deviceId == null || endPoint == null) {
            return;
        }
        try {
            if (!this.endPoint2ClientAndStatus.containsKey(endPoint)) {
                this.endPointList.add(endPoint);
                this.endPoint2ClientAndStatus.put(endPoint, new Pair(null, (Object)false));
                this.reconstructClient(endPoint);
            }
            LEADER_CACHE_MANAGER.updateLeaderEndPoint(deviceId, endPoint);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update leader cache for device {} with endpoint {}:{}.", new Object[]{deviceId, endPoint.getIp(), endPoint.getPort(), e});
        }
    }
}

