/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.tsfile.read.filter.basic.Filter;

public class TimePartitionUtils {
    private static long timePartitionOrigin = CommonDescriptor.getInstance().getConfig().getTimePartitionOrigin();
    private static long timePartitionInterval = CommonDescriptor.getInstance().getConfig().getTimePartitionInterval();

    public static TTimePartitionSlot getTimePartitionSlot(long time) {
        TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot();
        timePartitionSlot.setStartTime(TimePartitionUtils.getTimePartitionLowerBound(time));
        return timePartitionSlot;
    }

    public static long getTimePartitionInterval() {
        return timePartitionInterval;
    }

    public static long getTimePartitionLowerBound(long time) {
        long lowerBoundOfTimePartition = TimePartitionUtils.getTimePartitionId(time) * timePartitionInterval + timePartitionOrigin;
        return lowerBoundOfTimePartition;
    }

    public static long getTimePartitionUpperBound(long time) {
        return TimePartitionUtils.getTimePartitionLowerBound(time) + timePartitionInterval;
    }

    public static long getTimePartitionId(long time) {
        return (time -= timePartitionOrigin) > 0L || time % timePartitionInterval == 0L ? time / timePartitionInterval : time / timePartitionInterval - 1L;
    }

    public static boolean satisfyPartitionId(long startTime, long endTime, long partitionId) {
        return TimePartitionUtils.getTimePartitionId(startTime) <= partitionId && TimePartitionUtils.getTimePartitionId(endTime) >= partitionId;
    }

    public static boolean satisfyPartitionStartTime(Filter timeFilter, long partitionStartTime) {
        return timeFilter == null || timeFilter.satisfyStartEndTime(partitionStartTime, partitionStartTime + timePartitionInterval - 1L);
    }

    public static boolean satisfyTimePartition(Filter timeFilter, long partitionId) {
        long partitionStartTime = partitionId * timePartitionInterval + timePartitionOrigin;
        return TimePartitionUtils.satisfyPartitionStartTime(timeFilter, partitionStartTime);
    }

    public static void setTimePartitionInterval(long timePartitionInterval) {
        TimePartitionUtils.timePartitionInterval = timePartitionInterval;
    }

    public static long getEstimateTimePartitionSize(long startTime, long endTime) {
        return (endTime - startTime) / timePartitionInterval + 1L;
    }
}

