/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.config;

import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConfig {
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionConfig.class);

    public int getSubscriptionSubtaskExecutorMaxThreadNum() {
        return COMMON_CONFIG.getSubscriptionSubtaskExecutorMaxThreadNum();
    }

    public int getSubscriptionPrefetchTabletBatchMaxDelayInMs() {
        return COMMON_CONFIG.getSubscriptionPrefetchTabletBatchMaxDelayInMs();
    }

    public long getSubscriptionPrefetchTabletBatchMaxSizeInBytes() {
        return COMMON_CONFIG.getSubscriptionPrefetchTabletBatchMaxSizeInBytes();
    }

    public int getSubscriptionPrefetchTsFileBatchMaxDelayInMs() {
        return COMMON_CONFIG.getSubscriptionPrefetchTsFileBatchMaxDelayInMs();
    }

    public long getSubscriptionPrefetchTsFileBatchMaxSizeInBytes() {
        return COMMON_CONFIG.getSubscriptionPrefetchTsFileBatchMaxSizeInBytes();
    }

    public int getSubscriptionPollMaxBlockingTimeMs() {
        return COMMON_CONFIG.getSubscriptionPollMaxBlockingTimeMs();
    }

    public int getSubscriptionSerializeMaxBlockingTimeMs() {
        return COMMON_CONFIG.getSubscriptionSerializeMaxBlockingTimeMs();
    }

    public long getSubscriptionLaunchRetryIntervalMs() {
        return COMMON_CONFIG.getSubscriptionLaunchRetryIntervalMs();
    }

    public int getSubscriptionRecycleUncommittedEventIntervalMs() {
        return COMMON_CONFIG.getSubscriptionRecycleUncommittedEventIntervalMs();
    }

    public long getSubscriptionReadFileBufferSize() {
        return COMMON_CONFIG.getSubscriptionReadFileBufferSize();
    }

    public long getSubscriptionReadTabletBufferSize() {
        return COMMON_CONFIG.getSubscriptionReadTabletBufferSize();
    }

    public long getSubscriptionTsFileDeduplicationWindowSeconds() {
        return COMMON_CONFIG.getSubscriptionTsFileDeduplicationWindowSeconds();
    }

    public void printAllConfigs() {
        LOGGER.info("SubscriptionSubtaskExecutorMaxThreadNum: {}", (Object)this.getSubscriptionSubtaskExecutorMaxThreadNum());
        LOGGER.info("SubscriptionPrefetchTabletBatchMaxDelayInMs: {}", (Object)this.getSubscriptionPrefetchTabletBatchMaxDelayInMs());
        LOGGER.info("SubscriptionPrefetchTabletBatchMaxSizeInBytes: {}", (Object)this.getSubscriptionPrefetchTabletBatchMaxSizeInBytes());
        LOGGER.info("SubscriptionPrefetchTsFileBatchMaxDelayInMs: {}", (Object)this.getSubscriptionPrefetchTsFileBatchMaxDelayInMs());
        LOGGER.info("SubscriptionPrefetchTsFileBatchMaxSizeInBytes: {}", (Object)this.getSubscriptionPrefetchTsFileBatchMaxSizeInBytes());
        LOGGER.info("SubscriptionPollMaxBlockingTimeMs: {}", (Object)this.getSubscriptionPollMaxBlockingTimeMs());
        LOGGER.info("SubscriptionSerializeMaxBlockingTimeMs: {}", (Object)this.getSubscriptionSerializeMaxBlockingTimeMs());
        LOGGER.info("SubscriptionLaunchRetryIntervalMs: {}", (Object)this.getSubscriptionLaunchRetryIntervalMs());
        LOGGER.info("SubscriptionRecycleUncommittedEventIntervalMs: {}", (Object)this.getSubscriptionRecycleUncommittedEventIntervalMs());
        LOGGER.info("SubscriptionReadFileBufferSize: {}", (Object)this.getSubscriptionReadFileBufferSize());
        LOGGER.info("SubscriptionReadTabletBufferSize: {}", (Object)this.getSubscriptionReadTabletBufferSize());
        LOGGER.info("SubscriptionTsFileDeduplicationWindowSeconds: {}", (Object)this.getSubscriptionTsFileDeduplicationWindowSeconds());
    }

    private SubscriptionConfig() {
    }

    public static SubscriptionConfig getInstance() {
        return SubscriptionConfigHolder.INSTANCE;
    }

    private static class SubscriptionConfigHolder {
        private static final SubscriptionConfig INSTANCE = new SubscriptionConfig();

        private SubscriptionConfigHolder() {
        }
    }
}

