/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IoTProgressIndex
extends ProgressIndex {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Integer, Long> peerId2SearchIndex;

    private IoTProgressIndex() {
        this(Collections.emptyMap());
    }

    public IoTProgressIndex(Integer peerId, Long searchIndex) {
        this(Collections.singletonMap(peerId, searchIndex));
    }

    public IoTProgressIndex(Map<Integer, Long> peerId2SearchIndex) {
        this.peerId2SearchIndex = new HashMap<Integer, Long>(peerId2SearchIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.IOT_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)this.peerId2SearchIndex.size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<Integer, Long> entry : this.peerId2SearchIndex.entrySet()) {
                ReadWriteIOUtils.write((int)entry.getKey(), (ByteBuffer)byteBuffer);
                ReadWriteIOUtils.write((long)entry.getValue(), (ByteBuffer)byteBuffer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.IOT_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write((int)this.peerId2SearchIndex.size(), (OutputStream)stream);
            for (Map.Entry<Integer, Long> entry : this.peerId2SearchIndex.entrySet()) {
                ReadWriteIOUtils.write((int)entry.getKey(), (OutputStream)stream);
                ReadWriteIOUtils.write((long)entry.getValue(), (OutputStream)stream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this);
                return bl;
            }
            if (!(progressIndex instanceof IoTProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            IoTProgressIndex thisIoTProgressIndex = this;
            IoTProgressIndex thatIoTProgressIndex = (IoTProgressIndex)progressIndex;
            boolean bl = thatIoTProgressIndex.peerId2SearchIndex.entrySet().stream().noneMatch(entry -> !thisIoTProgressIndex.peerId2SearchIndex.containsKey(entry.getKey()) || thisIoTProgressIndex.peerId2SearchIndex.get(entry.getKey()) <= (Long)entry.getValue());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof IoTProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            IoTProgressIndex thisIoTProgressIndex = this;
            IoTProgressIndex thatIoTProgressIndex = (IoTProgressIndex)progressIndex;
            boolean bl = thisIoTProgressIndex.peerId2SearchIndex.size() == thatIoTProgressIndex.peerId2SearchIndex.size() && thatIoTProgressIndex.peerId2SearchIndex.entrySet().stream().allMatch(entry -> thisIoTProgressIndex.peerId2SearchIndex.containsKey(entry.getKey()) && thisIoTProgressIndex.peerId2SearchIndex.get(entry.getKey()).equals(entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IoTProgressIndex)) {
            return false;
        }
        return this.equals((IoTProgressIndex)obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.peerId2SearchIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (!(progressIndex instanceof IoTProgressIndex)) {
                ProgressIndex progressIndex2 = ProgressIndex.blendProgressIndex(this, progressIndex);
                return progressIndex2;
            }
            IoTProgressIndex thisIoTProgressIndex = this;
            IoTProgressIndex thatIoTProgressIndex = (IoTProgressIndex)progressIndex;
            HashMap<Integer, Long> peerId2SearchIndex = new HashMap<Integer, Long>(thisIoTProgressIndex.peerId2SearchIndex);
            thatIoTProgressIndex.peerId2SearchIndex.forEach((thatK, thatV) -> peerId2SearchIndex.compute((Integer)thatK, (thisK, thisV) -> thisV == null ? thatV : Math.max(thisV, thatV)));
            IoTProgressIndex ioTProgressIndex = new IoTProgressIndex(peerId2SearchIndex);
            return ioTProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.IOT_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        this.lock.readLock().lock();
        try {
            ProgressIndex.TotalOrderSumTuple totalOrderSumTuple = new ProgressIndex.TotalOrderSumTuple(this.peerId2SearchIndex.values().stream().mapToLong(Long::longValue).sum());
            return totalOrderSumTuple;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getPeerId2SearchIndexSize() {
        this.lock.readLock().lock();
        try {
            int n = this.peerId2SearchIndex.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static IoTProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        IoTProgressIndex ioTProgressIndex = new IoTProgressIndex();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            int peerId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            long searchIndex = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
            ioTProgressIndex.peerId2SearchIndex.put(peerId, searchIndex);
        }
        return ioTProgressIndex;
    }

    public static IoTProgressIndex deserializeFrom(InputStream stream) throws IOException {
        IoTProgressIndex ioTProgressIndex = new IoTProgressIndex();
        int size = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < size; ++i) {
            int peerId = ReadWriteIOUtils.readInt((InputStream)stream);
            long searchIndex = ReadWriteIOUtils.readLong((InputStream)stream);
            ioTProgressIndex.peerId2SearchIndex.put(peerId, searchIndex);
        }
        return ioTProgressIndex;
    }

    public String toString() {
        return "IoTProgressIndex{peerId2SearchIndex=" + this.peerId2SearchIndex + '}';
    }
}

