/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.request;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.request.AsyncRequestContext;
import org.apache.iotdb.commons.client.request.AsyncRequestRPCHandler;
import org.apache.iotdb.commons.utils.function.CheckedTriConsumer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncRequestManager<RequestType, NodeLocation, Client> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncRequestManager.class);
    protected IClientManager<TEndPoint, Client> clientManager;
    protected ImmutableMap<RequestType, CheckedTriConsumer<Object, Client, AsyncRequestRPCHandler<?, RequestType, NodeLocation>, TException>> actionMap;
    protected ImmutableMap.Builder<RequestType, CheckedTriConsumer<Object, Client, AsyncRequestRPCHandler<?, RequestType, NodeLocation>, TException>> actionMapBuilder;
    private static final int MAX_RETRY_NUM = 6;

    protected AsyncRequestManager() {
        this.initClientManager();
        this.actionMapBuilder = ImmutableMap.builder();
        this.initActionMapBuilder();
        this.actionMap = this.actionMapBuilder.build();
    }

    protected abstract void initClientManager();

    protected abstract void initActionMapBuilder();

    public void sendAsyncRequestToNodeWithRetryAndTimeoutInMs(AsyncRequestContext<?, ?, RequestType, NodeLocation> requestContext, long timeoutInMs) {
        this.sendAsyncRequest(requestContext, 6, timeoutInMs);
    }

    public final void sendAsyncRequestWithRetry(AsyncRequestContext<?, ?, RequestType, NodeLocation> requestContext) {
        this.sendAsyncRequest(requestContext, 6, null);
    }

    public final void sendAsyncRequest(AsyncRequestContext<?, ?, RequestType, NodeLocation> requestContext) {
        this.sendAsyncRequest(requestContext, 1, null);
    }

    public void sendAsyncRequest(AsyncRequestContext<?, ?, RequestType, NodeLocation> requestContext, int retryNum, Long timeoutInMs) {
        if (requestContext.getRequestIndices().isEmpty()) {
            return;
        }
        RequestType requestType = requestContext.getRequestType();
        for (int retry = 0; retry < retryNum; ++retry) {
            requestContext.resetCountDownLatch();
            for (int requestId : requestContext.getRequestIndices()) {
                NodeLocation targetNode = requestContext.getNodeLocation(requestId);
                this.sendAsyncRequest(requestContext, requestId, targetNode, retry);
            }
            try {
                if (timeoutInMs == null) {
                    requestContext.getCountDownLatch().await();
                } else if (!requestContext.getCountDownLatch().await(timeoutInMs, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Timeout during {} on ConfigNode. Retry: {}/{}", new Object[]{requestType, retry, retryNum});
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted during {} on ConfigNode. Retry: {}/{}", new Object[]{requestType, retry, retryNum});
                Thread.currentThread().interrupt();
            }
            if (!requestContext.getRequestIndices().isEmpty()) continue;
            return;
        }
        if (!requestContext.getRequestIndices().isEmpty()) {
            LOGGER.warn("Failed to {} on ConfigNode after {} retries, requestIndices: {}", new Object[]{requestType, retryNum, requestContext.getRequestIndices()});
        }
    }

    protected void sendAsyncRequest(AsyncRequestContext<?, ?, RequestType, NodeLocation> requestContext, int requestId, NodeLocation targetNode, int retryCount) {
        try {
            if (!this.actionMap.containsKey(requestContext.getRequestType())) {
                throw new UnsupportedOperationException("unsupported request type " + requestContext.getRequestType() + ", please set it in AsyncRequestManager::initActionMapBuilder()");
            }
            Client client = this.clientManager.borrowClient(this.nodeLocationToEndPoint(targetNode));
            this.adjustClientTimeoutIfNecessary(requestContext.getRequestType(), client);
            Object req = requestContext.getRequest(requestId);
            AsyncRequestRPCHandler<?, RequestType, NodeLocation> handler = this.buildHandler(requestContext, requestId, targetNode);
            Objects.requireNonNull((CheckedTriConsumer)this.actionMap.get(requestContext.getRequestType())).accept(req, client, handler);
        }
        catch (Exception e) {
            LOGGER.warn("{} failed on Node {}, because {}, retrying {}...", new Object[]{requestContext.getRequestType(), this.nodeLocationToEndPoint(targetNode), e.getMessage(), retryCount});
        }
    }

    protected void adjustClientTimeoutIfNecessary(RequestType type, Client client) {
    }

    protected abstract TEndPoint nodeLocationToEndPoint(NodeLocation var1);

    protected abstract AsyncRequestRPCHandler<?, RequestType, NodeLocation> buildHandler(AsyncRequestContext<?, ?, RequestType, NodeLocation> var1, int var2, NodeLocation var3);

    public void resetClient(TEndPoint endPoint) {
        this.clientManager.clear(endPoint);
    }

    public Client getAsyncClient(NodeLocation targetNode) throws ClientManagerException {
        return this.clientManager.borrowClient(this.nodeLocationToEndPoint(targetNode));
    }
}

