/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.auth.AuthOperationProcedureState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthOperationProcedure
extends AbstractNodeProcedure<AuthOperationProcedureState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthOperationProcedure.class);
    private String user;
    private String role;
    private AuthorPlan plan;
    private long timeoutMS;
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";
    private static final int RETRY_THRESHOLD = 2;
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private final List<Pair<TDataNodeConfiguration, Long>> dataNodesToInvalid = new ArrayList<Pair<TDataNodeConfiguration, Long>>();
    private List<TDataNodeConfiguration> datanodes;

    public AuthOperationProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public AuthOperationProcedure(AuthorPlan plan, List<TDataNodeConfiguration> alldns, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.user = plan.getUserName();
        this.role = plan.getRoleName();
        this.plan = plan;
        this.datanodes = alldns;
        this.timeoutMS = commonConfig.getDatanodeTokenTimeoutMS();
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AuthOperationProcedureState state) {
        block10: {
            try {
                switch (state) {
                    case INIT: {
                        this.writePlan(env);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    case DATANODE_AUTHCACHE_INVALIDING: {
                        TInvalidatePermissionCacheReq req = new TInvalidatePermissionCacheReq();
                        req.setUsername(this.user);
                        req.setRoleName(this.role);
                        Iterator<Pair<TDataNodeConfiguration, Long>> it = this.dataNodesToInvalid.iterator();
                        while (it.hasNext()) {
                            Pair<TDataNodeConfiguration, Long> pair = it.next();
                            if ((Long)pair.getRight() + this.timeoutMS < System.currentTimeMillis()) {
                                it.remove();
                                continue;
                            }
                            TSStatus status = (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(((TDataNodeConfiguration)pair.getLeft()).getLocation().getInternalEndPoint(), req, CnToDnRequestType.INVALIDATE_PERMISSION_CACHE);
                            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                            it.remove();
                        }
                        if (this.dataNodesToInvalid.isEmpty()) {
                            LOGGER.info("Auth procedure: clean datanode cache successfully");
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                        this.setNextState(AuthOperationProcedureState.DATANODE_AUTHCACHE_INVALIDING);
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail when execute {} ", (Object)this.plan);
                    this.setFailure(new ProcedureException(e));
                }
                LOGGER.error("Retrievable error trying to execute plan {}, state: {}", new Object[]{this.plan, state, e});
                if (this.getCycles() <= 2) break block10;
                this.setFailure(new ProcedureException(String.format("Fail to execute plan [%s] at state[%s]", new Object[]{this.plan.toString(), state})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void writePlan(ConfigNodeProcedureEnv env) {
        TSStatus res;
        try {
            res = env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(this.plan) : this.plan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
        }
        if (res.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(AuthOperationProcedureState.DATANODE_AUTHCACHE_INVALIDING);
            for (TDataNodeConfiguration item : this.datanodes) {
                this.dataNodesToInvalid.add((Pair<TDataNodeConfiguration, Long>)new Pair((Object)item, (Object)System.currentTimeMillis()));
            }
            LOGGER.info("Execute auth plan {} success. To invalidate datanodes: {}", (Object)this.plan, this.dataNodesToInvalid);
        } else {
            LOGGER.info("Failed to execute plan {} because {}", (Object)this.plan, (Object)res.message);
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(res.message, res.code)));
        }
    }

    @Override
    protected boolean isRollbackSupported(AuthOperationProcedureState state) {
        return state == AuthOperationProcedureState.INIT;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, AuthOperationProcedureState state) {
    }

    @Override
    protected AuthOperationProcedureState getState(int stateId) {
        return AuthOperationProcedureState.values()[stateId];
    }

    @Override
    protected int getStateId(AuthOperationProcedureState state) {
        return state.ordinal();
    }

    @Override
    protected AuthOperationProcedureState getInitialState() {
        return AuthOperationProcedureState.INIT;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_AUTH_OPERATE_PROCEDURE.getTypeCode() : ProcedureType.AUTH_OPERATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((int)this.datanodes.size(), (OutputStream)stream);
        for (TDataNodeConfiguration tDataNodeConfiguration : this.datanodes) {
            ThriftCommonsSerDeUtils.serializeTDataNodeConfiguration((TDataNodeConfiguration)tDataNodeConfiguration, (DataOutputStream)stream);
        }
        ReadWriteIOUtils.write((long)this.timeoutMS, (OutputStream)stream);
        ReadWriteIOUtils.write((ByteBuffer)this.plan.serializeToByteBuffer(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.dataNodesToInvalid.size(), (OutputStream)stream);
        for (Pair pair : this.dataNodesToInvalid) {
            ThriftCommonsSerDeUtils.serializeTDataNodeConfiguration((TDataNodeConfiguration)((TDataNodeConfiguration)pair.left), (DataOutputStream)stream);
            ReadWriteIOUtils.write((long)((Long)pair.right), (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        TDataNodeConfiguration datanode;
        super.deserialize(byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.datanodes = new ArrayList<TDataNodeConfiguration>();
        for (int i = 0; i < size; ++i) {
            datanode = ThriftCommonsSerDeUtils.deserializeTDataNodeConfiguration((ByteBuffer)byteBuffer);
            this.datanodes.add(datanode);
        }
        this.timeoutMS = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        try {
            ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            this.plan = (AuthorPlan)ConfigPhysicalPlan.Factory.create(byteBuffer);
        }
        catch (IOException e) {
            LOGGER.error("IO error when deserialize authplan.", (Throwable)e);
        }
        if (byteBuffer.hasRemaining()) {
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (int i = 0; i < size; ++i) {
                datanode = ThriftCommonsSerDeUtils.deserializeTDataNodeConfiguration((ByteBuffer)byteBuffer);
                Long timeStamp = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
                this.dataNodesToInvalid.add((Pair<TDataNodeConfiguration, Long>)new Pair((Object)datanode, (Object)timeStamp));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthOperationProcedure that = (AuthOperationProcedure)o;
        return this.timeoutMS == that.timeoutMS && Objects.equals(this.plan, that.plan) && Objects.equals(this.dataNodesToInvalid, that.dataNodesToInvalid) && Objects.equals(this.datanodes, that.datanodes) && Objects.equals(this.isGeneratedByPipe, that.isGeneratedByPipe);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.timeoutMS, this.dataNodesToInvalid, this.datanodes, this.isGeneratedByPipe);
    }
}

