/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.client.CnToCnNodeRequestType;
import org.apache.iotdb.confignode.client.CnToDnRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.client.sync.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.PreDeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.AddConsensusGroupException;
import org.apache.iotdb.confignode.exception.AddPeerException;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.procedure.env.RegionMaintainHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.scheduler.LockQueue;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TActiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePipePluginInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropPipePluginInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TInactiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushMultiPipeMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushMultiTopicMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushSingleConsumerGroupMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushSinglePipeMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushSingleTopicMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeProcedureEnv {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigNodeProcedureEnv.class);
    private final LockQueue nodeLock = new LockQueue();
    private final ReentrantLock schedulerLock = new ReentrantLock(true);
    private final ConfigManager configManager;
    private final ProcedureScheduler scheduler;
    private final RegionMaintainHandler regionMaintainHandler;
    private final ReentrantLock removeConfigNodeLock;

    public ConfigNodeProcedureEnv(ConfigManager configManager, ProcedureScheduler scheduler) {
        this.configManager = configManager;
        this.scheduler = scheduler;
        this.regionMaintainHandler = new RegionMaintainHandler(configManager);
        this.removeConfigNodeLock = new ReentrantLock();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public TSStatus deleteDatabaseConfig(String name, boolean isGeneratedByPipe) {
        DeleteDatabasePlan deleteDatabasePlan = new DeleteDatabasePlan(name);
        return this.getClusterSchemaManager().deleteDatabase(deleteDatabasePlan, isGeneratedByPipe);
    }

    public void preDeleteDatabase(PreDeleteDatabasePlan.PreDeleteType preDeleteType, String deleteSgName) {
        this.getPartitionManager().preDeleteDatabase(deleteSgName, preDeleteType);
    }

    public boolean invalidateCache(String storageGroupName) throws IOException, TException {
        List<TDataNodeConfiguration> allDataNodes = this.getNodeManager().getRegisteredDataNodes();
        TInvalidateCacheReq invalidateCacheReq = new TInvalidateCacheReq();
        invalidateCacheReq.setStorageGroup(true);
        invalidateCacheReq.setFullPath(storageGroupName);
        for (TDataNodeConfiguration dataNodeConfiguration : allDataNodes) {
            int dataNodeId = dataNodeConfiguration.getLocation().getDataNodeId();
            NodeStatus nodeStatus = this.getLoadManager().getNodeStatus(dataNodeId);
            if (nodeStatus == NodeStatus.Unknown) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Sleep failed in ConfigNodeProcedureEnv: ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                nodeStatus = this.getLoadManager().getNodeStatus(dataNodeId);
            }
            if (nodeStatus == NodeStatus.Running) {
                TSStatus invalidatePartitionStatus = (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeConfiguration.getLocation().getInternalEndPoint(), invalidateCacheReq, CnToDnRequestType.INVALIDATE_PARTITION_CACHE);
                TSStatus invalidateSchemaStatus = (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeConfiguration.getLocation().getInternalEndPoint(), invalidateCacheReq, CnToDnRequestType.INVALIDATE_SCHEMA_CACHE);
                if (this.verifySucceed(invalidatePartitionStatus, invalidateSchemaStatus)) continue;
                LOG.error("Invalidate cache failed, invalidate partition cache status is {}, invalidate schemaengine cache status is {}", (Object)invalidatePartitionStatus, (Object)invalidateSchemaStatus);
                return false;
            }
            if (nodeStatus != NodeStatus.Unknown) continue;
            LOG.warn("Invalidate cache failed, because DataNode {} is Unknown", (Object)dataNodeConfiguration.getLocation().getInternalEndPoint());
        }
        return true;
    }

    public boolean verifySucceed(TSStatus ... status) {
        return Arrays.stream(status).allMatch(tsStatus -> tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public boolean checkEnoughDataNodeAfterRemoving(TDataNodeLocation removedDatanode) {
        int existedDataNodeNum = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.ReadOnly, NodeStatus.Removing).size();
        int dataNodeNumAfterRemoving = this.getLoadManager().getNodeStatus(removedDatanode.getDataNodeId()) != NodeStatus.Unknown ? existedDataNodeNum - 1 : existedDataNodeNum;
        return dataNodeNumAfterRemoving >= NodeInfo.getMinimumDataNode();
    }

    public void addConsensusGroup(TConfigNodeLocation tConfigNodeLocation) throws AddConsensusGroupException {
        ArrayList<TConfigNodeLocation> configNodeLocations = new ArrayList<TConfigNodeLocation>(this.configManager.getNodeManager().getRegisteredConfigNodes());
        configNodeLocations.add(tConfigNodeLocation);
        TSStatus status = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(tConfigNodeLocation.getInternalEndPoint(), new TAddConsensusGroupReq(configNodeLocations), CnToCnNodeRequestType.ADD_CONSENSUS_GROUP);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new AddConsensusGroupException(tConfigNodeLocation);
        }
    }

    public void addConfigNodePeer(TConfigNodeLocation configNodeLocation) throws AddPeerException {
        this.configManager.getConsensusManager().addConfigNodePeer(configNodeLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigNodePeer(TConfigNodeLocation tConfigNodeLocation) throws ProcedureException {
        TSStatus tsStatus;
        this.removeConfigNodeLock.lock();
        try {
            tsStatus = this.getConsensusManager().removeConfigNodePeer(tConfigNodeLocation) ? this.getConsensusManager().write(new RemoveConfigNodePlan(tConfigNodeLocation)) : new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_ERROR.getStatusCode()).setMessage("Remove ConfigNode failed because update ConsensusGroup peer information failed.");
        }
        catch (ConsensusException e) {
            LOG.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            tsStatus = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            tsStatus.setMessage(e.getMessage());
        }
        try {
            if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new ProcedureException(tsStatus.getMessage());
            }
        }
        finally {
            this.removeConfigNodeLock.unlock();
        }
    }

    public void deleteConfigNodePeer(TConfigNodeLocation removedConfigNode) throws ProcedureException {
        TSStatus tsStatus = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(removedConfigNode.getInternalEndPoint(), removedConfigNode, CnToCnNodeRequestType.DELETE_CONFIG_NODE_PEER);
        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ProcedureException(tsStatus.getMessage());
        }
    }

    public void stopConfigNode(TConfigNodeLocation tConfigNodeLocation) throws ProcedureException {
        TSStatus tsStatus = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(tConfigNodeLocation.getInternalEndPoint(), tConfigNodeLocation, CnToCnNodeRequestType.STOP_CONFIG_NODE);
        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ProcedureException(tsStatus.getMessage());
        }
        this.getLoadManager().removeNodeCache(tConfigNodeLocation.getConfigNodeId());
    }

    public void applyConfigNode(TConfigNodeLocation configNodeLocation, TNodeVersionInfo versionInfo) {
        this.configManager.getNodeManager().applyConfigNode(configNodeLocation, versionInfo);
    }

    public void notifyRegisterSuccess(TConfigNodeLocation configNodeLocation) {
        SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(configNodeLocation.getInternalEndPoint(), null, CnToCnNodeRequestType.NOTIFY_REGISTER_SUCCESS);
    }

    public void createConfigNodeHeartbeatCache(int nodeId) {
        this.getLoadManager().getLoadCache().createNodeHeartbeatCache(NodeType.ConfigNode, nodeId);
    }

    public void markDataNodeAsRemovingAndBroadcast(TDataNodeLocation dataNodeLocation) {
        if (this.getLoadManager().getNodeStatus(dataNodeLocation.getDataNodeId()) == NodeStatus.Unknown) {
            SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithGivenRetry(dataNodeLocation.getInternalEndPoint(), NodeStatus.Removing.getStatus(), CnToDnRequestType.SET_SYSTEM_STATUS, 1);
        } else {
            SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeLocation.getInternalEndPoint(), NodeStatus.Removing.getStatus(), CnToDnRequestType.SET_SYSTEM_STATUS);
        }
        long currentTime = System.nanoTime();
        this.getLoadManager().forceUpdateNodeCache(NodeType.DataNode, dataNodeLocation.getDataNodeId(), new NodeHeartbeatSample(currentTime, NodeStatus.Removing));
        TreeMap<TConsensusGroupId, Map<Integer, RegionHeartbeatSample>> removingHeartbeatSampleMap = new TreeMap<TConsensusGroupId, Map<Integer, RegionHeartbeatSample>>();
        this.getPartitionManager().getAllReplicaSets(dataNodeLocation.getDataNodeId()).forEach(replicaSet -> removingHeartbeatSampleMap.put(replicaSet.getRegionId(), Collections.singletonMap(dataNodeLocation.getDataNodeId(), new RegionHeartbeatSample(currentTime, RegionStatus.Removing))));
        this.getLoadManager().forceUpdateRegionGroupCache(removingHeartbeatSampleMap);
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> doRegionCreation(TConsensusGroupType consensusGroupType, CreateRegionGroupsPlan createRegionGroupsPlan) {
        DataNodeAsyncRequestContext<TCreateSchemaRegionReq, TSStatus> clientHandler;
        switch (consensusGroupType) {
            case SchemaRegion: {
                clientHandler = this.getCreateSchemaRegionClientHandler(createRegionGroupsPlan);
                break;
            }
            default: {
                clientHandler = this.getCreateDataRegionClientHandler(createRegionGroupsPlan);
            }
        }
        if (clientHandler.getRequestIndices().isEmpty()) {
            return new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        }
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        int requestId = 0;
        Map responseMap = clientHandler.getResponseMap();
        HashMap<TConsensusGroupId, TRegionReplicaSet> failedRegions = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (List<TRegionReplicaSet> regionReplicaSets : createRegionGroupsPlan.getRegionGroupMap().values()) {
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    if (((TSStatus)responseMap.get(requestId)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        failedRegions.computeIfAbsent(regionReplicaSet.getRegionId(), empty -> new TRegionReplicaSet().setRegionId(regionReplicaSet.getRegionId())).addToDataNodeLocations(dataNodeLocation);
                    }
                    ++requestId;
                }
            }
        }
        return failedRegions;
    }

    private DataNodeAsyncRequestContext<TCreateSchemaRegionReq, TSStatus> getCreateSchemaRegionClientHandler(CreateRegionGroupsPlan createRegionGroupsPlan) {
        DataNodeAsyncRequestContext<TCreateSchemaRegionReq, TSStatus> clientHandler = new DataNodeAsyncRequestContext<TCreateSchemaRegionReq, TSStatus>(CnToDnRequestType.CREATE_SCHEMA_REGION);
        int requestId = 0;
        for (Map.Entry<String, List<TRegionReplicaSet>> sgRegionsEntry : createRegionGroupsPlan.getRegionGroupMap().entrySet()) {
            String storageGroup = sgRegionsEntry.getKey();
            List<TRegionReplicaSet> regionReplicaSets = sgRegionsEntry.getValue();
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    clientHandler.putRequest(requestId, this.genCreateSchemaRegionReq(storageGroup, regionReplicaSet));
                    clientHandler.putNodeLocation(requestId, dataNodeLocation);
                    ++requestId;
                }
            }
        }
        return clientHandler;
    }

    private DataNodeAsyncRequestContext<TCreateDataRegionReq, TSStatus> getCreateDataRegionClientHandler(CreateRegionGroupsPlan createRegionGroupsPlan) {
        DataNodeAsyncRequestContext<TCreateDataRegionReq, TSStatus> clientHandler = new DataNodeAsyncRequestContext<TCreateDataRegionReq, TSStatus>(CnToDnRequestType.CREATE_DATA_REGION);
        int requestId = 0;
        for (Map.Entry<String, List<TRegionReplicaSet>> sgRegionsEntry : createRegionGroupsPlan.getRegionGroupMap().entrySet()) {
            String storageGroup = sgRegionsEntry.getKey();
            List<TRegionReplicaSet> regionReplicaSets = sgRegionsEntry.getValue();
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    clientHandler.putRequest(requestId, this.genCreateDataRegionReq(storageGroup, regionReplicaSet));
                    clientHandler.putNodeLocation(requestId, dataNodeLocation);
                    ++requestId;
                }
            }
        }
        return clientHandler;
    }

    private TCreateSchemaRegionReq genCreateSchemaRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet) {
        TCreateSchemaRegionReq req = new TCreateSchemaRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        return req;
    }

    private TCreateDataRegionReq genCreateDataRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet) {
        TCreateDataRegionReq req = new TCreateDataRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        return req;
    }

    public void persistRegionGroup(CreateRegionGroupsPlan createRegionGroupsPlan) {
        try {
            this.getConsensusManager().write(createRegionGroupsPlan);
        }
        catch (ConsensusException e) {
            LOG.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
        }
    }

    public void activateRegionGroup(Map<String, Map<TConsensusGroupId, Map<Integer, RegionHeartbeatSample>>> activateRegionGroupMap) {
        activateRegionGroupMap.forEach((database, regionGroupSampleMap) -> regionGroupSampleMap.forEach((regionGroupId, regionSampleMap) -> this.getLoadManager().getLoadCache().createRegionGroupHeartbeatCache((String)database, (TConsensusGroupId)regionGroupId, regionSampleMap.keySet())));
        this.getLoadManager().forceUpdateRegionGroupCache(activateRegionGroupMap.values().stream().flatMap(innerMap -> innerMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b)));
        this.getLoadManager().waitForRegionGroupReady(activateRegionGroupMap.values().stream().flatMap(innterMap -> innterMap.keySet().stream()).collect(Collectors.toList()));
    }

    public List<TRegionReplicaSet> getAllReplicaSets(String storageGroup) {
        return this.getPartitionManager().getAllReplicaSets(storageGroup);
    }

    public List<TSStatus> createTriggerOnDataNodes(TriggerInformation triggerInformation, Binary jarFile) throws IOException {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TCreateTriggerInstanceReq request = new TCreateTriggerInstanceReq(triggerInformation.serialize());
        if (jarFile != null) {
            request.setJarFile(ByteBuffer.wrap(jarFile.getValues()));
        }
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.CREATE_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> dropTriggerOnDataNodes(String triggerName, boolean needToDeleteJarFile) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TDropTriggerInstanceReq request = new TDropTriggerInstanceReq(triggerName, needToDeleteJarFile);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.DROP_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> activeTriggerOnDataNodes(String triggerName) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TActiveTriggerInstanceReq request = new TActiveTriggerInstanceReq(triggerName);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.ACTIVE_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> inactiveTriggerOnDataNodes(String triggerName) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TInactiveTriggerInstanceReq request = new TInactiveTriggerInstanceReq(triggerName);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.INACTIVE_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> createPipePluginOnDataNodes(PipePluginMeta pipePluginMeta, byte[] jarFile) throws IOException {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TCreatePipePluginInstanceReq request = new TCreatePipePluginInstanceReq(pipePluginMeta.serialize(), ByteBuffer.wrap(jarFile));
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.CREATE_PIPE_PLUGIN, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> dropPipePluginOnDataNodes(String pipePluginName, boolean needToDeleteJarFile) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TDropPipePluginInstanceReq request = new TDropPipePluginInstanceReq(pipePluginName, needToDeleteJarFile);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.DROP_PIPE_PLUGIN, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public Map<Integer, TPushPipeMetaResp> pushAllPipeMetaToDataNodes(List<ByteBuffer> pipeMetaBinaryList) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushPipeMetaReq request = new TPushPipeMetaReq().setPipeMetas(pipeMetaBinaryList);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.PIPE_PUSH_ALL_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public Map<Integer, TPushPipeMetaResp> pushSinglePipeMetaToDataNodes(ByteBuffer pipeMetaBinary) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushSinglePipeMetaReq request = new TPushSinglePipeMetaReq().setPipeMeta(pipeMetaBinary);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.PIPE_PUSH_SINGLE_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public Map<Integer, TPushPipeMetaResp> dropSinglePipeOnDataNodes(String pipeNameToDrop) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushSinglePipeMetaReq request = new TPushSinglePipeMetaReq().setPipeNameToDrop(pipeNameToDrop);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.PIPE_PUSH_SINGLE_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public Map<Integer, TPushPipeMetaResp> pushMultiPipeMetaToDataNodes(List<ByteBuffer> pipeMetaBinaryList) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushMultiPipeMetaReq request = new TPushMultiPipeMetaReq().setPipeMetas(pipeMetaBinaryList);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.PIPE_PUSH_MULTI_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public Map<Integer, TPushPipeMetaResp> dropMultiPipeOnDataNodes(List<String> pipeNamesToDrop) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushMultiPipeMetaReq request = new TPushMultiPipeMetaReq().setPipeNamesToDrop(pipeNamesToDrop);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.PIPE_PUSH_MULTI_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public Map<Integer, TPushTopicMetaResp> pushAllTopicMetaToDataNodes(List<ByteBuffer> topicMetaBinaryList) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushTopicMetaReq request = new TPushTopicMetaReq().setTopicMetas(topicMetaBinaryList);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.TOPIC_PUSH_ALL_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public List<TSStatus> pushSingleTopicOnDataNode(ByteBuffer topicMeta) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushSingleTopicMetaReq request = new TPushSingleTopicMetaReq().setTopicMeta(topicMeta);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.TOPIC_PUSH_SINGLE_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList().stream().map(TPushTopicMetaResp::getStatus).collect(Collectors.toList());
    }

    public List<TSStatus> dropSingleTopicOnDataNode(String topicNameToDrop) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushSingleTopicMetaReq request = new TPushSingleTopicMetaReq().setTopicNameToDrop(topicNameToDrop);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.TOPIC_PUSH_SINGLE_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList().stream().map(TPushTopicMetaResp::getStatus).collect(Collectors.toList());
    }

    public Map<Integer, TPushTopicMetaResp> pushMultiTopicMetaToDataNodes(List<ByteBuffer> topicMetaBinaryList) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushMultiTopicMetaReq request = new TPushMultiTopicMetaReq().setTopicMetas(topicMetaBinaryList);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.TOPIC_PUSH_MULTI_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public Map<Integer, TPushTopicMetaResp> dropMultiTopicOnDataNodes(List<String> topicNamesToDrop) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushMultiTopicMetaReq request = new TPushMultiTopicMetaReq().setTopicNamesToDrop(topicNamesToDrop);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.TOPIC_PUSH_MULTI_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public Map<Integer, TPushConsumerGroupMetaResp> pushAllConsumerGroupMetaToDataNodes(List<ByteBuffer> consumerGroupMetaBinaryList) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushConsumerGroupMetaReq request = new TPushConsumerGroupMetaReq().setConsumerGroupMetas(consumerGroupMetaBinaryList);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.CONSUMER_GROUP_PUSH_ALL_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestToNodeWithRetryAndTimeoutInMs(clientHandler, PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L * 2L / 3L);
        return clientHandler.getResponseMap();
    }

    public List<TSStatus> pushSingleConsumerGroupOnDataNode(ByteBuffer consumerGroupMeta) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushSingleConsumerGroupMetaReq request = new TPushSingleConsumerGroupMetaReq().setConsumerGroupMeta(consumerGroupMeta);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.CONSUMER_GROUP_PUSH_SINGLE_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList().stream().map(TPushConsumerGroupMetaResp::getStatus).collect(Collectors.toList());
    }

    public List<TSStatus> dropSingleConsumerGroupOnDataNode(String consumerGroupNameToDrop) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        TPushSingleConsumerGroupMetaReq request = new TPushSingleConsumerGroupMetaReq().setConsumerGroupNameToDrop(consumerGroupNameToDrop);
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnRequestType.CONSUMER_GROUP_PUSH_SINGLE_META, request, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseList().stream().map(TPushConsumerGroupMetaResp::getStatus).collect(Collectors.toList());
    }

    public LockQueue getNodeLock() {
        return this.nodeLock;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }

    public LockQueue getRegionMigrateLock() {
        return this.regionMaintainHandler.getRegionMigrateLock();
    }

    public ReentrantLock getSchedulerLock() {
        return this.schedulerLock;
    }

    public RegionMaintainHandler getRegionMaintainHandler() {
        return this.regionMaintainHandler;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }
}

